# spectragram.r


# first run power.r to get mdata (ReadData.r) (mean, baseline-removed)

# data[times, bands, stacks]
# BANDS.SEQ		frequencies (total of BAND)
# 1:dim(data)[1]	time points
# dimnames(data)[[2]]	another way to get these

if (!exists("mdata"))
   stop("Must run doAll.r, with ALIGN='go', class='', all else standard")
# both monkeys, go align is interval 160 ms (!)
# there's also the issue of what interval size data to use

SIGMOID = 8		# [8] Duplicate this many on top & bottom of range
SUPERSIGMOID = 90
JET  = T		# [F] !!  Ugh - looks beautiful
ZOOM = F		# [ ]
PUBLISH = F		# [F] !!
BLUR = 3.5		# [0 1.1, 1.8, 3.5]   Definitely helps; must adj scale

LowFreq = ifelse(ZOOM, 16, 4) 		# [16,4]   #[20, 4]    [new Zoom? 15]
HiFreq  = ifelse(ZOOM, 36, 116)		# [36,100] #[45, 100]  [new Zoom? 35]

ColorN = 60		# 40 or 60

if (ALIGN.OVERRIDE == "") {
   StartTime = -400	# target:-300  gocue:-300  go:-500/-300
   EndTime   = 1200	# target:1250  gocue: 250  go: 250/300
 } else if (ALIGN.OVERRIDE == "gocue") {
   StartTime = -300
   EndTime   =  450
 } else if (ALIGN.OVERRIDE == "go") {
   StartTime = -500
   EndTime   =  250
 } else if (ALIGN.OVERRIDE == "sac") {
   StartTime = -500
   EndTime   =  250
   }

#### previous submission         IDEAL
#    -40  45			-33  63		# target
#    -40  35			-34  60	# target, zoom
#    -40 175    		-32 270  (as low as 120?)
#    -40  85    		-28  90

LowPercent = -34		# Will map to a value of 0.42 in mdata
HiPercent  = 220		# Will map to a value of 2.70 in mdata


if (BLUR)
   library(spatstat)

# Not sure what this is all for ... the color bar?
Range = seq(LowPercent/100+1,
	       HiPercent/100+1,
	       length.out=ColorN+2*SIGMOID+SUPERSIGMOID)

LowFreq = which(BANDS.SEQ >= LowFreq)[1]
HiFreq  = which(BANDS.SEQ >= HiFreq )[1] - 1
Freqs = LowFreq:HiFreq

Times = seq(XtoMs(1), XtoMs(dim(mdata)[1]), by= XtoMs(2) - XtoMs(1))
TimesOut = NULL
if (floor(MsToX(StartTime)) > 1)
   TimesOut = 1:round(MsToX(StartTime))
if (ceiling(MsToX(EndTime)) < length(Times))
   TimesOut = c(TimesOut, ceiling((MsToX(EndTime))):length(Times))

DataTimeIndex = 1:length(Times)
if (!is.null(TimesOut)) {
   Times = Times[-TimesOut]
   DataTimeIndex = DataTimeIndex[-TimesOut]	# no easier way to do this!
   }

if (JET) {
   library("colorspace")
   A = colorRampPalette(c("darkblue", "blue","cyan","cyan","green","yellow","yellow","orange", "red", "red", "darkred"), bias=1.5)
   Colors = A(ColorN)
} else {
   library("viridis")
   # Colors = plasma(ColorN)	# viridis, plasma, magma, inferno, cividis
   Colors = viridis(ColorN)	# viridis, plasma, magma, inferno, cividis
   }

if (SIGMOID)
    Colors = c(rep(Colors[1], SIGMOID),
	       Colors, 
	       rep(Colors[length(Colors)], SIGMOID))

if (SUPERSIGMOID)
    Colors = c( # rep("black", SUPERSIGMOID),
	       Colors, 
	       rep("brown4", SUPERSIGMOID))

par(mfrow=c(3,2), mar=c(5, 4, 0.5, 2)+.1, las=1)
if (PUBLISH)
    par(mfrow=c(2,5), mar=c(5, 0.5, 5, 0.5)+.1, oma=c(0,3,0,3))
for (i in 1:5) {
   # Image = mdata[DataTimeIndex, Freqs, i]
   Image = mdata[DataTimeIndex, , i]	# Do all freqs, avoid edge effects
   if (BLUR) {				#  (desite exta work for 'blur')
      # Image = im(Image, BANDS.SEQ[Freqs], Times) # into an image class
      Image = im(Image, BANDS.SEQ, Times) # into an image class
      # To plot, divide times by 30 (or mult by 10?) & transpose data
      Image = as.matrix(blur(Image, BLUR)) # blur and out of image class
      }
   Image = Image[, Freqs]		# pull  out freqs you want here

   image(Times, BANDS.SEQ[Freqs], 
	Image,
	col=Colors, zlim=range(Range),
	axes = !PUBLISH,
	xlab = paste0("Time re: \"", ALIGN, "\""),
	ylab = if (PUBLISH) "" else "Frequency (Hz)",
	cex.lab = if (PUBLISH) .8 else 1,
	useRaster=F)

  if (!ZOOM)
     rect(min(Times)-500, 54, max(Times)+500, 66, col="white", border=NA)


  if (PUBLISH) {
     axis(1, cex.axis=.7)
     par(xpd=T)
     if (all(par("mfg") == c(1,1,2,5)))
        axis(2, cex.axis=.7)	# outer margin
     if (all(par("mfg") == c(1,5,2,5)))
        axis(4, cex.axis=.7)
     mtext("Frequency (Hz)", side=2, adj=.82, line=2, outer=T, cex=.7, las=3)
     mtext("Frequency (Hz)", side=4, adj=.82, line=2, outer=T, cex=.7, las=3)
     par(xpd=F)
     axis(1, at=c(-1000,1000), labels=F)		# bty="o" not working
     axis(2, at=c(-1000,1000), labels=F)
     axis(3, at=c(-1000,1000), labels=F)
     axis(4, at=c(-1000,1000), labels=F)
     }
  }


par(mar=c(5, 4, 7, 2)+.1, mgp=c(2.5,1,0))
if (PUBLISH)
   par(mar=c(14, 0.5, 0, 1.0)+.1)


# TRIM THE EDGES?
# Colors[1:(SUPERSIGMOID-2)] = "white"
# Colors[(length(Colors)-SUPERSIGMOID+2):length(Colors)] = "white"

# TRIM THE ENTIRE THING?
trim = Range > 2.05
Range  = Range [!trim]
Colors = Colors[!trim]

image(Range, 1:2,
      matrix(Range, ncol=2, nrow=length(Range), byrow=F), 
			col=Colors, zlim=range(Range),
      			ylim=c(1,6),
			xlab=paste("% change"),
			ylab="", axes=F, useRaster=F)

axis(1, at=c(.67, 1, 1.33, 1.67, 2), labels=paste0(c(-33, 0, 33, 67, 100), "%"))
# axis(1, at=sort(c(range(Range), 1)),
#         labels =  c(paste(round(100*(min(Range)-1)), "%"),
#		      "0 %",
#		      paste(round(100*(max(Range)-1)), "%")))

#rm(Colors, TimesOut, StartTime, EndTime, Times, LowFreq, HiFreq,
#   LowPercent, HiPercent, Range)

