# power8.r      Plot power spectra for 5 stacks, 8 class

#  Should have scale turned OFF for these!

ALIGN_ON_STACK = 0		# 0 or stack number  [-1]: align each stack
MIMIC.ALIGN_ON_STACK = 0	# [>0]: rm class 1+5 in this stk [-1]: all stks
				# Values of -1 only work for FREQ_PLOT
ALIGN_ON_UNIT = 0		# 0:ignore  1:align on pref
				#   -22: use only contra-prefering cells/sites
				#   -23:          ispi-
MERGE_STACKS = 0		# Merge 63:65 (all reaches)

POLAR_PLOT   = F		# Does NOT use "mimic"
   # hz = seq(128,240,2)	# [100-240]
   hz = seq(36,52,2)		# [36-52]
   # hz = seq(14,20,2)		# [14-20]
SCATTER_PLOT = F
FREQ_PLOT    = T
   LOG =    T			# For FREQ plot
   SMOOTH = F			# 
   SUPSMU = F			# else lowess
   FREQ_DIFF = F		# subtract unaligned from aligned
   KeyFreqs =			# Align all based on this; if 0, align each freq
    # seq(100,240,by=2)		# High gamma  (Don't use DIFF!)
    # seq(32,50,by=2)		# Low gamma
    # seq(12,18,by=2)		# Low Beta
    0



RANDOMIZE = F			# For picking best direction

if (POLAR_PLOT & any(ALIGN_ON_STACK==-1))
   stop("Cannot do -1 with polar -- will be missing values!\n")
if (POLAR_PLOT & any(MIMIC.ALIGN_ON_STACK != 0))
   stop("POLAR_PLOT does not mimic alignment!\n")
if (SCATTER_PLOT & any(ALIGN_ON_STACK < 1)) 
   stop("SCATTER_PLOT needs single stack alignment!\n")
if (FREQ_PLOT & any(ALIGN_ON_STACK!=0) & ALIGN_ON_UNIT)
   stop("Cannot align on a stack and also on unit preference")
if (FREQ_PLOT & any(ALIGN_ON_STACK==0) & FREQ_DIFF)
   FREQ_DIFF = F
if ((ALIGN_ON_UNIT > 1) || (ALIGN_ON_UNIT == -1))
   Warn("These align-on-unit settings don't make sense!")
   #  1         is good:     If cell prefers up, align LFP to right.
   # -1         is not good: It's all cells, so mimic looks like original
   # -2 and -3 are good:     Show LFP tuning only near ipsi or contra cells
   #  2 and  3 are not good: No point in aligning a subset of cells

# cat("Why is there data at 60 Hz?  And why does inj data have awful power?\n")
# cat("Why is 1/2 of zen data bad?\n")


EXCISE.STIMULATION = F			# Not used but needed by ReadAll*.r
SCATTER = F				# Used by doAl 
if (MATCHING.OVERRIDE) {
   cat("Ignoring matching flag!\n")
   }

if (!exists("SAVE_FLAG"))
   SAVE_FLAG = F

origALIGN.BASELINES = ALIGN.BASELINES
origALIGN = ALIGN.OVERRIDE

if (NORMALIZE.OVERRIDE && 		# Need the baseline data
    (ALIGN.OVERRIDE=="gocue"||ALIGN.OVERRIDE=="go"||ALIGN.OVERRIDE=="sac")) {
   ALIGN.OVERRIDE = ""			# Target-aligned
   source("ReadAll.r")
   saved.normalize = copy.normalize     # Baseline from targ-aligned; 
                                        # Used to normalize go[cue]-aligned data
   saved.scale = copy.scale     	# from targ-aligned;
   saved.files = files          	# Check that all the files are there
   rm(copy.normalize, copy.scale)
   ALIGN.OVERRIDE = origALIGN		# Restore for reading main data
   ALIGN.BASELINES = F          	# No need to do again on main data
   }

source("ReadAll.r")

if (any(ALIGN.BASELINES)) {		# Should only be target-aligns
   baseline = apply(data[1:MsToX(0),,,,,drop=F], 2:5, mean, na.rm=T)
   baseline = array(rep(c(baseline), each=dim(data)[1]), dim=dim(data))
   data = data - baseline + 1
   rm(baseline)
   }
ALIGN.BASELINES = origALIGN.BASELINES	# Restore for future doAll loops


# MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4)) # in ReadData
S_MAP = c("gray30", "green", "red", "blue",	# stack map
          "purple", "orange")			# orange: mimic all (no 1 or 5)
if (MERGE_STACKS) {
   S_MAP = S_MAP[c(1,3)]
 } else if (CC_INACT > 10)
   S_MAP = S_MAP[c(1,4,5)]		# Skipped uni reach for LIP CC lesions

# Collapse over time interval of interest and frequency bands
# (time, bands, classes, stacks, units) --> (classes, stacks, units)
LEFT = round(MsToX(FROM.TIME))
RIGHT  = round(MsToX(END.TIME))
if (LEFT < 1) {
   LEFT = 1
   cat("Shifting start time from", FROM.TIME, "to", XtoMs(LEFT), "ms\n")
   }
if (RIGHT < 1) {			# Unusual!
   RIGHT = 1
   cat("Shifting end time from", END.TIME, "to", XtoMs(RIGHT), "ms\n")
   }
if (RIGHT > dim(data)[1]) {
   RIGHT = dim(data)[1]
   cat("Shifting end time from", END.TIME, "to", XtoMs(RIGHT), "ms\n")
   }
# cat("DIAG: Left is", LEFT, "which is", XtoMs(LEFT), XtoMs(RIGHT), "\n")

# Used for plotting, but also for computing bias in horizontal direction
rads      <- function(rad) { return(rad/360*2*pi) }
degs      <- function(deg) { return(deg*360/2/pi) }
angles    <- c(0,-45,-90,-135,180,135,90,45)
angles1   <- c(angles, angles[1])
X         <- function(radius, ang=angles1) { radius * cos(rads(ang)) }
Y         <- function(radius, ang=angles1) { radius * sin(rads(ang)) }
				# radius must be 1st dim for X and Y

###########################################################################
###########################################################################
# Shared pre-processing

#  Just the times you want
Tdata = apply(data[if (LEFT==RIGHT) c(LEFT,RIGHT) else LEFT:RIGHT,,,,],
                                                        2:5, mean, na.rm=T)

RemoveMissing = function(freqs) {
   Missing = apply(Tdata[freqs,,,],
		   3+(length(freqs)>1), 
		   function(x) any(is.na(x)))

   if (any(Missing)) {
      cat("Missing data from", sum(Missing), "sites -- skipping (problem?)\n")
   					# Some code may not handle this right!! 
      Tdata <<- Tdata[,,,,!Missing]	# Remove from ALL frequencies
      }
   }

Rotate = function(ldata, best) {
        if (best == 1)
           return(ldata)
        return(rbind(ldata[best:8,], ldata[1:(best-1),]))
        }					# Always all 5 stacks, 1 site

BestClass = function(ldata) {			# 8 classes x stacks x 1 site
        if (length(dim(ldata)) > 1)			# more than 1 stack?
	   ldata = apply(ldata,1,mean,na.rm=T)	# average across stacks
        return(sort.list(ldata, decreasing=T)[1])	# hi'est value
	}

ComputeBias = function(Array, AlignedOn=0, ReturnIndis=F) {
     # subtlety: to compare alignment stack data to its own unaligned data,
     #  should remove classes 1 & 5 from the unaligned data as well when
     #  computing the bias, else unaligned will always be bigger bias.
     if (length(dim(Array)) == 3) {			# class, stack, site
         if (any(AlignedOn != 0))
	    Array[c(1,5), AlignedOn,] = NA
         return(colMeans(X(apply(Array,1:2,mean,na.rm=T), angles), na.rm=T))
         }
     if (length(dim(Array)) == 2) {			 # class, site
	 # cat("Add 'drop=F' when subscripting array to prevent this!\n")
         if (AlignedOn != 0)
	    Array[-c(1:5),] = NA
         if (ReturnIndis) stop("Cannot avg over classes before calling X()!\n")
         if (ReturnIndis)
            return(apply(X(Array, Angles), 1, mean,na.rm=T))
         return(mean(    X(apply(Array,1,  mean,na.rm=T), angles), na.rm=T))
         }
     }

SortAndAlignBasedOnUnits = function(Array) {
					# Expects (class, stack, site)
    Sites = rev(dim(Array))[1]
    source("PrefDirection.r")		# Build PrefDir[monk code, file, pref]
    prefs = rep(0, Sites)

    for (site in 1:Sites) {		# This is crazy-complex - a better way?
        monk = ifelse(grepl("tyr", dimnames(Tdata)[[4]][site], fixed=T),
		      "tyr", "zen")
        prefs[site] = PrefDir[(PrefDir[,"monk"] == monk) &
		 grepl(sub(".*/data_", "", dimnames(Tdata)[[4]][site]),
		       PrefDir[,"file"],
		       fixed=T),
		    "pref"]
	if ((ALIGN_ON_UNIT>0) & (prefs[site] != "0"))
	   Array[,,site] = Rotate(Array[,,site], as.numeric(prefs[site]))
        }
    if (abs(ALIGN_ON_UNIT) == 2)		# only contra-preferring
       Array = Array[,, (prefs == "8") | (prefs=="1") | (prefs=="2")]
    else if (abs(ALIGN_ON_UNIT) == 3)	# only ipsi-preferring
       Array = Array[,, (prefs == "4") | (prefs=="5") | (prefs=="6")]
    else
       Array = Array[,,prefs != "0"]

    return(Array)
    }



if (!SAVE_FLAG) {
   while(length(dev.list()) > 0)
      dev.off()
   pdf("StackPower.pdf")
   }

par(las=1)
par(xpd=NA)
par(oma=c(4,0,2,0))

###########################################################################
if (POLAR_PLOT) {

 Ordinals = match(hz, BANDS.SEQ)
 if (any(is.na(Ordinals)))
    stop("Asked for a frequency that was not computed")
 hz = Ordinals
 if (length(hz) == 1)
    hz = c(hz,hz)		# plays nicer if more than one dim

 RemoveMissing(hz)

 udata = apply(Tdata[hz,,,], c(2:4), mean, na.rm=T) 	# avg over requested hz

 if (ALIGN_ON_UNIT) {
    udata = SortAndAlignBasedOnUnits(udata)
  } else
 if (any(ALIGN_ON_STACK != 0)) {
    for (site in 1:dim(udata)[3]) {
	best = BestClass(udata[,ALIGN_ON_STACK,site])
	udata[,,site] = Rotate(udata[,,site], best)
        rm(best)
        }
  }


 # Set up the plot
 
 MIN	  <- min(apply(udata, 1:2, mean, na.rm=T))
 MAX	  <- max(apply(udata, 1:2, mean, na.rm=T))
 OFFSET	  <- (MAX-MIN)/2
 BIAS_SCALE = 4			# show bias at center, scaled
 
 grid      <- seq(0, 2 * pi, length = 360 / 5 + 1)
 
 LIM	  <- MAX-MIN+OFFSET
 
 # Draw an empty plot with particular dimensions:
 par(mar=c(0,0,1,0)+.1, pty='s')
 plot(0,0, type='n', bty='n', axes=F, xlab="", ylab="", asp=1,
           xlim=c(-LIM, LIM),
           ylim=c(-LIM, LIM))
 
 
 polar.line = function(amp,...) {
 	  amp = OFFSET - MIN + c(amp, amp[1])		# close the circle
 	  lines(X(amp), Y(amp), ...)
 	  }
 
 # Circles
 polar.line(rep(MIN,    8), lwd=1, lty=1,col="gray")
 polar.line(rep((MAX+MIN)/2,8), lwd=1, lty=1,col="gray")
 polar.line(rep(MAX,  8), lwd=1, lty=1,col="gray")
 
 # Crosshairs
 segments(0, (MAX-MIN+OFFSET)/1, 0, -(MAX-MIN+OFFSET)/1, lwd=1,lty=1,col="gray")
 segments((MAX-MIN+OFFSET)/1, 0, -(MAX-MIN+OFFSET)/1, 0, lwd=1,lty=1,col="gray")
 
 if (MERGE_STACKS & STACKS > 3)				# Merge stacks 63:65
    udata[,2,] = apply(udata[,2:4,], c(1,3), mean, na.rm=T)

 # Actual data, plus bias
 for (st in (1:ifelse(MERGE_STACKS, 2, STACKS))) {
     # (err bars, too)?
     polar.line(apply(udata[,st,], 1, mean, na.rm=T), col=S_MAP[st], lwd=4)
     bias = BIAS_SCALE * ComputeBias(udata[,st,], Aligned=ALIGN_ON_STACK)
     points(bias, 0, pch=19, col=S_MAP[st])
     segments(bias,  OFFSET*(.3+st/15),	# stagger lines so can spot overlaps
 	      bias, -OFFSET*(.3+(5-st)/15), col=S_MAP[st])
     }
 
 text(OFFSET, 0, paste0(round(100*OFFSET/BIAS_SCALE, dig=1), "%  "),
     						 pos=3, offset= 0.2, font=2)
 
 Bottom = -(MAX-MIN+OFFSET)
 
 if (any(ALIGN_ON_STACK == 0)) {
    arrows( OFFSET, Bottom,
 	   LIM,    Bottom, lwd=3)
    arrows(-OFFSET, Bottom,
 	  -LIM,    Bottom, lwd=3)
 
    text( LIM/2+OFFSET/3,  Bottom+OFFSET/3, "Contra field", adj=.5, font=2)
    text(-LIM/2-OFFSET/3,  Bottom+OFFSET/3, "Ipsi field", adj=.5, font=2)
  } else {
    arrows( OFFSET, Bottom,
 	   LIM,    Bottom, col=S_MAP[ALIGN_ON_STACK[1]], lwd=3)
    text( LIM/2+OFFSET/3,  Bottom+OFFSET/3, "Re-align", 
 		cex=1.2, font=2, adj=.5, col=S_MAP[ALIGN_ON_STACK[1]])
    }
 text( OFFSET, Bottom-OFFSET/2, paste0(round(MIN*100 - 100), "%"))
 text( LIM,    Bottom-OFFSET/2, paste0("+", round(MAX*100 - 100), "%"))
 text(-OFFSET, Bottom-OFFSET/2, paste0(round(MIN*100 - 100), "%"))
 text(-LIM,    Bottom-OFFSET/2, paste0("+", round(MAX*100 - 100), "%"))
 text(0,       Bottom-OFFSET/2, "0%")
 } else

###########################################################################
# Grid of scatter plots: bias when aligned versus native
if (SCATTER_PLOT) {

 if (any(ALIGN_ON_STACK == 0))
    stop("Need an 'align on' stack")

 par(mfrow=c(2,3), oma=c(4,4,2,0), mar=c(0,2,1,0)+.1, pty='s')

 for (fq in 2:7) {
  if (fq == 7)
     fq = seq(128,240, by=2)
   else
     fq = seq(2^fq, 2^(fq+1)-1, by=2)

  Ordinals = match(fq, BANDS.SEQ)
  if (any(is.na(Ordinals)))
     stop("Asked for a frequency that was not computed")
  hz = Ordinals

  RemoveMissing(hz)

  udata = apply(Tdata[hz,,,], c(2:4), mean, na.rm=T) 	# avg over requested hz

  if (ALIGN_ON_UNIT)
     udata = SortAndAlignBasedOnUnits(udata)

 if (MERGE_STACKS & STACKS > 3)				# Merge stacks 63:65
    udata[,2,] = apply(udata[,2:4,], c(1,3), mean, na.rm=T)

  adata = udata				# Start with unaligned data
  for (site in 1:dim(udata)[3]) {
      best = BestClass(udata[,ALIGN_ON_STACK,site])
      adata[,,site] = Rotate(udata[,,site], best)
      rm(best)
      }

 # Set up the plot
  LIM1 = -2.0 * (2-SCALE)
  LIM2 =  4.5 * (2-SCALE)
  plot(0,0, xlim=c(LIM1, LIM2), ylim=c(LIM1,LIM2), type='n',
       xlab="", ylab="",
       main= paste(fq[1], "-", fq[length(fq)], "Hz"), font.main=2,
       axes=F)
  # box(bty="l")

  axis(1, at=c(-2,0,2,4)*(2-SCALE), if (par()$mfg[1]!=2) labels=F)
  axis(2, at=c(-2,0,2,4)*(2-SCALE), if (par()$mfg[2]!=1) labels=F)

  segments(LIM1+1,LIM1+1, LIM2-1,LIM2-1, col="gray", lwd=2)

  for (st in (1:ifelse(MERGE_STACKS, 2, STACKS))) {
     if (st == 5) next
     u = ComputeBias(udata[,st,], ALIGN_ON_STACK, ReturnIndis=T)
     a = ComputeBias(adata[,st,], ALIGN_ON_STACK, ReturnIndis=T)
     cat("Not sure if this works ...\n")

     ubias = 100 * mean(u)				# 1st avg over classes
     u_err = 100 * SEM (u)				# Take SEM over sites
     abias = 100 * mean(a)				# 1st avg over classes
     a_err = 100 * SEM (a)				# Take SEM over sites
     Pvals = t.test(u-a)$p.value < 0.05

     segments(ubias+u_err, abias,
	      ubias-u_err, abias,       col=S_MAP[st])
     segments(ubias,       abias+a_err,
	      ubias,       abias-a_err, col=S_MAP[st])
     points(  ubias,       abias,       col=S_MAP[st], pch=21, lwd=3,
	       cex=ifelse(Pvals & (abias>ubias), 3.5,  2),
	    	bg=ifelse(Pvals, S_MAP[st], "white"))
     }
  }

 mtext("Visual hemifield aligned (% contra bias)",
             side=1, line=-1, outer=T, adj=0.5, font=2)


 # par(las=3)
 mtext("Movement aligned (% bias)",
      side=2, line= 1, outer=T, adj=0.5, font=2, las=3,
     				 col = S_MAP[ALIGN_ON_STACK[1]])

 if (any(ALIGN_ON_STACK != 0))
    mtext(paste("Aligned on stack", ALIGN_ON_STACK, 
	 	"-- Classes 1 and 5 excluded"),
     				 col = S_MAP[ALIGN_ON_STACK[1]],
      side=1, line=-24, outer=T, adj=0.5, font=2, cex=.9)

 # par(las=1)

 } else

###########################################################################
# Bias as a function of frequency
if (FREQ_PLOT) {

 A_STACK = if (any(ALIGN_ON_STACK==0)) MIMIC.ALIGN_ON_STACK else ALIGN_ON_STACK

 # Set up the plot
 par(mfrow=c(1,1), mar=c(3,4,4,2)+.1)

 LIM1 = -10
 LIM2 =  10
 if (SCALE==1) {
    LIM1 = LIM1 / 2
    LIM2 = LIM2 / 3
    }
 X_Values = if (WINDOW==160) 
		which(BANDS.SEQ > 10) else 1:length(BANDS.SEQ)

 Title = "Contra power bias"

 if (all(A_STACK== 0) & (ALIGN_ON_UNIT==0)) {
    Title = paste(Title, " -- raw alignment")
  } else 
    Title = paste(Title, 
    if (any(ALIGN_ON_STACK==-1))       "-- Aligned @ freq" else
    if (any(ALIGN_ON_STACK!= 0))       "-- Aligned"        else
    if (any(MIMIC.ALIGN.ON.STACK==-1)) "-- Mimic all"      else
    if (any(MIMIC.ALIGN.ON.STACK!=0))  "-- mimic aligned",
    if (any(A_STACK!=0)) 
       paste("on stack", paste(A_STACK, collapse=" "), "(no class 1+5)"))

 if (ALIGN_ON_UNIT)
    Title = paste(Title, 
      switch(4+ALIGN_ON_UNIT,
	     "only ipsi-preferring units",	# -3, sites near contra cells
	     "only contra-preferring units",	# -2, sites near ipsi cells
	     "mimic align on unit",		# -1  looks like 0 -- pointless
	     "",				#  0: nothing
	     "align on unit",			#  1: align on near unit's PD
	     "align, just contra-preferring",	#  2: like -2, but aligned
	     "align, just ipsi-preferring"))	#  3: like -2, but aligned


 plot(1,1, 
        xlim=range(BANDS.SEQ[X_Values]),
	xlab="Frequency (Hz)", 
	log=ifelse(LOG,"x",""),

	ylim=c(LIM1,LIM2), type='n',
	ylab=paste(if(FREQ_DIFF) "Difference in", 
		   if(SCALE== T) "Arbitrary bias units" else "Bias (%)"),

	main= Title,
        col.main = ifelse(length(A_STACK) > 1,
			  "purple",  
		   ifelse(A_STACK,
			  S_MAP[ifelse(A_STACK==-1, 6, A_STACK)],
			  1)),
	bty="n",
	axes=F,
	font.main=2)

 axis(1, at=c(4,8,16,32,64,128,240))
 axis(2, at=if (!SCALE) c(-6,0,6) else c(-4,-2,2,4))

 segments(BANDS.SEQ[X_Values[1]], 0, 
	  X_Values[length(X_Values)], 0, col="gray", lwd=2)

 abias = ubias = matrix(NA, nrow=length(BANDS.SEQ), ncol=STACKS)


 if (all(KeyFreqs != 0)) {	# (if specifying a freq, do not align on unit)
    Ordinals = match(KeyFreqs, BANDS.SEQ)
    if (any(is.na(Ordinals)))
        stop("Asked for a frequency that was not computed")

    RemoveMissing(Ordinals)

    # Get bias of (all) unaligned data (Tdata)
    for (fq in 1:length(BANDS.SEQ))
      ubias[fq,] = ComputeBias(Tdata[fq,,,], AlignedOn=A_STACK)
    	# ubias is freq, stack

    # Align ALL of Tdata, based only on a subset of frequencies (Keydata)
    Keydata = apply(Tdata[Ordinals,,,], (1:3)+(length(Ordinals)>1), mean)
    Adata = Tdata
    for (site in 1:(dim(Tdata)[4])) {
        best = BestClass(Keydata[,A_STACK,site])
        for (fq in 1:length(BANDS.SEQ)) {
           Adata[fq,,,site] = Rotate(Tdata[fq,,,site], best)
    	   }
        rm(best)
        }
   rm(Keydata)			# only used for getting aligns

    # Get bias of (all) aligned data (Tdata)
    for (fq in 1:length(BANDS.SEQ))
      abias[fq,] = ComputeBias(Adata[fq,,,], AlignedOn=A_STACK)

    rm(Adata)
  } else {
    for (fq in 1:length(BANDS.SEQ)) {

     RemoveMissing(fq)

     udata = Tdata[fq,,,]
     #  data(time,freq,class,stack,site)
     # udata(class, stack, site) for ONE time, ONE frequency
     # ubias(stack,freq)

     # Align each site (create "adata") based on unit pref direction
     if (ALIGN_ON_UNIT != 0)
        adata = SortAndAlignBasedOnUnits(udata)

     # Align each site (create "adata")
      else if (any(A_STACK != 0)) {
       adata = udata				# Will re-align this
       for (site in 1:dim(udata)[3]) {
         if (any(A_STACK == -1)) {		# Do all stacks, @ on its own
          for (st in (1:STACKS)) {		# Loop thru all stcks
            best = BestClass(udata[,st,site])
            adata[,,site] = Rotate(udata[,,site], best)
            }
         } else {		# Do only the one stack (or set of stacks)
            best = BestClass(udata[,A_STACK,site])
            adata[,,site] = Rotate(udata[,,site], best)
            }
         }
      rm(best)
      }

     # Start with [au]data: class x stack x site
     # First, collapase over sites and get means per class and stack
     # Then project onto X axis (or alignment axis) and avg over class
     Remove = if (any(A_STACK == -1)) 1:5 else A_STACK
     if (exists("adata"))
        abias[fq,] = ComputeBias(adata, AlignedOn=Remove)
     ubias[fq,] = ComputeBias(udata, AlignedOn=Remove)
     }
  # rm(adata,udata)
  }  

 if (MERGE_STACKS & STACKS > 3) {			# Merge stacks 63:65
    abias[,2] = rowMeans(abias[,2:4])
    ubias[,2] = rowMeans(ubias[,2:4])
    }

 for (st in (1:ifelse(MERGE_STACKS, 2, STACKS))) {
    if (st == 5) next

    y1 = 100 * abias[X_Values,st]
    y2 = 100 * ubias[X_Values,st]

    if (FREQ_DIFF)
	y1 = y1 - y2


    if (SMOOTH) {
	SUPSMU = F
        if (SUPSMU) {
	   y1 = supsmu(BANDS.SEQ[X_Values], y1, bass=0)$y
	   y2 = supsmu(BANDS.SEQ[X_Values], y2, bass=0)$y
	 } else {
	   # 4:40 Hz => 1 to 19
	   y1[1:19] = lowess(BANDS.SEQ[X_Values][1:19], y1[1:19], f=.2)$y
	   y2[1:19] = lowess(BANDS.SEQ[X_Values][1:19], y2[1:19], f=.2)$y
	   y1[20:119] = lowess(BANDS.SEQ[X_Values][20:119], y1[20:119], f=.3)$y
	   y2[20:119] = lowess(BANDS.SEQ[X_Values][20:119], y2[20:119], f=.3)$y
	   }
        }


    lines(BANDS.SEQ[X_Values], y1, col=S_MAP[st], lwd=3)

    if (!FREQ_DIFF)
       lines(BANDS.SEQ[X_Values], y2, col=S_MAP[st], 
	     lwd=3 + 2*is.nan(y1) + 2*is.na(y1),
	     lty=2 - is.nan(y1) - is.na(y1))	# If no y1, show heavy solid


    if (SAVE_FLAG) {
       assign(paste0("SaveY1_",st, "_", 
		  switch(1+CC_INACT.OVERRIDE%%10,"EM","CC","CCC")), y1)
       if (!FREQ_DIFF)
          assign(paste0("SaveY2_",st, "_", 
		  switch(1+CC_INACT.OVERRIDE%%10,"EM","CC","CCC")), y2)
       }
    }

 if (any(A_STACK!=0) & any(KeyFreqs!=0)) {	# Misses discontinuous sets!
    if (length(KeyFreqs) > 1)
       axis(1, at=range(KeyFreqs), lwd=8, col="purple", 
	    labels=F, lwd.ticks=0)		# No labels or ticks
     else
       axis(1, at=KeyFreqs-1, KeyFreqs+1, lwd=3, col="purple")
    }

 if (SAVE_FLAG)
    assign(paste0("SaveN_",switch(1+CC_INACT.OVERRIDE%%10, "EM","CC","CCC")),
	  dim(udata)[3])
 }
###########################################################################

 mtext(paste(ifelse(MONK=="{tyr,zen}","both",MONK),
 	    AREA,
 	    HEMI,
 	    MEMORY, SACONLY,
 	    if (CC_INACT.OVERRIDE)
 	       switch(2+INACT_TIME, "Pre-inact","Peri-inact", "Post-inact"),
	    switch(1+CC_INACT.OVERRIDE%%10, "", "cc", "ccc"),
 	    if (SCALE==T) "Scaled",
 	    if (CHRONUX) "Chronux",
 	    "  ",
	    if (POLAR_PLOT) {
              if (length(hz) < 4)
                 paste(paste(round(BANDS.SEQ[hz]),collapse=" "), "Hz")
              else
                 paste0(round(BANDS.SEQ[hz[1]]), "-", 
 		      round(BANDS.SEQ[hz[length(hz)]]),
 		      " Hz (by ", 
 		      round(BANDS.SEQ[hz[2]]) - 
 		      round(BANDS.SEQ[hz[1]]), ")")
	      }
	    ),
 	outer=T, side=3, line=-0.5, adj=.6, cex=1.6, font=2)
 
mtext(paste(
	 dim(udata)[3],
	 if (FREQ_PLOT & (any(ALIGN_ON_UNIT | ALIGN_ON_STACK) != 0))
	   if (dim(adata)[3] != dim(udata)[3])
	    paste("-->", dim(adata)[3]),
	 "sites", 
	 "   ",
         "Align on", switch(ALIGN, 
			 target="target", gocue="go cue", go="movement",
			 sac   ="saccade", "target"),
	 "   ",
	 XtoMs(LEFT), "to", XtoMs(RIGHT), "ms"),
      side=1, line=2, outer=T, adj=0.5)


mtext(paste(command, collapse=" "),  
	    side=1, line=3, outer=T, adj=0.01, cex=.6)
mtext(paste0("Z Crit=",CRITERION_Z, ", ", CRITERION_REPLACE),
	    side=1, line=3, outer=T, adj=0.99, cex=.6,
	    font=1+(CRITERION_REPLACE=="NA"))	# site count unreliable if 'NA'

# Legend
if (MERGE_STACKS) {
    mtext("Reach",
 	side=3, line=1.5*.85-2, outer=T, at=0.05, adj=0, col="red")
    mtext("Saccade",
 	side=3, line=0.5*.85-2, outer=T, at=0.05, adj=0, col="black")
  } else
    for (st in 1:(STACKS-1))
      mtext(c("Saccade","Ipsi arm","Contra arm","Same","Apart")[i],
 	side=3, line=(2.5-i)*.85-2, outer=T, at=0.05, adj=0, col=S_MAP[i])
 

if (!SAVE_FLAG)
   dev.off()

if (1) {
if (POLAR_PLOT)
   rm(OFFSET, MIN, MAX, grid, LIM, polar.line)

if (POLAR_PLOT || SCATTER_PLOT)
   rm(Ordinals)

rm(ubias)

if (any(ALIGN_ON_STACK !=0))
   rm(abias)

if (exists("adata"))			# if (!POLAR_PLOT)
   rm(adata)

# if (!FREQ_PLOT)

if (FREQ_PLOT & !SAVE_FLAG)
   rm(LOG, SMOOTH, FREQ_DIFF, KeyFreqs)

rm(POLAR_PLOT,FREQ_PLOT,SCATTER_PLOT)

if (!SAVE_FLAG)
 rm(STIMULATE.OVERRIDE, INTERPOLATE.STIMULATION,
   ALIGN.OVERRIDE, ALIGN_ON_STACK, SCALE.OVERRIDE, SAVE_FLAG,
   hz,
   S_MAP, RIGHT, LEFT,
   rads, degs, angles, angles1, X, Y)
}
