# power2.r	Plot power spectra for 5 stacks, > 1 class
#		Overlay two classes
#		For grant
#		Split: 3 & 5: '1' is purple (2 & 4 are orange)
#		       12:    '8' is purple (4 is orange)



LINES   =  T		# Solid line to show mean
RIBBONS =  T		# Ribbon of +/- 1 SEM (can have both)
SECOND_CLASS_RIBBONS = (CLASS.OVERRIDE=="RL")  # For the null or ipsi field?  
SHOW.STATS = 2		# [F,1,2,...] Number is which set of bands to show
PRINT.DIVERGE = T
PRINT_DATA_FOR_FIGURE = F

REPORT.STIMULATION = STIMULATE.OVERRIDE
EXCISE.STIMULATION = STIMULATE.OVERRIDE 	# Happens in ReadAll.r
StimAt = c(495,520)				# Contaminated range

if (ALIGN.OVERRIDE == "go")
    SHOW.STATS = 0

NAME.PDF = F

X.int = 250		# [250] Spacing between X axis tics

# COMMENT OUT OR CREATE OVERRIDE.OVERRIDE IF USING doAll.r
if (!exists("OVERRIDE.OVERRIDE")) {
  AREA.OVERRIDE = "PRR" # PRR, LIP
  MONK.OVERRIDE = "both"        # tyr, zen, both
  CLASS.OVERRIDE = "PN"   # 'PN'
  MEMORY.OVERRIDE = F   # Only zen, LIP
  SACONLY.OVERRIDE = F
  STIMULATE.OVERRIDE = F   # Only zen
  CC_INACT.OVERRIDE = F   # Only zen
  SACSPLIT.OVERRIDE = 0 # 0 or 1 (not true or false!) (With 'pref' gives errs)
  SPLITCODE.OVERRIDE = "15.1"   # "3.1" or "12.1", for examples
  ALIGN.OVERRIDE = ""   # ""(target), "end"(cue), "gocue", "go", "sac" or "EOT"
  NEAR.OVERRIDE = 2     # [0,1.25]
  FREQ.OVERRIDE = "4:240:2"
  SCALE.OVERRIDE = T
  AssumeLIP_PD = F
  ALIGN.BASELINES = F
  HEMI.OVERRIDE = ''	# L, R, LL, RR
  INTERPOLATE.STIMULATION = F
  }

SHOW.STACKS = if (AREA.OVERRIDE=="LIP") 1:4 else 1:5 # 1:4 for LIP, 1:5 for PRR
SHOW.STACKS = if (STIMULATE.OVERRIDE) 1:4 else 1:5
if (ALIGN.OVERRIDE == "go") 
   SHOW.STACKS = SHOW.STACKS[-1]		# Drop 'sacs' if go-aligned
# SHOW.STACKS = SHOW.STACKS[!(SHOW.STACKS %in% SKIP.STACK)]
if (SACONLY.OVERRIDE)
   SHOW.STACKS = 1

FOR.GRANT = F

SCATTER = 0				# compatibility with power.r

origALIGN.BASELINES = ALIGN.BASELINES
origALIGN = ALIGN.OVERRIDE

if (NORMALIZE.OVERRIDE && 		# Need the baseline data
    (ALIGN.OVERRIDE=="gocue"||ALIGN.OVERRIDE=="go"||ALIGN.OVERRIDE=="sac")) {
   ALIGN.OVERRIDE = ""			# Target-aligned
   source("ReadAll.r")
   saved.normalize = copy.normalize     # Baseline from targ-aligned; 
                                        # Used to normalize go[cue]-aligned data
   saved.scale = copy.scale     	# from targ-aligned;
   saved.files = files          	# Check that all the files are there
   rm(copy.normalize, copy.scale)
   ALIGN.OVERRIDE = origALIGN		# Restore for reading main data
   ALIGN.BASELINES = F          	# No need to do again on main data
   }

source("ReadAll.r")	# extended -- merged across all classes, just 1 delay


if (classes == 1)		# time, bands, classes, stacks, units
   cat("Better to use StackPower.r!\n")

if (length(dev.list()) > 0)
   cat(length(dev.list()), "devices open\n")

# Plots = list(c(10,20), 4, c(70,80,90,100,110,120))
# Plots = list(c(20,30), c(70,80,90,100,110,120))
# Plots = list(20, c(70,80,90,100,110,120))
# Plots = list(seq(16,28,2), seq(70,240,2))
# Plots = list(seq(16,26,2), seq(28,36,2), seq(70,240,2))
Plots = list(seq(20,30,2), seq(70,120,2))
# Plots = list(13,15,24,28,80)

if (MATCHING) {				# must use single band entries
    MatchBand <- function(f) return(BANDS.SEQ[order(abs(BANDS.SEQ-f))][1])
    Plots = lapply(Plots, MatchBand)
    }

for (l in 1:length(Plots)) {		# Replace freq with ordinal # 
    Ordinals = match(Plots[[l]], BANDS.SEQ)
    if (any(is.na(Ordinals)))
    	stop("Asked for a frequency that was not computed")
    Plots[[l]] = Ordinals
    }


# MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4)) # in ReadData
S_MAP = c("gray30", "green", "red", "blue",	# stack map
          "purple",                             # stack 66 or 661
	  "orange")                             # if splitsac, stack 662


Transparent<-function(someColor, alpha=100) {
   newColor<-col2rgb(someColor)
   apply(newColor, 2, 
	  function(curcoldata) {
		  rgb(red=curcoldata[1], 
		  green=curcoldata[2],
		  blue=curcoldata[3],
		  alpha=alpha*255,
		  maxColorValue=255)
	  	  })
   }
T_MAP = Transparent(S_MAP, .2)

if (NAME.PDF) {
   pdf(paste0("LFPPower",AREA.OVERRIDE,
	      if (NEAR.OVERRIDE != 0) paste0("+",NEAR.OVERRIDE),
	      "_",MONK.OVERRIDE,
	      if (STIMULATE.OVERRIDE) "_stim",
	      if (CC_INACT.OVERRIDE) "_cc",
	      if ((CC_INACT.OVERRIDE%%10)==2) "c",
	      if (CC_INACT.OVERRIDE > 10) "_memory",
	      if (MEMORY.OVERRIDE) "_Mem",
	      if (SACONLY.OVERRIDE) "_saconly",
	      if (ALIGN.OVERRIDE != "") "_", ALIGN.OVERRIDE,
	      if (SACSPLIT.OVERRIDE) paste0("SacSplit_", SPLITCODE.OVERRIDE),
	      if (CHRONUX) "_chronx",
	      "_PN.pdf"))
 } else
   pdf("StackPower.pdf")

if (ALIGN.BASELINES) {			# Should only be target-aligns
   baseline = apply(data[1:MsToX(0),,,,,drop=F], 2:5, mean, na.rm=T)
   baseline = array(rep(c(baseline), each=dim(data)[1]), dim=dim(data))
   data = data - baseline + 1
   rm(baseline)
   }
ALIGN.BASELINES = origALIGN.BASELINES	# Restore for future doAll loops



if (SHOW.STATS) {
   FROM.t = switch(SHOW.STATS, FROM.TIME,  50, -1)
   TO.t   = switch(SHOW.STATS, END.TIME, 350, -1)
   FROM.t = FROM.TIME; TO.t   = END.TIME;
   Value3D = apply(data[MsToX(FROM.t):MsToX(TO.t), 
		   	Plots[[SHOW.STATS]],,,,drop=F], 
	          3:5, mean, na.rm=T)

#   stderr = sqrt(apply(data, 1:3, var, na.rm=T)/length(files))
#   data = apply(data, 1:3, mean, na.rm=T)   # Leaves time, band, stacks
#   Value3D.errs = apply(err[MsToX(FROM.t):MsToX(TO.t), 
#		   	Plots[[SHOW.STATS]],,,,drop=F], 
#	          3:5, mean, na.rm=T)

   cat("Pref minus null,", FROM.t, "to", TO.t, 
       "ms, for each stack (band set #", SHOW.STATS, "):\n")

   for (di in 1:5)
      cat(" ", 61+di, 
          round(mean(Value3D[1,di,]), dig=2), "±",
	  round(sqrt(var(Value3D[1,di,])/dim(Value3D)[3]), dig=2),
          round(mean(Value3D[2,di,]), dig=2), "±",
	  round(sqrt(var(Value3D[2,di,])/dim(Value3D)[3]), dig=2), "p=",
          round(t.test(Value3D[1,di,], Value3D[2,di,], 
		       paired=T)$p.value, dig=3), "\n")
   COMPARE.CLASS = 1
   cat("Adjacent stack comparisons (",
       switch(COMPARE.CLASS,"pref","null"), "only):\n")
   for (di in 1:4)
      cat(" ", 61+di, "vs", 61+di+1,
          round(mean(Value3D[COMPARE.CLASS,di,]), 2),
          round(mean(Value3D[COMPARE.CLASS,di+1,]), 2),
          round(t.test(Value3D[COMPARE.CLASS,di,],
		       Value3D[COMPARE.CLASS,di+1,], 
		       paired=T)$p.value, dig=5), "\n")
    if (SHOW.STATS==2 && COMPARE.CLASS == 1)
       cat("  64 vs 66", 
          round(mean(Value3D[COMPARE.CLASS,64-61,]), 2),
          round(mean(Value3D[COMPARE.CLASS,66-61,]), 2),
	  round(t.test(Value3D[COMPARE.CLASS,64-61,], 
		Value3D[COMPARE.CLASS,66-61,], paired=T)$p.value, dig=3),"\n")

   Value2D  = matrix(NA, ncol=4, nrow=2 * 5 * length(files))
   colnames(Value2D) = c("value","class", "stack", "file")
   di = 1
   for (dj in 1:2)
    for (dk in 1:5)
     for (dl in 1:length(files)) {
      Value2D[di,] = c(Value3D[dj,dk,dl], dj, dk, dl)
      di = di + 1
      }
   Value2D = data.frame(value=Value2D[,"value"], 
		     class=as.factor(Value2D[,"class"]), 
	             stack=as.factor(Value2D[,"stack"]), 
		     file=as.factor(Value2D[,"file"]))
   Aov = aov(value ~ class * stack, data=Value2D)
   # print(anova(Aov))
   rm(dj,dk,dl,di)
   rm(FROM.t,TO.t,Value3D,Value2D,COMPARE.CLASS)
   }

# Average over all cells!	# time, bands, classes, stacks, units
stderr = sqrt(apply(data, c(1,2,3,4), var, na.rm=T) / length(files))
mdata = apply(data, c(1,2,3,4), mean, na.rm=T) 
				# Leaves time, band, classes, stacks
if (PRINT_DATA_FOR_FIGURE) {
   if (MONK == "{tyr,zen}")
      sink("Figure3A-B_Data.txt")
    else if (MONK == "tyr")
      sink("FigureS8_MkT_Data.txt")
    else if (MONK == "zen")
      sink("FigureS8_MkZ_Data.txt")
    else
      sink("FigurePower_Data.txt")
   cat("Raw data dimensions:\n\n")
   print(dimnames(data))
   cat("\n\n\nData:\n")
   options(max.print=9999999)
   print(data)
   options(max.print=99999)
   sink()
   }

LEFT = switch(ALIGN, target=1, gocue=MsToX(-500), go=MsToX(-500), 
	      sac=MsToX(-500), 1)
# LEFT = 1 			# Don't expand - make same scale as target_align

if (MATCHING & ALIGN=="") {			# Trim the gnarly edges
   LEFT  = LEFT  + (MsToX(100) - MsToX(0))
   times = times - (MsToX(250) - MsToX(0))	# switch() for diff aligns?
   }

RIGHT = times


TicsAtMs = X.int*((XtoMs(LEFT)%/%X.int):(XtoMs(RIGHT)%/%X.int))
if (TicsAtMs[1] < XtoMs(LEFT))
	   TicsAtMs = TicsAtMs[-1]
L = length(TicsAtMs)
if (TicsAtMs[L] > XtoMs(RIGHT))
       TicsAtMs = TicsAtMs[-L]


# Set up the plot
par(mfrow=c(length(Plots),1), las=1, mar=c(0,0,2,0)+.1, oma=c(6,5,3,2))
par(xpd=NA)


for (p in 1:length(Plots)) {
   hz = Plots[[p]]
   # Range = range(c(.65,1.5,mdata[,hz,,]), na.rm=T)
   if (length(hz) == 1)
      Range = range(c(.7,1.3,mdata[LEFT:times,hz,,,drop=F]), na.rm=T)
    else
      Range = range(c(.7,1.3,
	     apply(mdata[LEFT:times,hz,,,drop=F],c(1,3,4),mean,na.rm=T)),na.rm=T)

   plot(0,0, xlim=c(LEFT,times), ylim=Range,
		axes=F, xlab="",ylab="",bty='n',type='n', lwd=2)

   if (p==1 & FOR.GRANT)
      title(paste("Normalized LFP power in", AREA))

   axis(2, at=c(.8,1,1.2), labels=c("-20%", "", "+20%"), cex.axis=1.5)
   axis(1, at=MsToX(TicsAtMs), labels = F, cex.axis=1.5)

   # axis(2, at=c(.8,1,1.2), labels=c("-20%", "", "+20%"), cex.axis=1.5)

   segments(MsToX(0),    0,
	    MsToX(0),    mean(par()$usr[3:4], na.rm=T), lwd=3, xpd=F)
   segments(MsToX(1257), 0,
	    MsToX(1257), mean(par()$usr[3:4], na.rm=T), lwd=3, xpd=F)

   if (RIBBONS)
   # for (st in if (FOR.GRANT) 3 else SHOW.STACKS) {
   for (st in SHOW.STACKS) {			# Errors for all
      plus = (mdata+stderr)[LEFT:times,hz,1,st]
      minus= (mdata-stderr)[LEFT:times,hz,1,st]
      if (length(hz) > 1) {
	  plus  = rowMeans(plus, na.rm=T)
	  minus = rowMeans(minus, na.rm=T)
          }
      polygon(c(LEFT:times, times:LEFT),
	      c(plus, rev(minus)),
	      density=-1, border=ifelse(LINES,0,S_MAP[st]), col=T_MAP[st],lwd=2)

      if (SECOND_CLASS_RIBBONS) {
       plus = (mdata+stderr)[LEFT:times,hz,2,st]
       minus= (mdata-stderr)[LEFT:times,hz,2,st]
       if (length(hz) > 1) {
	  plus  = rowMeans(plus, na.rm=T)
	  minus = rowMeans(minus, na.rm=T)
          }
       polygon(c(LEFT:times, times:LEFT),
	      c(plus, rev(minus)),
	      density=-1, border=ifelse(LINES,0,S_MAP[st]), col=T_MAP[st],lwd=2)
       }
      }

   if (LINES)
    for (st in (SHOW.STACKS)) {
      lines(LEFT:times, 
	    if (length(hz)==1) mdata[LEFT:times,hz,1,st] else 
		      rowMeans(mdata[LEFT:times,hz,1,st],na.rm=T),
	    col=S_MAP[st], lwd=4+FOR.GRANT*4)
      lines(LEFT:times, 
	    if (length(hz)==1) mdata[LEFT:times,hz,2,st] else 
		      rowMeans(mdata[LEFT:times,hz,2,st],na.rm=T),
	    col=S_MAP[st], lwd=2, lty=2+FOR.GRANT*2)
      } # }

   if (FOR.GRANT == F)
      text(LEFT, Range[2]*.97, 
           if (length(hz) < 4)
              paste(paste(round(BANDS.SEQ[hz]),collapse=" "), "Hz")
            else
              paste0(round(BANDS.SEQ[hz[1]]), "-", 
		     round(BANDS.SEQ[hz[length(hz)]]),
		    " Hz (by ", 
		    round(BANDS.SEQ[hz[2]]) - 
		    round(BANDS.SEQ[hz[1]]), ")"),
	   col="red", adj=0, cex=1)

   if (PRINT.DIVERGE) {
      DIVERGE.LENGTH = 10
      DIVERGE.PAIRED = T
      DIVERGE.PVALUE = .01
      cat(range(BANDS.SEQ[hz]), "Hz; Length=", DIVERGE.LENGTH,
      		 "; Paired=", DIVERGE.PAIRED,
      		 "; Pvalue=", DIVERGE.PVALUE,
		 "\n")
      for (st in 2:STACKS) {
         sig.count = 0
         for (tt  in round(MsToX(0)+.5):times) {
             a = data[tt, hz, 1, st-1, ]
             b = data[tt, hz, 1, st  , ]
             if (DIVERGE.PAIRED) {
                out = is.na(a+b)
                a = a[!out]
                b = b[!out]
                rm(out)
                }
             if (t.test(a,b,paired=DIVERGE.PAIRED)$p.value<DIVERGE.PVALUE) {
                 sig.count = sig.count + 1
              } else
                 sig.count = 0
             if (sig.count >= DIVERGE.LENGTH) {
                cat(st-1, "vs", st, ":", XtoMs(tt-DIVERGE.LENGTH), "\n")
                break
                }
             }
          }
      # Now look at in versus out
      for (st in 1:STACKS) {
         sig.count = 0
         for (tt  in round(MsToX(0)+.5):times) {
             a = data[tt, hz, 1, st, ]
             b = data[tt, hz, 2, st, ]
             if (DIVERGE.PAIRED) {
                out = is.na(a+b)
                a = a[!out]
                b = b[!out]
                rm(out)
                }
             if (t.test(a,b,paired=DIVERGE.PAIRED)$p.value<DIVERGE.PVALUE) {
                 sig.count = sig.count + 1
              } else
                 sig.count = 0
             if (sig.count >= DIVERGE.LENGTH) {
                cat(st, "in v out", ":", XtoMs(tt-DIVERGE.LENGTH), "\n")
                break
                }
             }
          }
      }
   }


text(MsToX(30),   par()$usr[3]+.07, 
     switch(ALIGN, gocue="Cue", go="Move", sac="Saccade", "Target"),
     adj=0, cex=1)

if (ALIGN == "")
   text(MsToX(1200), par()$usr[3]+.07, "Go cue", adj=1, cex=1)

axis(1, at=MsToX(TicsAtMs), labels=TicsAtMs, cex.axis=1.5)

if (FOR.GRANT == F) {
  title(xlab=paste("Time (ms re:",
	            switch(ALIGN, 
			 target="target", gocue="go cue", go="movement",
			 sac   ="saccade", "target"),
	   	    "onset)"),
	cex.sub=1.5, cex.lab=1.5)

  mtext(paste(length(files), "units"), side=1, line=3, outer=T, adj=-0.1, cex=1.3)
  mtext(paste(command, collapse=" "),  side=1, line=4, outer=T, adj=1, cex=.6)
  if (CRITERION_Z)
  mtext(paste("Criterion Z =", CRITERION_Z), adj=0, side=1, line=4.5, outer=T, cex=.6)

  for (i in SHOW.STACKS)
     mtext(paste(
	     ifelse(STIMULATE.OVERRIDE, c(32,35,62,65)[i], 61+i), 
	     if (STIMULATE.OVERRIDE)
               c("Saccade-stim","Same-stim","Saccade","Same")
	     else
               c("Saccade","Ipsi arm","Contra arm","Same",
		if (SACSPLIT) "Opp:1" else "Opposite",
		if (SACSPLIT) "Opp:2"))[i],
	side=3, line=(2.5-i)*.85, outer=T, at=-.1, adj=0, col=S_MAP[i])

#  mtext(paste(MONK, AREA, HEMI, 
#	    if (NEAR>0) paste0("+",NEAR), CLASS, MEMORY, SACONLY, ALIGN),
#      outer=T, side=3, line=1, adj=.4, cex=1.6)

  mtext(paste(ifelse(MONK=="{tyr,zen}","both",MONK),
	      AREA,
	      HEMI,
	      if (NEAR) paste0("+",NEAR), 
	      "Class:", CLASS, 
	      MEMORY, SACONLY, STIMULATE,
	      if (CC_INACT.OVERRIDE) 
	         switch(2+INACT_TIME, "PRE-INACT","PERI-INACT", "POST-INACT"),
	      if (SACSPLIT) paste0("Split by sac:", SPLITCODE),
	      if (SCALE==F) "UNSCALED",
	      if (CHRONUX) "Chronux",
	      ALIGN),
	outer=T, side=3, line=-1.3, adj=.5, cex=1.6)


  mtext(ifelse(CLASS=="RL", 
	       paste0("Uni & apart:    X'd=dashed    unX'd=solid\n",
		      "Sac & same:    ipsi=dashed   contra=solid\n"),
		          "Pref direction (solid)\nNull direction (dashed)"),
      outer=T, side=3, line=0, at=1, adj=1, col="red")
  # Recording is flipped (normalized) so on the left; right targ == contra

  }

dev.off()

#rm(STIMULATE.OVERRIDE, INTERPOLATE.STIMULATION, ALIGN.OVERRIDE, SCALE.OVERRIDE)
   
# rm(AREA.OVERRIDE, CLASS.OVERRIDE, MONK.OVERRIDE, CC_INACT.OVERRIDE,
#   MEMORY.OVERRIDE, SACSPLIT.OVERRIDE)
