# power.r   Plot power spectra for 5 stacks, ONE class (Larry)
#		  And scatter plot

LINES   =  T		# Solid line to show mean
RIBBONS =  T		# Ribbon of +/- 1 SEM (can have both)
PRINT.MEANS = F		# Won't work for other alignments!
PRINT.DIVERGE = T
PRINT_DATA_FOR_FIGURE = F
StimAt = c(495, 520)				# Contaminated range

SKIP.STACK = 0		# [0], or [1] for skip saccade stack
SKIP.STACK = 1 * (ALIGN.OVERRIDE == "go")	# Skip sacs if "go"-align

selectcell = F		# plot only specific cells

SCATTER =  0		# 0: std plot  1: All 5 for each unit  2: 4 x vs y plots
			# In doAll, use MERGE=1 and MONK=c("tyr","zen")
NAME.PDF = F		# [F] 'T' if concat two monkeys in SCATTER=2

X.int = 250		# [250] Spacing between tics on X axis

if (SCATTER) {
   ALIGN.BASELINES = F
   cat("Do not align baselines if using 'scatter' (turning it off!)\n")
   }

if (!exists("OVERRIDE.OVERRIDE")) {
  AREA.OVERRIDE = "PRR"		# PRR, LIP
  MONK.OVERRIDE = "tyr"		# tyr, zen, both
  CLASS.OVERRIDE = ""		# "" (-mc) or 'pref' 
  SCALE.OVERRIDE = T
  CC_INACT.OVERRIDE = F		# Only zen, PRR
  INACT_TIME.OVERRIDE = F		# Only zen, PRR
  MEMORY.OVERRIDE = F		# Only zen, LIP
  SACONLY.OVERRIDE = F
  SACSPLIT.OVERRIDE = 0	# 0 or 1 (not true or false!) (With 'pref' gives errs)
  SPLITCODE.OVERRIDE = "5.1"	# "3.1" or "12.1", for examples
  ALIGN.OVERRIDE = ""	# ""(target), "end"(cue), "gocue", "go", "sac" or "EOT"
  NEAR.OVERRIDE = 2		# [0,1.25]
  FREQ.OVERRIDE = "4:240:2"	# "" (10:120:10)
  ALIGN.BASELINES = F		# Arguably, should do this earlier
  HEMI.OVERRIDE = ''		# L, R, LL, or RR
  STIMULATE.OVERRIDE = F
  }

INTERPOLATE.STIMULATION = 
REPORT.STIMULATION = 
EXCISE.STIMULATION = F  # [T OR STIMULATE.OVERRIDE] [or F]# See ReadAll.r

origALIGN.BASELINES = ALIGN.BASELINES
origALIGN = ALIGN.OVERRIDE

if (NORMALIZE.OVERRIDE && 		# Need the baseline data
    (ALIGN.OVERRIDE=="gocue" ||ALIGN.OVERRIDE=="go" ||ALIGN.OVERRIDE=="sac")) {
   ALIGN.OVERRIDE = ""			# Target-aligned
   source("ReadAll.r")
   saved.normalize = copy.normalize	# Baseline from targ-aligned; 
   					# Used to normalize go[cue]-aligned data
   saved.scale = copy.scale		# from targ-aligned; 
   saved.files = files			# Check that all the files are there
   rm(copy.normalize, copy.scale)
   ALIGN.OVERRIDE = origALIGN		# Restore for reading main data
   ALIGN.BASELINES = F			# No need to do again on main data
   }

source("ReadAll.r")	# extended -- merged across all classes, just 1 delay


if (classes != 1)		# time, bands, classes, stacks, units
   cat("Classes must be merged to run this!\n")
data = data[,,,,]		# Remove empty classes dimension

if (length(dev.list()) - (SCATTER>0) > 0)
   cat(length(dev.list()), "devices open\n")

# Plots = list(c(20,30), c(70,80,90,100,110,120))
# Plots = list(seq(16,28,2), seq(70,240,2))
# Plots = list(20, c(22,24,26), seq(70,120,10))
# Plots = list(30, 40, 100)
# Plots = list(seq(22,26,2), seq(70,150,10))
# Plots = list(seq(20,30,2), seq(70,150,2))	# USE THIS ONE
# Plots = list(seq(24,36,2), seq(70,150,2))	# coherence uses this
# Plots = list(13, 15, 24, 28, 80)		# For the other method
# Plots = list(seq(16,24,2), seq(20,30,2))	# for lesion data?
 Plots = list(seq(20,30,2));

if (CHRONUX) {
   MatchBand <- function(f) return(BANDS.SEQ[order(abs(BANDS.SEQ-f))][1])
   for (l in 1:length(Plots))
      for (m in 1:length(Plots[[l]]))
	  Plots[[l]][m] = MatchBand(Plots[[l]][m])
   }


if (MATCHING.OVERRIDE) {		# MUST USE SINGLE BAND ENTRIES !!
   MatchBand <- function(f) return(BANDS.SEQ[order(abs(BANDS.SEQ-f))][1])
   Plots = lapply(Plots, MatchBand)
   }


for (l in 1:length(Plots)) {    # Replace frequency with ordinal #
   Ordinals = match(Plots[[l]], BANDS.SEQ)
   if (any(is.na(Ordinals)))
       stop("Asked for a frequency that was not computed")
   Plots[[l]] <- Ordinals
   }

if (selectcell) {
   position = array(, dim= c(1,0))
   cellind = array(,dim=c(1,0))
   a = unlist(strsplit(celllist,'[.]'))
   b=matrix(a,ncol=length(celllist),nrow =2)
   for (cell in 1:length(celllist)) {
       site = b[1,cell]
       str = paste0(b[1,cell],".[1-9]_",b[2,cell])
       ind = grep(str,files)
       if (length(ind)>1) {
          sub = matrix(unlist(strsplit(substring(files[ind],42),'[.]')),
		       				    ncol=length(ind),nrow=2)
          sub = sub[1,1:length(ind)]
          ind = ind[which(sub==site)]
          }
       if (length(ind)) {
          position = array(c(position,cell), 
			   	dim=c(1,length(position)+length(cell)))
          cellind = array(c(cellind,ind),dim=c(1,length(cellind)+length(ind)))
          }
       }
   if (length(cellind) < 1)
       cat("NO MATCHING CELLS FROM THE FILE LIST\n")

   # Save list of selected cells from files list:
   whichcells = substring(files[cellind],42)
   }

# MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4))  # ReadAll.r
S_MAP = c("gray30", "green", "red", "blue", "purple",	# stack map
	  "orange")				# If SacSplit!
Index = (StackList%%10)-1		# Only last digit matters
S_MAP = S_MAP[Index]			# Keep just the colors we use
			# Not sure if it works for SacSplit
StackNames = c("Saccade","Ipsi arm","Contra arm","Same",
		if (SACSPLIT) "Opp:1" else "Opposite",
		if (SACSPLIT) "Opp:2")
StackNames = StackNames[Index]		# Again, keep just those we use
rm(Index)


Transparent<-function(someColor, alpha=100) {
   newColor<-col2rgb(someColor)
   apply(newColor, 2, 
	  function(curcoldata) {
		  rgb(red=curcoldata[1], 
		  green=curcoldata[2],
		  blue=curcoldata[3],
		  alpha=alpha*255,
		  maxColorValue=255)
	  	  })

   }
T_MAP = Transparent(S_MAP, .2)		# Fraction is opacity (larger=darker)


if (ALIGN.BASELINES) {  		# Should only be target-aligns
   baseline = apply(data[1:MsToX(0),,,], 2:4, mean, na.rm=T)
   baseline = array(rep(c(baseline), each=dim(data)[1]), dim=dim(data))
   data = data - baseline + 1
   rm(baseline)
   }
ALIGN.BASELINES = origALIGN.BASELINES   # Restore for future doAll loops


if (SCATTER) {
 pdf("StackPower.pdf")
 par(las=1)
 Ending = if (MsToX(END.TIME) > dim(data)[1]) dim(data)[1] else MsToX(END.TIME)
 par(las=1)

 values = apply(data[MsToX(FROM.TIME):Ending,		# e.g., c("10","20")
	            as.character(BANDS.SEQ[Plots[[1]]]), , ],
	       if (length(Plots[[1]]) > 1) {	# More than one band?
	          c(3,4)			# Avg over stacks & units
	        } else
	          c(2,3),		# Same operation, diff indexing
	       "mean", na.rm=T)		# Avg over stacks & units
	# dim 1: time:interval of interest (avg over)
	# dim 2: power bands of interest (avg over)
	# dim 3: classes -- only 1 (-mc) so drops out
	# dim 4: stacks (retained)
	# dim 5: units (retained)

 if (SCATTER == 1) {
    plot(0,0, xlim=c(0,length(files)), ylim=range(values,na.rm=T),
     type='n', bty='n',
     xlab="Cells", ylab="Normalized power",
     main=paste0("Power, per site," , FROM.TIME, "-", 
	   XtoMs(Ending), "ms after target onset   ",
	   paste(as.character(round(BANDS.SEQ[Plots[[1]]])),collapse=" "),"Hz"))

    for (st in 1:STACKS)
      points(1:length(files), values[st,], col=S_MAP[st], pch=19)

    legend("topright", legend=paste(StackList, StackNames),
	col=S_MAP[1:STACKS], lwd=3)
   } else {
    # if (MONK.OVERRIDE != 'zen') {
    #    par(mfrow=c(2,2), pty='s', mar=c(4,4,.5,.5)+.1, oma=c(0,0,1,0)) # First
    #    Col = 2; Cex = .7; Pch = 21; Bg = 2	# For OnePlot()
    #  } else {
    #    Col = 3; Cex = .7; Pch = 21; Bg = "transparent"
    #    cat("Very similar (±1%) if you do not scale (map to -1:1)\n")
    #    }

    par(mfrow=c(2,2), pty='s', mar=c(4,4,.5,.5)+.1, oma=c(0,0,2,0))

    OnePlot = function(x,y) {
       plot(values[x,], values[y,], xlab=Name[x], ylab=Name[y], axes=F,
	    xlim=c(0,2), ylim=c(0,2), col=2, cex=.7, pch=21, bg=2)
       segments(0.1,0.1,1.8,1.8)
       axis(1, at=c(.5,1,1.5), labels=c("-50%", "", "+50%"))
       axis(2, at=c(.5,1,1.5), labels=c("-50%", "", "+50%"))
       text(2, ifelse(MONK.OVERRIDE=="tyr",.2, .1),
	    paste0("Above/total: ", 
	        sum(values[y,] > values[x,]), 
		"/",
		sum(values[y,] != values[x,]),	# ignore values on line!
		" (",
	        round( sum(values[y,] > values[x,]) / 
		       sum(values[y,] != values[x,])*100),
		"%)"),
	    adj = 1, col = ifelse(MONK.OVERRIDE=="tyr",2,3), cex=.7)
       }
    Name = c("Saccades", "Ipsimanual Reach", "Contramanual reach", 
	  "Bimanual-together", "Bimanual-apart")

    OnePlot(2,1)
    OnePlot(3,2)
    OnePlot(4,3)
    OnePlot(5,4)
    }
 Band.one = BANDS.SEQ[Plots[[1]][1]]
 Band.end = BANDS.SEQ[Plots[[1]][length(Plots[[1]])]]
 mtext(paste0("Normalized power per site, ", 
	     ifelse(Band.one==Band.end,
		    Band.one,
		    paste0(Band.one, " - ", Band.end)),
		   " Hz in", AREA.OVERRIDE,
		   ", ", FROM.TIME, "-", XtoMs(Ending),
		   " ms after target onset",
	     if (CC_INACT.OVERRIDE) 
	       paste0("\n", switch(2+INACT_TIME.OVERRIDE,
		      		"PRE", "PERI", "POST"), " inact")),
	side=3, line=-1, outer=T)
 dev.off()
 rm(Ending)
} else {		# END OF SCATTER PLOT


if (NAME.PDF) {
   pdf(paste0("LFPPower",AREA.OVERRIDE,
	      if (NEAR.OVERRIDE) paste0("+", NEAR.OVERRIDE),
	      "_",MONK.OVERRIDE,
	      if (CC_INACT.OVERRIDE) "_cc",
	      if ((CC_INACT.OVERRIDE%%10)==2) "c",
	      if (CC_INACT.OVERRIDE > 10) "_memory",
	      if (SACONLY.OVERRIDE != "") "_saconly",
	      if (MEMORY.OVERRIDE != "") "_mem",
	      if (ALIGN.OVERRIDE != "") "_", ALIGN.OVERRIDE,
	      if (SACSPLIT.OVERRIDE) paste0("SacSplit_", SPLITCODE.OVERRIDE),
	      if (CHRONUX) paste0("_chronux"),
	      ".pdf"))
 } else
   pdf("StackPower.pdf")

# Average over all cells!	# time, bands, (classes), stacks, units
if (selectcell) {
   stderr = sqrt(apply(data[,,,cellind], 1:3, var, na.rm=T)/length(cellind))
   mdata = apply(data[,,,cellind],1:3, mean, na.rm=T)
 } else {
   stderr = sqrt(apply(data, 1:3, var, na.rm=T)/length(files))
   mdata = apply(data, 1:3, mean, na.rm=T)   # Leaves time, band, stacks
   }				# 'mdata' == mean data

if (PRINT_DATA_FOR_FIGURE & (ALIGN.OVERRIDE != "")) {
   if (ALIGN.OVERRIDE == "go")
      sink("FigureS10B_Data.txt")
    else if (ALIGN.OVERRIDE == "gocue")
      sink("FigureS10C_Data.txt")
    else if (ALIGN.OVERRIDE == "sac")
      sink("FigureS10A_Data.txt")
    else
      sink("FigureS10_Data.txt")

   cat("Raw data dimensions:\n\n")
   print(dimnames(data))
   cat("\n\n\nData:\n")
   options(max.print=9999999)
   print(data)
   options(max.print=99999)
   sink()
   }

# Set up the plot
par(mfrow=c(length(Plots),1), las=1, mar=c(0,0,2,0)+.1, oma=c(6,5,3,2))
par(xpd=NA)

LEFT = switch(ALIGN, target=1, gocue=MsToX(-500), go=MsToX(-500), 
	                       sac=MsToX(-500), 1)
if (LEFT < 1) {
   cat("(Should not see this!) Changing LEFT from", LEFT, "to 1\n")
   LEFT = 1
   }

if (MATCHING.OVERRIDE) {			# Trim the gnarly edges
   LEFT  = LEFT  + (MsToX(90) - MsToX(0))
   times = times - (MsToX(250) - MsToX(0))	# switch() for diff aligns?
   }

RIGHT = times

TicsAtMs = X.int*((XtoMs(LEFT)%/%X.int):(XtoMs(RIGHT)%/%X.int))
if (TicsAtMs[1] < XtoMs(LEFT))
   TicsAtMs = TicsAtMs[-1]
L = length(TicsAtMs)
if (TicsAtMs[L] > XtoMs(RIGHT))
   TicsAtMs = TicsAtMs[-L]

for (p in 1:length(Plots)) {
   hz = Plots[[p]]
   # Range = range(c(.5,2,mdata[,hz,]), na.rm=T)	# .65 to 1.5 for gocue?
   if (length(hz) == 1)
      Range = range(c(.7,1.3,mdata[LEFT:times,hz,]), na.rm=T)
    else
      Range = range(c(.7,1.3,
		 apply(mdata[LEFT:times,hz,],c(1,3),mean,na.rm=T)), na.rm=T)

   Range = c( ifelse(SCALE | BANDS.SEQ[hz[1]]>40, 0.6, 0.65),
              ifelse(SCALE | BANDS.SEQ[hz[1]]>40, 1.4, 1.9))  # Hard-wired

   plot(0,0, xlim=c(LEFT,times), ylim=Range,
	    axes=F, xlab="",ylab="",bty='n',type='n', lwd=2)

   if (SCALE|BANDS.SEQ[hz[1]]>40)
      axis(2, at=c(.8,1,1.2), labels=c("-20%", "", "+20%"), cex.axis=1.5)
    else
      axis(2, at=c(.8,1,1.25,1.5,1.75), labels=c("-25%","","","","+75%"), cex.axis=1.5)
   axis(1, at=MsToX(TicsAtMs), labels = F, cex.axis=1.5)

   segments(MsToX(0),    par()$usr[3],
	    MsToX(0),    mean(par()$usr[3:4], na.rm=T), lwd=3, xpd=F)
   segments(MsToX(1257), par()$usr[3],
	    MsToX(1257), mean(par()$usr[3:4], na.rm=T), lwd=3, xpd=F)

   if (RIBBONS)
    for (st in c(1:STACKS)) {
      if (st %in% SKIP.STACK) next
      plus = (mdata+stderr)[LEFT:times,hz,st]
      minus= (mdata-stderr)[LEFT:times,hz,st]
      if (length(hz) > 1) {
	  plus  = rowMeans(plus, na.rm=T)
	  minus = rowMeans(minus, na.rm=T)
          }
      polygon(c(LEFT:times, times:LEFT),
	      c(plus, rev(minus)),
	      density=-1, border=ifelse(LINES,0,S_MAP[st]), col=T_MAP[st],lwd=2)
      }

   if (REPORT.STIMULATION) {
      segments(MsToX(505),  .70, 
               MsToX(505), 1.40, lty="dotted", lwd=3, col="lightgray")
      text(    MsToX(500), 1.30, "Stim")

      # The 550 point includes 350 to 750
      # The 750 point includes 550 to 950
      test_from = round(MsToX(500+WINDOW/2+1))	# round down
      if (MATCHING.OVERRIDE) cat("UGH - must rewrite previous line!\n")
      test_to   = test_from + 1
      segments(test_from,  .70, 
               test_from, 1.40, lty="dashed", col="lightgray")
      segments(test_to  ,  .70, 
               test_to  , 1.40, lty="dashed", col="lightgray")
      text(    test_from, 1.20, "Stim test interval", adj=0)
      cat("Stimulation effect, ", 
            paste0(BANDS.SEQ[hz[1]], "-", BANDS.SEQ[hz[length(hz)]]),
	    "Hz,  saccades:    ",
	    100*round(mean(mdata[test_from:test_to,hz,3], na.rm=T) -
	              mean(mdata[test_from:test_to,hz,1], na.rm=T), dig=3),
	    "%\n")
      cat("Stimulation effect, ", 
            paste0(BANDS.SEQ[hz[1]], "-", BANDS.SEQ[hz[length(hz)]]),
	    "Hz,  bimanual-both:",
	    100*round(mean(mdata[test_from:test_to,hz,4], na.rm=T) -
	              mean(mdata[test_from:test_to,hz,2], na.rm=T), dig=3),
	    "%\n")
      }

   if (LINES)
    for (st in (1:STACKS)) {
      if (st %in% SKIP.STACK) next
      lines(LEFT:times, 
	    if (length(hz)==1) mdata[LEFT:times,hz,st] else 
		      rowMeans(mdata[LEFT:times,hz,st],na.rm=T),
	    col=S_MAP[st], lwd=4)
      }

   if (PRINT.DIVERGE) {
      DIVERGE.LENGTH = 10
      DIVERGE.PAIRED = T
      DIVERGE.PVALUE = .01
      cat(range(BANDS.SEQ[hz]), "Hz; Length=", DIVERGE.LENGTH,
          "; Paired=", DIVERGE.PAIRED,
          "; Pvalue=", DIVERGE.PVALUE,
          "\n")
      for (st in 2:STACKS) {
         sig.count = 0
         for (tt  in round(MsToX(0)+.5):times) {
             a = data[tt, hz, st-1, ]
             b = data[tt, hz, st  , ]
	     if (DIVERGE.PAIRED) {
	        out = is.na(a+b)
	        a = a[!out] 
	        b = b[!out]
		rm(out)
	        }
	     if (t.test(a,b,paired=DIVERGE.PAIRED)$p.value<DIVERGE.PVALUE) {
	         sig.count = sig.count + 1
	      } else
	         sig.count = 0
             if (sig.count >= DIVERGE.LENGTH) {
	        cat(st-1, "vs", st, ":", XtoMs(tt-DIVERGE.LENGTH), "\n")
	        break;
	        }
             }
	  }
      }


   if (PRINT.MEANS)
     if (p==1) {				# only the beta freqs
      cat("Means in interval:",FROM.TIME,"to",END.TIME,"ms; Hz:",range(BANDS.SEQ[hz]),"\n")
      for (st in (1:STACKS))
       if (!(st %in% SKIP.STACK))
        cat(round(mean(mdata  [MsToX(FROM.TIME):MsToX(END.TIME),hz,st]),dig=2),
	    "±",
            round(mean(stderr[MsToX(FROM.TIME):MsToX(END.TIME),hz,st]),dig=2),
	    "\t")
      cat("\n")
      }

   text(LEFT, Range[2]*.97, 
        if (length(hz) < 4)
           paste(" ", paste(round(BANDS.SEQ[hz]),collapse=" "), "Hz")
         else
           paste0(" ", round(BANDS.SEQ[hz[1]]), "-", 
		       round(BANDS.SEQ[hz[length(hz)]]),
		 " Hz (by ", round(BANDS.SEQ[hz[2]] - BANDS.SEQ[hz[1]]), ")"),
	col="red", adj=0, cex=1)
   }

text(MsToX(30),   par()$usr[3]+.07, 
     switch(ALIGN,  gocue="Cue", go="Move", sac="Saccade", "Target"),
     adj=0, cex=1)

if (ALIGN=="")
     text(MsToX(1200), par()$usr[3]+.07, "Go cue", adj=1, cex=1)

title(xlab=paste("Time (ms re:",
	switch(ALIGN, gocue="go cue", go="movement", sac="saccade", "target"),
		 "onset)"),
      cex.sub=1.5, cex.lab=1.5)

axis(1, at=MsToX(TicsAtMs), labels=TicsAtMs, cex.axis=1.5)

for (i in 1:STACKS) {
   if (i %in% SKIP.STACK) next

   mtext(paste(
	     ifelse(STIMULATE.OVERRIDE, c(32,35,62,65)[i], StackList[i]), 
	     if (STIMULATE.OVERRIDE) {
               c("Saccade-stim","Same-stim","Saccade","Same")[i]
       	     # } else if (SACSPLIT) {
             #  c("Saccade","Ipsi arm","Contra arm","Same", "Opp:1", "Opp:2")[i]
	     } else	
		StackNames[i]),
	side=3, line=(2.5-i)*.85, outer=T, at=.85, adj=0, col=S_MAP[i])
   }

mtext(paste(ifelse(MONK=="{tyr,zen}","both",MONK),
	    AREA, if (NEAR) paste0("+",NEAR), 
	    CLASS, 
	    MEMORY, SACONLY, STIMULATE, 
	    if (CC_INACT.OVERRIDE) 
	       switch(2+INACT_TIME.OVERRIDE,
		      		"PRE-INACT", "PERI-INACT", "POST-INACT"),
	    if (SACSPLIT) paste0("Split by sac:", SPLITCODE), 
	    if (SCALE==F) "UNSCALED",
	    ALIGN),
      outer=T, side=3, line=-1, adj=.5, cex=1.6)


mtext(paste(length(files), "units"), side=1, line=3, outer=T,adj=-0.1,cex=1.3)
mtext(paste(command, collapse=" "),  side=1, line=4, outer=T, adj=1, cex=.6)
if (CRITERION_Z)
mtext(paste("Criterion Z =", CRITERION_Z, 
	    if (CHRONUX) "Chronux"), side=1, line=4.5, outer=T, adj=0, cex=.6)

dev.off()
}

#rm(LINES, RIBBONS, Plots, SKIP.STACK,
#   STACKS,WINDOW,ZERO,MsToX,command,f,i,l,
#   MEMORY,REMOVE.FILES,FREQ,FLIP,errs,CRITERION_Z,classes,
#   BANDS,T_MAP,times,System,Transparent)
#if (!SCATTER)
#   rm(minus,plus,Range,st,stderr,hz,p,LEFT,RIGHT)
rm(PRINT.MEANS)
