# doConcat.r


FROM.TIME =   800	# [ 650] [-300 100  800 -100 100]
END.TIME =   1050	# [1150] [ -50 350 1050 -100 100] [go:maxi 160]
			# NOTE: intervals are centered on these times

ALIGN.OVERRIDE = ""
NEAR.OVERRIDE  = 2
AREA.OVERRIDE  = "LIP"
MONK.OVERRIDE  = "both"
CLASS.OVERRIDE = "all8"

INACT_INTERVAL.OVERRIDE = 400	# [200]

SAVE_FLAG = T			# Needed for concatenation

# Standard stuff
SCALE.OVERRIDE =     F		# [F]  Normalize the scale

OVERRIDE.OVERRIDE = T
FREQ.OVERRIDE =     "4:240:2"	# ["4:240:2"]  Overwritten for matching pursuit
MEMORY.OVERRIDE =    F		# [F]
STIMULATE.OVERRIDE = F		# [F]
SACONLY.OVERRIDE =   F		# [F]
NORMALIZE.OVERRIDE = T		# [T] Divide by pre-target power
SACSPLIT.OVERRIDE =  F  	# [Either!]
SPLITCODE.OVERRIDE = 3.2	# {3,5,10,12,32,64}.{1,2,3,4}
ALIGN.BASELINES =    T	# [T] will be unset if "go" or "gocue" & normalize
AssumeLIP_PD =       F  	# [F]
INTERPOLATE.STIMULATION = F 	# [F] STIMULATE.OVERRIDE
MATCHING.OVERRIDE =  F  	# [ ] Matched pursuit algorithm
CHRONUX = F			# [F]
SKIP_EARLY = 0			# [0]   288 for cc, pre?
DO_EARLY = 0			# [0]   144 for cc, peri?

AREA = AREA.OVERRIDE		# shorter!

rm(list=objects(patt="Save[NY]"))

CC_INACT.OVERRIDE =  ifelse(AREA=="PRR", 1, 11)	# :std 1:lesion 2:cntrl; >10 LIP
INACT_TIME.OVERRIDE = -1	# [-1] -1: pre-inact   0: inact   1: post-inact
source("power8.r")

CC_INACT.OVERRIDE =  ifelse(AREA=="PRR", 2, 12)	# :std 1:lesion 2:cntrl; >10 LIP
INACT_TIME.OVERRIDE = -1	# [-1] -1: pre-inact   0: inact   1: post-inact
source("power8.r")

CC_INACT.OVERRIDE =  0		# [0, 1, 2] 0:std 1:lesion 2:control; >10 is LIP
source("power8.r")

par(las=1, xpd=NA, oma=c(4,0,2,0))
par(mfrow=c(1,1), mar=c(3,4,2,1)+.1)

LIM1 = -10 + 7*SCALE
LIM2 =  10 - 5*SCALE

Title = "Contra power bias"

 if (all(A_STACK== 0) & (ALIGN_ON_UNIT==0)) {
    Title = paste(Title, " -- raw alignment")
  } else
    Title = paste(Title,
    if (any(ALIGN_ON_STACK==-1))       "-- Aligned @ freq" else
    if (any(ALIGN_ON_STACK!= 0))       "-- Aligned"        else
    if (any(MIMIC.ALIGN_ON_STACK==-1)) "-- Mimic all"      else
    if (any(MIMIC.ALIGN_ON_STACK!=0))  "-- mimic aligned",
    if (any(A_STACK!=0)) 
       paste("on stack", paste(A_STACK, collapse=" "), "(no class 1+5)"))

 if (ALIGN_ON_UNIT)
    Title = paste(Title,
      switch(4+ALIGN_ON_UNIT,
             "only ipsi-preferring units",      # -3, sites near contra cells
             "only contra-preferring units",    # -2, sites near ipsi cells
             "mimic align on unit",             # -1  looks like 0 -- pointless
             "",                                #  0: nothing
             "align on unit",                   #  1: align on near unit's PD
             "align, just contra-preferring",   #  2: like -2, but aligned
             "align, just ipsi-preferring"))    #  3: like -2, but aligned


plot(1,1,
        xlim=range(BANDS.SEQ[X_Values]),
        xlab="Frequency (Hz)",
        log=ifelse(LOG,"x",""),

        ylim=c(LIM1,LIM2), 
        ylab=paste(if(FREQ_DIFF) "Difference in",
		   if(SCALE ==T) "Arbitrary bias units" else "Bias (%)"),

	main= Title,
        col.main = ifelse(length(A_STACK) > 1,
                          "purple",
                   ifelse(A_STACK,
                          S_MAP[ifelse(A_STACK==-1, 6, A_STACK)],
                          1)),
        bty="n",
        axes=F,
        font.main=2)

axis(1, at=c(4,8,16,32,64,128,240))
axis(2, at=if (!SCALE) c(-8,0,8) else c(-2,0,2,4))

segments(BANDS.SEQ[X_Values[1]], 0,
	           X_Values[length(X_Values)], 0, col="gray", lwd=2)

for (st in 1:4) {
   if (MERGE_STACKS && st==3) break
   lines(BANDS.SEQ[X_Values],
        (SaveN_EM  * get(paste0("SaveY1_",st,"_EM")) +
         SaveN_CC  * get(paste0("SaveY1_",st,"_CC")) +
         SaveN_CCC * get(paste0("SaveY1_",st,"_CCC"))) /
					(SaveN_EM+SaveN_CC+SaveN_CCC),
         col=S_MAP[st], lwd=4)
   if (!FREQ_DIFF) {
      lines(BANDS.SEQ[X_Values],
        (SaveN_EM  * get(paste0("SaveY2_",st,"_EM")) +
         SaveN_CC  * get(paste0("SaveY2_",st,"_CC")) +
         SaveN_CCC * get(paste0("SaveY2_",st,"_CCC"))) /
					(SaveN_EM+SaveN_CC+SaveN_CCC),
         col=S_MAP[st], lwd=2+2*is.nan(y1)+2*is.na(y1),
			 lty=2-is.nan(y1)-is.na(y1))
      }			# if no y1, make y2 heavy solid line
   # if (!FREQ_DIFF) {
   }


 if (any(KeyFreqs!=0)) {                        # Misses discontinuous sets!
    if (length(KeyFreqs) > 1)
       axis(1, at=range(KeyFreqs), lwd=8, col="purple",
            labels=F, lwd.ticks=0)              # No labels or ticks
     else
       axis(1, at=KeyFreqs-1, KeyFreqs+1, lwd=3, col="purple")
    }


mtext(paste(ifelse(MONK=="{tyr,zen}","both",MONK),
            AREA,
            HEMI,
            MEMORY, SACONLY,
            if (SCALE==T) "Scaled",
            "  EM+CC+CCC",
            if (CHRONUX) "Chronux"
            ),
        outer=T, side=3, line=-0.5, adj=.6, cex=1.6, font=2)

mtext(paste(
         (SaveN_EM+SaveN_CC+SaveN_CCC), "sites",
         "   ",
         "Align on", switch(ALIGN,
                         target="target", gocue="go cue", go="movement",
                         sac   ="saccade", "target"),
         "   ",
         XtoMs(LEFT), "to", XtoMs(RIGHT), "ms"),
      side=1, line=2, outer=T, adj=0.5)

# Legend
if (MERGE_STACKS) {
    mtext("Reach",
        side=3, line=1.5*.85-2, outer=T, at=0.05, adj=0, col="red")
    mtext("Saccade",
        side=3, line=0.5*.85-2, outer=T, at=0.05, adj=0, col="black")
  } else
    for (st in 1:STACKS[-1])
      mtext(c("Saccade","Ipsi arm","Contra arm","Same","Apart")[i],
        side=3, line=(2.5-i)*.85-2, outer=T, at=0.05, adj=0, col=S_MAP[i])

mtext(paste(command, collapse=" "),
            side=1, line=3, outer=T, adj=0.01, cex=.6)
mtext(paste0("Z Crit=",CRITERION_Z, ", ", CRITERION_REPLACE),
            side=1, line=3, outer=T, adj=0.99, cex=.6,
            font=1+(CRITERION_REPLACE=="NA"))   # site count unreliable if 'NA'

rm(FREQ.OVERRIDE,SACONLY.OVERRIDE,MEMORY.OVERRIDE,SACSPLIT.OVERRIDE,
   SPLITCODE.OVERRIDE, CHRONUX,
   NEAR.OVERRIDE,AREA.OVERRIDE,MONK.OVERRIDE,CLASS.OVERRIDE,
   ALIGN.BASELINES)

rm(SAVE_FLAG)
