# doAll.r

OVERRIDE.OVERRIDE = T
options(warn=-1)
rm(FREQ.OVERRIDE,MEMORY.OVERRIDE,SACSPLIT.OVERRIDE,SPLITCODE.OVERRIDE,
   SACONLY.OVERRIDE, CC_INACT.OVERRIDE,
   ALIGN.OVERRIDE,NEAR.OVERRIDE,AREA.OVERRIDE,MONK.OVERRIDE,CLASS.OVERRIDE)
options(warn=0)

FREQ.OVERRIDE =     "4:240:2"	# ["4:240:2"]  Overwritten for matching pursuit
MEMORY.OVERRIDE =    F		# [F]
STIMULATE.OVERRIDE = F		# [F]
SACONLY.OVERRIDE =   F		# [F]
CC_INACT.OVERRIDE =  F		# [F] 0:std 1:lesion  2:control; >10 is LIP
INACT_TIME.OVERRIDE =  -1	# [0] -1: pre-inact   0: inact   1: post-inact
INACT_INTERVAL.OVERRIDE = 100	# [200] (ms) power computed in it (only inact)
NORMALIZE.OVERRIDE = T		# [T] Divide by pre-target power
SCALE.OVERRIDE =     T		# [T or F?]  Normalize the scale
SACSPLIT.OVERRIDE =  F  	# [Either!]
SPLITCODE.OVERRIDE = 3.2	# {3,5,10,12,32,64}.{1,2,3,4}
ALIGN.BASELINES =    T	# [T] will be unset if "go" or "gocue" & normalize
			# Less important for later data (go/gocue/sac align)
AssumeLIP_PD =       F  	# [F]
INTERPOLATE.STIMULATION = F 	# [F] STIMULATE.OVERRIDE
MATCHING.OVERRIDE =  F  	# [ ] Matched pursuit algorithm
CHRONUX = F			# [F]

SKIP_EARLY = 0			# [0]   288 for cc, pre?
DO_EARLY = 0			# [0]   144 for cc, peri?


FROM.TIME =   800	# [ 650] [-300 100  800 -100 100]
END.TIME =   1050	# [1150] [-100 350 1050 -100 100] [go:maxi 160]
	# NOTE: times are centered on request, so with -i200 (50ms shifts):
	#   0:150 --> c(-100:100 -50:150  0:200  50:250)
	# Times interact with WINDOW - e.g., if WINDOW is 400, -50 goes up
	#  to +150, so that's a bad start time for baseline!

if (MATCHING.OVERRIDE)
   FREQ.OVERRIDE = ""

if (!NORMALIZE.OVERRIDE || !ALIGN.BASELINES)
   cat("Not aligning; sure about that?\n")
if (CHRONUX) cat("CHRONUX!\n")		# non-standard

if (SACSPLIT.OVERRIDE) {
   cat("Fix byter so it does sac split calls properly")
   stop()
   }

#  for (SPLITCODE.OVERRIDE in c(3.2,12.2,64.3))
#for (ALIGN.OVERRIDE in c("","gocue","go","sac")) # ""(targ),"gocue","go","sac"
for (ALIGN.OVERRIDE in c("")) # ""(targ),"gocue","go","sac"
 for (NEAR.OVERRIDE in c(2))			# c(0,2)
  # for (AREA.OVERRIDE in c("PRR","LIP")) # c("LIP", "PRR")
  for (AREA.OVERRIDE in c("PRR")) # c("LIP", "PRR")
   #for (MONK.OVERRIDE in c("both","tyr","zen")) # c("tyr", "zen", "both")
   for (MONK.OVERRIDE in c("both"))
     #for (CLASS.OVERRIDE in c("PN",""))	# c("","PN","pref","RL","all8")
      for (CLASS.OVERRIDE in c(""))
      {
	cat(MONK.OVERRIDE,AREA.OVERRIDE,"+",NEAR.OVERRIDE,
	    CLASS.OVERRIDE,ALIGN.OVERRIDE,"\n")
	source(ifelse(CLASS.OVERRIDE=="PN"||CLASS.OVERRIDE=="RL",
	       	      "power2.r",		# With PN
		      # "abs_power.r"		# No PN: simple, no normalize
		ifelse(CLASS.OVERRIDE=="all8",
	       	      "power8.r",
		      "power.r")))		# No PN: standard (normalize)

	if (!exists("NAME.PDF") || (NAME.PDF == F)) {
 	   Cmd = paste0("mv StackPower.pdf ",
 		AREA,
 		if (NEAR) paste0("+", NEAR),
 		"_",
 		ifelse(MONK=="{tyr,zen}","both",MONK),
		if (STIMULATE!=0 && STIMULATE!="") "_stim",

		switch((CC_INACT.OVERRIDE+1)%%10,
		       "", "_cc", "_ccc"),
		if (CC_INACT.OVERRIDE > 10) "_memory",
		if (CC_INACT.OVERRIDE!=0 && CC_INACT.OVERRIDE!="")
		   switch(2+INACT_TIME.OVERRIDE, "_pre","_peri","_post"),
 		if (ALIGN!="") paste0("_", ALIGN),
 		if (CLASS!="") paste0("_", CLASS),
		if (SKIP_EARLY) paste0("_x1:",SKIP_EARLY),
		if (DO_EARLY)   paste0("_X1:",DO_EARLY),
 		if (AssumeLIP_PD & (AREA=="LIP")) "_PD.Assumed",
 		if (!ALIGN.BASELINES)  "_Unaligned",
 		if (SACSPLIT)  paste0("_split", SPLITCODE),
 		if (SCATTER)   "_scatter",
 		if (CHRONUX)   "_chronux",
 		".pdf\n")
	    cat(Cmd)
	    system(Cmd)
	    }
    }

rm(FREQ.OVERRIDE,SACONLY.OVERRIDE,MEMORY.OVERRIDE,SACSPLIT.OVERRIDE,
   SPLITCODE.OVERRIDE, CHRONUX,
   NEAR.OVERRIDE,AREA.OVERRIDE,MONK.OVERRIDE,CLASS.OVERRIDE,
   ALIGN.BASELINES)
