# Concat.r


if (exists("Diff1_EM") && exists("Diff1_CC") && exists("Diff1_CCC")) {

   # pdf("Concat.pdf")

   # Set up the plot
   par(las=1)
   par(xpd=NA)
   par(oma=c(4,0,2,0))
   par(mfrow=c(1,1), mar=c(3,4,4,2)+.1)

   LIM1 = -1.5
   LIM2 =  4.5
   if (SCALE==0) {
      LIM1 = LIM1 * 5
      LIM2 = LIM2 * 2.25
      }

   plot(1,1,
        xlim=range(BANDS.SEQ[X_Values]),
        xlab="Frequency (Hz)",
        log=ifelse(LOG,"x",""),

        ylim=c(LIM1,LIM2), 
        ylab=paste(if(FREQ_DIFF) "Difference in", "Bias (%)"),

        main= paste("Bias versus frequency",
            ifelse(any(ALIGN.ON.STACK==-1),
                                        "-- Each aligned (but no class 1 or 5)",
            ifelse(any(ALIGN.ON.STACK!=0),
                                     "-- Aligned",
            ifelse(any(MIMIC.ALIGN.ON.STACK==-1),
                                        "-- Mimic all (no class 1 or 5)",
            ifelse(any(MIMIC.ALIGN.ON.STACK!=0),
                                        "-- mimic aligned", ""))))),
        col.main = ifelse(A.STACK, S_MAP[ifelse(A.STACK==-1,6,A.STACK)], 1),
        bty="n",
        axes=F,
        font.main=2)

   axis(1, at=c(4,8,16,32,64,128,240))
   axis(2, at=if (!SCALE) c(-6,0,6) else -1:4)

   segments(BANDS.SEQ[X_Values[1]], 0,
            X_Values[length(X_Values)], 0, col="gray", lwd=2)
   for (st in 1:(4-2*(CC_INACT.OVERRIDE > 10)))
      lines(BANDS.SEQ[X_Values], 
	    (N_EM  * get(paste0("Diff",st,"_EM")) +
	     N_CC  * get(paste0("Diff",st,"_CC")) +
	     N_CCC * get(paste0("Diff",st,"_CCC"))) / (N_EM+N_CC+N_CCC),
	    col=S_MAP[st], lwd=3)

   mtext(paste(ifelse(MONK=="{tyr,zen}","both",MONK),
            AREA,
            HEMI,
            MEMORY, SACONLY,
	    "All (EM+CC+CCC)",
            if (SCALE==F) "Unscaled",
            if (CHRONUX) "Chronux",
            "  ",
            if (POLAR_PLOT) {
              if (length(hz) < 4)
                 paste(paste(round(BANDS.SEQ[hz]),collapse=" "), "Hz")
              else
                 paste0(round(BANDS.SEQ[hz[1]]), "-",
                      round(BANDS.SEQ[hz[length(hz)]]),
                      " Hz (by ",
                      round(BANDS.SEQ[hz[2]]) -
                      round(BANDS.SEQ[hz[1]]), ")")
              }
            ),
        outer=T, side=3, line=-0.5, adj=.6, cex=1.6, font=2)

   mtext(paste(
	 (N_E+N_CC+N_CCC), "sites",
         "   ",
         "Align on", switch(ALIGN,
                         target="target", gocue="go cue", go="movement",
                         sac   ="saccade", "target"),
         "   ",
         XtoMs(LEFT), "to", XtoMs(RIGHT), "ms"),
      side=1, line=2, outer=T, adj=0.5)


   mtext(paste(command, collapse=" "),
            side=1, line=3, outer=T, adj=0.01, cex=.6)
   mtext(paste0("Z Crit=",CRITERION_Z, ", ", CRITERION_REPLACE),
            side=1, line=3, outer=T, adj=0.99, cex=.6,
            font=1+(CRITERION_REPLACE=="NA"))   # site count unreliable if 'NA'

   # dev.off()

   rm()
   }
