# abs_power.r   Plot power spectra for 5 stacks, ONE class (Larry)

LINES   =  T		# Solid line to show mean
RIBBONS =  F		# Ribbon of +/- 1 SEM (can have both)

NAME.PDF = F		# [F] 'T' if concat two monkeys in SCATTER=2

X.int = 250		# [250] Spacing between tics on X axis

if (!exists("OVERRIDE.OVERRIDE")) {
  AREA.OVERRIDE = "PRR"		# PRR, LIP
  MONK.OVERRIDE = "tyr"		# tyr, zen, both
  CLASS.OVERRIDE = ""		# "" (-mc) or 'pref' 
  SCALE.OVERRIDE = F
  MEMORY.OVERRIDE = F		# Only zen, LIP
  SACSPLIT.OVERRIDE = 0	# 0 or 1 (not true or false!) (With 'pref' gives errs)
  SPLITCODE.OVERRIDE = "5.1"	# "3.1" or "12.1", for examples
  ALIGN.OVERRIDE = ""	# ""(target), "end"(cue), "gocue", "go", "sac" or "EOT"
  NEAR.OVERRIDE = 2		# [0,1.25]
  FREQ.OVERRIDE = "4:240:2"	# "" (10:120:10)
  ALIGN.BASELINES = F		# Arguably, should do this earlier
  HEMI.OVERRIDE = ''		# L, R, LL, or RR
  STIMULATE.OVERRIDE = F
  }
INTERPOLATE.STIMULATION = 
REPORT.STIMULATION = 
EXCISE.STIMULATION = STIMULATE.OVERRIDE

SCATTER = F			# doAll checks this


if (NORMALIZE.OVERRIDE && 
    (ALIGN.OVERRIDE=="gocue" ||ALIGN.OVERRIDE=="go" ||ALIGN.OVERRIDE=="sac")) {
   origALIGN = ALIGN.OVERRIDE
   ALIGN.OVERRIDE = ""
   source("ReadAll.r")
   saved.normalize = copy.normalize	# Baseline from targ-aligned; 
   					# Used to normalize go[cue]-aligned data
   saved.scale = copy.scale		# from targ-aligned; 
   saved.files = files		# Used to check that all the files are there
   rm(copy.normalize, copy.scale)
   ALIGN.OVERRIDE = origALIGN
   ALIGN.BASELINES = F		# Does not make sense to do this again
  } else
   origALIGN = ""

source("ReadAll.r")	# extended -- merged across all classes, just 1 delay

if (classes != 1)		# time, bands, classes, stacks, units
   cat("Classes must be merged to run this!\n")
data = data[,,,,]		# Remove empty classes dimension

if (length(dev.list()) > 0)
   cat(length(dev.list()), "devices open\n")

# Plots = list(c(20,30), c(70,80,90,100,110,120))
# Plots = list(seq(16,28,2), seq(70,240,2))
Plots = list(c(24,26,28), c(32,34,36), seq(74,124,10))
Plots = list(30, 40, 100)


for (l in 1:length(Plots)) {    # Replace frequency with ordinal #
   Ordinals = match(Plots[[l]], BANDS.SEQ)
   if (any(is.na(Ordinals)))
       stop("Asked for a frequency that was not computed")
   Plots[[l]] <- Ordinals
   }

# MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4))  # ReadAll.r
S_MAP = c("gray30", "green", "red", "blue", "purple",	# stack map
	  "orange")				# If SacSplit!

Transparent<-function(someColor, alpha=100) {
   newColor<-col2rgb(someColor)
   apply(newColor, 2, 
	  function(curcoldata) {
		  rgb(red=curcoldata[1], 
		  green=curcoldata[2],
		  blue=curcoldata[3],
		  alpha=alpha*255,
		  maxColorValue=255)
	  	  })
   }
T_MAP = Transparent(S_MAP, .2)		# Fraction is opacity (larger=darker)


if (NAME.PDF) {
   pdf(paste0("LFPPower",AREA.OVERRIDE,
	      if (NEAR.OVERRIDE) paste0("+", NEAR.OVERRIDE),
	      "_",MONK.OVERRIDE,
	      if (ALIGN.OVERRIDE != "") "_", ALIGN.OVERRIDE,
	      if (SACSPLIT.OVERRIDE) paste0("SacSplit_", SPLITCODE.OVERRIDE),
	      ".pdf"))
 } else
   pdf("StackPower.pdf")

# Average over all cells!	# time, bands, (classes), stacks, units
stderr = sqrt(apply(data, 1:3, var, na.rm=T)/length(files))
data = apply(data, 1:3, mean, na.rm=T)   # Leaves time, band, stacks

# Set up the plot
par(mfrow=c(length(Plots),1), las=1, mar=c(0,6,1,4)+.1, oma=c(7,0,1,2))
par(xpd=NA)

LEFT = switch(ALIGN, target=1, gocue=MsToX(-300), go=MsToX(-750), 
	                       sac=MsToX(-800), 1)
RIGHT = times


TicsAtMs = X.int*((XtoMs(LEFT)%/%X.int):(XtoMs(RIGHT)%/%X.int))
if (TicsAtMs[1] < XtoMs(LEFT))
   TicsAtMs = TicsAtMs[-1]
L = length(TicsAtMs)
if (TicsAtMs[L] > XtoMs(RIGHT))
   TicsAtMs = TicsAtMs[-L]

if (ALIGN.BASELINES) {
   baseline = apply(data[LEFT:MsToX(0), , ], 2:3, mean, na.rm=T)
   baseline = array(rep(c(baseline), each=dim(data)[1]), dim=dim(data))
   data = data - baseline + 1
   rm(baseline)
   }

for (p in 1:length(Plots)) {
   hz = Plots[[p]]
   if (length(hz) == 1)
      Range = range(data[LEFT:times,hz,], na.rm=T)
    else
      Range = range(apply(data[LEFT:times,hz,], c(1,3), mean, na.rm=T), na.rm=T)
   plot(0,0, xlim=c(LEFT,times), ylim=Range,
		axes=F, xlab="",ylab="",bty='n',type='n', lwd=2)

   axis(2)
   axis(1, at=MsToX(TicsAtMs), labels = F, cex.axis=1.5)

   segments(MsToX(0),    par()$usr[3],
	    MsToX(0),    mean(par()$usr[3:4], na.rm=T), lwd=3, xpd=F)
   segments(MsToX(1257), par()$usr[3],
	    MsToX(1257), mean(par()$usr[3:4], na.rm=T), lwd=3, xpd=F)

   if (RIBBONS)
   for (st in c(1:STACKS)) {
      plus = (data+stderr)[LEFT:times,hz,st]
      minus= (data-stderr)[LEFT:times,hz,st]
      if (length(hz) > 1) {
	  plus  = rowMeans(plus, na.rm=T)
	  minus = rowMeans(minus, na.rm=T)
          }
      polygon(c(LEFT:times, times:LEFT),
	      c(plus, rev(minus)),
	      density=-1, border=ifelse(LINES,0,S_MAP[st]), col=T_MAP[st],lwd=2)
      }

   if (LINES)
    for (st in (1:STACKS))
      lines(LEFT:times, 
	    if (length(hz)==1) data[LEFT:times,hz,st] else 
		      rowMeans(data[LEFT:times,hz,st],na.rm=T),
	    col=S_MAP[st], lwd=4)

   text(LEFT, Range[2]*.9, paste(paste(BANDS.SEQ[hz],collapse=" "), "Hz"), 
						col="red", adj=0, cex=1)
   }

text(MsToX(30),   par()$usr[3]+.07, 
     switch(ALIGN,  gocue="Cue", go="Move", sac="Saccade", "Target"),
     adj=0, cex=1)

if (ALIGN=="")
     text(MsToX(1270), par()$usr[3]+.07, "Go cue", adj=1, cex=1)

title(xlab=paste("Time (ms re:",
	switch(ALIGN, gocue="go cue", go="movement", sac="saccade", "target"),
		 "onset)"),
      cex.sub=1.5, cex.lab=1.5)

axis(1, at=MsToX(TicsAtMs), labels=TicsAtMs, cex.axis=1.5)

for (i in 1:STACKS)
   mtext(paste(61+i,
	       c("Saccade", "Ipsi arm", "Contra arm", "Same",
		 if (SACSPLIT) "Opp:1" else "Opposite",
		 if (SACSPLIT) "Opp:2"))[i],
	side=3, line=-i*1.2, outer=T, at=.85, adj=0, col=S_MAP[i])

mtext(paste(ifelse(MONK=="{tyr,zen}","both",MONK),
	    AREA, if (NEAR) paste0("+",NEAR), CLASS, MEMORY, 
	    if (SACSPLIT) paste0("Split by sac:", SPLITCODE), 
	    if (SCALE==F) "UNSCALED",
	    ALIGN),
      outer=T, side=3, line=-1, adj=.5, cex=1.6)

if (CRITERION_Z)
    title(main = paste("Criterion Z =", CRITERION_Z), 
	  outer=T, cex.main=1.5, line=-1.3, adj=1)

mtext(paste(length(files), "units"), side=1, line=3.5, outer=T,adj=0.1,cex=1.3)
mtext(paste(command, collapse=" "),  side=1, line=5, outer=T, adj=1, cex=.6)

dev.off()

#rm(AREA.OVERRIDE, CLASS.OVERRIDE, MONK.OVERRIDE, MEMORY.OVERRIDE, SACSPLIT.OVERRIDE)

#rm(LINES, RIBBONS, Plots,LEFT,
#   hz,STACKS,RIGHT,WINDOW,ZERO,MsToX,command,f,counts,Found,i,l,p,
#   MEMORY,minus,MeanPower,REMOVE.FILES,FREQ,FLIP,errs,CRITERION_Z,classes,
#   BANDS,plus,Range,st,T_MAP,times,System,stderr,Transparent)
