# readall8.r   Plot power spectra for classes.

# Normalize:
#	Divide power by power in target-aligned interval prior to time 0
#	Now values are expressed as percentage of baseline
#	Specific for each site and for each frequency
#	(stack & class are not relevant to baseline)
#
# Scale:
#	Give all sites equal weight, AFTER NORMALIZING.  Wierd!!
#	Find highest (normalized) value, e.g., 1.5 (rises 50% over baseline)
#	Divide all (for that site & freq) by that maximum, so that no data
#	 shows an increase greater than 1, and each site has at least one
#	 condition where the increase equals 1.  In other words, *normalize
#	 the increase*.  (As a safeguard, no normalization greater than 20
#	 is allowed.  A site whose largest increase in power is 2% will have
#	 a max increase of 40%, not 100%).

AREA = ifelse(exists("AREA.OVERRIDE"), AREA.OVERRIDE, "PRR")
HEMI = ifelse(exists("HEMI.OVERRIDE"), HEMI.OVERRIDE, "")
MONK = ifelse(exists("MONK.OVERRIDE"), MONK.OVERRIDE, "tyr")
CLASS = ifelse(exists("CLASS.OVERRIDE"), CLASS.OVERRIDE, "RL")
MEMORY = ifelse(exists("MEMORY.OVERRIDE"), MEMORY.OVERRIDE, FALSE)
STIMULATE = ifelse(exists("STIMULATE.OVERRIDE"), STIMULATE.OVERRIDE, FALSE)
SACONLY = ifelse(exists("SACONLY.OVERRIDE"), SACONLY.OVERRIDE, FALSE)

CC_INACT = ifelse(exists("CC_INACT.OVERRIDE"), CC_INACT.OVERRIDE, FALSE)
INACT_TIME = ifelse(exists("INACT_TIME.OVERRIDE"), INACT_TIME.OVERRIDE, 0)
INACT_INTERVAL = ifelse(exists("INACT_INTERVAL.OVERRIDE"), 
					     INACT_INTERVAL.OVERRIDE,  400)
SACSPLIT = ifelse(exists("SACSPLIT.OVERRIDE"), SACSPLIT.OVERRIDE, 0)
SPLITCODE = ifelse(exists("SPLITCODE.OVERRIDE"), SPLITCODE.OVERRIDE, "5.1")
	# Split code suffix: e.g., 3.1, 12.1; no suffix is usually 3.1
NEAR         = ifelse(exists("NEAR.OVERRIDE"),     NEAR.OVERRIDE,        0)
ALIGN        = ifelse(exists("ALIGN.OVERRIDE"),    ALIGN.OVERRIDE,      "")
FREQ         = ifelse(exists("FREQ.OVERRIDE"),     FREQ.OVERRIDE,       "")
NORMALIZE    = ifelse(exists("NORMALIZE.OVERRIDE"),NORMALIZE.OVERRIDE,TRUE)
MATCHING     = ifelse(exists("MATCHING.OVERRIDE"), MATCHING.OVERRIDE,FALSE)
SCALE        = ifelse(exists("SCALE.OVERRIDE"),    SCALE.OVERRIDE,    TRUE)
AssumeLIP_PD = ifelse(exists("AssumeLIP_PD"),      AssumeLIP_PD,     FALSE)

CRITERION_Z = 6		# [6] W/in a file & freq, find & rm aberrant samples
if (MATCHING) CRITERION_Z = 8
CRITERION_REPLACE = "mean"   # "NA","mean","limit","three/two/one_sigma"

			# [T] Everyone gets equal weight
PrevTrialError = ifelse(exists("PrevTrialError"),PrevTrialError, F)
REMOVE.ALL = F	# If fails at gocue,go or sac, remove for ALL alignments!

if (NORMALIZE == FALSE) {
   if (SCALE == TRUE) {
       cat("Cannot SCALE if not normalizing!  (ReadAll.r)\n")
       SCALE = FALSE
       if (exists("SCALE.OVERRIDE"))
          SCALE.OVERRIDE = FALSE
       }
   if (CRITERION_Z == TRUE) {
       cat("Cannot apply CRITERION_Z if not normalizing!  (ReadAll.r)\n")
       CRITERION_Z = FALSE
       }
   }

verbose = F

#  STACKS = 5 + SACSPLIT - STIMULATE - 2*(CC_INACT!=0)*(AREA=="LIP")
StackList = 
	if (SACSPLIT)      { 	c(62:65,661,662)} else
	if (STIMULATE)     { 	c(32,35,62,65)	} else
	if (SACONLY)       { 	  1 		} else  
        if (CC_INACT > 10) {	c(92,95,96)	} else
	    			  62:66
STACKS = length(StackList)

FLIP = 1	# -oh1  RIGHT hemisphere      -oh0 LEFT hemisphere
	# Stacks: started recording on LEFT so left (stk 63) = ipsi arm
	#	  Flip STACKS if recorded on right
	# Classes named for RIGHT arm, so flip CLASSES if record on RIGHT

if (CLASS!="pref" & CLASS!="RL" & CLASS!="PN" & CLASS!="" & CLASS!="all8")
   stop("ARGH - wrong name for CLASS\n")

if (MONK=="both")		# Try this!
    MONK = "{tyr,zen}"

if (FREQ == "10:120:10")	# standard
    FREQ = ""

System = function(command) system(paste("tcsh -c '", command, "'"), intern=T)

directory = paste0(
	     if (CC_INACT) "cc_inact/",
	     if (MATCHING) "mp/" else if (CC_INACT)
		    			 paste0(INACT_INTERVAL, "ms/"),
	     if (SACSPLIT) "splits/",
	     if (AREA != '' ) AREA,
	     if (exists('Hemisphere')) paste0('Group',loop,'of',totGroup),
	     if (NEAR>0) paste0("+",NEAR),
	     if (exists('ortholimit')) paste0("ortho",ortholimit),
	     "_",MONK, 
	     if (exists('Hemisphere')) paste0('_',Hemisphere),
	     if (MEMORY) "_memory",
	     if (STIMULATE) "_stim",
	     switch((CC_INACT+1)%%10, "", "_cc", "_ccc"),
	     if (CC_INACT > 10) "_memory",
	     if (SACONLY) "_saconly",
	     if (FREQ  != "") "_", FREQ,    # if blank, won't see it
	     if (ALIGN != "") "_", ALIGN,
	     if (CLASS != "") "_", CLASS,
	     if (SKIP_EARLY) paste0("_xt1:",SKIP_EARLY),
	     if (DO_EARLY  ) paste0("_Xt1:",DO_EARLY),
	     if (SACSPLIT) "_SacSplit_",
	     if (SACSPLIT) SPLITCODE,
	     if (AssumeLIP_PD & AREA=="LIP") "_AssumeLIP_PD",
	     if (PrevTrialError) "_PrevTrialError")

files = System(paste0("ls data",
		      if (CHRONUX) ".chronux",
		      "/",
		      directory,
		      "/*ata_*")) # backward compat for "PowerData_*" & "data_*"
cat(length(files), "files from", directory)
if (exists("CC_INACT")) {
   cat(switch(CC_INACT+1, "", " (callosal lesion", " (callosal control"))
   if (CC_INACT > 10) cat(" memory")
   if (CC_INACT != 0)
      cat(switch(INACT_TIME+2, " pre-inj)", " peri-inj)", " post-inj)")) 
   }
cat("\n")

# files = files[c(1,4,7,10)]	# Want to look at subset?
# cat("limiting files!\n")

Scan = function(...) scan(..., quiet=!verbose)


REMOVE.FILES = c("1152.2_2","1153.2_2","1034.2_2","1035.2_2")
	# Always remove these! First 2 drive weird 16-32Hz bump in
	# zen LIP raw plots. Last 2 are tyr PRR sites that drive
	# stronger contra than ipsi effect in raw plots:

REMOVE.FILES = c(REMOVE.FILES, "1299.4")	# zen PRR

# LFP POWER TOO HIGH
#REMOVE.FILES = c(REMOVE.FILES,"1006.2_2","1033.2_2","1036.2_2","10929.2_2","1100.4_1","1106.1_1","1106.1_2","909.2_2","917.2_1","932.2_1","1013.1_2","1091.1_2","1252.3_2","1298.2_1")

# LFP POWER TOO LOW
#REMOVE.FILES = c(REMOVE.FILES,"1099.3_1","11112.4_2","1111.4_2","1116.1_1","1117.1_1","1257.2_1","1258.2_1")


if (REMOVE.ALL || ALIGN=="gocue" || (exists("origALIGN") && origALIGN=="gocue"))
   REMOVE.FILES = c(REMOVE.FILES,
	# zen PRR
	"906.2","907.2","935.1","938.1","939.1","940.1","968.1","971.1",
	"1023.1","1025.1","1038.1","1044.1","1047.1","1054.1","1056.1",
	"1068.1",
	"1191.2_2",    # only fails in some cases
	"905.2","926.2","929.2","930.2","936.1","941.1","942.1","945.1",
	"961.2","966.1","967.1")

# 1041 and 1106 are the only cell/run numbers in both animals
#   So we (maybe) delete 2 cells unnessarily by not tracking which animal

if (REMOVE.ALL || ALIGN=="go" || (exists("origALIGN") && origALIGN=="go"))
   REMOVE.FILES = c(REMOVE.FILES,
	# zen PRR
	"1041.1","1044.1","1047.1","1066.1","1070.1","905.2","906.2","907.2",
	"926.2","929.2","930.2","936.1","939.1","940.1","961.2","966.1","967.1",
	"968.1","971.1",
	# "1059.1_1", "1064.1_1", "1065.1_1",
	# tyr LIP  Some file#'s use w/ both monks, so rm'ing more than need
	"1011.2","10930.2")

if (CLASS=="" && (REMOVE.ALL || 
		  ALIGN=="go" || (exists("origALIGN") && origALIGN=="go")))
   REMOVE.FILES = c(REMOVE.FILES,
	# zen PRR
	"1013.1","1023.1","1024.1","1025.1","1038.1","1040.1","1043.1",
	"1054.1","1056.1","1093.1","935.1","938.1","941.1","942.1","945.1",
	"1191.2_2",    # only fails in some cases
	# tyr LIP
	"1108.1","1091.1","1301.2","907.2","935.1","945.1",
	"1036.2"
	)

if (REMOVE.ALL || ALIGN=="sac" || (exists("origALIGN") && origALIGN=="sac"))
   REMOVE.FILES = c(REMOVE.FILES,
	"909.2","976.2","982.2","1005.2","1011.2","1012.3","1804.1","975.2",
	"983.2","985.2","1026.3","11040.2","1046.2","11047.2","1099.3",
	"11116.3","1803.1",
	"905.2","940.1","1013.1","1023.1","1066.1","1069.1","968.1","1128.2",
	"1248.2","1299.4","10930.2","1011.2","1045.3","1111.4","11112.4",
	"908.2","917.2","1028.4","1031.3","1032.2","1039.2","1111.4","1114.5",
	"11116.3",
	"1237.2")

if (CLASS=="" && (REMOVE.ALL ||
		  ALIGN=="sac" || (exists("origALIGN") && origALIGN=="sac")))
   REMOVE.FILES = c(REMOVE.FILES,
	# zen PRR (and tyr?)
	"1108.1","1091.1","1301.2","907.2","935.1","945.1","1036.2","1041.1",
	"1005.2","1011.2","1012.3","1026.3","1031.3","1032.2","1036.2","1039.2",
	"1038.1","906.2","936.1","939.1",
	"1191.2_2",    # only fails in some cases
	"1041.1","1043.4_1", "1046.2","10930.2","1099.3","1100.4","1103.1",
	"11040.2","1104.1","11047.2","1105.2","1106.1","1107.2","11112.4",
	"1111.4","11116.3","11117.2","1800.1","1801.1","1803.1","1804.1",
	"865.1","872.1","875.1","876.1","878.1","880.2","908.2","909.2","917.2",
	"975.2","976.2","981.2","982.2","983.2","985.2","992.2")

if (CLASS=="" && (ALIGN=="sac" || (exists("origALIGN") && origALIGN=="sac")))
   REMOVE.FILES = c(REMOVE.FILES,
	"1045.3","1217.2_2","1218.2_2","1231.2_1","1231.2_2","1272.2_2",
	"1273.2_2","1282.2_1","1293.2_1","1293.2_2","1294.3_1","1294.3_2",
	"1295.2_1","1295.2_2","1296.4_1","1296.4_2")


if (STIMULATE)
   #REMOVE.FILES = c("1495.3","1495.2",
   #		    "1496.3","1496.2",
   #		    "1497.3","1497.2",
   #		    "1498.4","1498.3")
   REMOVE.FILES = c("1495.2",
   		    "1496.2",
   		    "1497.2",
   		    "1498.3")

# REMOVE.FILES = c("1964", "1986", "1992", "1995", "1998", "2002", "2005", "2029", "2033")
	# 1964: poor (66 low, all else =)
	# 1986: poor (65 too high, 63 & 64 swapped)
	# 1992: poor (65 too high, 63 = 64)
	# 1995: ok early, but bad after 500 ms (blue too high, contras all =)
	# 1998: poor (65 too high, 63=64)
	# 2002: wierd: 65 > 62 > 66 > 63 (ipsi) > 64 (contra)
	# 2005: ugly: never dips, only climbs; order is wierd
	

if (CC_INACT) {
   REMOVE.FILES = c(2033)    # Lost channels pre-peri; if include can't do stats
   REMOVE.FILES = c(REMOVE.FILES,2002)		# toss! no pre diff, huge peri
   REMOVE.FILES = c(REMOVE.FILES,1978,1971)
   # REMOVE.FILES = c(REMOVE.FILES,1726)	# zen control - can keep
   # REMOVE.FILES = c(REMOVE.FILES,2002,2029,2037,2039)	# tyr exp - can keep

   if (CLASS == "all8")
      REMOVE.FILES = c(REMOVE.FILES,11670,11685,11696,1700,1703,1706,1712)
   	# Could put a flag in grab to exlcude aparts and write code for it

   if (CLASS == "all8" & CC_INACT.OVERRIDE==2 && INACT_TIME.OVERRIDE==1)
      stop("The only files we have for this are missing classes (1709+1714!")

   REMOVE.FILES = c(REMOVE.FILES, 
         switch(2+INACT_TIME, c("\\.2", "\\.3"), 
			      c("\\.1", "\\.3"),
			      c("\\.1", "\\.2"),
			        "\\.2"))

# REMOVE.FILES = c(REMOVE.FILES, 1726)	# 1726, 2002
# REMOVE.FILES = c(REMOVE.FILES, 2002)	# 1726, 2002

# zen: PRE:
#   1670.1 -  250:800 all except high 66; 800:62 x's
#   1685.1 -  250:500 perfect; 62 & 66 cross
#   1696.1 -  65/66; 63/4 at 700; 62 at 750
#   1703.1 -  awful!
# zen: POST:
#   1673.1 -  similar to pre
#   1687.1 -  66 hi; 62 x at 950
#   1697.2 -  66 sl hi, else nice
#   1703.3 -  not bad ...
   }


if (HEMI != "") {			# Why would this ever be blank?
   # Read table to divide files into hemispheres
   a = read.table(paste0("/data/coord/", MONK, "/", MONK, "units"),
	         header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   base = cbind(a, monk=MONK)    # Rename, add "monk" column
   source("/data/coord/grab/Nearest.r")
   if (AssumeLIP_PD)
	source('/data/coord/grab/AssumeLIP_PD.r')

   a = base     # Remove "monk" column
   rm(base)

   colnames(a) = NULL                # else rbind complains about mismatches
   a = rbind(cbind(a[, c(1:2, 3:10)],"channel"=1),
             cbind(a[, c(1:2,11:18)],"channel"=2),
             cbind(a[, c(1:2,19:26)],"channel"=3),
             cbind(a[, c(1:2,27:34)],"channel"=4))

   colnames(a) = c("date", "file", "hemi", "ML", "AP", "depth",
		   "pd", "unit", "lfp", "area","channel")

   # Exclude unusable LFP entries
   a = a[ !is.na(a[,"hemi" ]), ]     # exclude NA hemisphere
   a = a[ !is.na(a[,"ML" ]), ]       # exclude NA ml coord
   a = a[ !is.na(a[,"lfp"]), ]       # exclude NA lfp
   a = a[ a[,"ML"] != "", ]          # exclude blank ml coord
   a = a[ a[,"lfp"] == "1", ]        # include only 'true' lfp

   # Check entries (comment out, usually)
   bad = a[,"depth"] == "?" | a[,"depth"] == "????" | a[,"depth"]==NA
   if (any(bad))
	   a[bad, "depth"] = -1

   # If all else checks out, convert NA area to the characters NA
   a[is.na(a[,"area"]),"area"] = "-"

   # Split into hemispheres
   for (hemi in c("R","L","RR","LL"))
	        assign(paste0(MONK, "_", hemi),a[ a[,"hemi"]==hemi,])

   hem = which(a[   ,"hemi"]!=HEMI ) 
   filename = as.character(a$file[hem])
   ch = as.character(a$channel[hem])
   REMOVE.FILES = c(REMOVE.FILES,paste0(filename,'_',ch))
   } 

if (length(REMOVE.FILES)) {
   cat(paste("Exclude cells:  "))
   String = ""; count = 0
   for (i in 1:length(REMOVE.FILES)) {
      Found = grep(REMOVE.FILES[i], files)
      if (length(Found)) {
         count = count + length(Found)
         if (any(grepl("//", files[Found])))
           String = paste(String,
	      	sapply(	# split on each '/', take the 3rd or 4th piece
		 sapply(strsplit(files[Found],"/"), "[", 3+(CC_INACT!=0)),
     		 substring, 6))	# drop "data_"
	 else
           String = paste(String, files[Found])
         files = files[-Found]
         }
      }
   if (count > 6)
      cat(count, "cells\n")
    else
      cat(String, "\n")
   # rm(Found)
   }

# Now that we have removed unwanted files, we can check to see,
# in go[cue] alignment where we need to get baseline from
# target-aligned data, if there are any mismatches

if (NORMALIZE.OVERRIDE &&
    (ALIGN.OVERRIDE=="gocue" || ALIGN.OVERRIDE=="go"|| ALIGN.OVERRIDE=="sac")) {
   files.target = substring(saved.files, nchar(saved.files)-7)
   files.gocue  = substring(files, nchar(files)-7)
   if (!all(files.target %in% files.gocue))
      cat("\nFiles in target-aligned but not go[cue/sac]-aligned:",
		files.target[! (files.target %in% files.gocue)], "\n")
   if (!all(files.gocue %in% files.target))
      cat("\nFiles in go[cue/sac]-aligned but not target-aligned:",
		files.gocue[! (files.gocue %in% files.target)], "\n\n")
   # Really should QUIT right here, if mismatches found!
   }

Bad.times = 
Bad.stack = 
Bad.files = 
Bad.bands = NULL

UsedFiles = NULL		# rarely, files are skipped
for (file in files) {
   if (verbose)
      cat("file", file, "\n")

   command = Scan(file, nlines=1, what="character")
   params  = Scan(file, skip=2, nlines=1)
   # 1: version		
   # 2: interval_begin	3: interval_end
   # 4: -ot start	5: -ot end		
   # 6: filter
   # 7: UnitOrLFP	8: UnitOrLFP2
   # 9: start freq	10: end freq	11: freq step size
   # 12: file type 
   # 13: LFP hemisphere
   # 14: start high freq 15: end hi freq  16: step size
   # 17: evoked flag
   # 18: spike limits (all, exactly mimimum)  19: spike N   20: random seed
   # 21: use chronux flag

# params[10] = params[10] - params[11] # DIAG !
# cat("Bug fix in ReadAll.r -- frequencies (BANDS) may be off\n")	# DIAG !

   trials = Scan(file, skip=3, nlines=1)


   if (MATCHING) { # Decimate, round up to 2^n, match pursuit, decimate again
      match.params  = Scan(file, skip=4, nlines=1)	# Extras!
      #  1: # number of time points after 1st decimation (NUMBER_SAMPLE1)
      #  2: orig sampling rate, before EITHER decimation (MS_PER_SAMPLE0)
      #  3: 1st decimation (in time; affects Nyquist; Cheybeshev)
      #  4: 2nd decimation, post-MP (Butterworth)
   # Modified from Chuck:
   #  The "extra line" has 4 values: N1 fs td_1 td_2
   #  N1 = number of points AFTER 1st decimation.
   #  fs = sampling rate BEFORE either decimation.
   #  td_1 = 1st decimation (with Cheby filter)
   #  td_2 = 2nd decimation (with Butter filter)
   #  fs_1 = fs / td_1;
   #  freq_domain = seq(0, fs_1/2, (N1/2) + 1)
   #  N2 = ceil(N1 / td_2)  # of time points AFTER post-analysis decimation
   #  fs_2 = fs / (td_1 * td_2)
   #  time_domain = seq(0, (N2-1) / fs_2, N2)

      RATE_0 = match.params[2]			# Document & trouble-shoot
      RATE_1 = RATE_0 / match.params[3]		# D & t
      RATE_2 = RATE_1 / match.params[4]		# D & t
      
      COUNT_1 = match.params[1]				# Actual (D & t)
      # COUNT_0 = TO - FROM	# Requested (before decimation and rounding up)
      COUNT_0 = COUNT_1 * match.params[3]		# Effective (actual)
      COUNT_2 = ceiling(COUNT_1 / match.params[4])	# Actual

      NUMBER_SAMPLE_2 = ceiling(match.params[1] / match.params[4])

      MS_PER_SAMPLE_2 = 1000/RATE_2			# Used - do not remove!

      params[3]  = params[2] + COUNT_0 * 1000/RATE_1	# Actual end time
      params[9]  = 0				# 1st frequency
      params[10] = RATE_1 / 2			# Frequency step size
      params[11] = (COUNT_1/2) + 1		# Last frequency

      BANDS.SEQ = seq(params[9], params[10], length.out=params[11])
      BANDS = length(BANDS.SEQ)

      MsToX <- function(ms) return((ZERO+ms)/MS_PER_SAMPLE_2)
      XtoMs <- function(ix) return( (ix-1)*MS_PER_SAMPLE_2 - ZERO)
      rm(RATE_0,RATE_1,RATE_2, COUNT_0,COUNT_1,COUNT_2)
      rm(NUMBER_SAMPLE_2)
    } else {
      if (params[1] == 1) {
         BANDS = (params[10] - params[9]) / params[11] + 1
         BANDS.SEQ = seq(params[9], params[10], by=params[11])
         if (CHRONUX) {
            BANDS = round(BANDS)
            BANDS.SEQ = seq(from=params[9], by=params[11], length.out = BANDS)
            BANDS.SEQ = round(BANDS.SEQ, dig=1)
            }
       } else {                                    # version == 2+
         BANDS.SEQ = Scan(file, skip=4, nlines=1) # Get frequencies
         BANDS = length(BANDS.SEQ)
         if (abs(BANDS-round((params[10]-params[9])/params[11] + 1)) > CHRONUX)
            cat("Possible error in frequency bands\n")  # chronux: err of 1 ok
         }

      MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4))
      XtoMs <- function(ix) return( (ix-1)*WINDOW/4 - ZERO + WINDOW/2)
      }

   MatchBand <- function(f) return(BANDS.SEQ[order(abs(BANDS.SEQ-f))][1])

   FROM = params[2]
   TO   = params[3]
   WINDOW = params[4]	# Compute power within this window - do not use with MP
   LFP.HEMI = params[13]

   DURATION = TO - FROM + 1
   ZERO = -FROM

   # Count the time bins
   times = length(Scan(file, skip=4+MATCHING+(params[1]>1), nlines=1))

   if (!MATCHING) {		# Just a check:
      if (times != 1 + floor( (DURATION-WINDOW-1) / (WINDOW/4)))
          cat("Error in timing / duration\n")
      if (abs(TO - FROM - 1 - DURATION) > 10)	# some tolerance!
         cat("Extracted 'zero' may be wrong because bounds were redone\n")
      }
   rm(FROM, TO, DURATION)

   temp = Scan(file, skip=4+MATCHING+(params[1]>1))	# Read all the data
   L = length(temp)
   rm(params)


   classes = L / times / BANDS / STACKS / 2		# Number of classes?

   if (classes %% 1 != 0) {
      cat("Error in number of values -- file", file, "\n")
      if (verbose)
         cat("  L=",L, "times=",times, "Bands=",BANDS, "STACKS=",STACKS, "\n")
      if (SACSPLIT & (CLASS != "")) {
         if (verbose)
	    cat("Missing sac split in one of the classes? - skipping\n")
         next  # THE RARE SKIPPED FILE -- REQUIRES UsedFiles !
         }
      next	# Skip these - but we probably should just exit!
      }
   if (classes * STACKS != length(trials))
      cat("Error in number of classes/stacks\n")

   UsedFiles = c(UsedFiles, file)	# Note which files are used

   if (length(UsedFiles) == 1) {	# First file?
      if (STIMULATE.OVERRIDE) StimAt = MsToX(StimAt)

      save.classes <- classes
      save.times <- times
      save.bands <- BANDS
      Temp = array(NA,
	     dim=c(times, 2, BANDS, classes, STACKS, length(files)),
             dimnames=list(NULL, c("mean", "SD"), 
			   BANDS.SEQ,
		 	   1:classes,
			   StackList,
			   files))
      Temp[,,,,,1] = array(temp, dim=c(times, 2, BANDS, classes, STACKS))
    } else {
      if (save.classes != classes)
	 cat("Classes differ", save.classes, classes, file, "\n")
      if (save.times != times)
	 cat("Times differ", save.times, times, file, "\n")
      if (save.bands != BANDS)
	 cat("Bands differ", save.bands, BANDS, file, "\n")
      #if (dim(Temp)[1]*dim(Temp)[2]*dim(Temp)[3]*dim(Temp)[4]*dim(Temp)[5] != 
      #							length(temp)) {
      #   cat("Skip file", file, "\n")
      #   next		# do not do this; messes up the data!
      #   }
      Temp[,,,,,length(UsedFiles)] = 
          array(temp, dim=c(times, 2, BANDS, classes, STACKS))
      }
   # mirror image if lfp recorded on right hemisphere
   if (LFP.HEMI > 1)
      stop("LHS 7-2017: seems like this was written for just 0 and 1!")
   
   # FLIPPING
   if (CLASS == "RL") {		# Some get flipped, some do not!
      if (length(StackList) != 5)
	 stop("Write code to handle RL sort with other than 5 stacks!")
      if (SACONLY || STIMULATE)
	 stop("Why do RL with sac only or stimulate?")
      if (classes != 2)
	 stop("Why do RL with something other than 2 classes?")

      Temp2 <- array(Temp[,,,,,length(UsedFiles)],
           dim=c(times, 2, BANDS, classes, STACKS))	# note 1

      # Apart: No swap (sort by X/unX'd. 1:unX'd/5:X'd)  (1:solid 5:dashed)
      #       Independent of whether you recorded on right or left!
      Temp2.5       <- Temp2[,,, , match(6,StackList%%10)]
      			# The 5th stack is 66, 4th is 65, etc - deal with it!

      # Both: FLIP if record on R. Sort by side re: recording. 1:contra/5:ipsi
      Temp2.4       <- Temp2[,,, , match(5,StackList%%10)]
      if (LFP.HEMI == 1) {  				#0=left;1=right
         Temp2.4[,,,1] <- Temp2[,,,2, match(5,StackList%%10)]
         Temp2.4[,,,2] <- Temp2[,,,1, match(5,StackList%%10)]
         }

      # Sac:  FLIP.  Sort by side re: recording, 1:contra/5:ipsi
      Temp2.1       <- Temp2[,,, , match(2,StackList%%10)]
      if (LFP.HEMI == 1) {  				#0=left;1=right
         Temp2.1[,,,1] <- Temp2[,,,2, match(2,StackList%%10)]
         Temp2.1[,,,2] <- Temp2[,,,1, match(2,StackList%%10)]
         }

      # Unis: Some flip (complex).  Sort by X/unX'd. Arm may swap!
	# Standard is recording on left; stack 63 is ipsi/left arm
	#  We flipped stacks if recorded on right
	#  Without flip, class 1 == right == X'd for 63, but unX'd for 64
	#    Want 1(solid) to be unX'd, and 5(dashed) to be X'd
	#    So flip classes for 63 (right arm), not for 64  IF NOT FLIPPED
	#   But if you flipped the stacks,
	#       Flip classes for 64 (right arm), not for 63  !!

      if (LFP.HEMI == 1) {  				#0=left;1=right
         LeftUni  = match(3, (StackList%%10))
         RightUni = match(4, (StackList%%10))
         if (is.na(LeftUni) || is.na(RightUni))
	    stop("Skip this unit!")
	 # Flip stacks 63 and 64
         Temp2[,,,,LeftUni]  <- Temp[,,,,RightUni,length(UsedFiles)]
         Temp2[,,,,RightUni] <- Temp[,,,,LeftUni, length(UsedFiles)]
         }   # Must do this before flipping the classes

      Temp2.2       <- Temp2[,,, , match(3,StackList%%10)]
      Temp2.3       <- Temp2[,,, , match(4,StackList%%10)]
      	# Get these AFTER flipping the stacks!

      if (LFP.HEMI == 1) {  				#0=left;1=right
	 # Flip classes for stack 64
         Temp2.3[,,,1] <- Temp2[,,,2, match(4,StackList%%10)]
         Temp2.3[,,,2] <- Temp2[,,,1, match(4,StackList%%10)]
       } else {
	 # Flip classes for stack 63!
         Temp2.2[,,,1] <- Temp2[,,,2, match(3,StackList%%10)]
         Temp2.2[,,,2] <- Temp2[,,,1, match(3,StackList%%10)]
         }

      # Done flipping.  Get all the king's horses & all the king's men:
      Temp2[,,,,1] = Temp2.1
      Temp2[,,,,2] = Temp2.2
      Temp2[,,,,3] = Temp2.3
      Temp2[,,,,4] = Temp2.4
      Temp2[,,,,5] = Temp2.5
      rm(Temp2.1,Temp2.2,Temp2.3,Temp2.4,Temp2.5)

      Temp[,,,,,length(UsedFiles)] <- Temp2
      rm(Temp2)
   } else if (STIMULATE==F & FLIP & (LFP.HEMI == 1)) {  #0=left;1=right
      if (verbose)
         cat("Mirror data on right\n")
      Temp2 <- array(Temp[,,,,,length(UsedFiles)],
           dim=c(times, 2, BANDS, classes, STACKS))	# note 1
        # Swap stacks 2 & 3 (left and right paws)
      LeftUni = match(3, (StackList%%10))
      RightUni = match(4, (StackList%%10))
      if (!is.na(LeftUni) || !is.na(RightUni)) {
         if (is.na(LeftUni) || is.na(RightUni))
	     stop("Must write code for having just ONE unimanual stack!")
         if (!SACONLY) {
             Temp2[,,,,LeftUni]  <- Temp[,,,,RightUni,length(UsedFiles)]
             Temp2[,,,,RightUni] <- Temp[,,,,LeftUni, length(UsedFiles)]
	     }
         }
      if (CLASS != "PN") { 		# Pref/Null or RL sort? Do not flip
         # Swap classes 8,1,2 with 6,5,4 (mirror image)
         if (classes == 8) {
            Temp2[,,,c(8,1,2),] <- Temp[,,,c(6,5,4),,length(UsedFiles)]
            Temp2[,,,c(6,5,4),] <- Temp[,,,c(8,1,2),,length(UsedFiles)]
           } else if (classes == 2) {
            Temp2[,,,1,] <- Temp[,,,2,,length(UsedFiles)]
            Temp2[,,,2,] <- Temp[,,,1,,length(UsedFiles)]
           } else if (classes == 1) {
	    # No need to flip classes!
           } else
	    stop(paste("   ", classes, "classes -- how do I flip them?\n"))
	 }
      Temp[,,,,,length(UsedFiles)] <- Temp2
      rm(Temp2)
      }
   }

if (length(UsedFiles) < length(files)) {	# Rarely, we skip a file
   classes = save.classes			# Restore correct value
   cat("Skipped", length(files)-length(UsedFiles), "files,",
       "used ", length(UsedFiles), "\n")
   files = UsedFiles
   Temp = array(Temp[,,,,,1:length(files)],	# Throw out empties
		# Have to enumerate dim and dimnames - see note 1!
	    	 dim=c(times, 2, BANDS, classes, STACKS, length(files)),
                 dimnames=list(NULL, c("mean", "SD"), 
			   BANDS.SEQ,
		 	   1:classes,
			   StackList,
			   files))
   }
      
data = array(Temp[,"mean",,,,],
	    	 dim=c(times, BANDS, classes, STACKS, length(files))) # note 1
errs = array(Temp[,"SD" ,,,,],
	    	 dim=c(times, BANDS, classes, STACKS, length(files))) # note 1
copy.normalize = matrix(NA, ncol=BANDS, nrow=length(files))
copy.scale     = matrix(NA, ncol=BANDS, nrow=length(files))

if (INTERPOLATE.STIMULATION) {
   bad_at = c(floor(min(StimAt))-1, ceiling(max(StimAt))+1)
   ok_at = bad_at + c(-1,1)		# The good points that bracket the bad
   ok_start = data[ok_at[1],,,1:2,]	# Value of early good point
   ok_end   = data[ok_at[2],,,1:2,]	# Value of late end point
   for (tt in bad_at[1]:bad_at[2])	# (1 point at a time or matrix trouble)
      data[tt,,,1:2,] =			# (Ought to use 'apply')
	  ok_start + (ok_end-ok_start) * (tt-bad_at[1]+1)/(ok_at[2]-ok_at[1])
   cat("Interpolate data during stimulation\n")
   }

if (EXCISE.STIMULATION) {
   bad_at = c(floor(min(StimAt))-1, ceiling(max(StimAt))+1)
   data[bad_at[1]:bad_at[2],,,1:2,] = NA
   }

# Normalize and save values for excluding outliers
if (NORMALIZE) {
 if (verbose) cat("Normalize\n")
 if (ALIGN=="gocue" || ALIGN=="go" || ALIGN=="sac") {
    temp.files = sub(paste0("_", ALIGN), "", files)
    if (any(saved.files != temp.files))
        stop("file mismatch - have to fix this!\n")
    }
 SmallMaxValue = SmallMaxHertz = NULL
 for (f in 1:length(files)) {
   for (band in 1:BANDS) {
      if (CRITERION_Z) { 
         here = data[,band,,,f]
	 # bads = abs((here-mean(here)) / sd(here)) < -CRITERION_Z
	 bad.hi = (here-mean(here)) / sd(here) >  CRITERION_Z
	 bad.lo = (here-mean(here)) / sd(here) < -CRITERION_Z
	 bads = bad.hi | bad.lo
	 bads[is.na(bads)] = F		# We know about NA's - ignore them

	 if (any(bads)) {
	    # Replace with: NA, mean, or max/min allowed value
	    #   NA is in some ways best, but could imbalance things
 	    if (CRITERION_REPLACE == "NA") {
               data[,band,,,f][bads] = NA   	# Replace bad with NA
	     } else if (CRITERION_REPLACE == "mean") {
               data[,band,,,f][bads] = mean(here)	# Replace bad with mean
	     } else if (CRITERION_REPLACE == "limit") {
	       data[,band,,,f][bad.hi] =  mean(here) + CRITERION_Z*sd(here)
	       data[,band,,,f][bad.lo] =  mean(here) - CRITERION_Z*sd(here)
	     } else if (CRITERION_REPLACE == "three_sigma") {
	       data[,band,,,f][bad.hi] =  mean(here) + 3*sd(here)
	       data[,band,,,f][bad.lo] =  mean(here) - 3*sd(here)
	     } else if (CRITERION_REPLACE == "two_sigma") {
	       data[,band,,,f][bad.hi] =  mean(here) + 3*sd(here)
	       data[,band,,,f][bad.lo] =  mean(here) - 3*sd(here)
	     } else if (CRITERION_REPLACE == "one_sigma") {
	       data[,band,,,f][bad.hi] =  mean(here) + 3*sd(here)
	       data[,band,,,f][bad.lo] =  mean(here) - 3*sd(here)
	     } else {
	       stop("Illegal CRITERION_REPLACE value in ReadAll.r")
	       }
	    
	    # Save where it was
	    Bad.times = c(Bad.times, which(apply(bads,1,sum)>=1))
	    # if bad has a 3rd (middle) dimension, skip it (it's class)
	    Bad.stack = c(Bad.stack, which(apply(bads,length(dim(bads)),sum)>=1))
	    Bad.files = c(Bad.files, f)
	    Bad.bands = c(Bad.bands, 2*band+2)
	    # cat("Removed", sum(bads), "points from", 2*band+2, "Hz, file", f,
	    #  	"Times=", which(apply(bads,1,sum)>=1), 
	    #   Next line works only if there's > 1 class
	    # 	"pref/null=", ifelse(which(apply(bads,2,sum)>=1), "P", "N"),
	    # 	"stack=", 61+which(apply(bads,3,sum)>=1),
	    # 	"\n")
	    }
	 rm(bads, here)
	 # rm(bad.hi, bad.lo)
         }
      if (ALIGN=="gocue" || ALIGN=="go" || ALIGN=="sac") {
	 if (saved.files[f] != temp.files[f])
            stop("file mismatch (2) - have to fix this!\n")
	 normalize = saved.normalize[f,band]	# base from targ align
	} else if (ALIGN=="") {
	 normalize = mean(data[1:MsToX(0),band,,,f], na.rm=T)	# -400 to 50
	} else {
         stop("Unrecognized alignment!\n")
	 }
      data[,band,,,f] = data[,band,,,f]/normalize
      errs[,band,,,f] = errs[,band,,,f]/normalize

      if (SCALE) {
         if (ALIGN=="gocue" || ALIGN=="go" || ALIGN=="sac") {
	    scale = saved.scale[f, band]
          } else if (ALIGN=="") {
            if ((abs(BANDS.SEQ[band] -  60) > 6) &&	# Ignore  60 ± 6 Hz
                (abs(BANDS.SEQ[band] - 180) > 6) &&	# Ignore 180 ± 6 Hz
                    (BANDS.SEQ[band]  >  8)      &&	# Ignore 8 Hz & below
		    max(abs(data[,band,,,f]-1),na.rm=T) < .05) {
		SmallMaxValue = c(SmallMaxValue, max(abs(data[,band,,,f]-1),na.rm=T))
		SmallMaxHertz = c(SmallMaxHertz, BANDS.SEQ[band] + 2)
	        }
            scale = max(c(abs(data[,band,,,f]-1), .05), na.rm=T)
	    # Clip to a minimal value - scale up by no more than 20 (arbitrary)
	    }
         # Largest value, across time and conditions (stacks):
      	 # Maps 1 to 1, but makes the range across cells/bands more similar
         # FORCE ALL CELLS TO GO FROM 0 TO 2
      	 data[,band,,,f] = 1 + (data[,band,,,f]-1)/scale
         errs[,band,,,f] = 1 + (errs[,band,,,f]-1)/scale
	 }
      if (ALIGN=="") {
         copy.normalize[f,band] = normalize
         if (SCALE)
          copy.scale    [f,band] = scale
         }
      }
   }
 rm(normalize)
 if (SCALE)
    rm(scale)

 # Report small max values
  #if (length(SmallMaxValue) > 0 && length(SmallMaxValue) < 4) {
  #   for (smv in 1:length(SmallMaxValue))
  #      cat("Small max value:", SmallMaxValue[smv],
  #		   "  Band = ", SmallMaxHertz[smv], "Hz\n")
  #   rm(smv)
  #  } else
 if (length(SmallMaxValue) > 0)
    cat(length(SmallMaxValue), "small values (", min(SmallMaxValue),
       	"and up) at:", unique(sort(SmallMaxHertz)), "Hz\n")
 }		# End of normalize

# Names can get lost; add them back
dimnames(data) = list(Times=XtoMs(1:save.times), Frequencies=BANDS.SEQ, directions=1:classes,
		      tasks=StackList, files=files)

if (length(Bad.times) > 0) {			# Could also use table
  if (verbose) {
    cat("Bad times:", unique(sort(Bad.times)), "\n")
    cat("Bad stack:", unique(sort(Bad.stack)), "\n")
    cat("Bad files:", unique(sort(Bad.files)), "\n")
    cat("Bad bands:", unique(sort(Bad.bands)), "\n")
   } else
    cat("Criterion", CRITERION_Z, "eliminated", length(Bad.times), "points (",
	100*sum(Bad.times) / (sum(!is.na(data))+length(Bad.times)), "%)\n")
 }

if (length(files) == 1) {	# Just one file?
   cat("Requested just one file; duplicate it to make code happy\n")
   cat("Plot functions cannot deal with losing a dimension, nor with NA's\n")
   # sort of data = c(data,data) or data = cbind(data,data), but multi-dim!
  }

MEMORY = if (MEMORY) "Memory" else ""		# Easier to put titles on
STIMULATE = if (STIMULATE) "Stim" else ""	# Easier to put titles on
SACONLY = if (SACONLY) "Saconly" else ""	# Easier to put titles on

if (verbose)
   cat("Done with read\n")

rm(Scan,verbose,temp,L,save.classes,save.bands,save.times,Temp,
   UsedFiles,file)

rm(Bad.times, Bad.stack, Bad.files, Bad.bands)

#  note 1: if you collapse over classes (or stacks?) when you call the
#    macro, one dimension of data (or Temp) has size of 1.  When creating
#    a new array as a copy or subset, length 1 dimensions disappear!
#    Prevent this by enumerating the dimension sizes.
#  OR - use argument "drop=F" -- MUCH BETTER - SHOULD CHANGE !
