# PrefDirection.r
#   Return list of sites with pref direction of units (0 if none)

###########################################################################
# Set basic parameters

# AREA  = "PRR"
# MEMORY = F
# STIMULATE = F
# SACONLY   = F
# CC_INACT  = 0

###########################################################################

options(stringsAsFactors=F)		# ARGH - stupid data frames
					# cbind, maybe rbind, needs this

base = rbind(
   cbind(
      read.table(
	paste0("/data/coord/zen/zenunits", 
	       	if (MEMORY != "")       "_memory",
	       	if (SACONLY != "")      "_saconly",
	  	if (STIMULATE != "")    "_stim",
		if (CC_INACT>10)  "_memory",
		if (CC_INACT>0)   "_cc_",
	      	if ((CC_INACT%%10)==1)  "inactivate",
		if ((CC_INACT%%10)==2)  "control"),
	   header=T,comment="/",stringsAsFactors=F, fill=TRUE),
      monk="zen"),		# Append monkey name (as a column)

   cbind(
      read.table(paste0("/data/coord/tyr/tyrunits",
	       	if (SACONLY!="")  "_saconly",
		if (CC_INACT>10)  "_memory",
		if (CC_INACT>0)   "_cc_",
	      	if ((CC_INACT%%10)==1)  "inactivate",
		if ((CC_INACT%%10)==2)  "control"),
	   header=T,comment="/",stringsAsFactors=F, fill=TRUE),
      monk="tyr")) 		# Append monkey name (as a column)

base[base==""] = NA			# Else there are blanks!!!
base[is.na(base[,"pd1"]), "pd1"] = 0
base[is.na(base[,"pd2"]), "pd2"] = 0
base[is.na(base[,"pd3"]), "pd3"] = 0
base[is.na(base[,"pd4"]), "pd4"] = 0
base[is.na(base[,"lfp1"]), "lfp1"] = 0
base[is.na(base[,"lfp2"]), "lfp2"] = 0
base[is.na(base[,"lfp3"]), "lfp3"] = 0
base[is.na(base[,"lfp4"]), "lfp4"] = 0

PrefDir = NULL

for (channel in 1:4)			# For each recording channel
  for (i in which(base[,paste0("lfp",channel)] == 1)) {
    # Not running "Nearest.r", so do not use 'AREA' to sort
    PrefDir = rbind.data.frame(PrefDir, 
		    c(base[i,"monk"], 
		      paste0(base[i,"reach_file"], "_", channel),
		      base[i, paste0("pd",channel)]))
    }
colnames(PrefDir) = c("monk", "file", "pref")
