# PowerVsFreq_baseline.r		(Seul Ah)
# ----------------------------------------------------
# Plot LFPeffect as a function of frequency bands 
# Power vs. 1 variable (freq)

rm(list=ls())

NEAR.OVERRIDE      = 2	# [2] good value
ALIGN.OVERRIDE   = ""	# [""] Other aligns cannot be normalized (w/o writing
			# much more code, resembling what power.r does!)
CLASS.OVERRIDE   = ""	# [PN]  (-mc) ""(empty) or "pref" or "PN" or "all8" or "any"
USE.CLASS	 = 1	# If class is not "", pick which class to do (just 1!)
FREQ.OVERRIDE = "4:240:2"# [4:240:2] Freq range for ReadAll.r 
ALIGN.BASELINES    = F	# [T] Fixes Apart downward shift (F if NORMALIZE.OVERRIDE= F !) 
REGRESSION.LINE	 = T	# [T] for raw power plots only
PLOT.BASELINES   = F	#     if set, will show individuals
JUST.ONE.STACK   = 1	#     if set, will show individuals

REMOVE_ODD_POWER = T	#     Remove ~20 files with high or low power

NORMALIZE.OVERRIDE =
ALIGN.BASELINES    =
SCALE.OVERRIDE     =
CHRONUX 	   =
AssumeLIP_PD       =
SKIP_EARLY	   =
DO_EARLY	   =
MEMORY.OVERRIDE    =
SACSPLIT.OVERRIDE  = 
CC_INACT.OVERRIDE  =
STIMULATE.OVERRIDE = 	# [F] Read needs these -- not used here
EXCISE.STIMULATION = INTERPOLATE.STIMULATION = F




if (CLASS.OVERRIDE=="pref" & AssumeLIP_PD != "pref") {
    CLASS.OVERRIDE = "PN"		# Kluge to get just 'pref' from "PN"
    PN.ONLY.PREF = T
 } else
    PN.ONLY.PREF = F

block1=54	# blank out freq band 52-70 Hz (50-66 is better!)
block2=68
block3=176	# Maybe need these wider intervals for raw power?
block4=184

START= 750	#  [650]  [750] start point
END  =1250	# [1150] [1250] end index in the list- for target alignment

PLOT_HIGH = 240	# [115]  If not NORMALIZE, plot from 8 to 115 or 8:240

# Plotting params
AreaPlotList = "PRR" # c("LIP","PRR")		# two areas
# MonkPlotList = c("both","zen","tyr")	# indi monks & combined
MonkPlotList = "both" # c("both","zen","tyr")	# indi monks & combined
# MonkPlotList = "tyr" # c("both","zen","tyr")	# indi monks & combined

 
xlist=seq(8,PLOT_HIGH,2)	# [115?] Freq range for plotting (up to 240)


# Script begins here
for (M in MonkPlotList) {
 for (A in AreaPlotList) {
  AREA.OVERRIDE = A	# PRR, LIP  
  MONK.OVERRIDE = M	# tyr, zen, both	

  source("ReadAll.r")	# merged across all classes, just 1 delay	
		
  TIME.INTERVAL=paste0(START,"-",END,"ms",sep="")
  strIndx=MsToX(START)
  endIndx=min(MsToX(END),length(data[,1,1,1,1]))

	  # time, bands, classes, stacks, units
  if (classes != 1 && CLASS.OVERRIDE != c("PN"))
     cat("Classes must be merged to run this!\n")
  data = data[,,1,,]			# Pick just 1 class
  
  # Find bad sites
  baselineA = apply(data[1:MsToX(0),	# Just baseline period
		   	which(BANDS.SEQ>=16 & BANDS.SEQ<=32),
		        , ],		# Just 16 Hz to 32 Hz
		   4,			# Avg across all but sites/units
		   mean, na.rm=T)
  BAD.POWER = baselineA<.2 | baselineA>19	# (none between 12 and 19)
  if (REMOVE_ODD_POWER)
     data = data[,,, !BAD.POWER]
  rm(baselineA, BAD.POWER)

  data = log10(data)			# Do all averaging post-log!

  if (ALIGN.BASELINES) {	# Align baselines AFTER nomalization (ReadAll.r)
     if (length(dim(data))==4) {
	baseline = apply(data[1:MsToX(0), , , ], 2:3, mean, na.rm=T)
     } else if (length(dim(data))==3) {
	baseline = apply(data[1:MsToX(0), , ], 2:3, mean, na.rm=T)
     } else if (length(dim(data))==5)
	baseline = apply(data[1:MsToX(0), , , , ], 2:4, mean, na.rm=T)
     baseline = array(rep(c(baseline), each=dim(data)[1]), dim=dim(data))
     data = data - baseline + 1
     rm(baseline)
     }

  if (length(dev.list()) > 0)
     cat(length(dev.list()), "devices open\n")
	
  freqbands = match(xlist,BANDS.SEQ)
  if (any(is.na(freqbands)))
     stop("Asked for a frequency that was not computed")
		
  if (length(dim(data))==4) {
     data = data[,freqbands,,]
   } else
     data = data[,freqbands,,,]	# reassign data to its frequency subset
  
  # Getting matrices organized for plots
  # baseline matrix 
  baseline = apply(data[1:MsToX(0),,,],  c(2,3),mean,na.rm=T)
  baseline[is.na(baseline)]=0
	   
  # mean
  Plot= apply(data[strIndx:endIndx,,,],  c(2,3),mean,na.rm=T)
  Plot[is.na(Plot)] = 0

  plotcol = c("gray30","green","red","blue","purple","gray30")

  x = log2(xlist)
  keep = !(xlist %in% (block1:block2) |	# Which points to exclude?
	   xlist %in% (block3:block4))
  BaseLFPspec = rowMeans(baseline) # average across conditions
  # Add the baseline on as the final condition

  Plot = cbind(Plot,BaseLFPspec)	# Frequency by Stacks+baseline
  Plot[!keep, ] = NA
  # Plot = log10(Plot)	# Plot power in log scale (base 10) if raw plot

  pdf(paste0( MONK.OVERRIDE,"LFPspectrum", A, ALIGN.OVERRIDE, 
	   if (CLASS.OVERRIDE == "PN") paste0("_PN", USE.CLASS),
	   if (PLOT.BASELINES) "_baselines",
	   if (JUST.ONE.STACK) paste0("_stack", JUST.ONE.STACK),
	   ".pdf"))

  par(las=1, mar=c(0,4,1.2,1) +1, oma=c(7,0,1,5), xpd=NA) 
			
  plot(0,0,xlim = c(min(x),max(x)),
	        ylim = if (PLOT.BASELINES) c(-3.2,3.2) else
		       if (JUST.ONE.STACK) c(  -1,1)   else
		       if (PLOT_HIGH<140)  c(-1.3,2)   else
			       	           c(  -2,2),
		axes = F,
	        xlab = if (par()$mfg[3]==par()$mfg[1])
			expression("Frequency (Hz)") else "", 
	        ylab = "raw LFP Power")

  if (JUST.ONE.STACK || PLOT.BASELINES) {
     baselines = apply(data[1:MsToX(0),,,], c(2,4), mean, na.rm=T)
     # baselines = log10(baselines)
     baselines[!keep, ] = NA
     }
  if (PLOT.BASELINES) {	# time, bands, stacks, units
     for (site in 1:(dim(baselines)[2]))
 	 lines(x, baselines[,site], col=6, lwd=.25)
   } else if (JUST.ONE.STACK) {
     one.stack = apply(data[strIndx:endIndx,,JUST.ONE.STACK,],
		      				 c(2,3), mean, na.rm=T)
     # one.stack = log10(one.stack)
     one.stack[!keep, ] = NA
     for (site in 1:(dim(one.stack)[2]))
 	 lines(x, one.stack[,site]-baselines[,site], 
		  			col=plotcol[JUST.ONE.STACK], lwd=.25)
     lines(x, rowMeans(one.stack-baselines, na.rm=T), col=1, lwd=3) # mean
     lines(x, Plot[,JUST.ONE.STACK]-rowMeans(baselines), lwd=1, col="white")
   } else {
     for (set in 1:6) {
	 lines(x, Plot[,set],		# Set 6 is baseline
	          col = plotcol[set],lty=if (set==6) 2 else 1, lwd = 3)
         cat("Stats: set", set, "mean value from 32-40 Hz is", 
	     	  round(mean(Plot[round(2^x)>=32 & round(2^x)<=40 & keep,set]),
		        dig=2), "\n")
	 }
     }
  par(xpd =F)

  if (REGRESSION.LINE & !PLOT.BASELINES & !JUST.ONE.STACK) {
     Lsfit = lsfit(x,Plot[,6])
     print(Lsfit$coef)
     abline(lsfit(x,Plot[,6]), col="gray")
     print(lsfit(log(2^x), log(10^Plot[,6]))$coef)
     rm(Lsfit)
     }
     
  axis(2, at= c(-2,-1,0,1,2), labels = c(0.01,0.1,1,10,100),cex.axis=1)
  if (max(2^x) > 120)
     axis(1, at= log2(c(8,16,32,64,120,240)), 
	       labels=c(8,16,32,64,120,240), cex.axis=1)
   else
     axis(1, at= log2(c(8,16,32,64,120)), 
	       labels=c(8,16,32,64,120), cex.axis=1)
			
  legend("topright",bty='n',
	    legend=c("saccade","ipsi","contra","same","apart","base"),
	    ncol=2, pch=c(15,15,15,15,15,NA), lty=c(0,0,0,0,0,2),
	    lwd=c(0,0,0,0,0,1.5), col=plotcol) 
  mtext(paste(MONK.OVERRIDE, A, 
	 if (NEAR) paste0("+",NEAR), 
	 CLASS.OVERRIDE, 
	 MEMORY, 
	 ALIGN, 
	 if (!SCALE) "UNSCALED", 
	 TIME.INTERVAL),
         outer=T, side=3, line=-1.3, adj=.5, cex=1.6)
  mtext(paste(command, collapse=" "),  side=1, line=  5, outer=T, adj=1, cex=.6)
  dev.off()
  }	# End of area loop
 } 	# End of monk loop
