# PowerVsFreq.r		(Seul Ah)
# ----------------------------------------------------
# Plot LFPeffect as a function of frequency bands 
# Power vs. 1 variable (freq)
rm(list=ls())

NORMALIZE.OVERRIDE = F	# [T] usually, but [F] for raw power (1/f) plots
SCALE.OVERRIDE     = F	# [T] Everyone gets equal weight (F for raw power)
NEAR.OVERRIDE      = 2	# [2] good value
ALIGN.OVERRIDE   = ""	# [""] Other aligns cannot be normalized (w/o writing
			# much more code, resembling what power.r does!)
CLASS.OVERRIDE   = ""	# [PN]  (-mc) ""(empty) or "pref" or "PN" or "all8" or "any"
MEMORY.OVERRIDE   =  F	#      Only zen, LIP
CC_INACT.OVERRIDE =  0  # [ ]  0:std 1:lesion 2:control
INACT_TIME.OVERRIDE = 0 #      -1: pre-inact   0: inact   1: post-inact
SACSPLIT.OVERRIDE  = 0	#      0 or 1 (not true or false!)
FREQ.OVERRIDE = "4:240:2"# [4:240:2] Freq range for ReadAll.r 
MATCHING.OVERRIDE  = F	#     Overrides FREQ.OVERRIDE!  (set to blank)
AssumeLIP_PD       = F	# [F] Also needs to have CLASS.OVERRIDE = "pref"
ALIGN.BASELINES    = F	# [T] Fixes Apart downward shift (F if NORMALIZE.OVERRIDE= F !) 
SKIP_EARLY	 = F	# [F] For use with lesion data (see Read)
DO_EARLY	 = F	# [F] For use with lesion data
REGRESSION.LINE	 = T	# [T] for raw power plots only
STIMULATE.OVERRIDE = 	# [F] Read needs these -- not used here
  EXCISE.STIMULATION = INTERPOLATE.STIMULATION = F

OVERRIDE.YLIM    = F	# [F] Force ylim

CHRONUX = F		# [F] Not sure if it works with 'T'

PRINT_DATA_FOR_FIGURE = F

if (MATCHING.OVERRIDE)
    FREQ.OVERRIDE = ""
if (NORMALIZE.OVERRIDE) {
    REGRESSION.LINE = F
 } else {
    ALIGN.BASELINES = F			# else really wierd!
    SCALE.OVERRIDE = F			# No effect of turning this on or off
    }
if (CLASS.OVERRIDE=="pref" & AssumeLIP_PD != "pref") {
    CLASS.OVERRIDE = "PN"		# Kluge to get just 'pref' from "PN"
    PN.ONLY.PREF = T
 } else
    PN.ONLY.PREF = F

block1=52		# blank out freq band 52-70 Hz (50-66 is better!)
block2=68
block3=170		# Maybe need these wider intervals for raw power?
block4=190

#block1=54		# These are fine for normalized plots
#block2=62
#block3=0
#block4=0

START= 750		#  [650]  [750] start point
END  =1250#		# [1150] [1250] end index in the list- for target alignment

PLOT_HIGH = 230	# [115]  If not NORMALIZE, plot from 8 to 115 or 8:240

selectcell=F		# [F] T if you want to plot averages of specific sites
if (selectcell) {
   celltable = read.table(
			"/data/coord/R/units/PowerLists/LIP_away_minus_contra.txt")
   # read table to get site numbers - used only if selectcell == T
   celllist = substring(celltable[,1],1)	# entire list
   #celllist = celllist[1:34]		# portion of the list
   }

# Plotting params
AreaPlotList = "PRR" # c("LIP","PRR")		# two areas
# MonkPlotList = c("both","zen","tyr")	# indi monks & combined
 MonkPlotList = "both" # c("both","zen","tyr")	# indi monks & combined
# MonkPlotList = "tyr" # c("both","zen","tyr")	# indi monks & combined

LFPspec = T	# T for plotting LFP power as a function of freq (spectrum)
 		#   for raw power, set NORMALIZE to false
LFPeffect=F	# T for plotting LFP power DIFFERENCES as a function of freq
 
 beta=seq(8,58,2)   # increment of beta should match FREQ.OVERRIDE increment!
 gamma=seq(70,PLOT_HIGH,10)	# standard increment value of gamma (10Hz)
if (LFPspec)			# Will fail if MATCHING
   xlist = c(beta,gamma) 
if (LFPeffect) 
   xlist = seq(8,240,4)	# Freq range for plotting:  
 # xlist=seq(8,PLOT_HIGH, 2)

if (!NORMALIZE.OVERRIDE)
   xlist=seq(8,PLOT_HIGH,2)	# [115?] Freq range for plotting (up to 240)
# LFP effect plots
SET_1 = list(  3, 4, 3, 4)	# eye/arm, uni/bi, contra/ipsi, same/diff
SET_2 = list(  1, 3, 2, 5)
# raw LFP plot
SET_3 = list( 1, 2, 3, 4, 5)	# eye, ipsi, contra, same, diff
 

# Script begins here
for (M in MonkPlotList) {
 for (A in AreaPlotList) {
  AREA.OVERRIDE = A	# PRR, LIP  
  MONK.OVERRIDE = M	# tyr, zen, both	
  if (CLASS.OVERRIDE == "any" || CLASS.OVERRIDE == "all8")
     source("ReadAll8.r")	# not merged across classes, just 1 delay
  else
     source("ReadAll.r")	# merged across all classes, just 1 delay	
  if (MATCHING.OVERRIDE) {
     xlist = BANDS.SEQ[-1]	# All but DC ?
     xlist = xlist[ xlist >= 8 & xlist <= 200 ]		# 240 is overkill
     beta  = xlist[ xlist >= 8 & xlist <= 58]
     gamma = xlist[ xlist >= 70 & xlist <= PLOT_HIGH]
     }
		
  if (CLASS.OVERRIDE != "") {
     PLOTMAT=array(,dim=c(0,length(xlist),0))
   } else if (CLASS.OVERRIDE == "") {
     PLOTMAT=matrix(,ncol=length(xlist),nrow=0)
   }
  position = array(, dim= c(1,0))
  cellind = array(,dim=c(1,0))
  celllen = array(,dim=c(1,0))	
 		
  meanvalue=array(,dim = 
		c(if (CLASS.OVERRIDE != "" && CLASS.OVERRIDE != "pref" ) 2,
		  length(xlist),
		  length(SET_3) ))
  errorvalue=array(,dim = c(length(xlist),0))		
  effectmean=array(,dim = c(length(xlist),0))
		
  freqbands= matrix(,ncol=length(xlist),nrow=0)
	
  TIME.INTERVAL=paste0(START,"-",END,"ms",sep="")
  strIndx=MsToX(START)
  endIndx=min(MsToX(END),length(data[,1,1,1,1]))

  if (length(REMOVE.FILES))
     cat(paste("Excluding", length(REMOVE.FILES), "cells\n"))
		
	  # time, bands, classes, stacks, units
  if (classes != 1 && CLASS.OVERRIDE != c("PN"))
     cat("Classes must be merged to run this!\n")
  data = data[,,,,]		# Remove empty classes dimension

  if (ALIGN.BASELINES) {	# Align baselines AFTER nomalization (ReadAll.r)
     if (length(dim(data))==4) {
	baseline = apply(data[1:MsToX(0), , , ], 2:3, mean, na.rm=T)
     } else if (length(dim(data))==3) {
	baseline = apply(data[1:MsToX(0), , ], 2:3, mean, na.rm=T)
     } else if (length(dim(data))==5)
	baseline = apply(data[1:MsToX(0), , , , ], 2:4, mean, na.rm=T)
     baseline = array(rep(c(baseline), each=dim(data)[1]), dim=dim(data))
     data = data - baseline + 1
     rm(baseline)
     }

  if (length(dev.list()) > 0)
     cat(length(dev.list()), "devices open\n")
	
  for  (l in 1:length(xlist)) {
     Ordinals = match(xlist[[l]],BANDS.SEQ)
     if (any(is.na(Ordinals)))
	stop("Asked for a frequency that was not computed")
     freqbands[[l]] <- Ordinals
     }
		
  if (selectcell) {	# Runs only if we specify list of cells to be plotted
     a = unlist(strsplit(celllist,"[.]"))	
     b=matrix(a,ncol=length(celllist),nrow =2)
     for (cell in 1:length(celllist)) {
        site = b[1,cell]
        str = paste0(b[1,cell],".[1-9]_",b[2,cell])
        ind = grep(str,files)
        if (length(ind)>1) {
           sub = matrix(unlist(strsplit(substring(files[ind],42),"[.]")),
							ncol=length(ind),nrow=2)
	   sub = sub[1,1:length(ind)]
	   ind = ind[which(sub==site)] 
           }
        if (length(ind)) {
           position = array(c(position,cell), 
			   dim= c(1,length(position)+length(cell)))
	   cellind = array(c(cellind,ind),
			   dim=c(1,length(cellind)+length(ind))) 
	   }
        }
     if (length(cellind) < 1)
        cat("NO MATCHING CELLS FROM THE FILE LIST","\n")
     }
  celllen = length(cellind)	# number of cells actually selected
  whichcells = substring(files[cellind],42)
		  # filename of cells ACUTALLY selected from the celllist
	
  if (MATCHING.OVERRIDE || !NORMALIZE.OVERRIDE) {	# Prob do this ALWAYS!
     if (length(dim(data))==4) {
     	data = data[,freqbands,,]
      } else
     	data = data[,freqbands,,,]	# reassign data to its frequency subset
     }	
  
  # Allow logarithmic averaging in gamma band (vs plotting every increment)
  # But if Matching, has trouble finding the bands!  Skip for now.
  if (exists("gamma") && NORMALIZE.OVERRIDE && !MATCHING.OVERRIDE) {
     if (length(dim(data))==4) {
        pseudodata = data[,freqbands,,]
      } else
   	pseudodata = data[,freqbands,,,] # reassign data to its frequency subset
     # xlist and reformatting data
     gammainc = 0.1	# 10Hz increment (divide by 10 for rounding)
     for ( g in 1:length(gamma)) {
        n=which(round(gammainc*BANDS.SEQ)==(gamma[[g]]*gammainc))
        m=which(xlist==(gamma[[g]]))
        if (length(dim(data)) ==4)
           pseudodata[,m,,] =  apply(data[,n,,],c(1,3,4),mean,na.rm=T)
        else 
           pseudodata[,m,,,] = apply(data[,n,,,],c(1,3,4,5),mean,na.rm =T)
        }
     data = pseudodata		# Here we reassign data matrix!
     rm(pseudodata)
     }
	
  # Getting matrices organized for plots
  if ( LFPspec) {
     # baseline matrix 
     baseline = if (CLASS.OVERRIDE !="") {	# More than 1 class
     		 if (selectcell) 
		   apply(data[1:MsToX(0),,1:2,,cellind],c(2,4),mean,na.rm=T)
		  else
		   apply(data[1:MsToX(0),,1:2,,],c(2,4),mean,na.rm=T)
		 } else  { 				# Just 1 class
		 if (selectcell)		
	   	   apply(data[1:MsToX(0),,,cellind],c(2,3),mean,na.rm=T)
		  else
		   apply(data[1:MsToX(0),,,],c(2,3),mean,na.rm=T)
		  }
	   
     baselinemat = baseline
	   
     # mean & stderr matrices	   
     if (CLASS.OVERRIDE != "" && CLASS.OVERRIDE != "pref") {	# > 1 class?
	for (cl in 1:2) { 
	   if (selectcell) {	# 'set' is not defined; ??
	      value = mean(data[strIndx:endIndx,hz,cl,SET_3[[set]], cellind],
									na.rm=T)
	      stderr = sqrt(apply(apply(data[strIndx:endIndx,,,,cellind],
		                        c(2,3,4,5),mean,na.rm=T),
			          c(2,1,3),var,na.rm=T)/length(cellind)) 
	    } else {
	      value = apply(data[strIndx:endIndx,,,,], c(2,3,4),mean, na.rm=T)
   	      stderr = sqrt(apply(apply(data[strIndx:endIndx,,,,],
				        c(2,3,4,5),mean,na.rm=T),
				  c(2,1,3),var,na.rm=T)/length(files)) 
	      }
     	   stop("This is wrong -- the 2nd class overwrites the 1st! (LHS)")
	   meanvalue= value       
	   }
	}
	   
     if (CLASS.OVERRIDE == "") {	# Just 1 class
	if (PRINT_DATA_FOR_FIGURE) {
   	   sink("FigureS5_Data.txt")
	   cat("Raw data dimensions:\n\n")
   	   print(dimnames(data))
   	   cat("\n\n\nData:\n")
   	   options(max.print=9999999)
   	   print(data)
   	   options(max.print=99999)
   	   sink()
	   }
	value= apply(data[strIndx:endIndx,,,],c(2,3),mean,na.rm=T)
	stderr = sqrt(apply(apply(data[strIndx:endIndx,,,],
	            c(2,3,4),mean,na.rm=T),c(1,2), var,na.rm=T)/length(files)) 	
  	meanvalue = value			
	}
     }
	
  if (LFPeffect) {
     for (set in 1:length(SET_1)) {
        set1 = SET_1[[set]]
	set2 = SET_2[[set]]
	mean = apply(data[strIndx:endIndx,,set1,],2,mean,na.rm=T)-
	       apply(data[strIndx:endIndx,,set2,],2,mean,na.rm=T)
	meanbysite = apply(data[strIndx:endIndx,,set1,],c(2,3),mean,na.rm=T)-
	   	     apply(data[strIndx:endIndx,,set2,],c(2,3),mean,na.rm=T) 
	      	   # Watch out if set1 or set2 has multiple entries->c(2,4)
	error = sqrt(apply(meanbysite,1,var,na.rm=T)/length(files))
   	effectmean = array(c(effectmean,mean),dim=c(length(mean),set))	
	errorvalue=array(c(errorvalue,error),dim=c(length(error),set))
	}
     effectmean = t(effectmean)
     errorvalue = t(errorvalue)	 
     }
	
  PLOTMAT= if (LFPspec) meanvalue else if (LFPeffect) effectmean
  PLOTMAT[is.na(PLOTMAT)] = 0
  if (LFPspec)
     baselinemat[is.na(baselinemat)]=0

  movetype=c("saccade","ipsi","contra","same","diff")

  Transparent <- function(someColor, alpha=100) {
        	newColor<-col2rgb(someColor)
        	apply(newColor, 2,
              	function(curcoldata) {
             		rgb(red=curcoldata[1],
                	       green=curcoldata[2],
          	               blue=curcoldata[3],
                	       alpha=alpha*255,
                	       maxColorValue=255)
                	       })
		}
 
  plotcol = 
      if ( LFPspec) c("gray30","green","red","blue","purple","gray30") else
      if (LFPeffect) c("gray30","blue","green","purple")

  T_MAP = Transparent(plotcol, .3)

  if (LFPeffect) {	# Plots LFPeffect ( Freq vs. LFPeffect)
     monk = MONK.OVERRIDE
     source("SAK/code/LFPeffectplot.r")
     }

  if (LFPspec) {
     x = log2(xlist)
     BaseLFPspec = rowMeans(baselinemat) # average across conditions
     # Add the baseline on as the final condition
     if (CLASS.OVERRIDE == "PN") {
        Plot = array(, dim = c(classes,length(freqbands),6))
        for (cl in 1:classes)
            Plot[cl,,]=cbind(PLOTMAT[,cl,],BaseLFPspec)	# Add new column
        plus  = Plot[,,1:5] + stderr
        minus = Plot[,,1:5] - stderr
        Plot[, xlist %in% (block1:block2), ] = NA
        Plot[, xlist %in% (block3:block4), ] = NA
      } else {
        Plot = cbind(PLOTMAT,BaseLFPspec)	# Frequency by Stacks+baseline
        plus = PLOTMAT + stderr
        minus= PLOTMAT - stderr
        Plot[xlist %in% (block1:block2), ] = NA
        Plot[xlist %in% (block3:block4), ] = NA
        }
     if (NORMALIZE.OVERRIDE == F)
         Plot = log10(Plot)	# Plot power in log scale (base 10) if raw plot

     pdf(paste0( MONK.OVERRIDE,"LFPspectrum", A, ALIGN.OVERRIDE, 
	   if (CLASS.OVERRIDE == "PN") "_PN", 
	   if (CC_INACT)
	      paste0(switch(CC_INACT, "_cc", "_ccc"),
	             switch(2+INACT_TIME, "_pre", "_peri", "_post")),
	             ".pdf"))

     ynumb = round(seq(from= round(min(range(Plot, na.rm=T)),digits=2),
		       to  = round(max(range(Plot, na.rm=T)),digits=2),
		       length.out=5),
		   digits=2)

     if (OVERRIDE.YLIM[1] != 0)
         ynumb = OVERRIDE.YLIM
	 		
     par(mfrow = if (CLASS.OVERRIDE == "PN") c(2,1) else c(1,1), 
	       las=1, mar=c(0,4,if (CLASS.OVERRIDE == "PN") 3 else 1.2,1) +1, 
	       oma=c(7,0,1,5), xpd=NA) 
     if (PN.ONLY.PREF)
	par(mfrow=c(1,1), mar=c(0,4,1.2,1)+1)
			
     for (cl in 1:classes) {
        Plott = if (CLASS.OVERRIDE == "PN") Plot[cl,,] else Plot
        print(  if (!NORMALIZE.OVERRIDE)
	            c(ifelse(PLOT_HIGH<140,-1.3,-2),2) else range(ynumb))
        plot(0,0,xlim = c(min(x),max(x)),
	         ylim = if (!NORMALIZE.OVERRIDE)
			   c(ifelse(PLOT_HIGH<140,-1.3,-2),2)
	                 else range(ynumb), 
		axes = F,		# -2,2 if go to 240 Hz
	        xlab = if (par()$mfg[3]==par()$mfg[1])
			expression("Frequency (Hz)") else "", 
	        ylab = if (NORMALIZE.OVERRIDE==T)
			"LFP Power (%)" else "raw LFP Power")

     keep = !(xlist %in% (block1:block2) |	# Which points to exclude?
	      xlist %in% (block3:block4))
     if (NORMALIZE.OVERRIDE)			# Error bars
	for (set in 1:5) {
	   polygon(c(x[keep], rev(x[keep])), 
	         if(CLASS.OVERRIDE == "PN")
			 c(plus[cl,keep,set],rev(minus[cl,keep,set])) 
	         else    c(plus[keep,set], rev(minus[keep,set])),
	      density=-1, border=0, col=T_MAP[set],lwd=2)
       	   }
     for (set in 1:(length(SET_3)+!NORMALIZE.OVERRIDE)) {
	 # if (set %in% c(1,3,6))	# LHS: if you want just a few lines
	 lines(x, Plott[,set],		# Set 6 is baseline
	       col = plotcol[set],lty=if (set==6) 2 else 1, lwd = 3)
	 # DIAG 
         # cat("Power (Hz,value):  ")
    	 # for (HZ in (10:22)*2)
         #     cat(HZ, 
	 #	   round(mean(Plott[ 
	 #	   round(2^x)>=HZ & round(2^x)<=HZ & keep, set]), dig=2), "  ")
	 # cat ("\n")
	 # END DIAG
         # cat("Stats: set", set, "mean value from 20-30 Hz is", 
	 #     	round(mean(Plott[ 
	 #	    round(2^x)>=22 & round(2^x)<=30 & keep, set]), dig=2), "\n")
        cat("Stats: set", set, "mean value from 32-40 Hz is", 
	     	round(mean(Plott[round(2^x)>=32 & round(2^x)<=40 & keep, set]),
		      dig=2), "\n")
	}
     # No need to plot something to block it; we now clear these values
     # rect(log2(block1),min(ynumb)-1,
     #      log2(block2),max(ynumb)+1,col = "white", border = NA)
     # rect(log2(165),min(ynumb)-1,
     #      log2(195),max(ynumb)+1,col = "white", border = NA)		
     par(xpd =F)

     # Commented out by LHS 12-19-2016
     # axis(1, at= log2(range(xlist)), labels= F, cex.axis =1)

     if (REGRESSION.LINE) {
        Lsfit = lsfit(x,Plott[,6])
        print(Lsfit$coef)
        abline(lsfit(x,Plott[,6]), col="gray")
	print(lsfit(log(2^x), log(10^Plott[,6]))$coef)
	rm(Lsfit)
	}
     
     if (NORMALIZE.OVERRIDE ==T) {
        if (MATCHING.OVERRIDE) {
           axis(2, at= c(0.9,1,1.1), labels = c("-10%","0%","10%"),cex.axis=1)
	 } else
           axis(2, at= c(0.8,1,1.2), labels = c("-20%","0%","20%"),cex.axis=1)
        abline(h = 1, untf = FALSE, lty = 3)            # 0% LFP power line
        axis(1, at= log2(c(8,16,32,64,120,180)), 
	        labels=c(8,16,32,64,120,180), cex.axis=1)
      } else { 
   	# 1/f line (LHS)
        # abline(reg=lsfit(x, Plott[,6]), untf = FALSE, lty = 3)
        axis(2, at= c(-2,-1,0,1,2), labels = c(0.01,0.1,1,10,100),cex.axis=1)
        if (max(2^x) > 120)
            axis(1, at= log2(c(8,16,32,64,120,240)), 
	            labels=c(8,16,32,64,120,240), cex.axis=1)
         else
            axis(1, at= log2(c(8,16,32,64,120)), 
	            labels=c(8,16,32,64,120), cex.axis=1)
        }
     
     if (PN.ONLY.PREF)
        break
     }		# End of classes loop for plotting	
			
  if (CLASS.OVERRIDE != "PN" || PN.ONLY.PREF) {
     legend("topright",bty='n',
	    legend=c("saccade","ipsi","contra","same","apart","base"),
	    ncol=2, pch=c(15,15,15,15,15,NA), lty=c(0,0,0,0,0,2),
	    lwd=c(0,0,0,0,0,1.5), col=plotcol) 
   } else if (CLASS.OVERRIDE == "PN") {
     ClassLabels = c("Preferred direction", "Null direction")
     mtext(ClassLabels[1], outer=T, side=3, line=-3, at=.25, cex=1.6, col="red")
     mtext(ClassLabels[2], outer=T, side=3, line=-16,at=.25, cex=1.6, col="red")
     }
  mtext(paste(MONK.OVERRIDE, A, 
	 if (NEAR) paste0("+",NEAR), 
	 CLASS.OVERRIDE, 
	 MEMORY, 
	 ALIGN, 
	 if (!SCALE) "UNSCALED", 
	 TIME.INTERVAL,
	 if (CC_INACT) 
	     switch((2+INACT_TIME), "PRE-INACT","PERI-INACT", "POST-INACT")),
         outer=T, side=3, line=-1.3, adj=.5, cex=1.6)
  mtext(paste(if (sum(celllen)>0) sum(celllen) else length(files), "sites"),
	side=1, line=  3, outer=T, adj=0.1, cex=1.3)
  mtext(paste(command, collapse=" "),  side=1, line=  5, outer=T, adj=1, cex=.6)
  dev.off()
     }	# End of P vs. freq loop
  }	# End of area loop
 } 	# End of monk loop
