function [GC_beta_mean,GC_gamma_mean,GC_beta_sem,GC_gamma_sem,GC_beta_byPair,GC_gamma_byPair,files_read,all_files,...
all_data_GC,all_data_Freq]=fun_compute_mean_ppc(align_where,file_dir,filename,areafile,connect,reach_merge)
% example: 
% align_where = 'GoCue_-800:0ms'; 
% fun_compute_mean_GC(align_where,'em_data','FileList_crossX2_zen_EM','AreaList_crossX2_zen_EM','PRR-LIP');

	stacks = 62:66; % sac, left arm, right arm, together, apart
if strcmp(file_dir,'saconly')
	stacks = 62;
end
if ~isempty(reach_merge)
	stacks = [62 67];
end
% ppc_ft X_Y: X is causing Y (X is sending information to Y)
% need to reorganize into sac, contra arm, ipsi arm, together, apart

% when X is electrode 1 or 2 (left side): read in the order of 1,3,2,4,5
% when X is electrode 3 or 4 (right side)
%left_electrodes = [1 2]; right_electrodes = [3 4];

half_trials = 0; %1 using half trials. %0 using all trials
files_read = 0; % number of files read
%filename = 'FileList_PRR_tyr_EM';
%file_dir = 'em_data'; filename = 'FileList_PRR_zen_EM';
%file_dir = dir_input; filename = name_input;

curDir = pwd;
if contains(filename,'cross')
       % connect = 'LIP-PRR';
        %connect = 'PRR-LIP';
        if contains(file_dir,'memory')
                GC_lim = 0.2;
        end
end
if contains(file_dir,'memory')
stacks = [62 65 66];
end

toDir = [curDir '/filelists/' file_dir '/'];
if contains(file_dir,'em_data')
toDir = [curDir '/filelists/em_data/'];
end

cd(toDir);
filestr = fileread(filename);
%if contains(filename,'cross')
%areastr = fileread(areafile);
%end
cd(curDir);

%cd filelists;
%filestr = fileread(filename);
%cd ..;

filebyline = regexp(filestr, '\n', 'split');
filebyline( cellfun(@isempty,filebyline) ) = [];

%if contains(filename,'cross')
%areabyline = regexp(areastr, '\n', 'split');
%areabyline( cellfun(@isempty,areabyline) ) = [];
%end


%filebyfield = regexp(filebyline, '/data/coord/grab/ppc_ft/data/ppc_ft_LFP/', 'split');

% 
all_data_Freq = cell(1,length(stacks)); % X axis values (frequency)
all_data_GC = cell(1,length(stacks)); % Y axis values (GC)

% order will be sac, contra, ipsi, together, apart
for stack_ind = 1:length(stacks)
    all_data_Freq{1,stack_ind}=[];
    all_data_GC{1,stack_ind} = [];
end

if strcmp(file_dir,'saconly') || strcmp(file_dir,'mixed2')
	%original data
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_' file_dir '/'];
	
	%shuffle directory
	%which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP.SHUFFLE/' align_where '_Shuffle_001_' file_dir '/'];
	
elseif strcmp(file_dir,'em_data')
	if ~isempty(reach_merge)
		which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_' reach_merge '/'];
	else
		which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '/']; 
	end
elseif strcmp(file_dir,'em_data_reverse')
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_Reverse/'];
elseif strcmp(file_dir,'em_data_TrialReverse')
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_TrialReverse/'];
elseif strcmp(file_dir,'em_data_TimeReverse')
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_TimeReverse/'];
elseif strcmp(file_dir,'em_data_TimeReverseNew')
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_TimeReverseNew/'];
elseif strcmp(file_dir,'em_data_TrialAndTimeReverse')
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_TrialAndTimeReverse/'];
elseif strcmp(file_dir,'em_data_RL')
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP.RL/' align_where '/'];
elseif strcmp(file_dir,'memory_cc_')
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_memory_cc/'];
elseif strcmp(file_dir,'memory_ccc_')
	which_dir = ['/data/coord/grab/ppc_ft/data/ppc_ft_LFP/' align_where '_memory_ccc/'];

end

for file_ind = 1:length(filebyline)
    %cur_file = 'data_1968.1_1_3'; 
    cur_file = filebyline{file_ind};
        if strcmp(cur_file(1),'%')
            continue; % excluded file
        end
    
    slashes = find(cur_file=='/');
    
    cur_file = [which_dir cur_file((slashes(8)+1):end)];
    if half_trials
    cur_file = [cur_file(1:slashes(end-1)-1) '_half' cur_file(slashes(end-1):end)];
    end

    % specifying string_ind because the filenames in filebyline contains empty spaces
    %if file_ind == 1
	    
    	    %data_file = fileread(cur_file(1:end-1));
    	    try
	    data_file = fileread(cur_file(1:end-1));
    	    catch
   	    %disp(['cannot read ' data_file]); 
	    end
    %else
%	    data_file = fileread(cur_file(2:end-1));
    
    %end
    %keyboard;
    databyline = regexp(data_file, '\n', 'split');
    command_line = databyline{1}; where_h = find(command_line=='h');
    oh_value = command_line(where_h+1); % read out -oh value
    where_A = find(command_line=='A'); % read out area information (L: LIP, P: PRR) 
    first_A = command_line(where_A+1); second_A = command_line(where_A+3);

    %if contains(filename,'cross')
    %cur_area = areabyline{file_ind}; first_A = cur_area(1); second_A = cur_area(5);
    %        if strcmp(connect, 'LIP-PRR')
    %            if ~(strcmp(first_A,'L') && strcmp(second_A,'P')) && ...
    %               ~(strcmp(first_A,'L') && strcmp(second_A,'U')) &&  ~(strcmp(first_A,'U') && strcmp(second_A,'P'))
    %                    continue;
    %            end
    %    elseif strcmp(connect, 'PRR-LIP')
    %            if ~(strcmp(first_A,'P') && strcmp(second_A,'L')) && ...
    %                    ~(strcmp(first_A,'P') && strcmp(second_A,'U')) &&  ~(strcmp(first_A,'U') && strcmp(second_A,'L'))
    %                    continue;
    %            end
    %    end
    %end

    % check reps per class (skip if there is a rep <6
    %rep_min = 6;
    %mat_file = databyline{2}; where_dots = find(mat_file=='.'); slashes = find(mat_file=='/');
    %file_num = mat_file((slashes(end)+1):(where_dots(end)-1));
    %org_sfile = [mat_file(1:slashes(end)) 's' file_num];
    %grab_command = ['grab -R12 ' org_sfile];
    %[~,cmdout] = system(grab_command);
    %out_str=strsplit(cmdout,'\n'); 
    %num_reps = [];
    %for cur_line = 1:(size(out_str,2)-1)
   % 	cur_str_vals = textscan(out_str{cur_line},'%f %f %f');
   %	num_reps = [num_reps cur_str_vals{3}];
   %    end	
   % if min(num_reps)<rep_min
	%	 continue;
	%    end

    	% swapping stacks to match the order of saccade, contra, ipsi, together, apart
    %first_electrode = str2double(cur_file(end-3));
    %if ismember(first_electrode,left_electrodes)
    %    stack_order = [1 3 2 4 5];
    %else
    %    stack_order = 1:5;
    %end
     if strcmp(oh_value,'L')
     	stack_order = [1 3 2 4 5];
    else
        stack_order = 1:5;
    end

    	if contains(file_dir,'memory')
                stack_order = 1:3;
	end

    	if strcmp(file_dir,'saconly')
                stack_order = 1;
	end
	
	if contains(file_dir,'RL')
		if strcmp(oh_value,'L')
			class_order = [1 2]; % contra ipsi
		else
			class_order = [2 1]; % contra ipsi
		end
	end

	if ~isempty(reach_merge)
	stack_order = 1:2;
	end

	for stack_ind = stack_order
        % read out GC and FFT for each stack		
	% lines 5: frequency after FFT (stacks 62,...,66)
	% lines 6,7,8,9,10: GC (stacks 62,...,66)
    	%all_data_Freq{1,stack_ind}= [all_data_Freq{1,stack_ind}; str2num(databyline{5+stack_ind-1})];
    	%all_data_GC{1,stack_ind} = [all_data_GC{1,stack_ind}; str2num(databyline{10+stack_ind-1})];
    	all_data_Freq{1,stack_ind}= [all_data_Freq{1,stack_ind}; str2num(databyline{5})];
    	all_data_GC{1,stack_ind} = [all_data_GC{1,stack_ind}; str2num(databyline{6+stack_ind-1})];
	end

	files_read = files_read+1;
        all_files{files_read} = cur_file;
end


%plot_range1 = 18:25; % 20-30 Hz
%plot_range1 = 20:22; % 24-26 Hz
plot_range1 = 16:23; %19-27 Hz
plot_range2 = 58:81; % 70-100 Hz
% GC mean and SEM in beta nad gamma
GC_beta_mean = zeros(1,length(stacks)); GC_beta_sem = zeros(1,length(stacks));
GC_gamma_mean = zeros(1,length(stacks)); GC_gamma_sem = zeros(1,length(stacks));
GC_beta_byPair = zeros(files_read,length(stacks)); GC_gamma_byPair = zeros(files_read,length(stacks));

for stack_ind = 1:length(stacks)
        cur_GC = all_data_GC{stack_ind};
        cur_GC_beta = cur_GC(:,plot_range1); cur_GC_gamma = cur_GC(:,plot_range2);
        cur_GC_beta_mean = mean(mean(cur_GC_beta')); cur_GC_beta_sem = std(mean(cur_GC_beta'))/sqrt(numel(mean(cur_GC_beta')));
        cur_GC_gamma_mean = mean(mean(cur_GC_gamma')); cur_GC_gamma_sem = std(mean(cur_GC_gamma'))/sqrt(numel(mean(cur_GC_gamma')));
        GC_beta_mean(stack_ind) = cur_GC_beta_mean; GC_gamma_mean(stack_ind) = cur_GC_gamma_mean;
        GC_beta_sem(stack_ind) = cur_GC_beta_sem; GC_gamma_sem(stack_ind) = cur_GC_gamma_sem;

	%cur_GC_beta_byPair = []; cur_GC_gamma_byPair = [];
        for pair_ind = 1:files_read
                GC_beta_byPair(pair_ind,stack_ind) = mean(cur_GC_beta(pair_ind,:));
                GC_gamma_byPair(pair_ind,stack_ind) = mean(cur_GC_gamma(pair_ind,:));
        end

end
%keyboard;
end
%for plot_ind = 1:length(stacks)
%	to_plot_x = median(all_data_Freq{plot_ind}); to_plot_x= to_plot_x(x_min:x_max);
%	to_plot_y = median(all_data_GC{plot_ind}); to_plot_y= to_plot_y(x_min:x_max);
 %	plot(to_plot_x, to_plot_y,colors{plot_ind});
%	if plot_ind == 4 || plot_ind == 5
%	        to_plot_sem = std(all_data_GC{plot_ind})/sqrt(length(filebyline));
%		to_plot_sem = to_plot_sem(x_min:x_max);	
%		errorbar(to_plot_x,to_plot_y,to_plot_sem,colors{plot_ind});
%	else
%		plot(to_plot_x, to_plot_y,colors{plot_ind});
%	end
%end
%legend('sac','contra','ipsi','together','apart');

%figure_name = filename;
%if half_trials
%figure_name = [figure_name '_half'];
%end
%title([fun_rm_underscore(figure_name) ' ' 'n=' num2str(length(filebyline))]);
%xlabel('Freq (Hz)'); ylabel('GC'); 
%cd plots;
%saveas(gcf,[figure_name '.pdf']);
%cd ..;

