clear; close all;

%load old data
%load('both_monk_ppc_EM.mat');

%align_where = 'Target_500:1150ms'; align_where2 = '-at2 [500 1150ms]'; freq = 1.5; low_freq = 5:33; high_freq =47:66;
%align_where = 'GoCue_-800:0ms'; align_where2 = 'GoCue [-800 0ms]'; freq = 1.25; low_freq = 4:41; high_freq = 58:81; beta_freq = 18:25; 
%align_where = 'Target_50:550ms'; align_where2 = '-at2 [50 550ms]'; freq = 2; low_freq = 4:41; high_freq = 58:81; beta_freq = 18:25; 
%align_where = 'Target_-400:0ms'; align_where2 = 'Target [-400 0ms]'; freq = 1.25; low_freq = 4:41; high_freq = 58:81; beta_freq = 18:25; 
align_where = 'GoCue_-800:0ms'; align_where2 = 'GoCue [-800 0ms]'; freq = 1.25; low_freq = 4:41; high_freq = 58:81; beta_freq = 16:23; % beta 19-27Hz 
%align_where = 'GoCue_-800:0ms'; align_where2 = 'GoCue [-800 0ms]'; freq = 1.25; low_freq = 12:41; high_freq = 58:81; beta_freq = 17:29; % beta 20-35Hz
reach_merge=''; 
data_dir = 'em_data'; % default
%data_dir = 'em_data_reverse'; % trial reverse
%data_dir = 'em_data_TrialReverse'; % new trial reverse
%data_dir = 'em_data_TimeReverseNew'; % time within trial reverse
%data_dir = 'em_data_TrialAndTimeReverse'; % trial & time within trial reverse
%bootstrap=1; bca=0;% 1: do bootstrap with replacement 0: don't
bootstrap=0; bca=1;% 1: do bootstrap with replacement 0: don't
%bootstrap=0; bca=0;% 1: do bootstrap with replacement 0: don't
%ci_alpha = 0.01; %99%
ci_alpha = 0.05; %95%
%ci_alpha = 0.32; %68%

freq_of_i = 16:23;
[PRR_beta_mean,PRR_gamma_mean,PRR_beta_sem,PRR_gamma_sem,PRR_beta_pair,PRR_gamma_pair,num_PRR,PRR_files,PRR_all_ppc,all_data_Freq]=fun_compute_mean_ppc(align_where,data_dir,'FileList_PRR_both_EM','no_area_file','no_connect',reach_merge);
[LIP_beta_mean,LIP_gamma_mean,LIP_beta_sem,LIP_gamma_sem,LIP_beta_pair,LIP_gamma_pair,num_LIP,LIP_files,LIP_all_ppc]=fun_compute_mean_ppc(align_where,data_dir,'FileList_LIP_both_EM','no_area_file','no_connect',reach_merge);
[crossX2_PL_beta_mean,crossX2_PL_gamma_mean,crossX2_PL_beta_sem,crossX2_PL_gamma_sem,crossX2_PL_beta_pair,crossX2_PL_gamma_pair,num_crossX2_PL,PL_files,crossX2_PL_all_ppc]=...
	fun_compute_mean_ppc(align_where,data_dir,'FileList_crossX2_both_EM','no_area_file','no_connect',reach_merge);
%[crossX2_LP_beta_mean,crossX2_LP_gamma_mean,crossX2_LP_beta_sem,crossX2_LP_gamma_sem,crossX2_LP_beta_pair,crossX2_LP_gamma_pair,num_crossX2_LP,LP_files,crossX2_LP_all_ppc]=...
%        fun_compute_mean_ppc(align_where,data_dir,'FileList_crossX2_both_EM','AreaList_crossX2_both_EM','LIP-PRR',reach_merge);
[cross_PL_beta_mean,cross_PL_gamma_mean,cross_PL_beta_sem,cross_PL_gamma_sem,cross_PL_beta_pair,cross_PL_gamma_pair,num_cross_PL,~,cross_PL_all_ppc]=...
	fun_compute_mean_ppc(align_where,data_dir,'FileList_cross_both_EM','no_area_file','no_connect',reach_merge);
%[cross_LP_beta_mean,cross_LP_gamma_mean,cross_LP_beta_sem,cross_LP_gamma_sem,cross_LP_beta_pair,cross_LP_gamma_pair,num_cross_LP,~,cross_LP_all_ppc]=...
%        fun_compute_mean_ppc(align_where,data_dir,'FileList_cross_both_EM','AreaList_cross_both_EM','LIP-PRR',reach_merge);

	num_stack = 5; num_connect = 6;
kernel = 5;
%connect_colors = {[0 0.4470 0.7410],[0.8500 0.3250 0.0980],[0.9290 0.6940 0.1250],...
%                [0.4940 0.1840 0.5560],[0.4660 0.6740 0.1880],[0.3010 0.7450 0.9330]};
connect_colors = {[0 0.4470 0.7410],[0.8500 0.3250 0.0980],[0.9290 0.6940 0.1250],[0.4660 0.6740 0.1880]};
stack_colors = {'k','r','g','b','m'};
x_freq = all_data_Freq{1}; x_freq = x_freq(1,:);
%keyboard;
%low_freq = 4:41; % range for  x_freq is between 4 to 50Hz
%high_freq = 58:81; % range for  x_freq is between 70 to 100Hz
beta_plot_data = zeros(num_stack,num_connect);
beta_plot_err = zeros(num_stack,num_connect);
for stack_ind = 1:num_stack
	%beta_plot_data(stack_ind,1) = PRR_beta_mean(stack_ind);
	%beta_plot_data(stack_ind,2) = LIP_beta_mean(stack_ind);
	%beta_plot_data(stack_ind,3) = cross_PL_beta_mean(stack_ind);
	%beta_plot_data(stack_ind,4) = cross_LP_beta_mean(stack_ind);
	%beta_plot_data(stack_ind,5) = crossX2_PL_beta_mean(stack_ind);
	%beta_plot_data(stack_ind,6) = crossX2_LP_beta_mean(stack_ind);
	beta_plot_data(stack_ind,1) = mean(median(PRR_all_ppc{stack_ind}(:,beta_freq)));
	beta_plot_data(stack_ind,2) = mean(median(LIP_all_ppc{stack_ind}(:,beta_freq)));
	beta_plot_data(stack_ind,3) = mean(median(cross_PL_all_ppc{stack_ind}(:,beta_freq)));
	beta_plot_data(stack_ind,4) = mean(median(cross_LP_all_ppc{stack_ind}(:,beta_freq)));
	beta_plot_data(stack_ind,5) = mean(median(crossX2_PL_all_ppc{stack_ind}(:,beta_freq)));
	beta_plot_data(stack_ind,6) = mean(median(crossX2_LP_all_ppc{stack_ind}(:,beta_freq)));


	%beta_plot_err(stack_ind,1) = PRR_beta_sem(stack_ind); 
	%beta_plot_err(stack_ind,2) = LIP_beta_sem(stack_ind); 
	%beta_plot_err(stack_ind,3) = cross_PL_beta_sem(stack_ind); 
	%beta_plot_err(stack_ind,4) = cross_LP_beta_sem(stack_ind); 
	%beta_plot_err(stack_ind,5) = crossX2_PL_beta_sem(stack_ind); 
	%beta_plot_err(stack_ind,6) = crossX2_LP_beta_sem(stack_ind); 
	beta_plot_err_low(stack_ind,1) = mean((median(PRR_all_ppc{stack_ind}(:,beta_freq))-...
	prctile(PRR_all_ppc{stack_ind}(:,beta_freq),25))/sqrt(size(PRR_all_ppc{stack_ind}(:,beta_freq),1))); 
	beta_plot_err_low(stack_ind,2) = mean((median(LIP_all_ppc{stack_ind}(:,beta_freq))-...
	prctile(LIP_all_ppc{stack_ind}(:,beta_freq),25))/sqrt(size(LIP_all_ppc{stack_ind}(:,beta_freq),1))); 
	beta_plot_err_low(stack_ind,3) = mean((median(cross_PL_all_ppc{stack_ind}(:,beta_freq))-...
	prctile(cross_PL_all_ppc{stack_ind}(:,beta_freq),25))/sqrt(size(cross_PL_all_ppc{stack_ind}(:,beta_freq),1))); 
	beta_plot_err_low(stack_ind,4) = mean((median(cross_LP_all_ppc{stack_ind}(:,beta_freq))-...
	prctile(cross_LP_all_ppc{stack_ind}(:,beta_freq),25))/sqrt(size(cross_LP_all_ppc{stack_ind}(:,beta_freq),1))); 
	beta_plot_err_low(stack_ind,5) = mean((median(crossX2_PL_all_ppc{stack_ind}(:,beta_freq))-...
	prctile(crossX2_PL_all_ppc{stack_ind}(:,beta_freq),25))/sqrt(size(crossX2_PL_all_ppc{stack_ind}(:,beta_freq),1))); 
	beta_plot_err_low(stack_ind,6) = mean((median(crossX2_LP_all_ppc{stack_ind}(:,beta_freq))-...
	prctile(crossX2_LP_all_ppc{stack_ind}(:,beta_freq),25))/sqrt(size(crossX2_LP_all_ppc{stack_ind}(:,beta_freq),1))); 
	
	beta_plot_err_high(stack_ind,1) = mean((prctile(PRR_all_ppc{stack_ind}(:,beta_freq),75)-...
	median(PRR_all_ppc{stack_ind}(:,beta_freq)))/sqrt(size(PRR_all_ppc{stack_ind}(:,beta_freq),1)));
	beta_plot_err_high(stack_ind,2) = mean((prctile(LIP_all_ppc{stack_ind}(:,beta_freq),75)-...
        median(LIP_all_ppc{stack_ind}(:,beta_freq)))/sqrt(size(LIP_all_ppc{stack_ind}(:,beta_freq),1)));
	beta_plot_err_high(stack_ind,3) = mean((prctile(cross_PL_all_ppc{stack_ind}(:,beta_freq),75)-...
        median(cross_PL_all_ppc{stack_ind}(:,beta_freq)))/sqrt(size(cross_PL_all_ppc{stack_ind}(:,beta_freq),1)));
	beta_plot_err_high(stack_ind,4) = mean((prctile(crossX2_LP_all_ppc{stack_ind}(:,beta_freq),75)-...
        median(cross_LP_all_ppc{stack_ind}(:,beta_freq)))/sqrt(size(crossX2_LP_all_ppc{stack_ind}(:,beta_freq),1)));
	beta_plot_err_high(stack_ind,5) = mean((prctile(cross_PL_all_ppc{stack_ind}(:,beta_freq),75)-...
        median(crossX2_PL_all_ppc{stack_ind}(:,beta_freq)))/sqrt(size(crossX2_PL_all_ppc{stack_ind}(:,beta_freq),1)));
	beta_plot_err_high(stack_ind,6) = mean((prctile(cross_LP_all_ppc{stack_ind}(:,beta_freq),75)-...
        median(crossX2_LP_all_ppc{stack_ind}(:,beta_freq)))/sqrt(size(crossX2_LP_all_ppc{stack_ind}(:,beta_freq),1)));
end
% t tests
for stack_ind = 1:num_stack
        [beta_same_ttests(stack_ind),beta_same_ttests_p(stack_ind)]=...
        ttest2(PRR_beta_pair(:,stack_ind),LIP_beta_pair(:,stack_ind));
        [beta_cross_paired_ttests(stack_ind),beta_cross_paired_ttests_p(stack_ind)]=...
        ttest2(cross_PL_beta_pair(:,stack_ind),cross_LP_beta_pair(:,stack_ind));
        [beta_crossX2_paired_ttests(stack_ind),beta_crossX2_paired_ttests_p(stack_ind)]=...
        ttest2(crossX2_PL_beta_pair(:,stack_ind),crossX2_LP_beta_pair(:,stack_ind));
end
% wilcoxon tests
for stack_ind = 1:num_stack
        [beta_same_w_tests_p(stack_ind),beta_same_w_tests(stack_ind)]=...
        ranksum(PRR_beta_pair(:,stack_ind),LIP_beta_pair(:,stack_ind));
	[beta_cross_paired_w_tests_p(stack_ind),beta_cross_paired_w_tests(stack_ind)]=...
        signrank(cross_PL_beta_pair(:,stack_ind),cross_LP_beta_pair(:,stack_ind));
        [beta_crossX2_paired_w_tests_p(stack_ind),beta_crossX2_paired_w_tests(stack_ind)]=...
        signrank(crossX2_PL_beta_pair(:,stack_ind),crossX2_LP_beta_pair(:,stack_ind));
end
% ANOVA by task type
% GoCue -800:0
% PRR-PRR: 0.4929 LIP-LIP: 0.9233
% cross PL: 0.9021 cross LP: 0.9925
% crossX2 PL: 0.8436 crossX2 LP: 0.9024
PRR_anova_p=anova1(PRR_beta_pair); LIP_anova_p=anova1(LIP_beta_pair);
cross_PL_anova_p=anova1(cross_PL_beta_pair); cross_LP_anova_p=anova1(cross_LP_beta_pair);
crossX2_PL_anova_p=anova1(crossX2_PL_beta_pair); crossX2_LP_anova_p=anova1(crossX2_LP_beta_pair);


keyboard;
figure; hold on;
b = bar(beta_plot_data,'grouped');
%title([align_where2 ' EM both 20-30Hz ppc']);
title(sprintf([align_where2 ' EM both %d-%dHz ppc'],round(x_freq(beta_freq(1))),round(x_freq(beta_freq(end)))));
set(gca,'XTicklabel',{'sac';'';'contra';'';'ipsi';'';'together';'';'apart'});
% Plotting error bars on grouped bar plots
% https://www.mathworks.com/matlabcentral/answers/102220-how-do-i-place-errorbars-on-my-grouped-bar-graph-using-function-errorbar-in-matlab
% Calculate the width for each bar group
groupwidth = min(0.8, num_connect/(num_connect + 1.5));
% Set the position of each error bar in the centre of the main bar
% Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
test_on = 0;
for i = 1:num_connect
    % Calculate center of each bar
    x = (1:num_stack) - groupwidth/2 + (2*i-1) * groupwidth / (2*num_connect);
    errorbar(x, beta_plot_data(:,i), beta_plot_err_low(:,i), beta_plot_err_high(:,i) , 'k', 'linestyle', 'none');
        if i == 1
                for stack_ind = 1:num_stack
                        %if beta_same_ttests_p(stack_ind)<0.05
                        %plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.005), '-k', ...
                        %x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.01), '*k')
                        %end
                        if beta_same_w_tests_p(stack_ind)<0.05 && test_on
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i+1)+beta_plot_err_high(stack_ind,i+1)+0.0015), '-b', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i+1)+beta_plot_err_high(stack_ind,i+1)+0.003), '*b')
                        end
                end
        end
        if i == 3
                for stack_ind = 1:num_stack
                        %if beta_cross_paired_ttests_p(stack_ind)<0.05
                        %plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i)+beta_plot_err(stack_ind,i)+0.005), '-k', ...
                        %x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i)+beta_plot_err(stack_ind,i)+0.01), '*k')
                        %end

                        if beta_cross_paired_w_tests_p(stack_ind)<0.05 && test_on
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i)+beta_plot_err_high(stack_ind,i)+0.0015), '-b', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i)+beta_plot_err_high(stack_ind,i)+0.003), '*b')
                        end
                end
        end
        if i == 5
                for stack_ind = 1:num_stack
                        %if beta_crossX2_paired_ttests_p(stack_ind)<0.05
                        %plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i)+beta_plot_err(stack_ind,i)+0.005), '-k', ...
                        %x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i)+beta_plot_err(stack_ind,i)+0.01), '*k')
                        %end

                        if beta_crossX2_paired_w_tests_p(stack_ind)<0.05 && test_on
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i)+beta_plot_err_high(stack_ind,i)+0.0015), '-b', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i)+beta_plot_err_high(stack_ind,i)+0.003), '*b')
                        end
                end
        end

end


%er = errorbar(bar_plot_data,bar_plot_err);
legend(sprintf('PRR-PRR (n=%d)', num_PRR),sprintf('LIP-LIP (n=%d)', num_LIP),...
        sprintf('PRR-LIP (cross) (n=%d)', num_cross_PL), sprintf('LIP-PRR (cross) (n=%d)', num_cross_LP),...
        sprintf('PRR-LIP (crossX2) (n=%d)', num_crossX2_PL), sprintf('LIP-PRR (crossX2) (n=%d)', num_crossX2_LP),'Location','northwest');
%legend('PRR-PRR','LIP-LIP','PRR-LIP (crossX2)', 'LIP-PRR (crossX2)', 'PRR-LIP (cross)', 'LIP-PRR (cross)','Location','northwest');
ylim([0 0.10]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);

saveas(gcf,[align_where '_EM_both_beta_summary.pdf']);
%keyboard;

beta_RBG_plot = zeros(1,num_connect);
beta_RBG_err = zeros(1,num_connect);

beta_RBG_plot(1) = mean(mean(PRR_beta_pair(:,2:4)));
beta_RBG_plot(2) = mean(mean(LIP_beta_pair(:,2:4)));
beta_RBG_plot(3) = mean(mean(cross_PL_beta_pair(:,2:4)));
beta_RBG_plot(4) = mean(mean(cross_LP_beta_pair(:,2:4)));
beta_RBG_plot(5) = mean(mean(crossX2_PL_beta_pair(:,2:4)));
beta_RBG_plot(6) = mean(mean(crossX2_LP_beta_pair(:,2:4)));

RBG_PRR_beta = PRR_beta_pair(:,2:4);
RBG_LIP_beta = LIP_beta_pair(:,2:4);
RBG_cross_PL_beta = cross_PL_beta_pair(:,2:4);
RBG_cross_LP_beta = cross_LP_beta_pair(:,2:4);
RBG_crossX2_PL_beta = crossX2_PL_beta_pair(:,2:4);
RBG_crossX2_LP_beta = crossX2_LP_beta_pair(:,2:4);

beta_RBG_err(1) = std(RBG_PRR_beta(:))/sqrt(numel(RBG_PRR_beta(:)));
beta_RBG_err(2) = std(RBG_LIP_beta(:))/sqrt(numel(RBG_LIP_beta(:)));
beta_RBG_err(3) = std(RBG_cross_PL_beta(:))/sqrt(numel(RBG_cross_PL_beta(:)));
beta_RBG_err(4) = std(RBG_cross_LP_beta(:))/sqrt(numel(RBG_cross_LP_beta(:)));
beta_RBG_err(5) = std(RBG_crossX2_PL_beta(:))/sqrt(numel(RBG_crossX2_PL_beta(:)));
beta_RBG_err(6) = std(RBG_crossX2_LP_beta(:))/sqrt(numel(RBG_crossX2_LP_beta(:)));
% t tests
        [beta_RBG_same_ttests,beta_RBG_same_ttests_p]=...
        ttest2(RBG_PRR_beta(:),RBG_LIP_beta(:));
        [beta_RBG_cross_ttests,beta_RBG_cross_ttests_p]=...
        ttest2(RBG_cross_PL_beta(:),RBG_cross_LP_beta(:));
        [beta_RBG_crossX2_ttests,beta_RBG_crossX2_ttests_p]=...
        ttest2(RBG_crossX2_PL_beta(:),RBG_crossX2_LP_beta(:));

% wilcoxon tests
	[beta_RBG_same_w_tests_p,beta_RBG_same_w_tests]=...
        ranksum(RBG_PRR_beta(:),RBG_LIP_beta(:));
        [beta_RBG_cross_w_ttests_p,beta_RBG_cross_w_ttests]=...
        signrank(RBG_cross_PL_beta(:),RBG_cross_LP_beta(:));
        [beta_RBG_crossX2_w_ttests_p,beta_RBG_crossX2_w_ttests]=...
        signrank(RBG_crossX2_PL_beta(:),RBG_crossX2_LP_beta(:));
figure; hold on;
b = bar(beta_RBG_plot,'grouped');
title([align_where2 ' EM both 20-30Hz ppc']);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
set(gca,'XTicklabel',{'sac';'';'contra';'';'ipsi';'';'together';'';'apart'});
% Plotting error bars on grouped bar plots
% https://www.mathworks.com/matlabcentral/answers/102220-how-do-i-place-errorbars-on-my-grouped-bar-graph-using-function-errorbar-in-matlab
% Calculate the width for each bar group
groupwidth = min(0.8, num_connect/(num_connect + 1.5));
% Set the position of each error bar in the centre of the main bar
% Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
for i = 1:num_connect
    % Calculate center of each bar
    x = (1:num_stack) - groupwidth/2 + (2*i-1) * groupwidth / (2*num_connect);
    errorbar(x, beta_plot_data(:,i), beta_plot_err(:,i), 'k', 'linestyle', 'none');
        if i == 1
                for stack_ind = 1:num_stack
                        if beta_same_ttests_p(stack_ind)<0.5
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.005), '-k', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.01), '*k')
                        end
                        if beta_same_w_tests_p(stack_ind)<0.5
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.015), '-b', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.02), '*b')
                        end
                end
        end
        if i == 3
                for stack_ind = 1:num_stack
                        if beta_cross_paired_ttests_p(stack_ind)<0.5
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i)+beta_plot_err(stack_ind,i)+0.005), '-k', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i)+beta_plot_err(stack_ind,i)+0.01), '*k')
                        end

                        if beta_cross_paired_w_tests_p(stack_ind)<0.5
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.015), '-b', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.02), '*b')
                        end
                end
        end
        if i == 5
                for stack_ind = 1:num_stack
                        if beta_crossX2_paired_ttests_p(stack_ind)<0.5
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i)+beta_plot_err(stack_ind,i)+0.005), '-k', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i)+beta_plot_err(stack_ind,i)+0.01), '*k')
                        end

                        if beta_crossX2_paired_w_tests_p(stack_ind)<0.5
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.015), '-b', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (beta_plot_data(stack_ind,i+1)+beta_plot_err(stack_ind,i+1)+0.02), '*b')
                        end
                end
        end

end

%keyboard;
gamma_plot_data = zeros(num_stack,num_connect);
gamma_plot_err = zeros(num_stack,num_connect);
for stack_ind = 1:num_stack
        gamma_plot_data(stack_ind,1) = PRR_gamma_mean(stack_ind);
        gamma_plot_data(stack_ind,2) = LIP_gamma_mean(stack_ind);
        gamma_plot_data(stack_ind,3) = cross_PL_gamma_mean(stack_ind);
        gamma_plot_data(stack_ind,4) = cross_LP_gamma_mean(stack_ind);
        gamma_plot_data(stack_ind,5) = crossX2_PL_gamma_mean(stack_ind);
        gamma_plot_data(stack_ind,6) = crossX2_LP_gamma_mean(stack_ind);

        gamma_plot_err(stack_ind,1) = PRR_gamma_sem(stack_ind);
        gamma_plot_err(stack_ind,2) = LIP_gamma_sem(stack_ind);
        gamma_plot_err(stack_ind,3) = cross_PL_gamma_sem(stack_ind);
        gamma_plot_err(stack_ind,4) = cross_LP_gamma_sem(stack_ind);
        gamma_plot_err(stack_ind,5) = crossX2_PL_gamma_sem(stack_ind);
        gamma_plot_err(stack_ind,6) = crossX2_LP_gamma_sem(stack_ind);
end
% t tests
for stack_ind = 1:num_stack
        [gamma_same_ttests(stack_ind),gamma_same_ttests_p(stack_ind)]=...
        ttest2(PRR_gamma_pair(:,stack_ind),LIP_gamma_pair(:,stack_ind));
        [gamma_cross_paired_ttests(stack_ind),gamma_cross_paired_ttests_p(stack_ind)]=...
        ttest(cross_PL_gamma_pair(:,stack_ind),cross_LP_gamma_pair(:,stack_ind));
        [gamma_crossX2_paired_ttests(stack_ind),gamma_crossX2_paired_ttests_p(stack_ind)]=...
        ttest(crossX2_PL_gamma_pair(:,stack_ind),crossX2_LP_gamma_pair(:,stack_ind));
end
%keyboard;
figure; hold on;
b = bar(gamma_plot_data,'grouped');
title([align_where2 ' EM both 70-100Hz ppc']);
set(gca,'XTicklabel',{'sac';'';'contra';'';'ipsi';'';'together';'';'apart'});
% Plotting error bars on grouped bar plots
% https://www.mathworks.com/matlabcentral/answers/102220-how-do-i-place-errorbars-on-my-grouped-bar-graph-using-function-errorbar-in-matlab
% Calculate the width for each bar group
groupwidth = min(0.8, num_connect/(num_connect + 1.5));
% Set the position of each error bar in the centre of the main bar
% Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
for i = 1:num_connect
    % Calculate center of each bar
    x = (1:num_stack) - groupwidth/2 + (2*i-1) * groupwidth / (2*num_connect);
    errorbar(x, gamma_plot_data(:,i), gamma_plot_err(:,i), 'k', 'linestyle', 'none');
        if i == 5
                for stack_ind = 1:num_stack
                        if gamma_crossX2_paired_ttests(stack_ind)
                        plot([x(stack_ind) x(stack_ind)+groupwidth/num_connect], [1 1]*(gamma_plot_data(stack_ind,i+1)+gamma_plot_err(stack_ind,i+1)+0.005), '-k', ...
                        x(stack_ind)+(groupwidth/num_connect)/2, (gamma_plot_data(stack_ind,i+1)+gamma_plot_err(stack_ind,i+1)+0.01), '*k')
                        end
                end
        end

end


%er = errorbar(bar_plot_data,bar_plot_err);
%legend('PRR-PRR','LIP-LIP','PRR-LIP (crossX2)', 'LIP-PRR (crossX2)', 'PRR-LIP (cross)', 'LIP-PRR (cross)','Location','northwest');
legend(sprintf('PRR-PRR (n=%d)', num_PRR),sprintf('LIP-LIP (n=%d)', num_LIP),...
        sprintf('PRR-LIP (cross) (n=%d)', num_cross_PL), sprintf('LIP-PRR (cross) (n=%d)', num_cross_LP),...
        sprintf('PRR-LIP (crossX2) (n=%d)', num_crossX2_PL), sprintf('LIP-PRR (crossX2) (n=%d)', num_crossX2_LP),'Location','northwest');

ylim([0 0.1]);

saveas(gcf,[align_where '_EM_both_gamma_summary.pdf']);

% Plot Freq (x) vs. ppc (y) (merge all stacks)
% I'll show 6 lines (each line means a connection; e.g. PRR-PRR)
ppc_by_connect{1} = [PRR_all_ppc{1}; PRR_all_ppc{2}; PRR_all_ppc{3}; PRR_all_ppc{4}; PRR_all_ppc{5}];
ppc_by_connect{2} = [LIP_all_ppc{1}; LIP_all_ppc{2}; LIP_all_ppc{3}; LIP_all_ppc{4}; LIP_all_ppc{5}];
ppc_by_connect{3} = [cross_PL_all_ppc{1}; cross_PL_all_ppc{2}; cross_PL_all_ppc{3}; cross_PL_all_ppc{4}; cross_PL_all_ppc{5}];
ppc_by_connect{4} = [crossX2_PL_all_ppc{1}; crossX2_PL_all_ppc{2}; crossX2_PL_all_ppc{3}; crossX2_PL_all_ppc{4}; crossX2_PL_all_ppc{5}];

ppc_sac{1} = PRR_all_ppc{1};
ppc_sac{2} = LIP_all_ppc{1};
ppc_sac{3} = cross_PL_all_ppc{1};
ppc_sac{4} = cross_LP_all_ppc{1};
ppc_sac{5} = crossX2_PL_all_ppc{1};
ppc_sac{6} = crossX2_LP_all_ppc{1};

ppc_reach{1} = [PRR_all_ppc{2}; PRR_all_ppc{3}; PRR_all_ppc{4}; PRR_all_ppc{5}];
ppc_reach{2} = [LIP_all_ppc{2}; LIP_all_ppc{3}; LIP_all_ppc{4}; LIP_all_ppc{5}];
ppc_reach{3} = [cross_PL_all_ppc{2}; cross_PL_all_ppc{3}; cross_PL_all_ppc{4}; cross_PL_all_ppc{5}];
ppc_reach{4} = [cross_LP_all_ppc{2}; cross_LP_all_ppc{3}; cross_LP_all_ppc{4}; cross_LP_all_ppc{5}];
ppc_reach{5} = [crossX2_PL_all_ppc{2}; crossX2_PL_all_ppc{3}; crossX2_PL_all_ppc{4}; crossX2_PL_all_ppc{5}];
ppc_reach{6} = [crossX2_LP_all_ppc{2}; crossX2_LP_all_ppc{3}; crossX2_LP_all_ppc{4}; crossX2_LP_all_ppc{5}];

ppc_PL_sac = cross_PL_all_ppc{1}; ppc_PL_reach = ppc_reach{3}; 
ppc_LP_sac = cross_LP_all_ppc{1}; ppc_LP_reach = ppc_reach{4};

%ppc_reach{1} = [PRR_all_ppc{2}; PRR_all_ppc{3}; PRR_all_ppc{4}; ];
%ppc_reach{2} = [LIP_all_ppc{2}; LIP_all_ppc{3}; LIP_all_ppc{4}; ];
%ppc_reach{3} = [cross_PL_all_ppc{2}; cross_PL_all_ppc{3}; cross_PL_all_ppc{4};];
%ppc_reach{4} = [cross_LP_all_ppc{2}; cross_LP_all_ppc{3}; cross_LP_all_ppc{4};];
%ppc_reach{5} = [crossX2_PL_all_ppc{2}; crossX2_PL_all_ppc{3}; crossX2_PL_all_ppc{4};];
%ppc_reach{6} = [crossX2_LP_all_ppc{2}; crossX2_LP_all_ppc{3}; crossX2_LP_all_ppc{4};];
%keyboard;
for stack_ind =  1:num_stack
ppc_diffs{stack_ind} = [cross_PL_all_ppc{stack_ind}-cross_LP_all_ppc{stack_ind}];
ppc_diffs2{stack_ind} = median(cross_PL_all_ppc{stack_ind})-median(cross_LP_all_ppc{stack_ind});
end

% wilcoxon test
for test_ind = 1:size(ppc_by_connect{3},2)
        %PRR-LIP (within) vs.  LIP-PRR (within)
	[wilcox_p(test_ind),wilcox_sigstars(test_ind)] = signrank(ppc_by_connect{3}(:,test_ind),ppc_by_connect{4}(:,test_ind));
	%PRR-LIP (crossX2) vs.  LIP-PRR (crossX2)
	[wilcox_crossX2_p(test_ind),wilcox_crossX2_sigstars(test_ind)] = signrank(ppc_by_connect{5}(:,test_ind),ppc_by_connect{6}(:,test_ind));
	%PRR-LIP (within) (reaches) vs.  LIP-PRR (within) (crossX2)
	[wilcox_reaches_p(test_ind),wilcox_reaches_sigstars(test_ind)] = signrank(ppc_reach{3}(:,test_ind),ppc_reach{5}(:,test_ind));
	%PRR-LIP (within) reach vs. sac
	[wilcox_PL_p(test_ind),wilcox_PL_sigstars(test_ind)] = ranksum(ppc_PL_sac(:,test_ind),ppc_PL_reach(:,test_ind));
	%LIP-PRR (within) reach vs. sac
	[wilcox_LP_p(test_ind),wilcox_LP_sigstars(test_ind)] = ranksum(ppc_LP_sac(:,test_ind),ppc_LP_reach(:,test_ind));

end

% _stacks_merged.pdf: plotting ppc values by connections
% Omitting PRR-PRR and LIP-LIP
% PRR-LIP (cross) and LIP-PRR (cross): errorbars and traces
% PRR-LIP (crossX2) and LIP-PRR (crossX): traces only
%keyboard;
figure; hold on;
%low_freq = 15:41;
low_freq = 4:150; % Target -400:0ms
for connect_ind = 1:num_connect
%for connect_ind = 3:num_connect
	%to_plot = median(ppc_by_connect{connect_ind}); 
	to_plot = smoothdata(median(ppc_by_connect{connect_ind}),2,'gaussian',kernel); 
	%plot(x_freq,smoothdata(median(ppc_by_connect{connect_ind}),2,'gaussian',5),'LineWidth',3,'Color',connect_colors{connect_ind});;
	plot(x_freq(low_freq),to_plot(low_freq),'LineWidth',3,'Color',connect_colors{connect_ind});
end

PL_toPlot = smoothdata(median(ppc_by_connect{3}),2,'gaussian',kernel);
LP_toPlot = smoothdata(median(ppc_by_connect{4}),2,'gaussian',kernel);
%keyboard;

trim_percents = 5;

for freq_ind = 1:size(x_freq,2)
        %cur_diffs = cross_PL_LP_diff(:,freq_ind);
	cur_PL = ppc_by_connect{3}(:,freq_ind); cur_LP = ppc_by_connect{4}(:,freq_ind);
        %inter_quart: 25-75%
        %inter_qs(freq_ind) = iqr(cur_diffs)/sqrt(size(cross_PL_LP_diff,1));
	
        %percentile 50%
        cur_PL_CI = prctile(cur_PL,[25 75]);
        low_PL_CI(freq_ind) = (PL_toPlot(freq_ind)-cur_PL_CI(1))/(sqrt(size(cur_PL,1)));
        high_PL_CI(freq_ind) = (cur_PL_CI(2)-PL_toPlot(freq_ind))/(sqrt(size(cur_PL,1)));;
        cur_LP_CI = prctile(cur_LP,[25 75]);
        low_LP_CI(freq_ind) = (LP_toPlot(freq_ind)-cur_LP_CI(1))/(sqrt(size(cur_LP,1)));
        high_LP_CI(freq_ind) = (cur_LP_CI(2)-LP_toPlot(freq_ind))/(sqrt(size(cur_LP,1)));;
        

	%inter_quart: std/sqrt(n)
        %sorted_cur_diff = sort(cur_diffs);
        %low_inter_q(freq_ind) = sorted_cur_diff(round(0.16*numel(cur_diffs)))/sqrt(size(cross_PL_LP_diff,1));;
        %high_inter_q(freq_ind) = sorted_cur_diff(round(0.84*numel(cur_diffs)))/sqrt(size(cross_PL_LP_diff,1));;

	% trim_data
	sorted_PL = sort(cur_PL); sorted_LP = sort(cur_LP);
	trimed_PL = sorted_PL(1:round(numel(cur_PL)*(100-trim_percents)/100)); %trimming higher ppc values
	trimed_LP = sorted_LP(1:round(numel(cur_LP)*(100-trim_percents)/100)); %trimming higher ppc values

	PL_trimE(freq_ind)  = std(trimed_PL)/sqrt(numel(trimed_PL));
	LP_trimE(freq_ind)  = std(trimed_LP)/sqrt(numel(trimed_LP));

end
% bootstrapping
PLs_per_stack = size(ppc_by_connect{3},1)/num_stack; LPs_per_stack = size(ppc_by_connect{4},1)/num_stack;
how_many_boots = 500; boot_percents = 1;
PL_booted_medians = []; LP_booted_medians = []; 
for boot_ind = 1:how_many_boots
	PL_boot_inds = []; LP_boot_inds = [];
	% get index for bootstrapped elements (with replacement)
	for stack_ind = 1:num_stack
		rng('shuffle');
		PL_boot_inds = [PL_boot_inds datasample(1:PLs_per_stack,round(PLs_per_stack*boot_percents))+PLs_per_stack*(stack_ind-1)]; 	
		LP_boot_inds = [LP_boot_inds datasample(1:LPs_per_stack,round(LPs_per_stack*boot_percents))+LPs_per_stack*(stack_ind-1)]; 	
	end
	PL_booted = ppc_by_connect{3}(PL_boot_inds,:); LP_booted = ppc_by_connect{4}(LP_boot_inds,:);	
	PL_booted_medians = [PL_booted_medians; median(PL_booted)];
       	LP_booted_medians = [LP_booted_medians; median(LP_booted)]; 
end
	PL_booted_SEM = std(PL_booted_medians); LP_booted_SEM = std(LP_booted_medians);
%bca_ bias coorected (for stacks merged)
med_fun= @(x)(median(x));
for freq_ind = 1:numel(x_freq)
	cur_PL = ppc_by_connect{3}(:,freq_ind); cur_LP = ppc_by_connect{4}(:,freq_ind);
	cur_boot_PL_CI = bootci(how_many_boots,{med_fun,cur_PL},'alpha',ci_alpha); 
	cur_boot_LP_CI = bootci(how_many_boots,{med_fun,cur_LP},'alpha',ci_alpha); 
	high_boot_PL_CI(freq_ind) = cur_boot_PL_CI(2)-median(cur_PL); low_boot_PL_CI(freq_ind) = median(cur_PL)-cur_boot_PL_CI(1);
	high_boot_LP_CI(freq_ind) = cur_boot_LP_CI(2)-median(cur_LP); low_boot_LP_CI(freq_ind) = median(cur_LP)-cur_boot_LP_CI(1);
end
	%for connect_ind = 1:num_connect
for connect_ind = [3 4]
	
	to_plot = smoothdata(median(ppc_by_connect{connect_ind}),2,'gaussian',kernel); 
	if connect_ind == 3
		low_CI = low_PL_CI; high_CI = high_PL_CI;
		trimE = PL_trimE; booted_SEM = PL_booted_SEM;
		%low_boot_CI = to_plot-low_boot_PL_CI; high_boot_CI = high_boot_PL_CI-to_plot;
		low_boot_CI = low_boot_PL_CI; high_boot_CI = high_boot_PL_CI;
	else
		low_CI = low_LP_CI; high_CI = high_LP_CI;	
		trimE = LP_trimE; booted_SEM = LP_booted_SEM;
		low_boot_CI = low_boot_LP_CI; high_boot_CI = high_boot_LP_CI;
	end
	%to_plot_sem = std(ppc_by_connect{connect_ind})/sqrt(size(ppc_by_connect{connect_ind},1));
	%ppc_by_connect_sem{connect_ind} = to_plot_sem;
	%to_plot = median(ppc_by_connect{connect_ind}); 
        
	
	
	
	% 50% interquartile
	%errorbar(x_freq(low_freq),to_plot(low_freq),low_CI(low_freq),high_CI(low_freq),'Color',connect_colors{connect_ind});
	
	% trimmed data
	if bootstrap
	errorbar(x_freq(low_freq),to_plot(low_freq),booted_SEM(low_freq),'Color',connect_colors{connect_ind});
	elseif bca
	errorbar(x_freq(low_freq),to_plot(low_freq),low_boot_CI(low_freq),high_boot_CI(low_freq),'Color',connect_colors{connect_ind});
	else
	errorbar(x_freq(low_freq),to_plot(low_freq),trimE(low_freq),'Color',connect_colors{connect_ind});
	end
	%errorbar(x_freq,smoothdata(median(ppc_by_connect{connect_ind}),2,'gaussian',5),to_plot_sem,'Color',connect_colors{connect_ind});
end

for freq_ind = low_freq
        %if cross_PL_LP_sigstars(freq_ind)
        %text(x_freq(freq_ind),max(cross_PL_LP_toPlot(low_freq))+0.01,'*','Color','black');
        %end
%        if wilcox_sigstars(freq_ind)
%        text(x_freq(freq_ind),0.0525,'*','Color','blue');
%        end
	
%        if wilcox_p(freq_ind)<0.01
%        text(x_freq(freq_ind),0.055,'*','Color','blue','FontSize',18);
%        end

	
        if wilcox_p(freq_ind)<0.001
        text(x_freq(freq_ind),0.0575,'*','Color','blue','FontSize',24,'HorizontalAlignment','center');
        end

end

%legend('PRR-PRR','LIP-LIP','PRR-LIP (cross)','LIP-PRR (cross)', 'PRR-LIP (crossX2)', 'LIP-PRR (crossX2)');
%legend(sprintf('PRR-LIP (within) n=%d',size(ppc_by_connect{3},1)),sprintf('LIP-PRR (within) n=%d',size(ppc_by_connect{4},1)),...
%	sprintf('PRR-LIP (cross)  n=%d',size(ppc_by_connect{5},1)), sprintf('LIP-PRR (cross) n=%d',size(ppc_by_connect{6},1)),'Location','southwest');
legend(sprintf('PRR-PRR  n=%d',size(ppc_by_connect{1},1)),sprintf('LIP-LIP  n=%d',size(ppc_by_connect{2},1)),...
	sprintf('cross  n=%d',size(ppc_by_connect{3},1)), sprintf('crossX2 n=%d',size(ppc_by_connect{4},1)),'Location','northwest');
%axis limit for both monkeys  data
%ylim([0 0.08]); yticks(0:0.01:0.08);
	xlabel('Freq (Hz)'); ylabel('ppc');
if bootstrap
title(sprintf([align_where2 ' both EM all stacks merged (smoothing : %.2f Hz) \n bootstrapped %d times %d percent'],...
	freq*kernel,how_many_boots,boot_percents*100));
saveas(gcf,[align_where '_EM_both_ppc_booted_stacks_merged.pdf']);
elseif bca
title(sprintf([align_where2 ' both EM all stacks merged (smoothing : %.2f Hz) \n BCa %d times %d percent data CI %d% interval'],...
	freq*kernel,how_many_boots,boot_percents*100, 100*(1-ci_alpha)));
saveas(gcf,[align_where '_EM_both_ppc_bca_stacks_merged.pdf']);
else
title(sprintf([align_where2 ' both EM all stacks merged (smoothing : %.2f Hz) %d percent trimmed'],freq*kernel,trim_percents));
saveas(gcf,[align_where '_EM_both_ppc_stacks_merged.pdf']);
end
%saveas(gcf,[align_where '_EM_both_ppc_stacks_merged.pdf']);
keyboard;

for stack_ind = 1:num_stack
        ppc_by_stack{stack_ind} = [PRR_all_ppc{stack_ind}; LIP_all_ppc{stack_ind}; cross_PL_all_ppc{stack_ind};...
        cross_LP_all_ppc{stack_ind}; crossX2_PL_all_ppc{stack_ind}; crossX2_LP_all_ppc{stack_ind}];
end
%keyboard;
% PRR-LIP (within) plot reach and saccade separately
figure; hold on;
ppc_PL_sac = cross_PL_all_ppc{1}; ppc_PL_reach = ppc_reach{3};
PL_sac_toPlot = smoothdata(median(ppc_PL_sac),2,'gaussian',kernel);
PL_reach_toPlot = smoothdata(median(ppc_PL_reach),2,'gaussian',kernel);
trim_percents = 5;

for freq_ind = 1:size(x_freq,2)
        %cur_diffs = cross_PL_LP_diff(:,freq_ind);
        cur_PL_sac = ppc_PL_sac(:,freq_ind); cur_PL_reach = ppc_PL_reach(:,freq_ind);

        % trim_data
        sorted_PL_sac = sort(cur_PL_sac); sorted_PL_reach = sort(cur_PL_reach);
        trimed_PL_sac = sorted_PL_sac(1:round(numel(cur_PL_sac)*(100-trim_percents)/100)); %trimming higher ppc values
        trimed_PL_reach = sorted_PL_reach(1:round(numel(cur_PL_reach)*(100-trim_percents)/100)); %trimming higher ppc values

        PL_sac_trimE(freq_ind)  = std(trimed_PL_sac)/sqrt(numel(trimed_PL_sac));
        PL_reach_trimE(freq_ind)  = std(trimed_PL_reach)/sqrt(numel(trimed_PL_reach));

end

%plotting significant stars
for freq_ind = low_freq
        if wilcox_PL_p(freq_ind)<0.05
        text(x_freq(freq_ind),0.0525,'*','Color','blue');
        end

        if wilcox_PL_p(freq_ind)<0.01
        text(x_freq(freq_ind),0.055,'*','Color','blue','FontSize',18);
        end


        if wilcox_PL_p(freq_ind)<0.001
        text(x_freq(freq_ind),0.0575,'*','Color','blue','FontSize',24);
        end

end


plot(x_freq(low_freq),PL_sac_toPlot(low_freq),'LineWidth',3,'Color','k');
plot(x_freq(low_freq),PL_reach_toPlot(low_freq),'LineWidth',3,'Color','r');
errorbar(x_freq(low_freq),PL_sac_toPlot(low_freq),PL_sac_trimE(low_freq),'Color','k');
errorbar(x_freq(low_freq),PL_reach_toPlot(low_freq),PL_reach_trimE(low_freq),'Color','r');
legend(sprintf('saccade (n=%d)',size(ppc_PL_sac,1)),sprintf('reach (n=%d)',size(ppc_PL_reach,1)));
title('both PRR->LIP saccade and reach');
xlabel('Freq (Hz)'); ylabel('ppc'); ylim([0 0.08]);
saveas(gcf,'both_PL_sac_reach.pdf');
% LIP-PRR (within) plot reach and saccade separately
figure; hold on;
ppc_LP_sac = cross_LP_all_ppc{1}; ppc_LP_reach = ppc_reach{4};
LP_sac_toPlot = smoothdata(median(ppc_LP_sac),2,'gaussian',kernel);
LP_reach_toPlot = smoothdata(median(ppc_LP_reach),2,'gaussian',kernel);
trim_percents = 5;

for freq_ind = 1:size(x_freq,2)
        %cur_diffs = cross_PL_LP_diff(:,freq_ind);
        cur_LP_sac = ppc_LP_sac(:,freq_ind); cur_LP_reach = ppc_LP_reach(:,freq_ind);

        % trim_data
        sorted_LP_sac = sort(cur_LP_sac); sorted_LP_reach = sort(cur_LP_reach);
        trimed_LP_sac = sorted_LP_sac(1:round(numel(cur_LP_sac)*(100-trim_percents)/100)); %trimming higher ppc values
        trimed_LP_reach = sorted_LP_reach(1:round(numel(cur_LP_reach)*(100-trim_percents)/100)); %trimming higher ppc values

        LP_sac_trimE(freq_ind)  = std(trimed_LP_sac)/sqrt(numel(trimed_LP_sac));
        LP_reach_trimE(freq_ind)  = std(trimed_LP_reach)/sqrt(numel(trimed_LP_reach));

end

%plotting significant stars
for freq_ind = low_freq
        if wilcox_LP_p(freq_ind)<0.05
        text(x_freq(freq_ind),0.0525,'*','Color','blue');
        end

        if wilcox_LP_p(freq_ind)<0.01
        text(x_freq(freq_ind),0.055,'*','Color','blue','FontSize',18);
        end


        if wilcox_LP_p(freq_ind)<0.001
        text(x_freq(freq_ind),0.0575,'*','Color','blue','FontSize',24);
        end

end


plot(x_freq(low_freq),LP_sac_toPlot(low_freq),'LineWidth',3,'Color','k');
plot(x_freq(low_freq),LP_reach_toPlot(low_freq),'LineWidth',3,'Color','r');
errorbar(x_freq(low_freq),LP_sac_toPlot(low_freq),LP_sac_trimE(low_freq),'Color','k');
errorbar(x_freq(low_freq),LP_reach_toPlot(low_freq),LP_reach_trimE(low_freq),'Color','r');
legend(sprintf('saccade (n=%d)',size(ppc_LP_sac,1)),sprintf('reach (n=%d)',size(ppc_LP_reach,1)));
title('both LIP->PRR saccade and reach');
xlabel('Freq (Hz)'); ylabel('ppc'); ylim([0 0.08]);
saveas(gcf,'both_LP_sac_reach.pdf');


% merge all connections
figure; hold on;
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5);
	%plot(x_freq,median(ppc_by_connect{connect_ind}));
        %plot(x_freq,smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5),'LineWidth',3,'Color',stack_colors{stack_ind});
	plot(x_freq(1:end),to_plot(1:end),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5);
        to_plot_sem = std(ppc_by_stack{stack_ind})/sqrt(size(ppc_by_stack{stack_ind},1));
        %errorbar(x_freq,smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5),to_plot_sem,'Color',stack_colors{stack_ind});
	errorbar(x_freq(1:end),to_plot(1:end),to_plot_sem(1:end),'Color',stack_colors{stack_ind});
end
legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM all connections merged (smoothing : %.2f Hz)'],freq*kernel));
saveas(gcf, [align_where '_EM_both_ppc_connections_merged.pdf']);
%keyboard;
% Plot PRR-LIP - LIP-PRR in 4-50Hz
cross_PL_LP_diff = ppc_by_connect{3}-ppc_by_connect{4}; %median(PRR-LIP minus LIP-PRR)
cross_PL_LP_diff2 = median(ppc_by_connect{3})-median(ppc_by_connect{4}); %median(PRR-LIP)-median(LIP-PRR)
cross_PL_LP_sem = std(cross_PL_LP_diff)/sqrt(size(cross_PL_LP_diff,1));
crossX2_PL_LP_diff = ppc_by_connect{5}-ppc_by_connect{6};crossX_PL_LP_diff2 = median(ppc_by_connect{5})-median(ppc_by_connect{6}); %median(PRR-LIP)-median(LIP-PRR)
crossX2_PL_LP_sem = std(crossX2_PL_LP_diff)/sqrt(size(crossX2_PL_LP_diff,1));
%keyboard;
cross_PL_LP_toPlot = smoothdata(median(ppc_by_connect{3}-ppc_by_connect{4}),2,'gaussian',kernel);
%cross_PL_LP_toPlot = mean(ppc_by_connect{3}-ppc_by_connect{4});
cross_PL_LP_toPlot2 = smoothdata(median(ppc_by_connect{3}),2,'gaussian',kernel)- smoothdata(median(ppc_by_connect{4}),2,'gaussian',kernel);
% both max range: x_freq(17:21) max at 22Hz PL_LP_diff SEM:0.0092 (20-27Hz) PL SEM: 0.0064 LP SEM: 0.0071
% both max range: x_freq(19:23) max at 25Hz PL_LP_diff SEM:0.0050 (20-27Hz) PL SEM: 0.0035 LP SEM: 0.0037
cross_PL_LP_sigstars = ttest2(ppc_by_connect{3},ppc_by_connect{4});
%keyboard;

% compute interquartile range of cross_PL_LP_diff
for freq_ind = 1:size(cross_PL_LP_diff,2)
	cur_diffs = cross_PL_LP_diff(:,freq_ind);
	%inter_quart: 25-75%
	inter_qs(freq_ind) = iqr(cur_diffs)/sqrt(size(cross_PL_LP_diff,1));
	
	%percentile 50%
	cur_CI = prctile(cur_diffs,[25 75]);
	%low_bar = cross_PL_LP_toPlot(freq_ind)-cur_CI(1)
	low_CI(freq_ind) = (cross_PL_LP_toPlot(freq_ind)-cur_CI(1))/(sqrt(size(cross_PL_LP_diff,1))); 
	high_CI(freq_ind) = (cur_CI(2)-cross_PL_LP_toPlot(freq_ind))/(sqrt(size(cross_PL_LP_diff,1)));;
	%inter_quart: std/sqrt(n)
	%sorted_cur_diff = sort(cur_diffs);
	%low_inter_q(freq_ind) = sorted_cur_diff(round(0.16*numel(cur_diffs)))/sqrt(size(cross_PL_LP_diff,1));;
	%high_inter_q(freq_ind) = sorted_cur_diff(round(0.84*numel(cur_diffs)))/sqrt(size(cross_PL_LP_diff,1));;
end

%bca_ bias coorected (sac and reach PL_LP)
med_fun= @(x)(median(x));
for freq_ind = 1:numel(x_freq)
        cur_PL_LP_diffs = cross_PL_LP_diff(:,freq_ind);

        cur_boot_PL_LP_CI = bootci(how_many_boots,{med_fun,cur_PL_LP_diffs},'alpha',ci_alpha);
        high_boot_PL_LP_CI(freq_ind) = cur_boot_PL_LP_CI(2)-median(cur_PL_LP_diffs); low_boot_PL_LP_CI(freq_ind) = median(cur_PL_LP_diffs)-cur_boot_PL_LP_CI(1);
end

%keyboard;
figure; hold on;
plot(x_freq(low_freq),cross_PL_LP_toPlot(low_freq),...
	'LineWidth',3,'Color',[0.6350 0.0780 0.1840]);
%errorbar(x_freq(low_freq),cross_PL_LP_toPlot(low_freq),cross_PL_LP_sem(low_freq),'Color',[0.6350 0.0780 0.1840]);
%errorbar(x_freq(low_freq),cross_PL_LP_toPlot(low_freq),low_inter_q(low_freq),high_inter_q(low_freq),'Color',[0.6350 0.0780 0.1840]);
%errorbar(x_freq(low_freq),cross_PL_LP_toPlot(low_freq),inter_qs(low_freq)/2,'Color',[0.6350 0.0780 0.1840]);
%errorbar(x_freq(low_freq),cross_PL_LP_toPlot(low_freq),low_CI(low_freq),high_CI(low_freq),'Color',[0.6350 0.0780 0.1840]);
errorbar(x_freq(low_freq),cross_PL_LP_toPlot(low_freq),low_boot_PL_LP_CI(low_freq),high_boot_PL_LP_CI(low_freq),...
	'Color',[0.6350 0.0780 0.1840]);

plot(x_freq(low_freq),x_freq(low_freq)*0,'k--');
%plotting significant stars
for freq_ind = low_freq
	%if cross_PL_LP_sigstars(freq_ind)
	%text(x_freq(freq_ind),max(cross_PL_LP_toPlot(low_freq))+0.01,'*','Color','black');
	%end
	%if wilcox_sigstars(freq_ind)
        %text(x_freq(freq_ind),max(cross_PL_LP_toPlot(low_freq))+0.012,'*','Color','blue');
        %end
	if wilcox_p(freq_ind)<0.001
        text(x_freq(freq_ind),0.0225,'*','Color','blue','FontSize',24,'HorizontalAlignment','center'); %both
	
        end

end
%ylim([-0.02 0.06]);
%ylim([-0.001 0.0175]); 
ylim([-0.025 0.025]); yticks([-0.02:0.01:0.02]);
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) (smoothing : %.2f Hz)'],freq*kernel));
%title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) (no smoothing)'],freq*kernel));
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
%saveas(gcf,[align_where '_EM_both_ppc_cross_PL_LP_diff_no_smooth.pdf']);
%saveas(gcf,[align_where '_EM_both_ppc_cross_PL_LP_diff_no_smooth.pdf']);
%saveas(gcf,[align_where '_EM_both_ppc_cross_PL_LP_inter_quart_diff_smooth.pdf']);
saveas(gcf,[align_where '_EM_both_ppc_cross_PL_LP_bca95.pdf']);
%keyboard;
figure; hold on;
plot(x_freq(low_freq),cross_PL_LP_toPlot2(low_freq),...
        'LineWidth',3,'Color',[0.6350 0.0780 0.1840]);
errorbar(x_freq(low_freq),cross_PL_LP_toPlot2(low_freq),cross_PL_LP_sem(low_freq),'Color',[0.6350 0.0780 0.1840]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
plot(x_freq(low_freq),x_freq(low_freq)*0,'k--');
%plotting significant stars
for freq_ind = low_freq
        if cross_PL_LP_sigstars(freq_ind)
        text(x_freq(freq_ind),max(cross_PL_LP_toPlot2(low_freq))+0.01,'*','Color','black');
        end
end
ylim([-0.02 0.05]);
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) (smoothing : %.2f Hz)'],freq*kernel));
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf,[align_where '_EM_both_ppc_cross_PL_LP_diff2.pdf']);

figure; hold on;
plot(x_freq(high_freq),cross_PL_LP_toPlot2(high_freq),...
        'LineWidth',3,'Color',[0.6350 0.0780 0.1840]);
errorbar(x_freq(high_freq),cross_PL_LP_toPlot2(high_freq),cross_PL_LP_sem(high_freq),'Color',[0.6350 0.0780 0.1840]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
plot(x_freq(high_freq),x_freq(high_freq)*0,'k--');
%plotting significant stars
for freq_ind = high_freq
        if cross_PL_LP_sigstars(freq_ind)
        %text(x_freq(freq_ind),max(cross_PL_LP_toPlot2(high_freq))+0.01,'*','Color','black');
        text(x_freq(freq_ind),max(cross_PL_LP_toPlot2(high_freq))+0.01,'*','Color','black'); %both
        
	end
end
ylim([-0.02 0.05]);
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) (smoothing : %.2f Hz)'],freq*kernel));
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf,[align_where '_EM_both_ppc_cross_PL_LP_high_freq_diff2.pdf']);


figure;
plot(x_freq(low_freq),smoothdata(median(crossX2_PL_LP_diff(:,low_freq)),2,'gaussian',kernel),...
        'LineWidth',3,'Color','k');
errorbar(x_freq(low_freq),smoothdata(median(crossX2_PL_LP_diff(:,low_freq)),2,'gaussian',kernel),crossX2_PL_LP_sem(low_freq),'Color','k');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (crossX2) - LIP-PRR (crossX2) (smoothing : %.2f Hz)'],freq*kernel));
saveas(gcf,[align_where '_EM_both_ppc_crossX2_PL_LP_diff.pdf']);

% figure of PRR-LIP - LIP-PRR in 4-50Hz by saccade and reach
sac_PL_LP_diff = ppc_sac{3}-ppc_sac{4};
sac_PL_LP_sem = std(sac_PL_LP_diff)/sqrt(size(sac_PL_LP_diff,1));
sac_PL_LP_toPlot = smoothdata(median(ppc_sac{3}),2,'gaussian',kernel)- smoothdata(median(ppc_sac{4}),2,'gaussian',kernel);

reach_PL_LP_diff = ppc_reach{3}-ppc_reach{4};
reach_PL_LP_sem = std(reach_PL_LP_diff)/sqrt(size(reach_PL_LP_diff,1));
reach_PL_LP_toPlot = smoothdata(median(ppc_reach{3}),2,'gaussian',kernel)- smoothdata(median(ppc_reach{4}),2,'gaussian',kernel);

% wilcoxson tests for PRR-LIP vs LIP-PRR in saccades
for test_ind = 1:size(ppc_sac{3},2)
        [wilcox_sac_p(test_ind),wilcox_sac_sigstars(test_ind)] = signrank(ppc_sac{3}(:,test_ind),ppc_sac{4}(:,test_ind));
end


% wilcoxson tests for PRR-LIP vs LIP-PRR in reach
for test_ind = 1:size(ppc_reach{3},2)
        [wilcox_reach_p(test_ind),wilcox_reach_sigstars(test_ind)] = signrank(ppc_reach{3}(:,test_ind),ppc_reach{4}(:,test_ind));
end

%wilcoxon tests for PRR-LIP minus LIP-PRR (saccade vs reach)
for test_ind= 1:size(ppc_sac{3},2)
	[wilcox_sac_reach_p(test_ind),wilcox_sac_reach_sigstars(test_ind)] = ranksum(sac_PL_LP_diff(:,test_ind),reach_PL_LP_diff(:,test_ind));	
end

trim_percents = 5;
%keyboard;
for freq_ind = 1:size(sac_PL_LP_diff,2)
        cur_sac_diffs = sac_PL_LP_diff(:,freq_ind);
        cur_reach_diffs = reach_PL_LP_diff(:,freq_ind);

        %inter_quart: 25-75%
        %inter_qs(freq_ind) = iqr(cur_diffs)/sqrt(size(cross_PL_LP_diff,1));

        %percentile 50%
        cur_sac_CI = prctile(cur_sac_diffs,[25 75]);
        cur_reach_CI = prctile(cur_reach_diffs,[25 75]);
        %low_bar = cross_PL_LP_toPlot(freq_ind)-cur_CI(1)
        low_sac_CI(freq_ind) = (sac_PL_LP_toPlot(freq_ind)-cur_sac_CI(1))/(sqrt(size(sac_PL_LP_diff,1)));
        high_sac_CI(freq_ind) = (cur_sac_CI(2)-sac_PL_LP_toPlot(freq_ind))/(sqrt(size(sac_PL_LP_diff,1)));;
        low_reach_CI(freq_ind) = (reach_PL_LP_toPlot(freq_ind)-cur_reach_CI(1))/(sqrt(size(reach_PL_LP_diff,1)));
        high_reach_CI(freq_ind) = (cur_reach_CI(2)-reach_PL_LP_toPlot(freq_ind))/(sqrt(size(reach_PL_LP_diff,1)));;
        %inter_quart: std/sqrt(n)
        %sorted_cur_diff = sort(cur_diffs);
        %low_inter_q(freq_ind) = sorted_cur_diff(round(0.16*numel(cur_diffs)))/sqrt(size(cross_PL_LP_diff,1));;
        %high_inter_q(freq_ind) = sorted_cur_diff(round(0.84*numel(cur_diffs)))/sqrt(size(cross_PL_LP_diff,1));;

	% trim_data
        sorted_sac_diffs = sort(cur_sac_diffs); sorted_reach_diffs = sort(cur_reach_diffs);
        trimed_sac_diffs = sorted_sac_diffs(round(numel(cur_sac_diffs)*(trim_percents/2)/100):round(numel(cur_sac_diffs)*(100-(trim_percents/2))/100)); %trimming lower higher ppc diffs
        trimed_reach_diffs = sorted_reach_diffs(round(numel(cur_reach_diffs)*(trim_percents/2)/100):round(numel(cur_reach_diffs)*(100-(trim_percents/2))/100)); %trimming lower  higher ppc diffss

        sac_diffs_trimE(freq_ind)  = std(trimed_sac_diffs)/sqrt(numel(trimed_sac_diffs));
        reach_diffs_trimE(freq_ind)  = std(trimed_sac_diffs)/sqrt(numel(trimed_reach_diffs));

end


%bca_ bias coorected (sac and reach PL_LP)
med_fun= @(x)(median(x));
for freq_ind = 1:numel(x_freq)
       	cur_sac_diffs = sac_PL_LP_diff(:,freq_ind);
        cur_reach_diffs = reach_PL_LP_diff(:,freq_ind);

        cur_boot_sac_CI = bootci(how_many_boots,{med_fun,cur_sac_diffs},'alpha',ci_alpha);
        cur_boot_reach_CI = bootci(how_many_boots,{med_fun,cur_reach_diffs},'alpha',ci_alpha);
        high_boot_sac_CI(freq_ind) = cur_boot_sac_CI(2)-median(cur_sac_diffs); low_boot_sac_CI(freq_ind) = median(cur_sac_diffs)-cur_boot_sac_CI(1);
        high_boot_reach_CI(freq_ind) = cur_boot_reach_CI(2)-median(cur_reach_diffs); low_boot_reach_CI(freq_ind) = median(cur_reach_diffs)-cur_boot_reach_CI(1);
end

figure;
%subplot('position',[0 0 1 1]); hold on;
hold on;
plot(x_freq(low_freq),sac_PL_LP_toPlot(low_freq),'LineWidth',3,'Color','k');
plot(x_freq(low_freq),reach_PL_LP_toPlot(low_freq),'LineWidth',3,'Color','r');
% regular SEM
%errorbar(x_freq(low_freq),sac_PL_LP_toPlot(low_freq),sac_PL_LP_sem(low_freq),'Color','k');
%errorbar(x_freq(low_freq),reach_PL_LP_toPlot(low_freq),sac_PL_LP_sem(low_freq),'Color','r');
% interquartile 50% range
%errorbar(x_freq(low_freq),sac_PL_LP_toPlot(low_freq),low_sac_CI(low_freq),high_sac_CI(low_freq),'Color','black');
%errorbar(x_freq(low_freq),reach_PL_LP_toPlot(low_freq),low_reach_CI(low_freq),high_reach_CI(low_freq),'Color','red');
% SEM after trimming
%errorbar(x_freq(low_freq),sac_PL_LP_toPlot(low_freq),sac_diffs_trimE(low_freq),'Color','k');
%errorbar(x_freq(low_freq),reach_PL_LP_toPlot(low_freq),reach_diffs_trimE(low_freq),'Color','r');
% BCa confience intervals
errorbar(x_freq(low_freq),sac_PL_LP_toPlot(low_freq),low_boot_sac_CI(low_freq),high_boot_sac_CI(low_freq),'Color','k');
errorbar(x_freq(low_freq),reach_PL_LP_toPlot(low_freq),low_boot_reach_CI(low_freq),high_boot_reach_CI(low_freq),'Color','r');
for freq_ind = low_freq
        %if wilcox_sac_sigstars(freq_ind)
        %text(x_freq(freq_ind),0.0275,'*','Color','black');
        %end

	%if wilcox_reach_sigstars(freq_ind)
        %text(x_freq(freq_ind),0.03,'*','Color','red');
        %end
	
	if wilcox_reach_p(freq_ind)<0.001
        text(x_freq(freq_ind),0.0325,'*','Color','blue','FontSize',24,'HorizontalAlignment','center');
        end
	
	%if wilcox_sac_reach_sigstars(freq_ind)
        %text(x_freq(freq_ind),0.0325,'*','Color','blue');
        %end

end


plot(x_freq(low_freq),x_freq(low_freq)*0,'k--');
%ylim([-0.02 0.06]);
%axis limit for both monkeys data
ylim([-0.05 0.05]);yticks(-0.04:0.01:0.04);
legend(sprintf('saccade (n=%d)',size(sac_PL_LP_diff,1)),sprintf('reach (n=%d)',size(reach_PL_LP_diff,1)));
xlabel('Freq (Hz)'); ylabel('ppc');
%title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) (smoothing : %.2f Hz)'],freq*kernel));
%title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) (smoothing : %.2f Hz %d percent trimmed)'],freq*kernel,trim_percents));
title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) merged (smoothing : %.2f Hz) \n BCa %d times %d percent data CI %d% interval'],...
        freq*kernel,how_many_boots,boot_percents*100, 100*(1-ci_alpha)));

%set(gca, 'LooseInset', get(gca,'TightInset'))
set(gcf,'units','inches');
set(gcf,'Position',[0 0 8.5 11]);

saveas(gcf,[align_where '_EM_both_ppc_PL_LP_sac_reach.pdf']);
%PRR-PRR (cross) task effects
all_freq = 4:150;
%all_freq = 4:41;
%all_freq = 15:41;
figure; hold on;
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(PRR_all_ppc{stack_ind}),2,'gaussian',5);
        %plot(x_freq,median(ppc_by_connect{connect_ind}));
        %plot(x_freq,smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5),'LineWidth',3,'Color',stack_colors{stack_ind});
        plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(cross_LP_all_ppc{stack_ind}),2,'gaussian',5);
        to_plot_sem = std(cross_LP_all_ppc{stack_ind})/sqrt(size(cross_LP_all_ppc{stack_ind},1));
        %errorbar(x_freq(low_freq),to_plot(low_freq),to_plot_sem(low_freq),'Color',stack_colors{stack_ind});
end
legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-PRR (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
%ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_PRR_PRR_each_stack.pdf']);

%LIP-LIP (cross) task effects
all_freq = 4:150;
%all_freq = 4:41;
%all_freq = 15:41;
figure; hold on;
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(LIP_all_ppc{stack_ind}),2,'gaussian',5);
        %plot(x_freq,median(ppc_by_connect{connect_ind}));
        %plot(x_freq,smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5),'LineWidth',3,'Color',stack_colors{stack_ind});
        plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(cross_LP_all_ppc{stack_ind}),2,'gaussian',5);
        to_plot_sem = std(cross_LP_all_ppc{stack_ind})/sqrt(size(cross_LP_all_ppc{stack_ind},1));
        %errorbar(x_freq(low_freq),to_plot(low_freq),to_plot_sem(low_freq),'Color',stack_colors{stack_ind});
end
legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM LIP-LIP (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
%ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_LIP_LIP_each_stack.pdf']);

%keyboard;
%LIP-PRR (cross) task effects
%all_freq = 1:150;
%all_freq = 4:41;
%all_freq = 15:41; %GoCue -800:0ms
%all_freq = 5:20; %Target -400:0ms (5-50)Hz
all_freq = 5:75;  %Target -400:0ms (5-180)Hz
figure; hold on;
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(cross_LP_all_ppc{stack_ind}),2,'gaussian',5);
        %plot(x_freq,median(ppc_by_connect{connect_ind}));
        %plot(x_freq,smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5),'LineWidth',3,'Color',stack_colors{stack_ind});
        plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(cross_LP_all_ppc{stack_ind}),2,'gaussian',5);
        to_plot_sem = std(cross_LP_all_ppc{stack_ind})/sqrt(size(cross_LP_all_ppc{stack_ind},1));
        %errorbar(x_freq(low_freq),to_plot(low_freq),to_plot_sem(low_freq),'Color',stack_colors{stack_ind});
end
%legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM LIP-PRR (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_LP_each_stack.pdf']);

%LIP-PRR (cross) task effects (sac and median(reaches))
all_freq = 1:150;
figure; hold on;
sac_to_plot = median(cross_LP_all_ppc{1});
reach_to_plot = median([cross_LP_all_ppc{2}; cross_LP_all_ppc{3}; cross_LP_all_ppc{4}; cross_LP_all_ppc{5}]);

to_plot=smoothdata(sac_to_plot,2,'gaussian',5);
plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color','k');
to_plot=smoothdata(reach_to_plot,2,'gaussian',5);
plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color','r');

legend('saccade','reach');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM LIP-PRR (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_LP_reach_median_each_stack.pdf']);
%saveas(gcf, [align_where '_EM_both_ppc_cross_LP_reach_median_each_stack.fig']);
keyboard;

%LIP-PRR (cross) mean of 5 tasks
%open('GoCue_-800:0ms_EM_both_ppc_ShuffleStack_cross_LP_each_stack.fig'); hold on;
figure;
all_freq = 4:150;
to_plot = smoothdata(median(ppc_by_connect{4}),2,'gaussian',5); %median of cross_PL in all stacks
plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color','k');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM LIP-PRR (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_LP_median_all_stacks.pdf']);


%PRR-LIP (cross) task effects
figure; hold on;
%all_freq = 1:150;
%all_freq = 4:41; %GoCue -800:0ms
%all_freq = 5:20; %Target -400:0ms (5-50)Hz
%all_freq = 5:75;  %Target -400:0ms (5-180)Hz
all_freq = 1:150;
%all_freq = 15:41;
%all_freq = [16:40 54:135];
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(cross_PL_all_ppc{stack_ind}),2,'gaussian',5);
        %plot(x_freq,median(ppc_by_connect{connect_ind}));
        %plot(x_freq,smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5),'LineWidth',3,'Color',stack_colors{stack_ind});
        plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(cross_PL_all_ppc{stack_ind}),2,'gaussian',5);
        to_plot_sem = std(cross_PL_all_ppc{stack_ind})/sqrt(size(cross_PL_all_ppc{stack_ind},1));
        %errorbar(x_freq(low_freq),to_plot(low_freq),to_plot_sem(low_freq),'Color',stack_colors{stack_ind});
end

% Plotting significance
%line([x_freq(freq_of_i(1)) x_freq(freq_of_i(end))],[0.07 0.07],'Color','c');
%text(median(x_freq(freq_of_i)),0.0725,'*','Color','cyan','FontSize',24,'HorizontalAlignment','center');

%legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
%ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_each_stack.pdf']);

%keyboard;
%PRR-LIP (cross) mean of 5 tasks
figure;
%open('GoCue_-800:0ms_EM_both_ppc_ShuffleStack_cross_PL_each_stack.fig'); hold on;
all_freq = 4:150;
to_plot = smoothdata(median(ppc_by_connect{3}),2,'gaussian',5); %median of cross_PL in all stacks
plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color','k');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_PL_median_all_stacks.pdf']);

%PRR-LIP (cross) task effects (sac and median(reaches))
all_freq = 1:150;
figure; hold on;
sac_to_plot = median(cross_PL_all_ppc{1});
reach_to_plot = median([cross_PL_all_ppc{2}; cross_PL_all_ppc{3}; cross_PL_all_ppc{4}; cross_PL_all_ppc{5}]);

to_plot=smoothdata(sac_to_plot,2,'gaussian',5);
plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color','k');
to_plot=smoothdata(reach_to_plot,2,'gaussian',5);
plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color','r');

legend('saccade','reach');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_PL_reach_median_each_stack.pdf']);
%saveas(gcf, [align_where '_EM_both_ppc_cross_PL_reach_median_each_stack.fig']);

%PRR-LIP (cross) & LIP-PRR (cross)  task effects (sac and median(reaches))
%all_freq = [1:46 54:142 150];
%freq_ranges = {16:46,54:141};
freq_ranges = {16:40,54:135}; wilcox_freq_ranges = [16:40 54:135];
figure; hold on;
%PRR-LIP (cross)
sac_to_plot = median(cross_PL_all_ppc{1});
reach_to_plot = median([cross_PL_all_ppc{2}; cross_PL_all_ppc{3}; cross_PL_all_ppc{4}; cross_PL_all_ppc{5}]);

for plot_ind = 1:size(freq_ranges,2)
to_plot=smoothdata(sac_to_plot,2,'gaussian',5);
plot(x_freq(freq_ranges{plot_ind}),to_plot(freq_ranges{plot_ind}),'LineWidth',3,'Color',connect_colors{3},'LineStyle','--');
to_plot=smoothdata(reach_to_plot,2,'gaussian',5);
plot(x_freq(freq_ranges{plot_ind}),to_plot(freq_ranges{plot_ind}),'LineWidth',3,'Color',connect_colors{3});
end
%LIP-PRR (cross)
sac_to_plot = median(cross_LP_all_ppc{1});
reach_to_plot = median([cross_LP_all_ppc{2}; cross_LP_all_ppc{3}; cross_LP_all_ppc{4}; cross_LP_all_ppc{5}]);

for plot_ind = 1:size(freq_ranges,2)
to_plot=smoothdata(sac_to_plot,2,'gaussian',5);
plot(x_freq(freq_ranges{plot_ind}),to_plot(freq_ranges{plot_ind}),'LineWidth',3,'Color',connect_colors{4},'LineStyle','--');
to_plot=smoothdata(reach_to_plot,2,'gaussian',5);
plot(x_freq(freq_ranges{plot_ind}),to_plot(freq_ranges{plot_ind}),'LineWidth',3,'Color',connect_colors{4});
end

for freq_ind = wilcox_freq_ranges

	if wilcox_reaches_p(freq_ind)<0.001
        text(x_freq(freq_ind),0.0575,'*','Color','blue','FontSize',24,'HorizontalAlignment','center');
        end

end
%legend('saccade','reach');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (cross) each stack (smoothing : %.2f Hz)'],freq*kernel));
xlim([0 180]);ylim([0 0.06]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_PL_LP_reach_median_each_stack.pdf']);
saveas(gcf, [align_where '_EM_both_ppc_cross_PL_LP_reach_median_each_stack.fig']);


%LIP-PRR (crossX2) task effects
figure; hold on;
%all_freq=4:41;
all_freq=15:41;
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(crossX2_LP_all_ppc{stack_ind}),2,'gaussian',5);
        %plot(x_freq,median(ppc_by_connect{connect_ind}));
        %plot(x_freq,smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5),'LineWidth',3,'Color',stack_colors{stack_ind});
        plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(crossX2_LP_all_ppc{stack_ind}),2,'gaussian',5);
        to_plot_sem = std(crossX2_LP_all_ppc{stack_ind})/sqrt(size(crossX2_LP_all_ppc{stack_ind},1));
        %errorbar(x_freq(low_freq),to_plot(low_freq),to_plot_sem(low_freq),'Color',stack_colors{stack_ind});
end
legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM LIP-PRR (crossX2) each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_crossX2_LP_each_stack.pdf']);

%LIP-PRR (crossX2) task effects (sac and mean(reaches))
all_freq = 1:150;
figure; hold on;
sac_to_plot = median(crossX2_LP_all_ppc{1});
reach_to_plot = median([crossX2_LP_all_ppc{2}; crossX2_LP_all_ppc{3}; crossX2_LP_all_ppc{4}; crossX2_LP_all_ppc{5}]);

to_plot=smoothdata(sac_to_plot,2,'gaussian',5);
plot(all_freq,to_plot(all_freq),'LineWidth',3,'Color','k');
to_plot=smoothdata(reach_to_plot,2,'gaussian',5);
plot(all_freq,to_plot(all_freq),'LineWidth',3,'Color','r');

legend('saccade','reach');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM LIP-PRR (crossX2) each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_crossX2_LP_reach_median_each_stack.pdf']);

%PRR-LIP (crossX2) task effects
figure; hold on;
%all_freq=4:41;
%all_freq=15:41;
all_freq=4:150;
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(crossX2_PL_all_ppc{stack_ind}),2,'gaussian',5);
        %plot(x_freq,median(ppc_by_connect{connect_ind}));
        %plot(x_freq,smoothdata(median(ppc_by_stack{stack_ind}),2,'gaussian',5),'LineWidth',3,'Color',stack_colors{stack_ind});
        plot(x_freq(all_freq),to_plot(all_freq),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(crossX2_PL_all_ppc{stack_ind}),2,'gaussian',5);
        to_plot_sem = std(crossX2_PL_all_ppc{stack_ind})/sqrt(size(crossX2_PL_all_ppc{stack_ind},1));
        %errorbar(x_freq(low_freq),to_plot(low_freq),to_plot_sem(low_freq),'Color',stack_colors{stack_ind});
end

%line([x_freq(freq_of_i(1)) x_freq(freq_of_i(end))],[0.07 0.07],'Color','c');
%text(median(x_freq(freq_of_i)),0.0725,'*','Color','cyan','FontSize',24,'HorizontalAlignment','center');
legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM (crossX2) each stack (smoothing : %.2f Hz)'],freq*kernel));
%ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_crossX2_each_stack.pdf']);

%PRR-LIP (crossX2) task effects (sac and mean(reaches))
all_freq = 1:150;
figure; hold on;
sac_to_plot = median(crossX2_PL_all_ppc{1});
reach_to_plot = median([crossX2_PL_all_ppc{2}; crossX2_PL_all_ppc{3}; crossX2_PL_all_ppc{4}; crossX2_PL_all_ppc{5}]);

to_plot=smoothdata(sac_to_plot,2,'gaussian',5);
plot(all_freq,to_plot(all_freq),'LineWidth',3,'Color','k');
to_plot=smoothdata(reach_to_plot,2,'gaussian',5);
plot(all_freq,to_plot(all_freq),'LineWidth',3,'Color','r');

legend('saccade','reach');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (crossX2) each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([0 0.08]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_crossX2_PL_reach_median_each_stack.pdf']);

%PRR-LIP (crossX2) & LIP-PRR (crossX2)  task effects (sac and median(reaches))
%freq_ranges = {16:46,54:141};
%freq_ranges = {16:40,54:135};
figure; hold on;
%PRR-LIP (crossX2)
sac_to_plot = median(crossX2_PL_all_ppc{1});
reach_to_plot = median([crossX2_PL_all_ppc{2}; crossX2_PL_all_ppc{3}; crossX2_PL_all_ppc{4}; crossX2_PL_all_ppc{5}]);

for plot_ind = 1:size(freq_ranges,2)
to_plot=smoothdata(sac_to_plot,2,'gaussian',5);
plot(x_freq(freq_ranges{plot_ind}),to_plot(freq_ranges{plot_ind}),'LineWidth',3,'Color','k');
to_plot=smoothdata(reach_to_plot,2,'gaussian',5);
plot(x_freq(freq_ranges{plot_ind}),to_plot(freq_ranges{plot_ind}),'LineWidth',3,'Color','r');
end
%LIP-PRR (crossX2)
sac_to_plot = median(crossX2_LP_all_ppc{1});
reach_to_plot = median([crossX2_LP_all_ppc{2}; crossX2_LP_all_ppc{3}; crossX2_LP_all_ppc{4}; crossX2_LP_all_ppc{5}]);

for plot_ind = 1:size(freq_ranges,2)
to_plot=smoothdata(sac_to_plot,2,'gaussian',5);
plot(x_freq(freq_ranges{plot_ind}),to_plot(freq_ranges{plot_ind}),'LineWidth',3,'Color','k','LineStyle','--');
to_plot=smoothdata(reach_to_plot,2,'gaussian',5);
plot(x_freq(freq_ranges{plot_ind}),to_plot(freq_ranges{plot_ind}),'LineWidth',3,'Color','r','LineStyle','--');
end

%legend('saccade','reach');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (crossX2) each stack (smoothing : %.2f Hz)'],freq*kernel));
xlim([0 180]);ylim([0 0.06]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_crossX2_PL_LP_reach_median_each_stack.pdf']);
saveas(gcf, [align_where '_EM_both_ppc_crossX2_PL_LP_reach_median_each_stack.fig']);

%save('cross_crossX2_EM_data.mat','crossX2_PL_all_ppc','crossX2_LP_all_ppc','cross_PL_all_ppc','cross_LP_all_ppc');


% figure of PRR-LIP - LIP-PRR in 4-50Hz by stacks


% PRR-LIP (cross)  vs. LIP-PRR (cross)
% median(A-B)
figure; hold on;
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(ppc_diffs{stack_ind}),2,'gaussian',5);
        plot(x_freq(low_freq),to_plot(low_freq),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(median(ppc_diffs{stack_ind}),2,'gaussian',5);
        to_plot_sem = std(ppc_diffs{stack_ind})/sqrt(size(ppc_diffs{stack_ind},1));
        errorbar(x_freq(low_freq),to_plot(low_freq),to_plot_sem(low_freq),'Color',stack_colors{stack_ind});
end
plot(x_freq(low_freq),x_freq(low_freq)*0,'k--');
legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) \n  each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([-0.02 0.06]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_PL_LP_diff_each_stack.pdf']);

% PRR-LIP (cross)  vs. LIP-PRR (cross)
% median(A)-median(B)
figure; hold on;
for stack_ind = 1:num_stack
        to_plot=smoothdata(ppc_diffs2{stack_ind},2,'gaussian',5);
        plot(x_freq(low_freq),to_plot(low_freq),'LineWidth',3,'Color',stack_colors{stack_ind});
end
for stack_ind = 1:num_stack
        to_plot=smoothdata(ppc_diffs2{stack_ind},2,'gaussian',5);
        to_plot_sem = std(ppc_diffs{stack_ind})/sqrt(size(ppc_diffs{stack_ind},1));
        errorbar(x_freq(low_freq),to_plot(low_freq),to_plot_sem(low_freq),'Color',stack_colors{stack_ind});
end
plot(x_freq(low_freq),x_freq(low_freq)*0,'k--');
legend('saccade','contra','ipsi','together','apart');
xlabel('Freq (Hz)'); ylabel('ppc');
title(sprintf([align_where2 ' both EM PRR-LIP (cross) - LIP-PRR (cross) \n  each stack (smoothing : %.2f Hz)'],freq*kernel));
ylim([-0.02 0.06]);
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_cross_PL_LP_diff2_each_stack.pdf']);


% scatterplot of PRR-LIP vs. LIP-PRR (saccade)
%figure; hold on; 
freq_of_i=17:23; 
sac_PL = ppc_sac{3}; sac_PL = mean(sac_PL(:,low_freq)');
sac_LP = ppc_sac{4}; sac_LP = mean(sac_LP(:,low_freq)');
%PL_inliers = find(sac_PL<0.2); LP_inliers = find(sac_LP<0.2); final_inliers = intersect(PL_inliers,LP_inliers);
%sac_PL = sac_PL(final_inliers); sac_LP = sac_LP(final_inliers);
scatter(sac_PL,sac_LP,'k');
scatter(median(sac_PL),median(sac_LP),'k','filled');
errorbar(median(sac_PL),median(sac_LP),std(sac_PL)/sqrt(numel(sac_PL)),'LineWidth',3,'Color','k');
errorbar(median(sac_PL),median(sac_LP),std(sac_LP)/sqrt(numel(sac_LP)),'horizontal','LineWidth',3,'Color','k');
plot(0:0.001:0.6,0:0.001:0.6,'k--');
xlabel('PRR-LIP ppc'); ylabel('LIP-PRR ppc');
xlim([0 0.2]); ylim([0 0.2]);
[rho,pval] = corr(sac_PL',sac_LP');
title(sprintf([align_where2 ' both EM saccade PRR-LIP (cross) vs. LIP-PRR (cross) \n corr:%.4f p:%.4f \n %.0fHz-%.0fHz \n n=%d'],rho,pval,...
 x_freq(freq_of_i(1)),x_freq(freq_of_i(end)),numel(sac_PL)));
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
%saveas(gcf, [align_where '_EM_both_ppc_PL_LP_sac_scatter.pdf']);

% scatterplot of PRR-LIP vs. LIP-PRR (reach)
%figure; hold on; 
freq_of_i=17:23;
reach_PL = ppc_reach{3}; reach_PL = mean(reach_PL(:,freq_of_i)');
reach_LP = ppc_reach{4}; reach_LP = mean(reach_LP(:,freq_of_i)');
%PL_inliers = find(reach_PL<0.2); LP_inliers = find(reach_LP<0.2); final_inliers = intersect(PL_inliers,LP_inliers);
%reach_PL = reach_PL(final_inliers); reach_LP = reach_LP(final_inliers);
scatter(reach_PL,reach_LP,'r');
scatter(median(reach_PL),median(reach_LP),'b','filled');
errorbar(median(reach_PL),median(reach_LP),std(reach_PL)/sqrt(numel(reach_PL)),'LineWidth',3,'Color','b');
errorbar(median(reach_PL),median(reach_LP),std(reach_LP)/sqrt(numel(reach_LP)),'horizontal','LineWidth',3,'Color','b');
plot(0:0.001:0.6,0:0.001:0.6,'r--');
xlabel('PRR-LIP ppc'); ylabel('LIP-PRR ppc');
xlim([0 0.2]); ylim([0 0.2]);
[rho,pval] = corr(reach_PL',reach_LP');
title(sprintf([align_where2 ' both EM reach PRR-LIP (cross) vs. LIP-PRR (cross) \n corr:%.4f p:%.4f \n %.0fHz-%.0fHz \n n=%d'],rho,pval,...
 x_freq(freq_of_i(1)),x_freq(freq_of_i(end)),numel(reach_PL)));
set(gcf,'units','inches'); set(gcf,'Position',[0 0 8.5 11]);
saveas(gcf, [align_where '_EM_both_ppc_PL_LP_reach_scatter.pdf']);
%saveas(gcf, [align_where '_EM_both_ppc_PL_LP_reach_scatter_inliers_only.pdf']);

% calculating std of PL and LP by stack 
freq_of_i = 16:23;

for pair_ind = 1:size(cross_LP_all_ppc{1},1)
        for stack_ind = 1:num_stack
                PL_mean_byStack(pair_ind,stack_ind) = mean(cross_PL_all_ppc{stack_ind}(pair_ind,freq_of_i));
                LP_mean_byStack(pair_ind,stack_ind) = mean(cross_LP_all_ppc{stack_ind}(pair_ind,freq_of_i));
        end
end

PL_std_byStack = std(median(PL_mean_byStack)); LP_std_byStack = std(median(LP_mean_byStack));
PL_range_byStack = range(median(PL_mean_byStack)); LP_range_byStack = range(median(LP_mean_byStack));
% PL_std_byStack: 0.0040 LP_std_byStack: 0.0019
% PL_range_byStack: 0.0129 LP_range_byStack: 0.0042

