close all; clear all; clc
addpath(genpath('/data/code/matlab'));
prepOutput;

%%%% PARAMS %%%%
dataDir = '/data/coord/tyr/15-07-13';


% Go to directory
initPath = path;
initDir  = pwd;
cd(dataDir);

% Clear temp files and run grab to generate them (run d-files)
delete('*.temp');
grabCall = 'grab -od -at2 -Xs62:66 -mc -i-450:1350 -ot500 -of5:120:5 -o19 -d1 -D2 s1001.3';
system(grabCall);
if isempty(dir('*.temp')), error('NO TEMP FILES!!'); end

% Run method 1
%addpath('/data/code/grab/2009.washu/_saves/2016-04-12/_macros/lfp/d-files/cohLFP');
addpath('/home/chuck/cohLFP');
cohLFP;
save(sprintf('%s/output/An1.mat',initDir));
movefile('CohLFPData',sprintf('%s/output/CohLFPData_1',initDir));
clearvars -except initDir initPath;
path(initPath);

% Run method 2
addpath('/data/code/grab/2009.washu/_macros/lfp/m-files/cohLFP');
cohLFP;
save(sprintf('%s/output/An2.mat',initDir));
movefile('CohLFPData',sprintf('%s/output/CohLFPData_2',initDir));
clearvars -except initDir initPath;
path(initPath);

% Go back to initDir
cd(initDir);

% Read files
A1 = load('output/An1.mat'); % A1.cohArray;  Freq x Time x Type
A2 = load('output/An2.mat'); % A2.cohSorted; Type x Freq x Time x mean/std

% Read original file
D  = readData19('/data/coord/grab/lfp-lfp/data/cohLFP/_old2/500ms_5Hz_Target/tyr/CohLFPData_1001.3_1_2');
D1 = readData19('output/CohLFPData_1');
D2 = readData19('output/CohLFPData_2');

% Plot first class
hfig = makeFig(5,4);
hold on;
plot(D.freq,mean(D.coh(:,:,1),2));
plot(D1.freq,mean(D1.coh(:,:,1),2));
plot(D2.freq,mean(D2.coh(:,:,1),2));
legend('old data','old analysis','new analysis');
print(hfig,'-depsc','-loose','output/Compare.eps');
close(hfig);
