close all; clear all; clc
addpath(genpath('/data/code/matlab'));
prepOutput;


%%%% PARAMETERS %%%%

% Database
database{1} = '/data/coord/tyr/tyrunits';
database{2} = '/data/coord/zen/zenunits';

% Data files
dataDir1 = '../data/cohLFP_TestJustPrintComplex';
dataDir2 = '../data/cohLFP/_old2/500ms_5Hz_Target';

% Display
linProp.col   = {'k','g','r','b','m'};
linProp.width = 1.5;

% Save params
save('output/params.mat');


%%%% LOAD AND SELECT DATA %%%%

% Select data
DataList1 = listLfpData(dataDir1,'CohLFPData','lfp-lfp');
DataList2 = listLfpData(dataDir2,'CohLFPData','lfp-lfp');

%%%% LOAD DATA %%%%

% Find intersection
for iData = 1:numel(DataList1)
    monkMatch  = strcmp(DataList1(iData).monk,{DataList2.monk});
    codeMatch  = strcmp(DataList1(iData).reachCode,{DataList2.reachCode});
    trodeMatch = cellfun(@(x) all(x==DataList1(iData).electrode), ...
                         {DataList2.electrode});

    nMatch(iData) = sum(monkMatch & codeMatch & trodeMatch);
end

if any(nMatch>1), error('Something matched more than once!!'); end
DataList = DataList1(nMatch==1);

% Load data
Data1 = loadLfpData(dataDir1,DataList,19);
Data2 = loadLfpData(dataDir2,DataList,19);

% Get mean ppc array
for iData = 1:length(Data1)
    cohAll1(:,:,iData) = mean(Data1(iData).coh,2);
    cohAll2(:,:,iData) = mean(Data2(iData).coh,2);
end
cohMean1  = mean(cohAll1,3);
cohMean2  = mean(cohAll2,3);

% Extract time and freq - verify they match across sites.
freq = Data1(1).freq;

% Make figure. Define a constant
lineProp.col   = {'k','g','r','b','m'};
lineProp.width = 2;

% Plot coh
hfig = makeFig(5,7);
subplot(211);
mseb(freq,cohMean1.',zeros(size(cohMean1.')),lineProp);
set(gca,'XScale','log','YScale','log');
xlim(freq([1,end]));
xlabel('Freq (Hz)');
ylabel('Coherence');
subplot(212);
mseb(freq,cohMean2.',zeros(size(cohMean2.')),lineProp);
set(gca,'XScale','log','YScale','log');
xlim(freq([1,end]));
xlabel('Freq (Hz)');
ylabel('Coherence');
print(hfig,'-dtiff','output/Coh.tiff');
print(hfig,'-depsc','-loose','output/Coh.eps');
close(hfig);
