close all; clear all; clc
addpath(genpath('/data/code/matlab'));
prepOutput;


%%%% PARAMETERS %%%%

% Database
database{1} = '/data/coord/tyr/tyrunits';
database{2} = '/data/coord/zen/zenunits';

% Data files
dataDir  = '../data/cohLFP_TestJustPrintReal/500ms_5Hz_Target_-450:1000ms';
dataDir2 = '../data/cohLFP/_old2/500ms_5Hz_Target';

% Display
linProp.col   = {'k','g','r','b','m'};
linProp.width = 2;

% Save params
save('output/params.mat');


%%%% LOAD AND SELECT DATA %%%%

% Select data
DataList   = listLfpData(dataDir,'CohLFPData','lfp-lfp');
DataList2  = listLfpData(dataDir2,'CohLFPData','lfp-lfp');
return

%%%% LOAD DATA %%%%

% Load data
Data = loadLfpData(dataDir,DataList,19);

% Get mean ppc array
for iData = 1:length(Data)
    cohAll(:,:,iData)  = mean(Data(iData).coh,2);
end
cohMean  = mean(cohAll,3);
cohErr   = 0*sem(cohAll,3); 

% Extract time and freq - verify they match across sites.
freq = Data(1).freq;

% Make figure. Define a constant
lineProp.col   = {'k','g','r','b','m'};
lineProp.width = 2;

% Plot coh
hfig = makeFig(5,4);
mseb(freq,cohMean.',cohErr.',lineProp);
set(gca,'XScale','log','YScale','log');
xlim(freq([1,end]));
xlabel('Freq (Hz)');
ylabel('Coherence');
print(hfig,'-dtiff','output/Coh.tiff');
print(hfig,'-depsc','-loose','output/Coh.eps');
close(hfig);
