clear all; close all; clc
addpath(genpath('/data/code/matlab'));

% error('to here')

% /usr/local/MATLAB/R2018a/bin/matlab -nodisplay -nosplash -r RunMacro19
% nohup /usr/local/MATLAB/R2018a/bin/matlab -nodisplay -nosplash < RunMacro19.m >&! out.1 &

CHRONUX = 0		% Use 0/1, NOT T/F
CROSSED = 0
SPLIT_UP = 0		% [0]  Break up the file into chunks? (For lesions)
		%      If too few trials, may have to remove those files by hand
monk = 'tyr'

% SELECT DATABASE
 database = sprintf('/data/coord/MONK/MONKunits');
% database = sprintf('/data/coord/MONK/MONKunits_memory');
% database = sprintf('/data/coord/MONK/MONKunits_cc_inactivate');
% database = sprintf('/data/coord/MONK/MONKunits_cc_control');
% database = sprintf('/data/coord/MONK/MONKunits_memory_cc_inactivate');
% database = sprintf('/data/coord/MONK/MONKunits_memory_cc_control');
%  appends 'cc' or 'ccc' automatically to output{3}


%%%% PARAMS %%%%
% Grab args
%   Sets of params to combine. 1st param should be a string, all others cell
% arrays of strings. The script runs grab on all combinations of arguments.
% Put generic grab arguments in args{1} (these will be used in each call).

% Outputs
%   These define output directories for each grab run. output{1} is the top
% level output directory. If output is only 1 element, then all data goes in
% that directory. If there are more elements, then the elements of output{2:end}
% are combined to be sub-directories in output{1}. arg{i} and ouput{i} should
% have the same number of elements for any i > 1.

% Go-align should end at 350 (or earlier) to catch as many as possible
% targ-align should start at -500 (no earlier) - maximize initial interval


args{1} = 'grab -o19';		%  -x1:48';

% CLASSES
if (CROSSED == 1)
   args{1} = strcat(args{1}, ...
   		' -mc10,1,2,8 -mc11,4:6 -xc1:8 ');
else
   args{1} = strcat(args{1}, ' -mc ');
end

% STACKS
args{1} = strcat(args{1}, ' -Xs62:96 -xs67:75 -xs77:91 -ms66,76 ');

% Other options:
%	'grab -o19 -mc10,7 -mc11,3 -xc1:8 -Xs62:66'		% UD
%	'grab -o19 -Xs62:66 -ms63:66 -mc' 	% merge all but sacs ("_all")
		% preserving 2 stacks (vs 1) makes code much easier to use!

args{2} = 	 { '-ot400 -of6:120:2' };
%  append " -oe1" for "NoE"
% {	'-ot100 -of6:120:2' };
% {	'-ot200 -of6:120:2' };
% {	'-ot300 -of6:120:2' };
% {	'-ot400 -of6:120:2' };
% {	'-ot500 -of6:120:2' };
% {	'-ot600 -of6:120:2' };
% { 	'-ot400 -of6:240:2' };
args{3} = {	'-at2 -i-450:1350' };  % 400
% {	'-abt1 -i-1200:500'  '-at2 -i-500:1300'	};  % 100 ms
% {	'-abt1 -i-1200:300', '-at2 -i-500:1300' };  % 200 ms   (was 1200:500)
% {	'-abt1 -i-1150:350', '-at2 -i-500:1300' };  % 300 ms
% {	'-abt1 -i-1150:350', '-at2 -i-450:1350' };  % 400
% {	'-abt1 -i-1000:250', '-at2 -i-500:1250' };  % 500
%                                     why not -500:1300 ?
% {	'-abt1 -i-1200:450', '-at2 -i-450:1200' };  % 600   % 300 --> 450

output{1} = '/data/coord/grab/lfp-lfp/data/cohLFP';
if (CROSSED == 1)
   output{1} = strcat(output{1},'.RL');
end
if (CHRONUX == 1)
   output{1} = strcat(output{1},'.chronux');
end

output{2} = { '400ms_2Hz' };
% {	'100ms_2Hz' };
% {	'200ms_2Hz' };
% {	'300ms_2Hz' };
% {	'400ms_2Hz' };
% {	'500ms_2Hz' };
% {	'600ms_2Hz' };
output{3} = { 'Target_-450:1350ms' };
%   					append "_NoE" and/or "_cc"
% {     'Target_-500:1300ms_NoE' };			% exclude evoked
% {	'GoCue_-1200:500ms', 'Target_-500:1300ms' };	% 100 ms
% {	'GoCue_-1200:300ms', 'Target_-500:1300ms' };	% 200 ms (was -1200:500)
% {	'GoCue_-1150:350ms', 'Target_-500:1300ms' };	% 300 ms
% {	'GoCue_-1150:350ms', 'Target_-450:1350ms' };	% 400 ms
% {	'GoCue_-1000:250ms', 'Target_-500:1250ms' };	% 500 ms
% {	'GoCue_-1200:450ms', 'Target_-450:1200ms' };	% 600 ms

% {	'GoCue_-1150:350ms_UD', 'Target_-450:1350ms_UD' };	% UD

                
if strcmp(database, '/data/coord/MONK/MONKunits_cc_inactivate') == 1
	output{3}=strcat(output{3},'_cc');
end
if strcmp(database, '/data/coord/MONK/MONKunits_cc_control') == 1
   output{3}=strcat(output{3},'_ccc');
end

if strcmp(database, '/data/coord/MONK/MONKunits_memory_cc_inactivate') == 1
	output{3}=strcat(output{3},'_memory_cc');
end
if strcmp(database, '/data/coord/MONK/MONKunits_memory_cc_control') == 1
   output{3}=strcat(output{3},'_memory_ccc');
end
if (CHRONUX == 1)
   args{1}=strcat(args{1},' -oC1');
end
if (SPLIT_UP)
   args{1}   = sprintf("%s -X%d:%d", ...
   			args{1}, 51+(SPLIT_UP-1)*150, 50+SPLIT_UP*150);
   output{3} = strcat(output{3}, '_split', num2str(SPLIT_UP));
end


%%%% PROCEDURE %%%%

% Get monk
% monk     = input('Monk: ','s');
database = regexprep(database,'MONK',monk);

% Check args and outputs match
if ~numel(args(2:end))==numel(output(2:end)) || ...
        ~all(cellfun(@(x,y) numel(x)==numel(y),args(2:end),output(2:end)))
    error('Mismatch of args and outputs!!');
end 

% Generate grab calls and outputs
if numel(args)>1
    grabBatch   = strcat(args{1},{' '},strCombos(args(2:end),' '));
    outputBatch = strcat(output{1},'/',strCombos(output(2:end),'_'),'/',monk);
else
    grabBatch   = args;
    outputBatch = strcat(output,'/',monk);
end

% Select Data
DataList   = selectDataFromDatabase(database,'lfp-lfp','coord');
SiteParams = listSiteParams(DataList,database,'coord');

% Loop through each batch
for iBatch = 1:numel(grabBatch)

    % Get this loop's output and grab call
    grabArgs  = grabBatch{iBatch};
    outputDir = outputBatch{iBatch};


    % Initial setup
    initDir  = pwd;                 % Remember initial dir.
    prepOutput(outputDir);          % Set up output directory.
    diary([outputDir,'/.diary'])    % Start diary.

    % Iterate through all unique files
    timerVal = tic;    % Start a timer.
    isSucc   = false(size(DataList));
    for iData = 1:length(DataList)

        % CD into target directory
        cd(DataList(iData).dataDir);

        % Define some iterative variables.
        dataFile   = sprintf('data_%s_%u_%u',        ...
                             DataList(iData).reachCode,    ...
                             DataList(iData).electrode(1), ...
                             DataList(iData).electrode(2));
        channelOpt = sprintf('-d%u -D%u',DataList(iData).electrode(1), ...
                                         DataList(iData).electrode(2));
        reachFile  = sprintf('s%s',DataList(iData).reachCode);
       
        % Hemisphere argument. Sort L/R by PRR, then LIP, then "undefined area".
        %   If both sites have the same area, then use the left hemisphere.
        hemiTemp = arrayfun(@(x) x.hemisphere,SiteParams(:,iData),'Un',0);
        if ~all(ismember(hemiTemp,{'L','LL','R','RR'}))
            error('Unknown hemisphere value!!');
        end
        hemi = cellfun(@(x) x(1)=='R',hemiTemp);
        area = zeros(1,2);
        area(strcmp({SiteParams(:,iData).area},'PRR')) = 1;
        area(strcmp({SiteParams(:,iData).area},'LIP')) = 2;
        if hemi(1)==hemi(2)
            hemiOpt = sprintf('-oh%u',hemi(1));
        elseif area(1)==area(2)
            hemiOpt = '-oh0';
        else
            [~,idxBestArea] = min(area);
            hemiOpt = sprintf('-oh%u',hemi(idxBestArea));
        end
            
	% Uncomment to print the command for the 1st cell
        % error(strjoin({grabArgs,hemiOpt,channelOpt,reachFile}))  % DIAG

        % Remove stale data file from target directory.
        if exist(dataFile)
            delete(dataFile); 
        end
        
        % Run grab
        grabCmd = strjoin({grabArgs,hemiOpt,channelOpt,reachFile});
        % grabCmd = strjoin({grabArgs,' -od ', hemiOpt,channelOpt,reachFile});
        disp(grabCmd);
        system(grabCmd);

        % Move file
        if exist(dataFile) 
            status = movefile(dataFile,outputDir);
            isSucc(iData) = status;
        else
            warning('No data file to move!!!'); 
        end
    end
    toc(timerVal)         % Clock time
    cd(initDir);

    % Report number of errs
    writeDataList(DataList(~isSucc),[outputDir,'/.ErrorList'],'lfp');
    nSucc(iBatch) = sum(isSucc);
end

% Output final errors
for iBatch = 1:numel(grabBatch)
    disp(sprintf('Batch %u: %u/%u files generated correctly.', ...
         iBatch,nSucc(iBatch),numel(DataList)));
end
