# lineplot.r

LINES   =  T		# Solid line to show mean
RIBBONS =  T		# Ribbon of +/- 1 SEM (can have both)

# Plots = list(24:32, 38:42, 90:110)	# Name ALL frequencies; it'll handle it
Plots = list(24:36, 70:120)

PRINT_FIGURE_DATA = T

if (CC_INACT) stop("Not written\n")

# Pull out just the recorded frequencies
# Plots = lapply(Plots, function(x) BANDS.SEQ[BANDS.SEQ %in% x])
# Pull out just the indices of the recorded frequencies
Plots = lapply(Plots, function(x) which(BANDS.SEQ %in% x))


# MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4))  # ReadAll.r
S_MAP = c("gray30", "green", "red", "blue", "purple",	# stack map
	  "orange")				# If SacSplit!

Transparent<-function(someColor, alpha=100) {
   newColor<-col2rgb(someColor)
   apply(newColor, 2, 
	  function(curcoldata) {
		  rgb(red=curcoldata[1], 
		  green=curcoldata[2],
		  blue=curcoldata[3],
		  alpha=alpha*255,
		  maxColorValue=255)
	  	  })
   }
T_MAP = Transparent(S_MAP, .2)

LEFT  <<- ifelse(ALIGN=="GoCue", MsToX(-500), 1)
RIGHT <<- times

if (PRINT_FIGURE_DATA) {
   sink("Data.txt")
   sink("FigureS4_Data.txt")
   print("Raw data dimensions:")
   print(dimnames(data))
   print("Times (values not part of the data structure so added here):")
   print(paste(XtoMs(LEFT:RIGHT)))
   print("Data:")
   print(apply(data[LEFT:RIGHT,,,], 1:3, mean, na.rm=T))
   sink()
   }

# Average over all cells!	# time, bands, (classes), stacks, units
stderr = sqrt(apply(data, c(1,2,3), var,  na.rm=T) / length(files))
data   =      apply(data, c(1,2,3), mean, na.rm=T) 
				# Leaves time, band, stacks

# Avg over unimanuals - put in stack 3 (ONLY if LIP-LIP & PRR-PRR; not crosses!)
if ((STACKS>2) && (classes==1) && (AREA == "LIP" || AREA == "PRR")) {
   data[,,3] = (data[,,2] + data[,,3]) / 2
   data[,,2] = NA
   }

# Set up the plot
par(mfrow=c(length(Plots),1), las=1, mar=c(1.5,6,0,4)+.1)

for (p in 1:length(Plots)) {
   hz = Plots[[p]]
   Range = range(c(data[,hz,]), na.rm=T)
   plot(0,0, xlim=c(LEFT,RIGHT), ylim=Range,
		axes=F, xlab="",ylab="",bty='n',type='n', lwd=2)

   axis(2) # , at=c(.5,1,1.5), labels=c("-50%", "", "+50%"), cex.axis=1.5)
   axis(1, at=LEFT:RIGHT, labels= F)

   segments(MsToX.float(0),    par()$usr[3],
	    MsToX.float(0),    mean(par()$usr[3:4], na.rm=T), lwd=3, xpd=F)
   segments(MsToX.float(1310), par()$usr[3],
	    MsToX.float(1310), mean(par()$usr[3:4], na.rm=T), lwd=3, xpd=F)

   if (RIBBONS)
   for (st in c(1:STACKS)) {
      if (st<4) next				# Just the last three
      plus = (data+stderr)[LEFT:RIGHT,hz,st]
      minus= (data-stderr)[LEFT:RIGHT,hz,st]
      if (length(hz) > 1) {
	  plus  = rowMeans(plus, na.rm=T)
	  minus = rowMeans(minus, na.rm=T)
          }
      polygon(c(LEFT:RIGHT, RIGHT:LEFT),
	      c(plus, rev(minus)),
	      density=-1, border=ifelse(LINES,0,S_MAP[st]), col=T_MAP[st],lwd=2)
      }
   if (LINES)
    for (st in (1:STACKS))
      lines(LEFT:RIGHT, 
	    if (length(hz)==1) data[LEFT:RIGHT,hz,st] else 
		      rowMeans(data[LEFT:RIGHT,hz,st],na.rm=T),
	    col=S_MAP[st], lwd=4)

   title(main= paste("\n\n\n  ",paste(BANDS.SEQ[hz],collapse=" "), "Hz"), 
				col.main="red", adj=0, cex=1)

   if (p == 1) {
      text(    MsToX(30),   par()$usr[3]+.07, "Target", adj=0, cex=1)
      text(    MsToX(1270), par()$usr[3]+.07, "Go cue", adj=1, cex=1)
      }
   }

mtext(paste(Call, MONK,
            if (NEAR.OVERRIDE) paste0("+", NEAR.OVERRIDE),
	    gsub("_", " ", Details),
	    # if (SUBTRACT.BASE) "- base",
       	    AREA.OVERRIDE
	    ),
      side=3, outer=T, line=0.6, cex=1.3, adj=0)

title( xlab=paste(
   "Time (ms) re:", ifelse(ALIGN=="GoCue","Go cue","target onset")),
   cex.sub=1.5, cex.lab=1.5)

axis(1, at=LEFT:RIGHT, labels=XtoMs(LEFT:RIGHT), cex.axis=1.5)

for (i in 1:STACKS)
   mtext(paste(61+i,
	    c("Saccade", "Ipsi arm", "Contra arm", "Same", "Apart"))[i],
	 side=3, line=-i*1.2, outer=T, at=.87, adj=0, col=S_MAP[i])

mtext(paste(length(files), "units"), side=1, line=1.7, outer=T, adj=0.1, cex=1)
mtext(paste(command, collapse=" "),  side=1, line=2, outer=T, adj=.95, cex=.6)
