# VsFreq.r
#   If 'SUBTRACT.BASE' is true, then save the base (target align) and
#   subtract it from cue align.

LO_FREQ =  18				# [18, 16, 12,  8]  (short intvl: 18?)
HI_FREQ =  100				# [100,100,50] (movement period:120)

LO_NOTCH = 57 			# [56-7]  if SUBTRACT.BASE: 56   if 200 ms: 46
HI_NOTCH = 62 			# [64-2]  if SUBTRACT.BASE: 64   if 200 ms: 72
MELD_ALL = F			#       Combine 63 & 64 even for cross

LOWESS = 0.1 		# [0.1] [0.001] Issues w/ NA near notch, lose some SE
			# Stats are computed BEFORE lowess is applied

SHOW.SIGNIF =		# [T] signif stars for PRR and LIP on plot?
PRINT.MEANS = T		# [T]  (make SHOW.SIGNIF = PRINT.MEANS!)
RAW.DATA.SEM = T	# [T] set to print just 'apart' SEM now
MEAN.RAW.DATA.SEM = F	# [T]  (see what data to exclude - give just 1 cell)
ONLY.BIMANUAL = F	# [F] Just show together and apart?
KEEP.DATA = T		# [ ] So can plot 'off-line'
PRINT_FIGURE_DATA = T

verbose = F

# Frequencies for stats - relative to LO_FREQ !!
FreqList = 				# 2-7 = 20-30 Hz  (4-6 is best 3-band)
  	# list(2:7, 3:8, 4:6)			# Multiple ranges 
  	# 1:12					# Each freq, separately
  	# list(3:8)				# Best 6-bands in orig (zen)
	# list(4:6)				# 24 - 28 (sig for zen)
	# list(4:8)				# 24 - 32 (zen, with '+' sig)
	list(4:10)				# 24 - 36 (sig for tyr)
	# list(5:7)				# 26-30 best 3 bands in tyr orig


T.test = function(...) {
	if (files[1] == files[2])
           return(list(p.value=NA))
	else
	   return(t.test(...))
	}
	

if (COLLAPSE) {
    SHOW.SIGNIF = F
    }

# Go to nearest band (complex for chronux!)
BandIndex = function(x, higher=T) {
	nears = abs(x-BANDS.SEQ)
	near = match(min(nears)[1], nears)
	if (higher)
	   return(max(near))
	return(min(near))
	}

LO_FREQ = BANDS.SEQ[BandIndex(LO_FREQ, higher=F)]
HI_FREQ = BANDS.SEQ[BandIndex(HI_FREQ, higher=T)]

# MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4))  # ReadAll.r
S_MAP = c("gray30", "green", "red", "blue", "purple",	# stack map
	  "orange")				# If SacSplit!

LEFT  <<- ifelse(exists("START.TIME"),
	   MsToX(START.TIME + WINDOW/2),
           max(1, MsToX(ifelse(ALIGN=="GoCue", -1000+WINDOW/2,  600))))  # std
RIGHT <<- ifelse(exists("END.TIME"),
	   MsToX(END.TIME - WINDOW/2),
	   MsToX(ifelse(ALIGN=="GoCue",   100-WINDOW/2, 1000)))  # std

if (verbose) {
   cat(paste0("Index: ", LEFT, " (", XtoMs(LEFT), ")"))
   if (LEFT != RIGHT)
       cat(paste0(" to ", RIGHT, " (", XtoMs(RIGHT), ")"))
   cat("\n")
   }


# Baseline: use target aligned and just the first interval or two
if ((SUBTRACT.BASE || SAVE.BASE) && SUBTRACT.PASS==1 && ALIGN=="Target") {
   LEFT = 1		# First bin
   RIGHT = 8		# Last bin

   while (XtoMs(RIGHT) + WINDOW/2 > 0)		# edge of last bin > 0 ?
       RIGHT = RIGHT - 1
   if (RIGHT < 1)  {
      cat("Cannot fit a baseline bin !!! -- use just first data point\n")
      RIGHT = 1
      }
   if (verbose)
     cat("Base interval is bin ", LEFT, " to ", RIGHT,
	" (",
	XtoMs(LEFT) - WINDOW/2,
	" ",
	XtoMs(LEFT) + WINDOW/2,
	") to (",
	XtoMs(RIGHT) - WINDOW/2,
	" ",
	XtoMs(RIGHT) + WINDOW/2,
	") ms\n", sep="")
   }

# Want to be able to use 'apply' even with the first index is one value
TimeRange = if (LEFT == RIGHT) LEFT else LEFT:RIGHT
Adjust = if (LEFT == RIGHT) 1 else 0

# If you ask for more time than you have:
if (max(TimeRange) > max(dim(data)[1])) {
   cat("Time too long; dropping from", TimeRange)
   TimeRange = TimeRange[ TimeRange <= max(dim(data)[1]) ]
   cat("to ", TimeRange, "-- name will be wrong!\n")
   }

if (COLLAPSE) {			# Average all together! (baseline)
   Means = apply(data[TimeRange,,,], 2-Adjust, mean, na.rm=T)
	# times, bands, stacks, units --> leave just bands

   Temp = apply(data[TimeRange,,,], c(2,4)-Adjust, mean, na.rm=T) 	
	# bands x units (if TimeRange is 1 value, keep dims 1:3)

   SEMs = Temp[,1]		# Size: of one unit (freq bins x files)
   for (row in 1:dim(Temp)[1])	# For each freq bin
     SEMs[row] = sqrt(var(Temp[row,]) / length(files))
   
   # Now make them look like the non-collapsed versions (add stacks dimension)
   Means = array(Means, dim=c(length(Means),1))
   SEMs  = array(SEMs,  dim=c(length(SEMs), 1))
   STACKS = 1
 } else {
   if (KEEP.DATA) {		# For cell by cell data (for lesions)
      KeepMeansIndi = apply(data[TimeRange,
			         BandIndex(LO_FREQ,F) + FreqList[[1]] - 1,,], 
 				 c(3,4)-Adjust, mean, na.rm=T)
      colnames(KeepMeansIndi) = 
	      sub("[-a-zA-Z0-9_:/]*data_", "", colnames(KeepMeansIndi))
      if (STACKS == 3)
         rownames(KeepMeansIndi) = c(62,64,65)
      if (CC_INACT) {
	 assign(paste0("KeepMeansIndi.", ifelse(INACT_TIME==-1, "pre", "per")),
		        KeepMeansIndi)
	 rm(KeepMeansIndi)
	 }
      }
   # Average over all site-pairs!	# times, bands, stacks, units/site-pairs
   Means = apply(data[TimeRange,,,], c(2,3)-Adjust, mean, na.rm=T)

   if (PRINT_FIGURE_DATA) {
      sink("Data.txt")
      print(apply(data[TimeRange,,,], 1:3, mean, na.rm=T))
      sink()
      }
						# Leaves band, stacks
   # Avg over unimanuals - put in stack 3 (ONLY LIP-LIP & PRR-PRR, not crosses!)
   if ((STACKS > 3) & (COLLAPSE==F) & 
       (MELD_ALL | (classes==1) & (AREA=="LIP" | AREA=="PRR"))) {
      Means[,3] = rowMeans(cbind(Means[,2], Means[,3]))
      Means[,2] = NA
      }
    
   # Get signif differences
   if ((STACKS > 2) & (COLLAPSE==F) & 
       ((MELD_ALL | (classes==1)))) { # & (AREA=="LIP" | AREA=="PRR"))) {
      tempdata = data
      if (length(TimeRange) > 1) {
         tempdata = apply(tempdata, 2:4, mean)	# merge over time points
       } else
         tempdata = tempdata[TimeRange,,,]
      						# Make it easier to handle
      if (STACKS > 3)
         UnisD = apply(tempdata[,2:3,], c(1,3), mean)	# merge 63 & 64 (avg)
      	   # Need one entry per site for paired t-test, so average (not concat)
      BothD = tempdata[,STACKS-1,]			# 65
      AwayD = tempdata[,STACKS,]			# 66 bands x site-pairs
      SacD  = tempdata[,1,]				# 62

      dimnames(tempdata)[[3]] = NULL 	# strip (long!) filenames
      if (STACKS != 3)
         dimnames(UnisD)   [[2]] = NULL	# easier to read when doing Diags
      dimnames(BothD)   [[2]] = NULL	# can comment these out or leave in
      dimnames(AwayD)   [[2]] = NULL	#
      dimnames(SacD)    [[2]] = NULL	#
      SigBothVsUnis = SigAwayVsUnis = SigBothVsAway = SigBothVsSac = NULL
      for (freqi in 1:dim(BothD)[1]) {
         if (STACKS != 3) {
            SigBothVsUnis = c(SigBothVsUnis, 
			   T.test(UnisD[freqi,],BothD[freqi,],pair=T)$p.value)
            SigAwayVsUnis = c(SigAwayVsUnis,
			   T.test(UnisD[freqi,],AwayD[freqi,],pair=T)$p.value)
	    }
         SigBothVsAway = c(SigBothVsAway,
			   T.test(AwayD[freqi,],BothD[freqi,],pair=T)$p.value)
         SigBothVsSac  = c(SigBothVsSac,
			   T.test(SacD[freqi,],BothD[freqi,],pair=T)$p.value)
         }
      if (STACKS != 3)
	 rm(UnisD)
      rm(BothD,AwayD,SacD,tempdata)
      }

   # Get the error bars:
   # FAILS: sqrt(apply(data[TimeRange,,,],2:3-Adjust,var,na.rm=T)/length(files))
   Temp = apply(data[TimeRange,,,], (2:4)-Adjust, mean, na.rm=T) 	
	# bands x stacks x units (if TimeRange is 1 value, keep dims 1:3)
   SEMs = Temp[,,1]		# Size: of one unit (freq bins x stacks x files)
   for (row in 1:dim(Temp)[1])	# For each freq bin
     for (col in 1:dim(Temp)[2])	#  For each stack
        SEMs[row,col] = sqrt(var(Temp[row,col,]) / length(files))
   }

BandIndices = function(lo, hi) {
	return(BandIndex(lo,higher=F) : BandIndex(hi,higher=T))
	}

# Remove stuff around 60 Hz
NOTCH_INDICES = BandIndices(LO_NOTCH,HI_NOTCH)
if (!SAVE.BASE)
   Means[NOTCH_INDICES,] = NA
if (COLLAPSE==F) {
   SigBothVsUnis[NOTCH_INDICES] = 1		# ignore the notch (non-sig)
   SigAwayVsUnis[NOTCH_INDICES] = 1		# could do NA, but will choke
   SigBothVsAway[NOTCH_INDICES] = 1
   SigBothVsSac [NOTCH_INDICES] = 1
   }

# Select the freqs you want:
KEEP_INDICES = BandIndices(LO_FREQ,HI_FREQ)
Means = Means[KEEP_INDICES,,drop=F]
SEMs =  SEMs [KEEP_INDICES,,drop=F]
x = BANDS.SEQ[BandIndex(LO_FREQ) : BandIndex(HI_FREQ)]

if (COLLAPSE == F) {
   SigBothVsUnis = SigBothVsUnis[KEEP_INDICES]
   SigAwayVsUnis = SigAwayVsUnis[KEEP_INDICES]
   SigBothVsAway = SigBothVsAway[KEEP_INDICES]
   SigBothVsSac  = SigBothVsSac [KEEP_INDICES]
   }


# TWO CASES IN WHICH YOU DO NOT PLOT - JUST SET THE BASE AND EXIT
if (SAVE.BASE) {
   if (ALIGN != "Target" || SUBTRACT.BASE)	# Expect targ align, !subtract
      stop("Problem here!")
   assign(paste("SavedBase",AREA,MONK,sep="."), Means, pos=1)
   assign(paste("SavedBaseID",AREA,MONK,sep="."), 
	  c(length(files),				# file count
   	     strsplit(DETAILS.OVERRIDE,"_")[[1]][1:2]),	# window,freq sampling
	  pos=1)
 } else
if (SUBTRACT.BASE & ALIGN=="Target" & SUBTRACT.PASS==1) {
   Base = Means					# Save base
 } else {  					# continue with plotting

# IN THESE CASES, YOU PLOT:
if (SUBTRACT.BASE & ALIGN=="GoCue" & SUBTRACT.PASS==1) { # Can only be pass==1
   if (!all(get(paste("SavedBaseID",AREA,MONK,sep="."))[2:3] ==
   	     strsplit(DETAILS.OVERRIDE,"_")[[1]][1:2]))
       stop("Mismatch of saved base window size or freq sampling")
   if (!all(get(paste("SavedBaseID",AREA,MONK,sep="."))[1] == length(files))) {
       warning("Mismatch in number of files used")
       cat("   Saved:   ", get(paste("SavedBaseID",AREA,MONK,sep="."))[1], "\n",
	   "  Now have:", length(files), "\n")
       }
   Base = get(paste("SavedBase",AREA,MONK,sep="."), pos=1)
   }

if (SUBTRACT.BASE) {		# If gocue, is pass 1; if target, is pass 2
   if (dim(Base)[2]==1) {	# N x 1 matrix; make it N x 5 (5 stacks)
      Base = drop(Base)
      Base = cbind(Base,Base,Base,Base,Base)
      }
   Means = Means - Base		# (gocue has no pass 2; target pass 1 is above)
   }

plot(0,0, xlim=c(LO_FREQ-3, HI_FREQ), xlab="", ylab="",
	ylim= if (SUBTRACT.BASE) c(-.08, .1) else 
	      if (CC_INACT) c(0.02,.4/(EXPAND_YLIM+1)) else
	      if (EXPAND_YLIM) c(.1,.25) else 
	      if (HI_FREQ > 140) c(.09,.40) else c(.09,.35),
	type='n', bty='n', axes=F)

if (SUBTRACT.BASE)
   segments(LO_FREQ, 0, HI_FREQ, 0, lty=1)

if (!exists("OVERRIDE")) {
   title(main=paste(MONK, AREA, 
		     if (NEAR) paste0("+", NEAR), 
		     ALIGN, "  n=", length(files),
	             if (CC_INACT) 
   		       switch((2+INACT_TIME),
			   "PRE-INACT","PERI-INACT", "POST-INACT", "PRE+POST"),
	             if (CC_INACT==2) "control"))
 } else
   title(main=paste(AREA,
		    "  n=", length(files),
	            if (CC_INACT) 
   		       switch((2+INACT_TIME),
			   "PRE-INACT","PERI-INACT", "POST-INACT", "PRE+POST"),
	             if (CC_INACT==2) "control"))

if (STACKS != 5) {
   if (STACKS == 3) {
      Means = cbind("62"=Means[,1], NA, NA, Means[,2:3])# sac, NA,NA, both, apart
      SEMs  = cbind(SEMs [,1], NA, NA, SEMs [,2:3])   # sac,uni,uni,both, apart
    } else {
      cat("Need to configure for", STACKS, "stacks\n")
      }
   }


if (PRINT.MEANS) {

  for (Freqs in FreqList) {
     if (COLLAPSE) {
         cat("Mean collapsed (", 
 	     range(seq(LO_FREQ,HI_FREQ, by=2)[Freqs]), " Hz):  ",
	     round(mean(Means[Freqs]), dig=3), "\n")
         next
	 }
     cat(sprintf(
       " Means [sac,uni,both,apart,diff] %2d-%2d Hz:  %.3f  %.3f  %.3f  %.3f  %.3f\n", 
 	round(min(seq(LO_FREQ,HI_FREQ, by=2)[Freqs])),
 	round(max(seq(LO_FREQ,HI_FREQ, by=2)[Freqs])),
        mean(Means[Freqs, 1]),
        mean(Means[Freqs, 3]),
        mean(Means[Freqs, 4]),
        mean(Means[Freqs, 5]),
        mean(Means[Freqs,4]-Means[Freqs,5])))
     if (RAW.DATA.SEM)
         cat(paste("  SEM:\t\t\t\t\t  ",
	     round(mean(SEMs[Freqs, 1]), dig=3),
	     round(mean(SEMs[Freqs, 3]), dig=3),
	     round(mean(SEMs[Freqs, 4]), dig=3),
	     round(mean(SEMs[Freqs, 5]), dig=3), "\n", sep="  "))
     if (MEAN.RAW.DATA.SEM)
         cat(paste("Mean SEM \t\t", 
	     round(mean(SEMs[Freqs, 1:5]), dig=4),
	     round(mean(SEMs[Freqs, 4:5]), dig=4), "\n", sep="  "))

     if (CC_INACT != 0 && SEM_OF_PRE_PERI_EFFECT && (length(FreqList)==1)) {
	     		# Have to make the code smarter if FreqList > 1
      if (Adjust == 0)
	   stop("Must rewrite to work -- apply now gets an extra dimension")

      if ((INACT_TIME != 1) && COLLAPSE==F) {	# Not 'post'
	BothByFile  = apply(data[TimeRange,
					BandIndices(LO_FREQ,HI_FREQ)[Freqs],
					STACKS-1,
					], 2, mean, na.rm=T) 	
	AwayByFile  = apply(data[TimeRange,
					BandIndices(LO_FREQ,HI_FREQ)[Freqs],
					STACKS,
					], 2, mean, na.rm=T) 	
         if (abs(mean(Means[Freqs, 4]) - mean(BothByFile)) > .0005)
	    cat("means are not equal! (1)", 
			mean(Means[Freqs,4]), BothByFile, "\n")

         if (abs(mean(Means[Freqs, 5]) - mean(AwayByFile)) > .0005)
	    cat("means are not equal! (2)", 
			mean(Means[Freqs,5]), AwayByFile, "\n")
	if (INACT_TIME == -1 || INACT_TIME == 2) {	# Pre or Pre+Post
	   BothByFile.pre = BothByFile		# save for later
	   AwayByFile.pre = AwayByFile		# save for later
	   if (INACT_TIME == 2) {		# Fold data so can do SEMs
	      Length = length(BothByFile.pre)/2
	      BothByFile.pre = 
	           (BothByFile.pre[1:Length]+BothByFile.pre[-(1:Length)])/2
	      Length = length(AwayByFile.pre)/2
	      AwayByFile.pre = 
	           (AwayByFile.pre[1:Length]+AwayByFile.pre[-(1:Length)])/2
	      rm(Length)
	      }
	 } else {
	   if (length(BothByFile) != length(BothByFile.pre))
	      stop("Cannot do SEM -- diff number of files for paired compare")
           # cat(sprintf(" SEMs for  both,apart,diff %27.3f  %.3f  %.3f\n",
           cat(sprintf(" SEMs                      %36.3f  %.3f  %.3f\n",
	       SEM(BothByFile - BothByFile.pre),
	       SEM(AwayByFile - AwayByFile.pre),
	       SEM((BothByFile-AwayByFile) - 
			             (BothByFile.pre-AwayByFile.pre))))
           cat(sprintf(" Pvals:  %54.3f  %.3f  %.4f\n",
	         T.test( BothByFile - BothByFile.pre)$p.value,
	         T.test( AwayByFile - AwayByFile.pre)$p.value,
	         T.test((BothByFile - AwayByFile) -
			(BothByFile.pre -AwayByFile.pre))$p.value))
	   rm(BothByFile.pre, AwayByFile.pre)
           }
	}
      rm(AwayByFile, BothByFile)
      }
     }
  # rm(Freqs)			Use once more below, if length(list) = 1
  }


for (i in (if (STACKS==3) c(5,4,1) else STACKS:1)) {
   if (LOWESS > 0.01)		# If using 'keep', smooth even if not plotting
      Means[,i] = lowess(x, Means[,i], f=LOWESS)$y
   if (KEEP.DATA) {			# For pooled data (across cells)
	KeepX = x
        KeepMeans = Means
	KeepSEMs  = SEMs
   	}

   if (ONLY.BIMANUAL & (i < 4))
      next
   if (SKIP_SACCADE_LINE & (i==1))
      next

   lines(x, Means[,i], col=S_MAP[i], lwd=ifelse(i==4||i==5, 4, 2))
   if (COLLAPSE==T || i==4 || i==5 || SUBTRACT.BASE)		# Error bars
      segments(x, Means[,i]+SEMs[,i],
	       x, Means[,i]-SEMs[,i], col=S_MAP[i], lwd=0.7)
   if (SUBTRACT.BASE)			# Warning: only approximate stars!
      text(x, 0.08+c(1:5)[i]*.005, 
	ifelse(abs(Means[,i]) - 2*SEMs[,i] > 0, "*", ""),
	col=S_MAP[i], cex=2)
   }

if (SHOW.SIGNIF & COLLAPSE==F) {
   if (AREA!="PRR")
     text(x,.35, ifelse(SigBothVsSac <.05, "*", ""), col="black")
   text(x, .335, ifelse(SigBothVsUnis<.05, "*", ""), col="blue")
   text(x, .320, ifelse(SigAwayVsUnis<.05, "*", ""), col="purple")
   text(x, .305, ifelse(SigBothVsAway<.05, "*", ""), col="orange")


   freqN = sum((x < LO_NOTCH) | (x > HI_NOTCH))	# count freqs outside notch
   cat(freqN, "freqs (mult compares)")
   if (AREA!="PRR")
     text(x,.35, ifelse(SigBothVsSac <.05/freqN,"*",""),cex=2,col="black")
   text(x, .335, ifelse(SigBothVsUnis<.05/freqN,"*",""),cex=2,col="blue")
   text(x, .320, ifelse(SigAwayVsUnis<.05/freqN,"*",""),cex=2,col="purple")
   text(x, .305, ifelse(SigBothVsAway<.05/freqN,"*",""),cex=2,col="orange")

   if (AREA=="PRR")
      legend("topright",
	     inset=c(-.05,-.1),		# shift re: "topright"
	     xpd=NA,			# no clipping
	     bty="n",			# no box
	     legend=c("  Sig stars", "(Sac v Both)",
		      "Uni v Both", "Uni v Away", "Both v Away",
		      "Both v Away subset"), 
	     text.col=c("black", "black","blue","purple","orange","orange"),
	     cex=.67)

   # If you are ONLY looking at the listed frequencies, redo multiple comparison
   if (CC_INACT && length(FreqList)==1)	# Mult compare more restricted!
      text(x[Freqs],	# Look only at this subset of frequencies
	   .29, 
	   ifelse(SigBothVsAway<.05/length(Freqs),"*","")[Freqs],
	   cex=2,col="orange")

   }
cat("\n")

axis(2, lwd=2, labels=
     	(CC_INACT || !exists("OVERRIDE") || (par()$mfg[2] == 1)))

axis(1, at=seq(ifelse(LO_FREQ>14, 20, 10),  HI_FREQ, 20),
        lwd=2,
       	labels= (1 || CC_INACT || !exists("OVERRIDE") || (par()$mfg[1] == 2)))
   # turned on for all of them -- the 4-on-a-page layout is messed up

if (all(par()$mfg[1:2] == par()$mfrow[1:2])) {  # last panel?
   mtext(paste(
	"Lowess:", LOWESS,
	"Range:", LO_FREQ, HI_FREQ,
	"Notch:", LO_NOTCH, HI_NOTCH,
	 if (CHRONUX) "Chronux"),
	       side=1,line=1,outer=T,adj=-.1,cex=.6)
   if (JUST_ONE != F && JUST_ONE != "")
      mtext(paste("Just one:", paste(JUST_ONE,collapse=" ")), 
	    		side=1,line=2,outer=F,at=-5,adj=0,cex=0.4)
   }

if (!exists("OVERRIDE"))
   dev.off()
} # END 'continue with plotting'

rm(Adjust,BandIndices,HI_FREQ,LO_FREQ,HI_NOTCH,LO_NOTCH,Means,row,SEMs)
rm(S_MAP,verbose)
if (!COLLAPSE)
  rm(col)

if (PRINT.MEANS)
   rm(FreqList, freqN, Freqs)

rm(freqi, FROM, KEEP_INDICES, KEEP.DATA, LFP.HEMI, LOWESS, MELD_ALL, MsToX.float, NOTCH_INDICES, ONLY.BIMANUAL, PRINT.MEANS, RAW.DATA.SEM, SHOW.SIGNIF, SigAwayVsUnis, SigBothVsAway, SigBothVsSac, SigBothVsUnis, TO, x)



##################################################################
# barplot(cbind( c(126,114)-119, c(145,140)-143, c(153,140)-142), ylim=c(-5,12), beside=T, space=c(-1,1), ylab="Coherence (x 10^3)", names=c("Pre-inject", "Peri-inject", "Post-inject"), legend=c("bimanual-together","bimanual-apart"), args.legend=(list(x="center")), col=c("blue","purple"))

# barplot(c(12.5, 5.4, 13.8), space=.5, ylim=c(0,14),  ylab="Coherence (x 10^3)", names=c("Pre-inject", "Peri-inject", "Post-inject"), col=c("black","red","black"))

# segments(c(1,2,3), c(13.2, 5.8, 13.1)+c(6.8,6,16.7), c(1,2,3), c(13.2, 5.8, 13.1)-c(6.8,6,16.7))
