# Spec[tagram].r

#   Smooth with blur() from library(spatstat) !!

SHOW_PALETTE = T
BANDS.USE = 16:100 # 16:100  (10:48)
BANDS.OUT = 54:66  # 54:66 (52:68 or more for small windows)	# stop band

if (CC_INACT) stop("Not written!\n")

# FROM http://sebastianraschka.com/Articles/heatmaps_in_r.html
if (!require("RColorBrewer")) {
   install.packages("RColorBrewer", dependencies = TRUE)
   library(RColorBrewer)
   }
my_palette <- 
    # colorRampPalette(c("#00007F","blue","#007FFF","cyan","#7FFF7F","yellow","#FF7F00","red","#7F0000"))(n=299)		# Like matlab

     # Balanced values
     colorRampPalette(c("black", "green", "yellow", "red", "purple"))(n = 299)

     # Skewed to positive values
     # colorRampPalette(c("black", "black", "green", "yellow", "orange", "red", "purple"))(n = 299)

     # Very skewed to positive values
     # colorRampPalette(c("black", "black", "black", "green", "yellow", "orange", "red", "purple1", "black"))(n = 299)

# optional: define color breaks manually for a "skewed" color transition

# Average over all cells!	# time, bands, (classes), stacks, units
data = apply(data, c(1,2,3), mean, na.rm=T) 
				# Leaves time, band, stacks

# Avg over unimanuals - put in stack 3 (ONLY if LIP-LIP & PRR-PRR; not crosses!)
if ((STACKS>2) && (classes==1) && (AREA == "LIP" || AREA == "PRR")) {
   data[,,3] = (data[,,2] + data[,,3]) / 2
   data = data[,,-2]
   STACKS = STACKS - 1
   }

BANDS.USE = which(BANDS.SEQ %in% BANDS.USE)
BANDS.OUT = which(BANDS.SEQ %in% BANDS.OUT)

if ((SUBTRACT.BASE || SAVE.BASE) && SUBTRACT.PASS==1 && ALIGN=="Target") {
   LEFT = 1		# First bin
   RIGHT = 8		# Last bin

   while (XtoMs(RIGHT) + WINDOW/2 > 0)		# edge of last bin > 0 ?
       RIGHT = RIGHT - 1
   if (RIGHT < 1)  {
      cat("Cannot fit a baseline bin !!! -- use just first data point\n")
      RIGHT = 1
      }
   cat("Base interval is bin ", LEFT, " to ", RIGHT,
	" (",
	XtoMs(LEFT) - WINDOW/2,
	" ",
	XtoMs(LEFT) + WINDOW/2,
	") to (",
	XtoMs(RIGHT) - WINDOW/2,
	" ",
	XtoMs(RIGHT) + WINDOW/2,
	") ms\n", sep="")

   # Want to be able to use 'apply' even with the first index is one value
   TimeRange = if (LEFT == RIGHT) LEFT else LEFT:RIGHT
   Adjust = if (LEFT == RIGHT) 1 else 0
   }


############################
# TWO CASES IN WHICH YOU DO NOT PLOT - JUST SET THE BASE AND EXIT
if (SAVE.BASE) {
   if (ALIGN != "Target" || SUBTRACT.BASE)	# Expect targ align, !subtract
      stop("Problem here!")
   Base = apply(data[TimeRange,,], 2-Adjust, mean)
   assign(paste("SpecSavedBase",AREA,MONK,sep="."), Base, pos=1)
   assign(paste("SpecSavedBaseID",AREA,MONK,sep="."), 
	  c(length(files),				# file count
   	     strsplit(DETAILS.OVERRIDE,"_")[[1]][1:2]),	# window,freq sampling
	  pos=1)
 } else
if (SUBTRACT.BASE & ALIGN=="Target" & SUBTRACT.PASS==1) {
   Base = apply(data[TimeRange,,], 2-Adjust, mean)
 } else {  					# continue with plotting

# IN THESE CASES, YOU PLOT:
if (SUBTRACT.BASE & ALIGN=="GoCue" & SUBTRACT.PASS==1) { # Can only be pass==1
   if (!all(get(paste("SpecSavedBaseID",AREA,MONK,sep="."))[2:3] ==
   	     strsplit(DETAILS.OVERRIDE,"_")[[1]][1:2]))
       stop("Mismatch of saved base window size or freq sampling")
   if (get(paste("SpecSavedBaseID",AREA,MONK,sep="."))[1] != length(files))
       warning("Mismatch in number of files used")
   Base = get(paste("SpecSavedBase",AREA,MONK,sep="."), pos=1)
   }

if (SUBTRACT.BASE) {		     # If gocue, is pass 1; if target, is pass 2
  for (band in 1:length(BANDS.SEQ))  # gocue has no p 2; target p 1 is above
     data[,band,] = data[,band,] - Base[band]
   				
  #  Map color map from -.4 to +.4
  if (ALIGN == "GoCue") {
     # col_breaks=c(seq(-0.35,.35,length=300))
     col_breaks=c(seq(-0.25,.25,length=300))
     # col_breaks=c(seq(-0.14,.14,length=300))
     # col_breaks=c(seq(-0.07,.07,length=300))
    } else
     col_breaks=c(seq(-.14,.14,length=300))
} else {
  col_breaks=c(seq(0.1,.5,length=300))
  }

data[,BANDS.OUT,] = NA		# notch filter

# Set up the plot
par(mfrow=c(STACKS+SHOW_PALETTE,1), las=1, mar=c(0,4,1,2)+.1) #, oma=c(5,3,3,0))

# GoCue: Equal data before and after zero
START = ifelse(ALIGN == "Target", 1, MsToX(-XtoMs(times)))

for (st in 1:STACKS) {
   image(x=START:times, BANDS.SEQ[BANDS.USE], data[START:times,BANDS.USE,st],
		col=my_palette,
		breaks=col_breaks,
		axes=F, xlab="",ylab="",bty='n')

   axis(2)
   axis(1, at=START:times, labels= F)

   segments(MsToX.float(0),    par()$usr[3],
	    MsToX.float(0),    par()$usr[4], lwd=3, xpd=F)
   segments(MsToX.float(1310), par()$usr[3],
	    MsToX.float(1310), par()$usr[4], lwd=3, xpd=F)

   title(paste("\n\n\n", 
	       c("Saccade", 
		 if (STACKS==4) "One arm" else if 
		    (STACKS==2) "Reach" else 
			    c("Ipsi arm", "Contra arm"), "Same", "Apart")[st]),
   	adj=0, cex=1)
   if (st==1)
      title(paste0("\n\n\n(n= ", length(files), ")"), adj=.14, cex=1)
   if (st==STACKS)
      mtext("Time (ms)", side=1, line=0)
   }

mtext(paste(Call, MONK,
   if (NEAR.OVERRIDE) paste0("+", NEAR.OVERRIDE),
   Details,
   if (SUBTRACT.BASE) "- base",
   AREA.OVERRIDE
   ),
 side=3, outer=T, line=0.6, cex=1.3, adj=0)

axis(1, at=1:times, labels=XtoMs(1:times), cex.axis=1.3)

if (SHOW_PALETTE) {
   par(mar=c(0,4,3,2)+.1)
   Pal = col_breaks
   # Pal = seq(min(col_breaks), max(col_breaks), length=300)
   Pal = cbind(Pal,Pal)
   image(1:300, 1:2, Pal, col=my_palette, 
	 		breaks=col_breaks, axes=F, ylab="",xlim=c(0,300))
   # ZeroAt = round(300*(-min(col_breaks))/(max(col_breaks)-min(col_breaks)))
   # axis(1, at=c(1,ZeroAt,300), labels=round(col_breaks[c(1,ZeroAt,300)],
   #                                                 dig=2), side=1, line=0.5)
   mtext(round(col_breaks[c(1,150,300)],dig=2), side=1, line=0.5, adj=c(0,.5,1))
   }

mtext(paste(command, collapse=" "),  side=1, line=4, outer=T, adj=1, cex=.6)

if (!exists("OVERRIDE"))
   dev.off()
} # END 'continue with plotting'

