# Select2.r
#   Pick the right files to run (using cell database)

MEMORY = F

verbose = F
###########################################################################

options(stringsAsFactors = FALSE)

a = b = NULL
if (MONK=="zen" || MONK=="both") {
   a = read.table(
	paste0("/data/coord/zen/zenunits", ifelse(MEMORY, "_memory", "")),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   a = cbind(a, monk="zen")		# Append monkey name (as a column)
   }
if (MONK=="tyr" || MONK=="both") {
   b = read.table("/data/coord/tyr/tyrunits",
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
   }
base = rbind(a,b)			# Required for 'both'
rm(a,b)

if (NEAR)
   source("Nearest.r")

cat(MONK, AREA, "\n")

FilesToDo = NULL
MonksToDo = NULL

while (grepl("base", search()[2]))
	        detach(2)
attach(data.frame(base, stringsAsFactors=FALSE))

for (jjj in 1:3)
 for (kkk in (jjj+1):4) {
   if (AREA=="cross" || AREA=="crossX2") {
      index = (
	(((base[,paste0("area",jjj)]=="LIP") &
	  (base[,paste0("area",kkk)]=="PRR")) |
	 ((base[,paste0("area",jjj)]=="PRR") &
	  (base[,paste0("area",kkk)]=="LIP"))) &
	if (AREA=="cross")
	 ((base[,paste0("hem", jjj)] == base[,paste0("hem",kkk)])) else
	 ((base[,paste0("hem", jjj)] != base[,paste0("hem",kkk)])))

      if (any(index)) {
	 FilesToDo = c(FilesToDo, paste0(reach_file[index],"_",jjj,"_",kkk))
	 MonksToDo = c(MonksToDo, monk[index])
	 }
      }

   # Just one area:
   if (AREA=="LIP" || AREA=="PRR") {
      index = (
   	 (base[,paste0("area",jjj)]==AREA) & 
	 (base[,paste0("area",kkk)]==AREA) &
    	((base[,paste0("hem", jjj)] != base[,paste0("hem",kkk)])))
      if (verbose) cat("Test: (", jjj, kkk, ")   ",
	sum(base[,paste0("area",jjj)]==AREA, na.rm=T), 
	sum(base[,paste0("area",kkk)]==AREA, na.rm=T),
	sum(base[,paste0("hem", jjj)] != base[,paste0("hem",kkk)], na.rm=T),
       	"\n")
      if (any(index)) {
         FilesToDo = c(FilesToDo, paste0(reach_file[index],"_",jjj,"_",kkk))
         MonksToDo = c(MonksToDo, monk[index])
         }
      }
   }

detach(2)
