# Select.r
#   Pick the right files to run (using cell database)
MEMORY = F
###########################################################################

options(stringsAsFactors = FALSE)

a = b = NULL
if (MONK=="zen" || MONK=="both") {
   a = read.table(
	paste0("/data/coord/zen/zenunits", ifelse(MEMORY, "_memory", 
			   ifelse(CC_INACT==1, "_cc_inactivate",
			   ifelse(CC_INACT==2, "_cc_control",    "")))),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   a = cbind(a, monk="zen")		# Append monkey name (as a column)
   }
if ((MONK=="tyr" || MONK=="both") && (MEMORY==0)) {
   b = read.table(
	paste0("/data/coord/tyr/tyrunits", ifelse(MEMORY, "_memory", 
		   ifelse(CC_INACT==1, "_cc_inactivate",
		   ifelse(CC_INACT==2, "_cc_control",
		   ifelse(CC_INACT==11, "_memory_cc_inactivate",
		   ifelse(CC_INACT==12, "_memory_cc_control",    "")))))),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
   }
base = rbind(a,b)			# Required for 'both'
rm(a,b)

source("Nearest.r")

cat(MONK, AREA, ALIGN)
if (CC_INACT) {
   if (CC_INACT == 2)
       cat(" Control")
   cat(switch(2+INACT_TIME, 
            " PRE-INACT"," PERI-INACT", " POST-INACT", " PRE+POST"))
   }
cat("\n")

FilesToDo = NULL
MonksToDo = NULL

while (grepl("base", search()[2]))
	        detach(2)
attach(data.frame(base, stringsAsFactors=FALSE))

BlockA = rep(c(T,T,F,F), length.out=length(base[,"date"]))

for (jjj in 1:3)
 for (kkk in (jjj+1):4) {
   if (AREA == "cross") {	# Diff areas, same hemispheres
      index = (
   	(((base[,paste0("area",jjj)]=="LIP") & 
	  (base[,paste0("area",kkk)]=="PRR")) |
         ((base[,paste0("area",jjj)]=="PRR") & 
	  (base[,paste0("area",kkk)]=="LIP"))) &
    	 ((base[,paste0("hem",jjj) ] == base[,paste0("hem",kkk)])) &
    	 ((base[,paste0("lfp",jjj) ]==1) & (base[,paste0("lfp",kkk) ]==1)))
      if (ONLY_BLOCK_A)
	 index = index & (if (ONLY_BLOCK_A == 1) BlockA else !BlockA)
      if (any(index, na.rm=T)) {
         FilesToDo = c(FilesToDo, paste0(reach_file[index],"_",jjj,"_",kkk))
         MonksToDo = c(MonksToDo, monk[index])
         }
      }

   if (AREA == "crossX2") {	# Diff areas, diff hemispheres
      index = (				# Do flipping here!!
   	(((base[,paste0("area",jjj)]=="LIP") & 
	  (base[,paste0("area",kkk)]=="PRR")) |
         ((base[,paste0("area",jjj)]=="PRR") & 
	  (base[,paste0("area",kkk)]=="LIP"))) &
    	 ((base[,paste0("hem",jjj) ] != base[,paste0("hem",kkk)])) &
    	 ((base[,paste0("lfp",jjj) ]==1) & (base[,paste0("lfp",kkk) ]==1)))
      if (ONLY_BLOCK_A)
	 index = index & (if (ONLY_BLOCK_A == 1) BlockA else !BlockA)
      if (any(index, na.rm=T)) {
         FilesToDo = c(FilesToDo, paste0(reach_file[index],"_",jjj,"_",kkk))
         MonksToDo = c(MonksToDo, monk[index])
         }
      }

   # Just one area:
   if (AREA=="LIP" || AREA=="PRR") {
      index = (
   	 (base[,paste0("area",jjj)]==AREA) & 
	 (base[,paste0("area",kkk)]==AREA) &
    	 ((base[,paste0("hem",jjj) ] != base[,paste0("hem",kkk)])) &
    	 ((base[,paste0("lfp",jjj) ]==1) & (base[,paste0("lfp",kkk) ]==1)))
      if (ONLY_BLOCK_A)
	 index = index & (if (ONLY_BLOCK_A == 1) BlockA else !BlockA)
      if (any(index, na.rm=T)) {
   	   	# Datafiles are always with lower channel 1st (j then k)
         FilesToDo = c(FilesToDo, paste0(reach_file[index],"_",jjj,"_",kkk))
         MonksToDo = c(MonksToDo, monk[index])
         }
      }
   }

detach(2)

rm(MEMORY,jjj,kkk,BlockA)
