# ReadAll.r   Plot power spectra for classes.

# In correlation, 'flip' irrelevant to LIP-LIP and PRR-PRR, but matters in
# a straightforward way for cross.
# Crossx2 is trickier; have to do it in Select

CRITERION_Z = 0		# [0] Remove if greater than (3?)
SCALE = F		# [T] Everyone gets equal weight

REMOVE_POWER_OUTLIERS = T	# Identified in ../power

SACSPLIT = F
# CLASS = ""		# Set this in DoAll.r

verbose = 0		# [0,1,2]  taciturn, normal, verbose
			# [-3]     Negative are specials

STACKS = 5 + SACSPLIT
FLIP = T	# -oh1  RIGHT hemisphere      -oh0 LEFT hemisphere
	# Stacks: started recording on LEFT so left (stk 63) = ipsi arm
	#	  Flip STACKS if recorded on right
	# Classes named for RIGHT arm, so flip CLASSES if record on RIGHT

if (grepl("_all", DETAILS)) {
    STACKS = 2
    CLASS = 1
    FLIP = F
    }

if (MONK=="both")		# Try this!
    MONK = "{tyr,zen}"

System = function(command) system(paste("tcsh -c '", command, "'"), intern=T)
Scan = function(...) scan(..., quiet=verbose<=0)

print(DETAILS)

# files = paste0( "/data/coord/grab/lfp-lfp/data/Wilbur/cohLFP/",
files = paste0( "/data/coord/grab/lfp-lfp/data/cohLFP",
	        if (CROSSED) ".RL",
		if (CHRONUX) ".chronux",
		"/",
		DETAILS,
		"/",
		 MonksToDo,
		"/data_",
		 FilesToDo, sep="")

if (length(files) == 1)		# Cannot do a single file; must duplicate it
   files = c(files, files)	#  (will not catch all cases, so "placeholder"

UsedFiles = NULL		# rarely, files are skipped
for (file in c(files,"placeholder")) {	# If just one file, need to duplicate

   if ((file == "placeholder") && (length(UsedFiles)==1))
      file = UsedFiles			# Do the file over again!

   # zen s1023.1 throws an error
   # Zen files generate bounds errors (EndMs1 --> X ms) with GoCue alignment:
	# 905.2,936.1,967.1: 433  906.2,938.1: 393   907.2,968.1: 353
        # 930.2,966.1: 453
	# 940.1: 373   942.1:  413   
   if ((ALIGN == "GoCue" && grepl(":500ms",DETAILS)) ||
       (ALIGN == "Target" && grepl("100ms_",DETAILS) && SAVE.BASE) ||
       (ALIGN == "Target" && grepl("200ms_",DETAILS) && SAVE.BASE))
    if (grepl("_90[567].2",file) || grepl("_930.2",file) || 
	grepl("_93[68].1",file) || grepl("_94[02].1",file) ||
       	grepl("_966.1",file)
       ) {
      if (verbose>0)
         cat("Skip", sub("[-a-zA-Z0-9_:/]*/cohLFP", "", file), "\n")
      next
      }

   if (REMOVE_POWER_OUTLIERS) {
      if (grepl("_1006.2_2",file) ||
	  grepl("_1033.2_2",file) || 
	  grepl("_1036.2_2",file) || 
	  grepl("_10929.2_2",file) || 
	  grepl("_1100.4_1",file) || 
	  grepl("_1106.1_1",file) || 
	  grepl("_1106.1_2",file) || 
	  grepl("_909.2_2",file) || 
	  grepl("_917.2_1",file) || 
	  grepl("_932.2_1",file) || 
	  grepl("_1013.1_2",file) || 
	  grepl("_1091.1_2",file) || 
	  grepl("_1252.3_2",file) || 
	  grepl("_1298.2_1",file)
	  ) {
         if (verbose>0)
            cat("Skip (high power)", 
		sub("[-a-zA-Z0-9_:/]*/cohLFP", "", file), "\n")
         next
         }
      if (grepl("_1099.3_1",file) ||
	  grepl("_11112.4_2",file) || 
	  grepl("_1111.4_2",file) || 
	  grepl("_1116.1_1",file) || 
	  grepl("_1117.1_1",file) || 
	  grepl("_1257.2_1",file) || 
	  grepl("_1258.2_1",file)
	  ) {
         if (verbose>0)
            cat("Skip (low power)", 
		sub("[-a-zA-Z0-9_:/]*/cohLFP", "", file), "\n")
         next
         }
      }

#   Files over a stretch in zen showed apart > same cohere!
#   if (grepl("12[3456][0-9].[1-9]", file)
#       ) {
#      cat("Skip late data", sub("[-a-zA-Z0-9_:/]*/data_", "", file), "\n")
#      next
#      }
   #if (#grepl("865.1", file) || grepl("1259.2",file) ||
       #grepl("1191.2", file) ||
       #grepl("919.2", file) || grepl("932.2", file)) { #|| grepl("96", file))
      #cat("Skip", substring(file,43), "\n")
      #next
   #   }

    if (verbose==-3) cat(basename(file), ": \n")
    SKIP_FLAG = F
    if (JUST_ONE[1] != F)
     for (ii in 1:length(JUST_ONE)) {
       if (ifelse(is.numeric(JUST_ONE[ii]),	# Negative or "-string":
       		  JUST_ONE[ii] < 0,
		  substr(JUST_ONE[ii], 1, 1) == "-")) { # Skip if find it
	  if (is.numeric(JUST_ONE[ii])) {
             if (grepl(abs(JUST_ONE[ii]), file))	# (Take positive)
                SKIP_FLAG = T
	   } else if (grepl(substring(JUST_ONE[ii], 2), file))
                SKIP_FLAG = T				# (Strip leading "-")

	} else if (!grepl(JUST_ONE[ii], file))  # Positive: skip if NOT it
            SKIP_FLAG = T
       rm(ii)
       }        
    if (SKIP_FLAG) {
        if (verbose==-3) cat("   Skip due to JUST_ONE\n")
	next
        }
    rm(SKIP_FLAG)

# Skip 1st three, the low volumes?
    if (SKIP_EARLY)				# Set this in DoAll.r
     if (
	 grepl("11670",file) ||
         grepl("11685",file) ||
         grepl("11696",file) ||
	 0)
      next

    if (CC_INACT) {
      if (INACT_TIME == -1 && (!grepl("\\.1",file))) {
          if (verbose==-3) cat("   Skip due to INACT_TIME\n")
	  next
       } else if ((INACT_TIME == 0) && (!grepl("\\.2",file))) {
          if (verbose==-3) cat("   Skip due to INACT_TIME\n")
	  next
       } else if ((INACT_TIME == 1) && (!grepl("\\.3",file))) {
          if (verbose==-3) cat("   Skip due to INACT_TIME\n")
	  next
       } else if ((INACT_TIME == 2) && grepl("\\.2",file)) { # Skip only if peri
          if (verbose==-3) cat("   Skip due to INACT_TIME\n")
	  next
	  }
      }

   if (!file.exists(file)) {
      if (verbose)
         cat("Cannot find", sub("[-a-zA-Z0-9_:/]*/cohLFP", "", file), "\n")
      next
      }

   if (verbose==2)
      cat("file", file, "\n")

   command = Scan(file, nlines=1, what="character")
   params  = Scan(file, skip=2, nlines=1)
   # 1: version         
   # 2: interval_begin  3: interval_end
   # 4: time start      5: time end             
   # 6: filter
   # 7: UnitOrLFP       8: UnitOrLFP2
   # 9: start freq      10: end freq    11: freq step size
   # 12: file type 
   # 13: LFP hemisphere
   # 14: start high freq 15: end hi freq  16: step size
   # 17: evoked flag
   # 18: spike limits (all, exactly mimimum)  19: spike N   20: random seed
   # 21: use chronux flag

   WINDOW = params[4]

   FROM = params[2]
   TO   = params[3]
   DURATION = TO - FROM + 1
   ZERO = -FROM

   # Read in counts for each trial type
   counts = Scan(file, skip=3, nlines=1) # Get 'n' for each trial type
   if (min(counts) < MIN_COUNTS) {
      cat("Too few repetitions - skipping\n")
      next
      }

   # Work out what frequencies were used
   if (params[1] == 1) {
      BANDS = (params[10] - params[9]) / params[11] + 1
      BANDS.SEQ = seq(params[9], params[10], by=params[11])
      if (CHRONUX) {
         BANDS = round(BANDS)
         BANDS.SEQ = seq(from=params[9], by=params[11], length.out = BANDS)
         BANDS.SEQ = round(BANDS.SEQ, dig=1)
         }
    } else {					# version == 2+
      BANDS.SEQ = Scan(file, skip=4, nlines=1) # Get frequencies
      BANDS = length(BANDS.SEQ)
      if (abs(BANDS - round((params[10]-params[9]) / params[11] + 1)) > CHRONUX)
	 cat("Possible error in frequency bands\n")  # if chronux, err of 1 ok
      }


   times = length(Scan(file, skip=4+(params[1]>1), nlines=1)) # Count time bins
   # Just a check:
   if (times != 1 + floor( (DURATION-WINDOW-1) / (WINDOW/4)))
       cat("Error in timing / duration\n")

   LFP.HEMI = params[13]
   if (abs(TO - FROM - 1 - DURATION) > 10)      # some tolerance!
      cat("Extracted 'zero' may be wrong because bounds were redone\n")

   MsToX <- function(ms) return(floor(1+(ZERO-WINDOW/2+ms)/(WINDOW/4)))
   	# Returns fractions, which as indices end up being floor-ed
   	# gives index whose CENTER is ms
   MsToX.float <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4))
   XtoMs <- function(ix) return( (ix-1)*WINDOW/4 - ZERO + WINDOW/2)
   	# This is the CENTER; the edges are +/- WINDOW/2 from this.


   temp = Scan(file, skip=4+(params[1]>1))	# Read all the data
   L = length(temp)

   STACKS = length(counts)			# Addded 2019-5-21, LHS
   if (STACKS > 6)
      STACKS = STACKS / 2			# Must be 2 classes
   # If 6 'things', could be 6 stacks OR 3 stacks x 2 classes -- need to work this out!

   classes = L / times / BANDS / STACKS / 2	# Nmber of classes?

   if (classes %% 1 != 0) {
      cat("Error in number of values\n")
      if (verbose)
         cat("  L=",L, "times=",times, "Bands=",BANDS, "STACKS=",STACKS, "\n")
      if (SACSPLIT & (CLASS != 0)) {
         if (verbose)
	    cat("Missing sac split in one of the classes? - skipping\n")
         next  # THE RARE SKIPPED FILE -- REQUIRES UsedFiles !
         }
      }
   if (classes * STACKS != length(counts))
      cat("Error in number of classes/stacks\n")

   UsedFiles = c(UsedFiles, file)	# Note which files are used
   if (verbose==-3)  cat("   Keeping\n")

   if (length(UsedFiles) == 1) {	# First file?
      save.classes <- classes
      save.times <- times
      save.bands <- BANDS
      Temp = array(NA,
	     dim=c(times, 2, BANDS, classes, STACKS, length(files)),
             dimnames=list(
		NULL,
		c("mean", "SEM"), 
		BANDS.SEQ,
		1:classes,
		if (SACSPLIT) c(62:65,661,662) else (62:66)[1:STACKS],
		files))
      Temp[,,,,,1] = array(temp, dim=c(times, 2, BANDS, classes, STACKS))
    } else {
      if (save.classes != classes)
	 if (grepl("RLDU",DETAILS)) {
            if (verbose>0)
               cat("Skip (missing classes)", sub("[-a-zA-Z0-9_:/]*/data_", "", file), "\n")
		# Could be missing RL *or* could be missing DU - that's a prob!
            next
	  } else
	    stop("Classes differ", save.classes, classes, file, "\n")

      if (save.times != times)
	 cat("Times differ", save.times, times, file, "\n")
      if (save.bands != BANDS)
	 cat("Bands differ", save.bands, BANDS, file, "\n")
      
      Temp[,,,,,length(UsedFiles)] = 
          array(temp, dim=c(times, 2, BANDS, classes, STACKS))
      }

   # mirror image if lfp recorded on right hemisphere
   if (FLIP & (LFP.HEMI == 1)) {  #0=left;1=right
      if (verbose>0)
         cat("Mirror data on right\n")
      Temp2 <- array(Temp[,,,,,length(UsedFiles)],
           dim=c(times, 2, BANDS, classes, STACKS))	# note 1
        # Swap stacks 2 & 3 (left and right paws)
      Temp2[,,,,2] <- Temp[,,,,3,length(UsedFiles)]
      Temp2[,,,,3] <- Temp[,,,,2,length(UsedFiles)]

      # Swap classes 8,1,2 with 6,5,4 (mirror image)  (verticals uneffected)
      #if (classes == 8) {
      #   Temp2[,,,c(8,1,2),] <- Temp[,,,c(6,5,4),,length(UsedFiles)]
      #   Temp2[,,,c(6,5,4),] <- Temp[,,,c(8,1,2),,length(UsedFiles)]
      # } else if (((classes==2) || (classes==4)) && (CLASS != "PN")) {
      #    			# if already sorted by Pref/null, don't chg!
      #   Temp2[,,,1,] <- Temp[,,,2,,length(UsedFiles)]
      #   Temp2[,,,2,] <- Temp[,,,1,,length(UsedFiles)]
      # } else if (classes == 1) {
      #	 # No need to flip classes!
      # } else if (verbose)
      #	 cat(paste("   ", classes, "classes -- how do I flip them?\n"))

      Temp[,,,,,length(UsedFiles)] <- Temp2
      rm(Temp2)
      }
   }

if (length(UsedFiles) == 0)
   stop("Cannot find the data")

if (length(UsedFiles) < length(files)) {	# Rarely, we skip a file
   classes = save.classes			# Restore correct value
   if (verbose)
      cat("Skipped", length(files)-length(UsedFiles), "files,",
          "used ", length(UsedFiles), "\n")
   files = UsedFiles
   Temp = array(Temp[,,,,,1:length(files)],	# Throw out empties
		# Have to enumerate dim and dimnames - see note 1!
	    	 dim=c(times, 2, BANDS, classes, STACKS, length(files)),
                 dimnames=list(NULL, c("mean", "SEM"), 
			   BANDS.SEQ,
		 	   1:classes,
			   if (SACSPLIT)c(62:65,661,662) else (62:66)[1:STACKS],
			   files))
   }
      
data = array(Temp[,"mean",,,,],
	    	 dim=c(times, BANDS, classes, STACKS, length(files))) # note 1
errs = array(Temp[,"SEM" ,,,,],
	    	 dim=c(times, BANDS, classes, STACKS, length(files))) # note 1

# Normalize and save values for excluding outliers
# MeanPower = matrix(NA, ncol=BANDS, nrow=length(files))
# for (f in 1:length(files)) {
#    for (band in 1:BANDS) {
#       MeanPower[f,band] = mean(data[,band,,,f])		# to whole interval
#       if (ALIGN=="" && SACSPLIT==0 && MEMORY=="" && CLASS=="") {
# 	 normalize = mean(data[1:MsToX(0),band,,,f])	# -400 to 50
#          assign(paste("BaselinePower",f,band,AREA,MONK,sep="."),normalize) #save
# 	} else if (NORMALIZE.TO.BASELINE) {
#          normalize = get(paste("BaselinePower",f,band,AREA,MONK,sep="."))
# 	} else {
#          normalize = MeanPower[f,band]
# 	 }
#       if (NORMALIZE) {
#          data[,band,,,f] = data[,band,,,f]/normalize
#          errs[,band,,,f] = errs[,band,,,f]/normalize
#          }
# 
#       if (SCALE) {
#          scale = max(abs(data[,band,,,f]))
#          # Largest value, across time and conditions (stacks):
#       	 # Maps 1 to 1, but makes the range across cells/bands more similar
#       	 data[,band,,,f] = 1 + (data[,band,,,f]-1)/(scale-1)
#          errs[,band,,,f] = 1 + (errs[,band,,,f]-1)/(scale-1)
# 	 }
#       }
#    rm(normalize)
#    }

# Names can get lost; add them back
dimnames(data) = 
     list(times=NULL, Frequencies=BANDS.SEQ, classes=1:classes,
	  tasks=if (SACSPLIT) c(62:65,661,662) else (62:66)[1:STACKS],
	  files=files)

# Zscore power per band (gives files x bands)
#if (CRITERION_Z) {
#   MeanPower = log(MeanPower)
#   Zscore = (MeanPower - apply(MeanPower, 2, mean)) / apply(MeanPower, 2, sd)
#
#   for (f in 1:length(files))		# Should not have to use a loop!
#       data[,abs(Zscore[f,])>CRITERION_Z,,,f] = NA
#   #for (b in 1:BANDS) data[,b,,, abs(Zscore[,b]) > CRIT_Z] = NA    # equivalent
#   cat("Removed", sum(abs(Zscore) > CRITERION_Z), "entries -- ", 
#   	round(100*sum(abs(Zscore) > CRITERION_Z) / sum(Zscore < 10000)),
#         "%\n")
#   rm(MeanPower,Zscore)
#   }


if (length(files) == 1) {	# Just one file?
   cat("Requested just one file; duplicate it to make code happy\n")
   cat("Plot functions cannot deal with losing a dimension, nor with NA's\n")
   # sort of data = c(data,data) or data = cbind(data,data), but multi-dim!
   }

if (verbose>0)
   cat("Done with read\n")


#rm(Scan,verbose,temp,L,save.classes,save.bands,save.times,Temp)
#rm(UsedFiles,file,CRITERION_Z,SCALE,SACSPLIT,FLIP)
#rm(DURATION,FilesToDo,channel,params,counts,MonksToDo)
#rm(System)

#  note 1: if you collapse over classes (or stacks?) when you call the
#    macro, one dimension of data (or Temp) has size of 1.  When creating
#    a new array as a copy or subset, length 1 dimensions disappear!
#    Prevent this by enmerating the dimension sizes.
