# Run 'pre' & 'peri'
  # Generates KeepMeansIndi - they are stacks x cells
# For memory lesion data, only 3 stacks:  1=sac, 2=together, 3=apart

PRINT_ALL = F

Per = KeepMeansIndi.per
Pre = KeepMeansIndi.pre


cat(sprintf("Does 'saccade'  change?  %6.3f -> %6.3f  p=%.4f\n",
	    mean(Pre["62",]),
	    mean(Per["62",]),
	    t.test(Pre["62",], Per["62",], paired=T)$p.value))
cat(sprintf("Does 'together' change?  %6.3f -> %6.3f  p=%.4f\n",
	    mean(Pre["65",]),
	    mean(Per["65",]),
	    t.test(Pre["65",], Per["65",], paired=T)$p.value))
cat(sprintf("Does 'apart'    change?  %6.3f -> %6.3f  p=%.4f\n",
	    mean(Pre["66",]),
	    mean(Per["66",]),
	    t.test(Pre["66",], Per["66",], paired=T)$p.value))
cat(sprintf("Does the diff   change?  %6.3f -> %6.3f  p=%.4f\n",
	    mean(Pre["65",]-Pre["66",]),
	    mean(Per["65",]-Per["66",]),
    t.test(Pre["65",]-Pre["66",], Per["65",]-Per["66",], paired=T)$p.value))
	# t.test(Pre[2,]-Per[2,], Pre[3,]-Per[3,]) -- save result

if (PRINT_ALL) {
   for (i in 1:length(Pre[1,]))
      cat(sprintf("%5.2f ", Pre[2,i]-Pre[3,i]))
   cat("\n")
   for (i in 1:length(Pre[1,]))
      cat(sprintf("%5.2f ", Per[2,i]-Per[3,i]))
   cat("\n")
   for (i in 1:length(Pre[1,]))
      cat(sprintf("%5.2f ", Per[2,i]-Per[3,i] -Pre[2,i]+Pre[3,i]))
   cat("\n")
   }

rm(Per,Pre)
