# Each.r
#   From 'VsFreq', but operate on single trials and singe frequencies

LO_FREQ =  20					# as low as 5
HI_FREQ =  35					# as hi  as 120
STEP_FREQ = BANDS.SEQ[2] - BANDS.SEQ[1]

# Go to nearest
if (LO_FREQ < min(BANDS.SEQ))
    LO_FREQ = min(BANDS.SEQ)			# else
LO_FREQ = (LO_FREQ %/% STEP_FREQ) * STEP_FREQ
if (HI_FREQ > max(BANDS.SEQ))
    HI_FREQ = max(BANDS.SEQ)			# else
HI_FREQ = ((HI_FREQ+STEP_FREQ-1) %/% STEP_FREQ) * STEP_FREQ

# MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4))  # ReadAll.r
S_MAP = c("gray30", "green", "red", "blue", "purple",	# stack map
	  "orange")				# If SacSplit!

LEFT  <<- ifelse(exists("START.TIME"),
	   MsToX(START.TIME + WINDOW/2),
           max(1, MsToX(ifelse(ALIGN=="GoCue", -1000+WINDOW/2,  600))))  # std
RIGHT <<- ifelse(exists("END.TIME"),
	   MsToX(END.TIME - WINDOW/2),
	   MsToX(ifelse(ALIGN=="GoCue",   100-WINDOW/2, 1000)))  # std

# Average over particular time points, leaving freq band, stacks & units
Subset = if (LEFT == RIGHT) data[LEFT      ,,,] else
       		      apply(data[LEFT:RIGHT,,,], 2:4, mean)

# Average over particular frequency band, leaving stacks & units
Index = function(freq) return(match(freq, BANDS.SEQ))
Subset = if (LO_FREQ==HI_FREQ) {
	    Subset[Index(LO_FREQ),,] 
	  } else
	    apply(Subset[Index(LO_FREQ):Index(HI_FREQ),,], 2:3, mean)

# average together left and right single arm movements, leave '2' blank
Subset[3,] = rowMeans(cbind(Subset[2,], Subset[3,]))
Subset[2,] = NA

# Set up the plot: a difference in power for two stacks, for each unit
# par(xpd=NA)

Score = Subset[5,] - Subset[4,]
names(Score) = sub("[-/_:0-9a-zA-Z]*Data_", "", names(Score))
names(Score) = sub("_[0-9]_[0-9]", "", names(Score))
Score = round(Score, dig=3)
if (AREA == "PRR") {
   assign(paste0("Each.",MONK), Score)
   save(list=paste0("Each.",MONK), file=paste0("Each.",MONK))
   }

L = 1:length(files)
plot(0,0, xlim=range(L),
     	  ylim=range(c(.2,-.2,Score)),
	  type='n', bty='n', axes=T)

title(main=paste(AREA, "  n=", length(files)))

segments(1,0, max(L), 0)

if (t.test(Score)$p.value < .1) {
    segments(10,        mean(Score), 
	     max(L)-10, mean(Score), col="red", lwd=3)
   text(1, .20, round(t.test(Score)$p.value, dig=3),adj=0,col="red")
   }

LM = lm(Score ~ L)
if (summary.lm(LM)$coefficients[2,4] < .1) {
   abline(LM, col="blue", lwd=3) 
   text(1, .16, round(summary.lm(LM)$coefficients[2,4], dig=3),adj=0,col="blue")
   }

points(L, Score, pch=19)	# apart minus together

rm(L,Score,LM,Index,Subset,S_MAP,HI_FREQ,LO_FREQ,STEP_FREQ)
