## DoAll
# INACT_TIME:    -1: pre only  0: peri only  1: post only  2: pre+post
#  LESION vs CONTROL, ZEN:
   # 11685 11670 11696 1703 1706 1712 1718 1722 (1726)  vs   1700 1709 (1714)
   # Often exclude 1726
#  LESION vs CONTROL, TYR:
   # 1964 1986 1992 1995 1998 2002 2005  vs   1968 1971 1973 1978
   # 4,-5 6,4  6,8  2,-1 5,-2 -1,1 2,1	  % 100*difference in r for pre,peri
   #                          high

CC_INACT    = 0		# 0: std   1: inactivation    2: control 
				#          11-12: LIP (inact, control)
				#    3, 13, etc, NOT WORKING
# INACT_TIMEs = c(-1,0)		# -1: pre only  0: peri only  1: post only
INACT_TIMEs = c(-1,0,1)

				# c(-1,0)  c(-1,0,1,2)   c(-1,0,1)  c(2,0)  

# Call = "VsFreq"			# VsFreq, VsTime, Each, Spec
Call = "VsFreq"		# DIAG

CHRONUX = F
ONLY_BLOCK_A = 0		# [0] both   1: only A   -1: only B
SPLIT_UP = 0			# [0] do a single block (1,2, etc)
				#  If too few trials, may have to remove by hand
NO_EVOKED = F			# Remove the evoked response?
# AREA.OVERRIDES = c("PRR", "LIP", "cross", "crossX2")
AREA.OVERRIDES = c("PRR")
COLLAPSE = F			# [F] T: combine across stacks, VsFreq only
				#     If T, probably want to change "DETAILS"

CLASS = 0              # 0 (just one class) or the *one* class you want
CROSSED = F		# [F] for "RL" -- distinguish crossed from uncrossed
			#    Must select a class if use RL (1=X'd,2=unX'd ?)

SEM_OF_PRE_PERI_EFFECT = F	#  (for CC_INACT) (can cause trouble!)
	# SEM computed *per frequency* and *then* averaged - not ideal
	# Best to start a new session, do pre first, then peri
SKIP_EARLY = F			# Only for CC_INACT==1 (and does not help!)

MIN_COUNTS = 2			# [2] No real effect of raising this
EXPAND_YLIM = F			# [F]
SKIP_SACCADE_LINE = F		# [F]


for (INACT_TIME in INACT_TIMEs) {
  


	# Include ONE or exclude any #; uses grep: "1697.1" or "1703"
	# Include (positive): CANNOT HAVE MORE THAN ONE VALUE
	# No wild cards in negatives (because if quoted, they are not negative)

 if (CC_INACT == 1) {
    JUST_ONE = c(	 # TYR
		 -2033,	 # Have LFP from only one hemisphere after inject
                 -2002,	 # toss! huge pre correlation (no diff)
    		 -2029,  # toss! ditto as for 2002

		 	 # ZEN		# "-1703.._1_3", _1_4, _2_3, _2_4,
	          # "-11670",	# SEM = .014-.05, weird patterns (ok or not?)
		  "-11685",	# SEM = .02-.08, weird patterns
		  "-11696",	# SEM = .04-.08, peaked at 30 Hz

		  "-1703",	# SEM = .03-.06
		  # "-1706",	# SEM = .01-.03 (ok)
		  # "-1712",	# SEM = .01-.03 (ok)
		  "-1718",	# SEM = .03-.09
		  # "-1722",	# SEM = .01-.02 (ok)
		  "-1726",	# SEM = .03-.08
		  "-999999999"		# dummy, so commas are ok
		 )

  } else if (CC_INACT == 2) {
    JUST_ONE = c(-1978,-1971,		# tyr control: diff coher even in gamma
		 -1714)			# zen control: huge diff in power

  } else if (CC_INACT == 11) {
    # JUST_ONE = c(-2219,-2220,-2230,-2231)  # OLD: Flagged as odd (but ok?)
    JUST_ONE = F

  } else if (CC_INACT == 12) {
    JUST_ONE = F
   #JUST_ONE = c(-2136:-2241, -2243)
  } else
    JUST_ONE = F


# JUST_ONE = "11670"
		# 1726 was odd, so exclude it -- ZEN EXP
		# 2037 hi coher  -- TYR CCC (control)
		# 2039 hi coher  -- TYR CC


SUBTRACT.BASE = F		# If target, subtract pre-target interval data
				# If gocue, look for a saved base to subtract
				# (Does not work if plotting only 65 & 66 ??)
SAVE.BASE = F		# Save a base to subquently subtract from go-cue data
   # For GoCue, 1st run corresponding target-align with SAVE.BASE=T, SUBTRACT=F
   #            then run gocue-align with SUBTRACT.BASE=T, SAVE.BASE=F

DETAILS.OVERRIDE =			# Select one: (must be in time loop)

#  THE 'CC' IS NOW ADDED AUTOMAGICALLY (below)
# "500ms_2Hz_GoCue_-1000:250ms" ; START.TIME = -500; END.TIME = 0
# "500ms_2Hz_Target_-500:1250ms"; START.TIME =  750; END.TIME = 1250
# "500ms_2Hz_Target_-500:1250ms"; START.TIME =  -500; END.TIME = 0
# "500ms_2Hz_GoCue_-1000:250ms_NoE" ; START.TIME = -500; END.TIME = 0
# "500ms_2Hz_Target_-500:1250ms_NoE"; START.TIME =  750; END.TIME = 1250
# "500ms_2Hz_Target_-500:1250ms_NoE"; START.TIME =  -500; END.TIME = 0

#  "100ms_2Hz_Target_-500:1300ms";  START.TIME =  850; END.TIME = 1250
#  "100ms_2Hz_GoCue_-1200:300ms";   START.TIME = -400; END.TIME =    0
#  "100ms_2Hz_GoCue_-1200:300ms";   START.TIME =  100; END.TIME =  200
#  "100ms_2Hz_GoCue_-1200:300ms";   START.TIME =  200; END.TIME =  300
#  "100ms_2Hz_GoCue_-1200:500ms";   START.TIME = -400; END.TIME =    0

# "200ms_2Hz_Target_-500:1300ms";  START.TIME =  850; END.TIME = 1250
# "200ms_2Hz_Target_-500:1300ms_NoE";  START.TIME = -400; END.TIME = 0
# "200ms_2Hz_Target_-500:1300ms_NoE";  START.TIME =  850; END.TIME = 1250
# "200ms_2Hz_GoCue_-1200:300ms";   START.TIME = -400; END.TIME =    0
# "200ms_2Hz_GoCue_-1200:300ms";   START.TIME = -500; END.TIME =    0
# "200ms_2Hz_GoCue_-1200:300ms";   START.TIME =   50; END.TIME =  300
# "200ms_2Hz_GoCue_-1200:500ms";   START.TIME =   300; END.TIME =  500 # deleted
# "200ms_2Hz_GoCue_-1200:500ms_NoE";   START.TIME =   300; END.TIME =  500
# "200ms_2Hz_GoCue_-1200:500ms";   START.TIME =   300; END.TIME =  500

#  "400ms_2Hz_Target_-450:1350ms";  START.TIME =   50; END.TIME =  450
#  "400ms_2Hz_Target_-450:1350ms";  START.TIME =  850; END.TIME = 1250
#  "400ms_2Hz_Target_-450:1350ms";  START.TIME = -450; END.TIME =   50
#  "400ms_2Hz_GoCue_-1150:350ms";  START.TIME = -450; END.TIME =  -50
#  "400ms_2Hz_GoCue_-1150:350ms";  START.TIME = -350; END.TIME =   50
#  "400ms_2Hz_GoCue_-1150:350ms";  START.TIME = -450; END.TIME =   50
#  "400ms_2Hz_GoCue_-1150:350ms";  START.TIME =  -50; END.TIME =  350

#  "400ms_2Hz_Target_-450:1350ms_RL" ; START.TIME =  850 ; END.TIME = 1250
#  "400ms_2Hz_GoCue_-1150:350ms_RL" ; START.TIME = -450 ; END.TIME = -50
#  "400ms_2Hz_Target_-450:1350ms_UD" ; START.TIME =  850 ; END.TIME = 1250
#  "400ms_2Hz_GoCue_-1150:350ms_UD" ; START.TIME = -450 ; END.TIME = -50

#  'all': merges all but sacs ?
#   "400ms_2Hz_Target_-500:1300ms_all" ; START.TIME =  -400 ; END.TIME = 0
#  "400ms_2Hz_GoCue_-1200:300ms_all" ; START.TIME =  -400 ; END.TIME = 0

#  "500ms_2Hz_Target_-500:1250ms"; START.TIME =  650; END.TIME = 1150
#  "500ms_2Hz_Target_-500:1250ms"; START.TIME =  750; END.TIME = 1250  # GOOD
#  "500ms_2Hz_Target_-500:1250ms"; START.TIME = -500; END.TIME = 0	# Good for baseline

# WAS USING THIS:
  "500ms_2Hz_GoCue_-1000:250ms";   START.TIME = -500; END.TIME = 0  # GOOD!
#  "500ms_3Hz_GoCue_-1000:250ms";   START.TIME = -500; END.TIME =    0
#  "500ms_2Hz_GoCue_-1000:250ms_6:240Hz";  START.TIME = -500; END.TIME = 0  # extended

# VsTime
# "200ms_2Hz_GoCue_-1200:300ms";  START.TIME = -1200; END.TIME =  300
# "300ms_3Hz_GoCue_-1150:350ms";  START.TIME = -1150; END.TIME =  350
# "400ms_2Hz_GoCue_-1150:350ms";  START.TIME = -1150; END.TIME = -350
# "400ms_2Hz_Target_-450:1350ms"; START.TIME =  -450; END.TIME = 1350

if (NO_EVOKED)
   DETAILS.OVERRIDE = paste0(DETAILS.OVERRIDE, "_NoE")
if (CC_INACT)
   DETAILS.OVERRIDE = paste0(DETAILS.OVERRIDE, switch(CC_INACT,"_cc","_ccc"))
if (CC_INACT==11 || CC_INACT==12)
   DETAILS.OVERRIDE = paste0(DETAILS.OVERRIDE, 
			     	switch(CC_INACT-10,"_memory_cc","_memory_ccc"))
if (SPLIT_UP)
   DETAILS.OVERRIDE = paste0(DETAILS.OVERRIDE, "_split", SPLIT_UP)

OVERRIDE = T
ALIGN.OVERRIDE = if (grepl("GoCue", DETAILS.OVERRIDE)) "GoCue" else "Target"

if (SAVE.BASE & ALIGN.OVERRIDE != "Target")
	stop("Should use target alignment when saving the base")
if (ALIGN.OVERRIDE == "GoCue" & (Call == "Time" || Call=="Each")) 
   if (SUBTRACT.BASE)
      stop("Cannot get a base interval with these windows!")
if (SUBTRACT.BASE & Call=="VsTime")
   stop("Cannot subtract base in a 'VsTime' display!")
if (SKIP_EARLY && ((CC_INACT != 1)||(CC_INACT !=11)))
   print("Not skipping early (not lesion data!)")

if ((length(AREA.OVERRIDES) > 1) & SEM_OF_PRE_PERI_EFFECT)
   stop("Can only do one area at a time if you want SEM_OF_PRE_PERI_EFFECT")


# Check that start and end times are ok
# if (START.TIME
#  WRITE ME!!

# Frequency range for display is set in VsFreq.r

# else can get in trouble from old ones!
if (exists("MONK"))  rm(MONK)
if (exists("NEAR"))  rm(NEAR)
if (exists("AREA"))  rm(AREA)
if (exists("DETAILS"))  rm(DETAILS)
if (exists("ALIGN")) rm(ALIGN)

# pdf(file=paste0(area,"_",NEAR,".pdf"))

 NEAR.OVERRIDE = 2
# for (MONK.OVERRIDE in c("zen", "tyr", "both"))	# "zen", "tyr", "both"
# for (MONK.OVERRIDE in c("tyr", "zen"))
for (MONK.OVERRIDE in c("both"))
#  for (NEAR.OVERRIDE in c(0,2))
    {
    Details <- unlist(strsplit(DETAILS.OVERRIDE, "_"))
    Details <- paste0(	# Remove database time range (does not affect plot!)
		     paste0(Details[!grepl(":", Details)], collapse="_"))

    	# If showing just one class, tell us which
    class_at = grepl("[A-Z][A-Z]", Details)	# Look for 2+ caps in a row
    if (class_at)				# If found, append CLASS
	Details[class_at] = paste0(Details[class_at], ".",CLASS)
    rm(class_at)

    if (Call != "Spec" && Call != "VsTime")	# Add start to end time range
	Details <- paste0(Details, "_", START.TIME, ":", END.TIME, "ms")

    if (!SAVE.BASE) {
       pdf(file=paste0(
	    Call, "_",
	    Details,
	    if (length(AREA.OVERRIDES)==1)
		paste0("_", AREA.OVERRIDES,
	               if (NEAR.OVERRIDE) paste0("+", NEAR.OVERRIDE)), 
	    if (SUBTRACT.BASE) "-Base",
	    if (MONK.OVERRIDE != "both") paste0("_",MONK.OVERRIDE),
	    if (CC_INACT)
	       switch((2+INACT_TIME),"_PRE","_PERI","_POST", "_PRE+POST"),
	    if (CROSSED) switch(CLASS, "_unX", "_Xed", "_Xerr"),
	    if (CLASS & !CROSSED) paste0("_cl", CLASS),
	    if (CHRONUX) "_chronux",
	    ".pdf"))
       par(las=1, mar=c(3,3,2,2), oma=c(3,3,3,0))
       # if (CC_INACT!=1 && CC_INACT!=2 && !all(par()$mfg==1))
       if (CC_INACT!=1 && CC_INACT!=2 && (length(AREA.OVERRIDES) > 1))
          par(mfrow=c(2,2), mar=c(2,2,2,2), las=1, oma=c(3,3,3,0))
       }


    Details = gsub("_", " ", Details)

    for (AREA.OVERRIDE in AREA.OVERRIDES) { 
        if (((CC_INACT == 1) || (CC_INACT == 2)) && (AREA.OVERRIDE != "PRR"))
           next

	SUBTRACT.PASS = 1
	if (exists("MONK"))  rm(MONK)
	if (exists("NEAR"))  rm(NEAR)
	if (exists("AREA"))  rm(AREA)
	if (exists("DETAILS"))  rm(DETAILS)
	if (exists("ALIGN")) rm(ALIGN)
	source("main.r")	# Find the base, OR do the requested interval

        if (SAVE.BASE || (SUBTRACT.BASE & (ALIGN.OVERRIDE=="Target")))
	   BaseTimes = paste0("(", XtoMs(LEFT)  - WINDOW/2, " ",
		 		    XtoMs(LEFT)  + WINDOW/2, ") to (",
		 		    XtoMs(RIGHT) - WINDOW/2, " ",
		 		    XtoMs(RIGHT) + WINDOW/2, ") ms")

        if (SUBTRACT.BASE & (ALIGN.OVERRIDE=="Target")) {	# Do it now
	   if (exists("MONK"))  rm(MONK)
	   if (exists("NEAR"))  rm(NEAR)
	   if (exists("AREA"))  rm(AREA)
	   if (exists("DETAILS"))  rm(DETAILS)
	   if (exists("ALIGN")) rm(ALIGN)
	   SUBTRACT.PASS = 2		# Second time, do actual subtraction
	   source("main.r")		# Get data, subtract Base from it
	   }
	SUBTRACT.PASS = 1		# Reset back to 1st
        }

    if (!SAVE.BASE) {
     mtext(paste(Call, MONK,
		if (NEAR.OVERRIDE) paste0("+", NEAR.OVERRIDE),
		Details,
		if (SUBTRACT.BASE) "- base",
		if (Call=="Spec") AREA.OVERRIDE
		),
	  side=3, outer=T, line=0.6, cex=1.3, adj=0)

     par(las=0)
     # if (exists("LEFT")) {
        # TimeSlot = paste0( XtoMs(LEFT)  - WINDOW/2, ":",
	# 	       XtoMs(LEFT)  + WINDOW/2)
        # if (LEFT != RIGHT)
        #    TimeSlot = paste0(TimeSlot, " to ",
	# 	       XtoMs(RIGHT) - WINDOW/2, ":",
	# 	       XtoMs(RIGHT) + WINDOW/2)
        # TimeSlot = paste(TimeSlot, "ms")
        # mtext(TimeSlot, side=3, outer=T, line=1.8, cex=.8, adj=.9)
        # rm(TimeSlot)
        # }

     if (SUBTRACT.BASE) {
        mtext(BaseTimes, side=3, outer=T, line=-0.2, cex=.6, adj=1) # was line0.5,cex.8,adj=.9
        mtext(BaseTimes, side=1, line=3, outer=T, adj=0.05, cex=.8)
        }

     if (Call=="VsFreq" || Call=="Each")
        mtext("Frequency (Hz)", side=1, outer=T, line=0.8, cex=1.3)
     if (Call=="VsTime")
        mtext("Time (ms)", side=1, outer=T, line=0.8, cex=1.3)
     if (Call=="Spec")
        mtext("Coherence", side=1, outer=T, line=0.8, cex=1.3)

     if (Call=="Spec")
        mtext("Frequency (Hz)", side=2, outer=T, line=1, cex=1.3)
     if (Call=="VsFreq" || Call=="Each")
        mtext("Coherence (r)", side=2, outer=T, line=1, cex=1.3)
     if (Call=="VsFreq" && STACKS==2) {
        mtext("Saccade", side=3,line=-4.5,outer=T,adj=.4, cex=1.2)
        mtext("Reach",   side=3,line=-5.8,outer=T,adj=.4, cex=1.2, col="green")
        }

     mtext(paste(command, collapse=" "),  side=1,line=2,outer=T,adj=.9,cex=.6)
     dev.off()
     }
    }

if (length(dev.list()) > 0)
   cat("Device open\n")

if (exists("LEFT"))
   rm(LEFT,RIGHT)
rm(OVERRIDE, MONK.OVERRIDE, AREA.OVERRIDE, NEAR.OVERRIDE, ALIGN.OVERRIDE)
rm(DETAILS.OVERRIDE,SUBTRACT.BASE,SAVE.BASE)
rm(SUBTRACT.PASS,START.TIME,WINDOW,END.TIME,XtoMs,ZERO,times,STACKS,command)
if (exists("Base"))
   rm(Base)
rm(data,MONK,Details)
if (CC_INACT == 0)			# Don't do multiple times if not inact!
   break
}

rm(Call, CC_INACT, CLASS, EXPAND_YLIM, INACT_TIME, JUST_ONE,
   SEM_OF_PRE_PERI_EFFECT, SKIP_SACCADE_LINE)
rm(CHRONUX,ONLY_BLOCK_A,NO_EVOKED,AREA.OVERRIDES,COLLAPSE,MIN_COUNTS,SKIP_EARLY)
