# To combine the two controls (control-peri and experimental-pre), set
# KEEP.DATA in VsFreq.r to true, run each condition separately and save
# the saved data:

#  vi VsFreq.r
#     set  KEEP.DATA  to  TRUE
#  vi DoAll.r
#     set  CC_INACT   to     2
#     set  INACT_TIME to     0
#  source("DoAll.r")
#  KeepX     -> X.late_control
#  KeepMeans -> Mean.late_control
#  KeepSEMs  -> SEMs.late_control

#  vi DoAll.r
#     set  CC_INACT   to     1
#     set  INACT_TIME to    -1
#  source("DoAll.r")
#  KeepX     -> X.early_control
#  KeepMeans -> Mean.early_control
#  KeepSEMs  -> SEMs.early_control

#  vi DoAll.r
#     set  CC_INACT   to     1
#     set  INACT_TIME to     0
#  source("DoAll.r")
#  KeepX     -> X.experimental
#  KeepMeans -> Mean.experimental
#  KeepSEMs  -> SEMs.experimental

S_MAP = c("gray30", "green", "red", "blue", "purple")
ONLY.BIMANUAL = -1	# F: just biman  T: all  -1: all base, bim lesion

plot(0,0, xlim=c(range(X.experimental)),
	  ylim=c(0,.3),
	  # ylim=c(0.05,.25),
	  xlab="Frequency (Hz)",
	  ylab="Coherence (r)",
	  type='n', bty='n')

if (any(X.experimental != X.early_control) |
    any(X.experimental != X.late_control))
  stop("Mismatched x's")

X = (X.early_control + X.late_control)/2
Mean.control = (Mean.early_control + Mean.late_control)/2
SEMs.control = (SEMs.early_control + SEMs.late_control)/2

for (i in 5:1) {
   if ((ONLY.BIMANUAL == 1) | (i>=4))
     lines(X, Mean.control[,i], col=S_MAP[i], lwd=ifelse(i==4||i==5, 4, 3), lty=4)
   if (ONLY.BIMANUAL & i < 4)
      next
   lines(X, Mean.experimental[,i], col=S_MAP[i], lwd=ifelse(i==4||i==5, 8, 3))
   if (i>=4) {
      segments(x, Mean.control[,i]+SEMs.control[,i],
               x, Mean.control[,i]-SEMs.control[,i], col=S_MAP[i], lwd=0.7)
      # segments(x, Mean.experimental[,i]+SEMs.experimental[,i],
               # x, Mean.experimental[,i]-SEMs.experimental[,i], col=S_MAP[i], lwd=0.7)
      }
   }
