# ReadAll.r   Read in the LFPs

verbose = F
# NORMALIZE = T		# [T]	Set in LFP.r! (sets inherit baseline to true)
EXCLUDE.MANY = F	# [F]	go align, PD and non-PD (implied by 'ALL')
EXCLUDE.ALL  = F	# [F]   go & sac aligns (PD & non-PD)
INHERIT.BASELINE = F	# [ ]	apply target aligned baseline correction to
			#       all subsequent aligns (run targ align first!)

AREA = ifelse(exists("AREA.OVERRIDE"), AREA.OVERRIDE, "PRR")
HEMI = ifelse(exists("HEMI.OVERRIDE"), HEMI.OVERRIDE, "")
MONK = ifelse(exists("MONK.OVERRIDE"), MONK.OVERRIDE, "tyr")
NEAR = ifelse(exists("NEAR.OVERRIDE"), NEAR.OVERRIDE, 2)
ALIGN = ifelse(exists("ALIGN.OVERRIDE"), ALIGN.OVERRIDE, "")
CLASS = ifelse(exists("CLASS.OVERRIDE"), CLASS.OVERRIDE, "RL")
STIMULATE = ifelse(exists("STIMULATE.OVERRIDE"), STIMULATE.OVERRIDE, 0)

if (MONK=="both")               # Try this!
    MONK = "{tyr,zen}"

if (EXCLUDE.ALL)
    EXCLUDE.MANY = T
if (NORMALIZE) {
    INHERIT.BASELINE = T
    if (ALIGN == "") {
	What_TargAlign = paste(MONK, AREA, NEAR, CLASS, collapse="")
	File_TargAlign =			# ordered list of files
	Mean_TargAlign =			# ordered list of means
	SD_TargAlign   = NULL			# ordered list of SD's
     } else {
        if (!exists("File_TargAlign"))
	   stop("Must first run target-aligned so you can normalize")
	if (What_TargAlign != paste(MONK, AREA, NEAR, CLASS, collapse="")) {
	   cat("  Mismatch: rerun target-aligned so you can normalize\n")
	   cat("  Baseline is", What_TargAlign, "\n")
	   cat(paste("  Asking for ", MONK, AREA, NEAR, CLASS, "\n"))
	   stop("Stopping")
	   }
	}
    }

System = function(command) system(paste("tcsh -c '", command, "'"), intern=T)

directory = paste0(
	AREA,
	if (NEAR>0) paste0("+",NEAR),
	"_",MONK, 
	if (STIMULATE) "_stim",
	if (ALIGN != "") "_", ALIGN,
	if (CLASS != "") "_", CLASS)
	# if (SACSPLIT) "_SacSplit_",
	# if (SACSPLIT) SPLITCODE,
	# if (AssumeLIP_PD & AREA=="LIP") "_AssumeLIP_PD")

files = System(paste0("ls data/", directory, "/data*"))
cat(length(files), "files from", directory, "\n")


# files = files[10:56]	# Want to look at subset?
# cat("DIAG: limiting files!\n")

Scan = function(...) scan(..., quiet=!verbose)


REMOVE.FILES = c("1152.2_2","1153.2_2","1034.2_2","1035.2_2")
	# Always remove these! First 2 drive weird 16-32Hz bump in
	# zen LIP raw plots. Last 2 are tyr PRR sites that drive
	# stronger contra than ipsi effect in raw plots:

REMOVE.FILES = c(REMOVE.FILES, "1299.4")	# zen PRR

if (EXCLUDE.MANY || ALIGN == "go")
   REMOVE.FILES = c(REMOVE.FILES,
	# zen PRR
	"1041.1","1044.1","1047.1","1066.1","1070.1","905.2","906.2","907.2",
	"926.2","929.2","930.2","936.1","939.1","940.1","961.2","966.1","967.1",
	"968.1","971.1",
	# tyr LIP  Some file#'s use w/ both monks, so rm'ing more than need
	"1011.2","10930.2")

if (EXCLUDE.ALL || (CLASS=="" && ALIGN == "go"))
   REMOVE.FILES = c(REMOVE.FILES,
	# zen PRR
	"1013.1","1023.1","1024.1","1025.1","1038.1","1040.1","1043.1",
	"1054.1","1056.1","1093.1","935.1","938.1","941.1","942.1","945.1",
	# tyr LIP
	"1108.1","1091.1","1301.2","907.2","935.1","945.1",
	"1036.2"
	)

if (EXCLUDE.ALL || ALIGN == "sac")
   REMOVE.FILES = c(REMOVE.FILES,
	"909.2","976.2","982.2","1005.2","1011.2","1012.3","1804.1","975.2",
	"983.2","985.2","1026.3","11040.2","1046.2","11047.2","1099.3",
	"11116.3","1803.1",
	"905.2","940.1","1013.1","1023.1","1066.1","1069.1","968.1","1128.2",
	"1248.2","1299.4","10930.2","1011.2","1045.3","1111.4","11112.4",
	"908.2","917.2","1028.4","1031.3","1032.2","1039.2","1111.4","1114.5",
	"11116.3",
	"1237.2")

if (EXCLUDE.ALL || (CLASS=="" && ALIGN == "sac"))
   REMOVE.FILES = c(REMOVE.FILES,
	# zen PRR (and tyr?)
	"1108.1","1091.1","1301.2","907.2","935.1","945.1","1036.2","1041.1",
	"1005.2","1011.2","1012.3","1026.3","1031.3","1032.2","1036.2","1039.2",
	"1038.1","906.2","936.1","939.1",
	"1041.1","1045.3","1046.2","10930.2","1099.3","1100.4","1103.1",
	"11040.2","1104.1","11047.2","1105.2","1106.1","1107.2","11112.4",
	"1111.4","11116.3","11117.2","1800.1","1801.1","1803.1","1804.1",
	"865.1","872.1","875.1","876.1","878.1","880.2","908.2","909.2","917.2",
	"975.2","976.2","981.2","982.2","983.2","985.2","992.2")

if (STIMULATE.OVERRIDE) {
   REMOVE.FILES = NULL
  # REMOVE.FILES =c(REMOVE.FILES, "1496.2","1497.2","1498.3")  # 25 µA
  # REMOVE.FILES =c(REMOVE.FILES, "1495.2","1497.2","1498.3")  # 25 µA
  # REMOVE.FILES =c(REMOVE.FILES, "1495.2","1496.2","1498.3")  # 25 µA
  # REMOVE.FILES =c(REMOVE.FILES, "1495.2","1496.2","1497.2")  # 25 µA

  REMOVE.FILES =c(REMOVE.FILES, "1495.2","1496.2","1497.2","1498.3")  # 25 µA
  REMOVE.FILES =c(REMOVE.FILES, "1495.3","1496.3","1497.3","1498.4")  # 50 µA
  # REMOVE.FILES =c(REMOVE.FILES, "1495.4","1496.4","1497.4","1498.5")  # 100 µA
   }

Found = NULL
if (length(REMOVE.FILES)) {
   cat(paste("Exclude cells:  "))
   for (i in 1:length(REMOVE.FILES)) {
      Found = grep(REMOVE.FILES[i], files)
      if (length(Found)) {
         cat(" ", sapply(	# split on each '/', take the 3rd piece
			 sapply(strsplit(files[Found],"/"), "[", 3),
	     		 substring, 6))	# drop "data_"
         files = files[-Found]
         }
      }
   cat("\n")
   }
rm(Found)

if (exists("INDI_FILE") && (INDI_FILE != ""))
   files = files[grep(INDI_FILE, files)]
   # tyr 985.2  tyr 1012!

FIRST = T

for (file in files) {
   if (verbose)
      cat("file", file, "\n")
   command = Scan(file, nlines=1, what="character")
   params  = Scan(file, skip=2, nlines=1)
   # 1: version		
   # 2: interval_begin	3: interval_end
   # 4: time start	5: time end		
   # 6: filter
   # 7: UnitOrLFP	8: UnitOrLFP2
   # 9: start freq	10: end freq	11: freq step size
   # 12: file type 
   # 13: LFP hemisphere
   # 14: start high freq 15: end hi freq  16: step size
   # 17: evoked flag
   # 18: spike limits (all, exactly mimimum)  19: spike N   20: random seed
   # 21: use chronux flag

   FROM = params[2]
   TO   = params[3]
   DURATION = TO - FROM + 1
   if (abs(TO - FROM - 1 - DURATION) > 10)	# some tolerance!
      cat("Extracted 'zero' may be wrong because bounds were redone\n")
   ZERO = -FROM
   # rm(FROM, TO)

   BANDS = (params[10] - params[9]) / params[11] + 1
   BANDS.SEQ = seq(params[9], params[10], by=params[11])

   LFP.HEMI = params[13]

   trials = Scan(file, skip=3, nlines=1)	# won't use this, probably
   times  = Scan(file, skip=4, nlines=1)		# frames, ms, whatever

   temp = Scan(file, skip=5)
   if (trials != length(temp)/(2+2*times))
      stop("Wrong data length")
   temp = matrix(temp, ncol=2+2*times, byrow=T) # Read all data

   types = temp[,2]			# string of trial types
   temp  = temp[,(3+times):(2+2*times)]	# Keep just the real data

   trialtypes = sort(unique(types))

   if (STIMULATE == 0) {
      if (CLASS == "" && length(trialtypes) != 5)
         stop("Class is -mc but there are not 5 classes")  # (stacks!)
      if (CLASS == "PN" && length(trialtypes) != 10)
         stop("Class is PN but there are not 10 classes")
    } else {
      if (CLASS == "" && length(trialtypes) != 4)
         stop("Stimulate, Class is -mc, but not 4 classes")
      if (CLASS == "PN" && length(trialtypes) != 8)
         stop("Stimulate, Class is PN but not 10 classes")
      }

   # mirror image if lfp recorded on right hemisphere
   # Can be either merge all or merge PREF and NULL
   #  So no need to swap classes; just stacks 2 & 3
   if (STIMULATE==0 && LFP.HEMI == 1) {  #0=left;1=right
      if (verbose)
         cat("Mirror data on right\n")
      if (CLASS == "") {			# Numbered by stack
         trialtypes[ trialtypes==63 ] = 640
         trialtypes[ trialtypes==64 ] = 63
         trialtypes[ trialtypes==640] = 64
       } else {				# 1:2 are 62; 3:4 are 63; 5:6 are 64 etc
         trialtypes[ trialtypes==3 ] = 50	# 1,3,5... are pref class
         trialtypes[ trialtypes==5 ] = 3	# 2,4,6... are null class
         trialtypes[ trialtypes==50] = 5
         trialtypes[ trialtypes==4 ] = 60
         trialtypes[ trialtypes==6 ] = 4
         trialtypes[ trialtypes==60] = 6
         }
      }

   if (FIRST) {
      data = matrix(0, nrow=length(trialtypes), ncol=times)
      data2 = data
      FIRST = F
      }

   if (NORMALIZE) {		# Normalize re: whole target-aligned dataset
      if (ALIGN == "") {	# Inherit the scale factors from target align
         File_TargAlign = c(File_TargAlign, file)
         Mean_TargAlign = c(Mean_TargAlign, mean(temp))
         SD_TargAlign   = c(SD_TargAlign,   sd(temp))
         }
      index_TA = grep(sub("data/[A-Za-z+0-9/_]*data_", "data_", file),
		      						File_TargAlign)
      if (length(index_TA) > 1)			# Same indices in two monks!
         if (grepl("zen", file)) {		#   Identify the monkey
            index_TA = index_TA[grep("zen", File_TargAlign[index_TA])]
	  } else 				#   Keep only that monk's files
            index_TA = index_TA[grep("tyr", File_TargAlign[index_TA])]
          
      	# Leave "data_" in the string, else "10.1" matches "210.1", "310.1", etc
      if (length(index_TA) != 1) {
          if (verbose | length(index_TA) != 0) {
	     cat("Found", length(index_TA), "of", file, "-- Skip!\n")
      	     # If want more detail:
	     # cat(index_TA, sub("data/[A-Za-z+0-9/_]*TimeLFP", "", file), "\n")
	     # print(File_TargAlign[index_TA])
	     }
          next
          }
      temp = (temp - Mean_TargAlign[index_TA]) / SD_TargAlign[index_TA]
      }

   for (tt in 1:length(trialtypes)) {
      if (exists("INDI_TRIAL") &&			# Just one trial?
	   (INDI_TRIAL != 0)) {			   	#  Want just the Nth
         TheseTrials = which(types == trialtypes[tt])	# Just one trial type
	 TheseTrials = TheseTrials[INDI_TRIAL]		#  Select N-th trial
         MeanTimeSeries = temp[TheseTrials,]		# Mean response
       } else
         MeanTimeSeries = colMeans(temp[types==trialtypes[tt],])
      
      data [tt, ] = data [tt,] + MeanTimeSeries	   # Acculmulate over all FILES
      data2[tt, ] = data2[tt,] + MeanTimeSeries^2  # Divide by filecount later
      }
   }
# Done with all files
rm(MeanTimeSeries)

#compute SEM and means
if ((length(files) == 1) &&				# Single file?
    !(exists("INDI_TRIAL") && (INDI_TRIAL != 0))) {	# NOT just one trial?
   # Redo data and data2 so that they are sum and sum of squares of TRIALS
   for (tt in 1:length(trialtypes)) {
	data [tt,] = colSums( (temp[types==trialtypes[tt],])  )
        data2[tt,] = colMeans((temp[types==trialtypes[tt],])^2)
	TrialCount = sum(types==trialtypes[tt])
        data2[tt,] = sqrt(abs(data2[tt,] - (data[tt,] * data[tt,] / 
				       	TrialCount))) / (TrialCount-1)
        data[tt,] = data[tt,] / TrialCount		# n = number of TRIALS
        }
 } else {
   data2 = sqrt(abs(data2 - (data * data / length(files)))) / (length(files)-1)
   data = data / length(files)			# n = number of FILES
   }

if (ALIGN == "") {
   baseline.align = rowMeans(data[,1:ZERO])
   data = data - baseline.align
 } else if (INHERIT.BASELINE && exists(("baseline.align")))
   data = data - baseline.align

if (verbose)
   cat("Done with read\n")

rm(Scan,temp,file,verbose,System,directory)
rm(REMOVE.FILES,FIRST,params,i)
rm(BANDS,BANDS.SEQ,DURATION)
