# LFP.r

LOWESS = 0.0002			# [0.02]
SHOW.SEM = T			# [T] Shows half ribbons for two edge cases
if (!exists("PREF.ONLY"))
   PREF.ONLY = F
YLIM = 0 # c(-80,15)		# F or c(-80,15); chg'd if NORMALIZE|INDI_TRIAL

SPECIAL = F			# [T] SEM of 2 traces (only targ-align)
INVERT = F			# Invert axes?

NORMALIZE = T			# [T] Not for indis

# Single cell: set INDI_FILE in doAll, Lowess=0.0002, SPECIAL=F, NORMALIZE=F
# Single trial: set INDI_FILE *and* INDI_TRIAL in doAll, 

if (!exists("OVERRIDE.OVERRIDE")) {
  AREA.OVERRIDE = "LIP"		# PRR, LIP
  MONK.OVERRIDE = "zen"		# tyr, zen, both
  CLASS.OVERRIDE = ""		# "" (-mc) or 'pref' 
  MEMORY.OVERRIDE = F		# Only zen, LIP
  STIMULATE.OVERRIDE = T	# 
  #SACSPLIT.OVERRIDE = 0  # 0 or 1 (not true or false!) (With 'pref' gives errs)
  #SPLITCODE.OVERRIDE = "5.1"	# "3.1" or "12.1", for examples
  ALIGN.OVERRIDE = ""	# ""(target), "end"(cue), "gocue", "go", "sac" or "EOT"
  NEAR.OVERRIDE = 0		# [0,1.25]
  HEMI.OVERRIDE = ""		# L, R, LL, or RR
  }

if ((PREF.ONLY==T) && (CLASS.OVERRIDE!="PN"))
   warning("Cannot show preferred direction only unless select CLASS 'PN'")

if (exists("INDI_TRIAL") & INDI_TRIAL != 0) {
   LOWESS = 0.0002
   PREF.ONLY = T
   NORMALIZE = 0
   SHOW.SEM = F
   SPECIAL  = F
   use.rows = c(1,3,5,7,9)	# 1,3,5,7,9 are pref 
   }

source("ReadAll.r")	# extended -- merged across all classes, just 1 delay

if (length(dev.list()) > 0)
   cat(length(dev.list()), "devices open\n")

S_MAP = c("black", "green", "red", "blue", "purple",	# stack map
	  "orange")				# If SacSplit!
T_MAP = adjustcolor(S_MAP, alpha.f=.2)

pdf(paste0("Raw",
	   switch(1+NORMALIZE, "Abs", ""),
	   "LFP_",AREA.OVERRIDE,
	      if (NEAR.OVERRIDE) paste0("+", NEAR.OVERRIDE),
	      "_",MONK.OVERRIDE,
	      if (ALIGN.OVERRIDE != "") "_", ALIGN.OVERRIDE,
	      # if (SACSPLIT.OVERRIDE) paste0("SacSplit_", SPLITCODE.OVERRIDE),
	      if (PREF.ONLY) "_Pref",
	      if (CLASS.OVERRIDE != "") "_", CLASS.OVERRIDE,
	      ".pdf"))

# Set up the plot
par(las=1, oma=c(1.5,0,1.5,0), xpd=NA)

if (NORMALIZE)				# Cannot do this until after 'Read'
   if (CLASS == "PN") {
      YLIM = if (SPECIAL) c(-1.5,.2) else c(-1.1,.1)
    } else
      YLIM = c(-.9,0.2)
if (YLIM[1] == 0) {
    YLIM = range(data)
    if (SHOW.SEM)
       YLIM = range(c(data+data2,data-data2))
    }
if (exists("use.rows"))			# single trial
    YLIM = range(data)
if (INVERT)
    YLIM = rev(YLIM)

plot(0,0, xlim=c(FROM,TO), ylim=YLIM,
	ylab=paste("Evoked LFP", if (NORMALIZE) "(normalized units)"),
	axes=!SPECIAL, xlab="",
	bty='n',type='n', lwd=2)

if (SPECIAL) {
   if (ALIGN == "") {
      axis(1, at=c(-500,-250,0, 250,500, 750,1000), 
	 labels=c("-500","","0","","500","","1000"))
    } else
      axis(1, at=c(-250,0,250), labels=c("","0",""))
   axis(2, at=c(0,-.5,-1), labels=c("0","","-1.0"))
 } else {
   if (ALIGN == "") {
      axis(1, at=c(1000,1250), labels=F)
    } else
      axis(1, at=c(-500,-250,250,500), labels=F)
   }

# If pref only, skip the null rows
# If go-align,  skip saccade tasks
if (!exists("use.rows"))
   use.rows = 
	   if (ALIGN == "go") {
   	    if (PREF.ONLY) c(3,5,7,9) else if (CLASS=="PN") c(3:10) else 2:5
	   } else
   	    if (PREF.ONLY) c(1,3,5,7,9) else 1:length(trialtypes)

if (SHOW.SEM) {
   LateMeans = rowMeans(data[,((TO-FROM)*.6):((TO-FROM)*.8)])
   LateMeanOrder = order(LateMeans)
   LateMeanOrder = LateMeanOrder[LateMeanOrder %in% use.rows]
   }

X = FROM:TO
for (i in use.rows) {
    Lowess = if (LOWESS) lowess(X, data[i,], f=LOWESS) else cbind(X,data[i,])

    lines(Lowess,
	 col=if (CLASS=="") S_MAP[i] else S_MAP[(i+1)%/%2],
  	 lty=ifelse(CLASS=="PN", 2-(i%%2), 1), 
	 lwd=2)

    #  Show SEM for the smallest and largest values
    if (SHOW.SEM)
     if (i == LateMeanOrder[1] || i == LateMeanOrder[length(LateMeanOrder)]) {
      LowessSEM = lowess(X, data2[i,], f=LOWESS)
      x0 = Lowess$x
      y0 = Lowess$y
      x1 = LowessSEM$x
      y1 = LowessSEM$y

      polygon(c(x0, rev(x0)),
            # c(y0+y1, rev(y0-y1)),
            if (i==LateMeanOrder[1])	# 1st (lowest value)
            	c(y0, rev(y0-y1))	#  Show just mean - SEM
	       else			# last (largest value)
            	c(y0+y1, rev(y0)),	#  Show just mean - SEM
	    density=-1, border=NA,
	    col=if (CLASS=="") T_MAP[i] else T_MAP[(i+1)%/%2])
      }
    }

Bottom     = par()$usr[3]
NearBottom = Bottom + (par()$usr[4] - par()$usr[3])/50	#  2% up
MarkHeight = Bottom + (par()$usr[4] - par()$usr[3])/(3+7*SPECIAL) # 33/10% up

segments(0,    NearBottom,
	 0,    MarkHeight, lwd=3, xpd=F)
segments(1257, NearBottom,
	 1257, MarkHeight, lwd=3, xpd=F)

text(30,   NearBottom, 
     switch(ALIGN,  gocue="Cue", go="Move", sac="Saccade", "Target"),
     adj=c(0,0), cex=1)

if (ALIGN=="")
     text(1225, NearBottom, "Earliest go cue", adj=c(1,0), cex=1)

title(xlab=paste("Time (ms re:",
	switch(ALIGN, gocue="go cue", go="movement", sac="saccade", "target"),
		 "onset)"),
      cex.sub=1.5, cex.lab=1.5)

for (i in 1:5)
   if (STIMULATE) {
      mtext(c("32 Sac + stim", "35 Same + stim", "62 Saccade", "65 Same")[i],
	side=3, line = 1-(i*1), outer=T, at=.82, adj=0, col=S_MAP[i])
    } else
      mtext(paste(61+i,
	       c("Saccade", "Ipsi arm", "Contra arm", "Same", "Opposite"
		 #if (SACSPLIT) "Opp:1" else "Opposite",
		 #if (SACSPLIT) "Opp:2"
		 ))[i],
	side=3, line = 1-(i*1), outer=T, at=.82, adj=0, col=S_MAP[i])

mtext(paste(ifelse(MONK=="{tyr,zen}","both",MONK),
	    AREA, if (NEAR) paste0("+",NEAR), CLASS, 
	    # MEMORY.OVERRIDE, 
	    if (STIMULATE.OVERRIDE) "stimulation",
	    # if (SACSPLIT) paste0("Split by sac:", SPLITCODE), 
	    ALIGN),
      outer=T, side=3, line=-1, adj=.5, cex=1.6)

mtext(paste(" ",			# Prevent 'zero length text' error
	    if (PREF.ONLY) "Pref only",
	    if (LOWESS > 0.005) paste0("(smooth=", LOWESS, ")"),
	    if (NORMALIZE) "normalized"),
      outer=T, side=3, line=-2, adj=.5, cex=0.8)

if (exists("INDI_FILE") && (INDI_FILE != "")) {
   mtext(paste0("Unit ", sub(".*data_", "", files),
	    if (exists("INDI_TRIAL") && INDI_TRIAL) 
		paste0(", trial ", INDI_TRIAL)),
      side=1, line=0, outer=T,adj=0.1,cex=1.3)
 } else
   mtext(paste(length(files), "units"), side=1, line=0, outer=T,adj=0.1,cex=1.3)
mtext(paste(command, collapse=" "),  side=1, line=-1, outer=T, adj=.95, cex=.6)
mtext(paste(if (SHOW.SEM) "SHOW.SEM",
	    if (EXCLUDE.MANY) "EXCLUDE.MANY",
	    if (EXCLUDE.ALL) "EXCLUDE.ALL",
	    if (INHERIT.BASELINE) "INHERIT.BASELINE",
	    if (PREF.ONLY) "PREF.ONLY"
	    ), side =1, line=0, outer=T, adj=.95, cex=.6)

dev.off()
if (SHOW.SEM) rm(LateMeans, LateMeanOrder,LowessSEM,x0,y0,x1,y1)
rm(LOWESS,SHOW.SEM,PREF.ONLY,YLIM)
rm(i,S_MAP,X,Bottom,NearBottom,MarkHeight,Lowess,T_MAP,use.rows)
# From ReadALL
rm(ALIGN,AREA,MONK,NEAR,CLASS,HEMI,command)
rm(TO,data,data2,ZERO,trials,files,trialtypes,FROM,times,types)
rm(NORMALIZE, EXCLUDE.MANY, EXCLUDE.ALL, INHERIT.BASELINE)
