# analyze

REREAD = T
ZSCORE = F

files = system("ls data/LIP+2_zen_stim", intern=T)
files = paste0("data/LIP+2_zen_stim/", files)

files = files[c(1,4,7,10)+2]

if (REREAD)
  for (file in files) {

   Rows = as.numeric(system(paste(
   	"grep '^[0-9]* [0-9]*$'",
   	file,
    	"| wc -l"), intern=T))
   
   a <- scan(file, skip=4, quiet=T)
   points <- scan(file, skip=3, nlines=1, quiet=T)
   b <- matrix(a, nrow=Rows, byrow=T)
   
   First = which(abs(a) > 1)[4]
   
   a32 = colMeans(b[b[,2]==32,])
   a35 = colMeans(b[b[,2]==35,])
   a62 = colMeans(b[b[,2]==62,])
   a65 = colMeans(b[b[,2]==65,])
   
   
   a32 = a32[First:(First+points-3)]
   a35 = a35[First:(First+points-3)]
   a62 = a62[First:(First+points-3)]
   a65 = a65[First:(First+points-3)]
   
   if (file == files[1]) {
      m32 = m35 = m62 = m65 = rep(0, length(a32))
    }
   m32 = m32 + a32
   m35 = m35 + a35
   m62 = m62 + a62
   m65 = m65 + a65

   a32 = a32[1:500]
   a35 = a35[1:500]
   a62 = a62[1:500]
   a65 = a65[1:500]
   
#   plot(0,0, xlim=c(1,500), ylim=range(c(a32,a35,a62,a65)),
#   			ylab="voltage", xlab="Time(ms)", type='n')
#   lines(1:500, a32[1:500], col="gray")
#   lines(1:500, a35[1:500], col="green")
#   lines(1:500, a62[1:500], col="red")
#   lines(1:500, a65[1:500], col="blue")
   }

m32 = m32 / length(files)
m35 = m35 / length(files)
m62 = m62 / length(files)
m65 = m65 / length(files)

if (ZSCORE) {
   m32 = m32 - mean(m32[-(990:1020)])
   m35 = m35 - mean(m35[-(990:1020)])
   m62 = m62 - mean(m62)
   m65 = m65 - mean(m65)
   }

plot(0,0, xlim=c(1,2000), ylim=if (ZSCORE) c(-550,600) else c(-225,105),
   			ylab="voltage", xlab="Time(ms)", type='n')
lines(m32, col="gray", lwd=3)
lines(m35, col="green", lwd=3)
lines(m62, col="red", lwd=3)
lines(m65, col="blue", lwd=3)
