# ReadAllNear.r
#   In case you have read in a different dataNearBase!


# Set basic/default parameters #
########################

if (NEAR==0)
   return

cat("Reading in standard dataNearBase for 'Near'\n")

a = b = NULL
if (MONK=="zen" || MONK=="both") {
   a = read.table("/data/coord/zen/zenunits",
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   a = cbind(a, monk="zen")		# Append monkey name (as a column)
   }
if (MONK=="tyr" || MONK=="both") {
   b = read.table("/data/coord/tyr/tyrunits",
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
   }
NearBase = rbind(a,b)			# Required for 'both'
rm(a,b)

# ADD TO A FILE THAT IS CALLED EVERYWHERE THAT THE DATA BASES ARE READ!!!
NearBase[NearBase==""] = NA			# Else there are blanks!!!
NearBase[is.na(NearBase[,"pd1"]), "pd1"] = 0
NearBase[is.na(NearBase[,"pd2"]), "pd2"] = 0
NearBase[is.na(NearBase[,"pd3"]), "pd3"] = 0
NearBase[is.na(NearBase[,"pd4"]), "pd4"] = 0

NearBase[is.na(NearBase[,"area1"]), "area1"] = "?"
NearBase[is.na(NearBase[,"area2"]), "area2"] = "?"
NearBase[is.na(NearBase[,"area3"]), "area3"] = "?"
NearBase[is.na(NearBase[,"area4"]), "area4"] = "?"
