# Nearest.r
	# Includes hemisphere and monkey info

#  Absolute value of NEAR is the criterion distance
#  NEGATIVE value means exclude the originals - give JUST the added ones

# Warning: some LIP/PRR do not have depths, so will not be in LIP & PRR

#  If we append only a single monkey as a last column, then 'base' seems
#    to not inherit the name.  I don't get it, but I think it's ok; some
#    quirk of using factors and (ugh) read.table()!

verbosE = F

# if (!exists("base"))
#   source("/data/coord/grab/ReadAllNear.r")

L = length(base[,1])				# Number of runs

# Each: cell, channel, ML, AP, depth, hemi, monk
each = matrix(NA, ncol=7, nrow= 4*L)		# 4 chans/run, so 4 times 'L'
areas = rep(NA, 4*L)				# What area?

Criterion = abs(NEAR)				# Inherit from calling function
ExcludeOriginals = NEAR < 0			#  if negative, just new ones

# Build 'each':  cell channel area ml ap depth hemisphere monkey
for (channel in 1:4) {
   each[(channel-1)*L + (1:L),] = 
	cbind(
		base[,"reach_file"], 
		channel, 
		base[,paste0("ml",channel)],
		base[,paste0("ap",channel)],
		base[,paste0("depth",channel)],
		base[,paste0("hem",channel)],
		base[,"monk"]
		)
   areas[(channel-1)*L + (1:L)] = base[, paste0("area",channel)]
   }

colnames(each) = c("cell", "channel", "ml", "ap", "z", "hemi", "monk")

# Decode coordinates into true locations
#      Remove 'M', 'L', 'P', 'A'
each[,"ml"] = paste(ifelse(substring(each[,"ml"],1,1)=="M", "-", ""),
		    substring(each[,"ml"], 2), sep="")
each[,"ap"] = paste(ifelse(substring(each[,"ap"],1,1)=="P", "-", ""),
		    substring(each[,"ap"], 2), sep="")

#  Deal with all the different 'NA' entry types
each[each=="NANA"] = NA
each[each=="?"] = NA
each[each=="????"] = NA
each[each=="0000"] = NA
each[each=="0"] = NA
each[each==""] = NA

each[,"hemi"] = 
	ifelse(each[,"hemi"]=="L",  0, 
	ifelse(each[,"hemi"]=="R",  1, 
	ifelse(each[,"hemi"]=="RR", 2,
	ifelse(each[,"hemi"]=="LL", 4,
				    -1))))

each[,"monk"] = ifelse(each[,"monk"]=="tyr",0,ifelse(each[,"monk"]=="zen",1,-1))

bad = apply(each, 1, function(x) any(is.na(x)))
each[ bad, 6:7] = -1	#
each[ bad, 2:5] = NA	# any is NA? -> all NA!

each = apply(each, 1:2, as.numeric)	# apply: as.numeric coerces to a vector!

#  5 maps to 4.5 mm, and -5 maps to -4.5 mm
each[,c("ml","ap")] = 
	sign(each[,c("ml","ap")]) * (abs(each[,c("ml","ap")]) - .5)

LIP = each[ areas=="LIP", ]		# Pull out just the LIPs
PRR = each[ areas=="PRR", ]		# Pull out just the PRRs

Distance = function(x1, x2) {
		sqrt(((x1[,1]-x2[1])^2 + (x1[,2]-x2[2])^2 + (x1[,3]-x2[3])^2))
	}

minL = rep(1000, length(each[,1]))
if (length(LIP))			# Should be (LIP[,1]) ?
  for (i in 1:length(LIP[,1])) {
     # compute distance from each i'th cell to each known LIP cell
     distance = Distance(each[,c("ml","ap","z")], LIP[i,c("ml","ap","z")])

     # if the i'th cell is a different monkey or different hemisphere than
     #  the LIP cell to which it is being compared, set the distance to NA
     distance[ LIP[i,"monk"] != each[,"monk"] ] = NA
     distance[ LIP[i,"hemi"] != each[,"hemi"] ] = NA

     # find the closest distance from each i'th cell to a known LIP cell
     minL = pmin(distance, minL, na.rm=T)
     }
     
minP = rep(1000, length(each[,1]))
if (length(PRR)) {			# Should be (PRR[,1]) ?
 for (i in 1:length(PRR[,1])) {
     distance = Distance(each[,c("ml","ap","z")], PRR[i,c("ml","ap","z")])
     distance[ PRR[i,"monk"] != each[,"monk"] ] = NA
     distance[ PRR[i,"hemi"] != each[,"hemi"] ] = NA
     minP = pmin(distance, minP, na.rm=T)
     }
}

if (any(minL<=Criterion & minP<=Criterion)) {
   NearBoth = (minL<=Criterion & minP<=Criterion) # & (minL>0 & minP>0)
	# Include those already labelled; want to clear those distances, too
	#  (e.g., if minP for an LIP cell is small, want to set it high)
	#  (else could get reclassified as a PRR cell!)
   if (verbosE)
      cat(sum(NearBoth), "sites within", Criterion, "mm of both LIP & PRR\n")
   minL[NearBoth] = 10000
   minP[NearBoth] = 10000
   rm(NearBoth)
   }

# Convert those close to area, not already that area, not already the other area
if (verbosE)
   cat("Converting", sum(minL <= Criterion & minL > 0), "to LIP, and",
		     sum(minP <= Criterion & minP > 0), "to PRR\n")

for (channel in 1:4) {

   index = (channel-1)*L + (1:L)
   Area = paste0("area", channel)

   if (ExcludeOriginals) {
       LIP.orig = base[,Area] == "LIP"
       LIP.orig[is.na(LIP.orig)] = F
       PRR.orig = base[,Area] == "PRR"
       PRR.orig[is.na(PRR.orig)] = F
       }
   base[,Area] = ifelse((minL[index]<=Criterion) & (minL[index]>0),
					       	"LIP", base[,Area])
   base[,Area] = ifelse((minP[index]<=Criterion) & (minP[index]>0),
					       	"PRR", base[,Area])
   if (ExcludeOriginals) {
       base[LIP.orig, Area] = "LIP.ORIG"
       base[PRR.orig, Area] = "PRR.ORIG"
       }
   }

rm(L,each,areas,Criterion,ExcludeOriginals,index,Area,minL,minP,bad,LIP,PRR)
rm(Distance,distance, verbosE)
