/* FILE userio */
     /* Major user interaction with program	*
	Title			(Interactively) get title & print it	
	ChooseReg		(Interactively) get reg # from user
	vtprint			Print string on text ('vt100') screen

 * ******************************************************************** */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <setjmp.h>				/* Return from signals	*/
#include <string.h>
#include "defs.h"				/* #defines & macros	*/

/* ******************************************************************** */

/* FUNCTION Title */
	 /* Interactively get (up to MAX_LINES lines of) title	*/
void Title(char *cmd) {
#	define MAX_LINES	8
	char title[MAX_LINES][255];
	static int  center;
	int AddHeight = 0;
	int SaveFirstLine = 0;
	int i;

	if (*cmd != 0)
	   strcpy(title[0], cmd);
	else
	   inputs("Title> Centered or Left-justified [CL?]: ", title[0]);
	switch (title[0][0]) {
	   case '':	return;
	   case 'C':
	   case 'c':	center = 1; break;
	   case 'L':
	   case 'l':	center = 0; break;
	   case '?':
		fputs("Title> Enter C for centered, L for on left", stderr);
		break;
	   default:
		if (Status & COMMAND_MODE) {	/* Default for cmd mode	*/
		   center = 0;			/* On the left		*/
		   AddHeight = 125;		/* Way up high		*/
		   SaveFirstLine = 1;		/* Don't overwrite line	*/
		   break;
		   }
	   	fputs("  Title> Enter each line of title sequentially\n", stderr);
	   	fputs("  Title> When through, enter blank line\n",        stderr);
		fputs("  Title> To abort, enter ESC as entire subtitle\n",stderr);
		Title(cmd);
		return;
	   }
	if (!(Status & COMMAND_MODE))
	   fputs("Enter title:  (ESC to quit, empty line to print", stderr);
	for (i=SaveFirstLine; i<MAX_LINES; i++) {
	   inputs(" ", title[i]);
	   if (title[i][0] == '')
	      return;
	   if (title[i][0] == NONE)
	      break;
	   }
	for (i=0; (i<MAX_LINES && title[i][0]!=NONE); i++) {
	   GraphFontSize((i==0)? 16:12);
	   if (!((title[i][0]=='.' || title[i][0]=='_') && title[i][1]==0))
	      GraphText(			/* Skip if just a dot alone */
		(center==0) ?
	   	   1 :
		   ScreenWidth()/2 - (int)(5.5*(int)(int)strlen(title[i])),
		ScreenHeight() + AddHeight - 30*i - 15,
		title[i]);
	   }
	if (AddHeight) {		/* If special title, add date	*/
#	   ifdef DIAG /* Replace with call to time() */
	   move(1, 1);
	   GraphFontSize(10);
	   system("date | sed 's/... //' | sed 's/:[0-9][0-9] [PE][SD]T//'");
	   GraphFontSize(12);
#	   endif
	   }
	GraphFontSize(12);
	return;
	}
/* ********************************************************************	*/

/* FUNCTION ChooseReg */
	 /* Prompt for and return a reg number				*/
int ChooseReg(char *p, int dfault, char *CmdLine) {
/* char *p;					 * Points to ask line	*/
/* int dfault;					 * Default return value	*/
/* char *CmdLine;				 * \0 or proper reg #	*/

  int  i;					/* Cntr			*/
  char newnumber[255] = "?";			/* User entered number	*/

if ( 			/* (*CmdLine != NONE)	 * File was on cmd line	*/
    isdigit(CmdLine[0]) || 
   (isspace(CmdLine[0]) && isdigit(CmdLine[1])) ||
   (isspace(CmdLine[0]) && isspace(CmdLine[1]) && isdigit(CmdLine[2]))
   ) {
   if (!(Status & COMMAND_MODE))
      fprintf(stderr,"   %s: %2d\n",p,atoi(CmdLine));
   return(atoi(CmdLine));
   }
/* Not verbose */

START:
if (!(Status & COMMAND_MODE))
   fprintf(stderr,">  %s: [%2d]   ",p,dfault);
inputs("",newnumber);			/* Read as string	*/

if (newnumber[0] == NONE)			/* IE, nothing entered	*/
   return(dfault);

for (i=0;i<(int)(int)strlen(newnumber);i++)	/* Each char received:	*/
   if (!isdigit(newnumber[i])) {		/*  Is it a digit?	*/
      ListReg();
      goto START;				/*  Ask again		*/
      }
return(atoi(newnumber));			/* Convert ascii->int 	*/
}
/* END FUNCTION ChooseReg */
/* ******************************************************************** */

/* FUNCTION vtprint */
	 /* Print string on vt100 (text-emulating) terminal screen	*/
void vtprint(char *string) { fprintf(stderr,"%s\n",string); }
/* END FUNCTION vtprint */
/* ******************************************************************** */
