/* FILE termdef */
     /* Terminal (vt100, Xwindow) instructions	*/
     /* Stderr: user interface; stdout: graphics	*/

#include <stdio.h>

/* ************************   VT100 (TEXT) ***************************	*/
/* Erasing	*/
#define Erase_ToBottom		fputs("\033\1330J",	stderr)
#define Erase_FromTop		fputs("\033\1331J",	stderr)
#define Erase_Screen		fputs("\033\1332J",	stderr)
#define Erase_ToEOLN		fputs("\033\1330K",	stderr)
#define Erase_FromStartOfLine	fputs("\033\1331K",	stderr)
#define Erase_Line		fputs("\033\1332K",	stderr)

/* Cursor movement */
#define Cursor_Status		fputs("\033\1336n",	stderr)
#define Move_Home		fputs("\033\133f",	stderr)
#define Save_Cursor		fputs("\033\133s",	stderr)
#define Restore_Cursor		fputs("\033\133u",	stderr)
#define Move_Up(y)		fprintf(stderr, "\033\133%dA", y)
#define Move_Down(y)		fprintf(stderr, "\033\133%dB", y)
#define Move_Forward(y)		fprintf(stderr, "\033\133%dC", y)
#define Move_Back(y)		fprintf(stderr, "\033\133%dD", y)
#define Move_To(y,x)		fprintf(stderr, "\033\133%d;%d;f",  y,x)
#define Move_Line(y)		fprintf(stderr, "\033\133%d;1;f",   y)
#define Move_Column(x)		fprintf(stderr, "\033\1331;%d;f",   x)

/*  Can't quite get these to work *
#define Bold			fputs("\033[0;1", stdout);
#define Reverse_video		fputs("\033[0;7", stdout);
#define Attribute_off		fputs("\033[0"  , stdout);
*/
