/* FILE Stack */
     /* Deal with event stack in header */
#include "array.h"			/* Access register's stacks	*/
#include "defs.h"
#include "stack.h"			/* Header and stack variables	*/
#include "_imports/event.i"		/* For StackDump	*/
/* ********************************************************************	*/
     /*
      * SaveStackAt	Copy header stack to a SaveStack
      * UseStack	Set SaveStack to Extract from
      * CopyStack	From one register to another
      * StackDump	Print out the stack (UseStack() sensitive)
      * StackExtract	Obtain value or time associated w/ specific event
       * Functions to avoid including event.h in lots of places:
      * Get_Start_Time_From_Stack	load.c
      */
/* ********************************************************************	*/

static int CurrentStack = 0;
static EVENT *CurrentStackPtr = (EVENT *) Register[0].stack;

/* ********************************************************************	*/
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION SaveStackAt */
	 /* Save a header stack in the register structure	*/
void SaveStackAt(int reg) {
EVENT *From = (EVENT *) Header_stack();
EVENT *To   = (EVENT *) Register[reg].stack;
EVENT *End  = (EVENT *) Header_stack() + MAX_EVENTS;

if (ProofReg(reg) == FAIL)
   return;
while (From < End  &&  From->type) {
    To->time = From->time;
    To->type = From->type;
    To->one = From->one;
    To->two = From->two;
    To->three = From->three;
    From++, To++;
    }
if (To < End) {				/* End of stack	*/
   To -> type = 0;
   if (++To < End)				/* Insurance	*/
      To -> type = 0;
   }
 }
/* ********************************************************************	*/

/* FUNCTION UseStack */
	 /* Which reg to stack-extract from */ 
	 /* Not true? Commmented out LHS 2014-20-31: If <0, use header stack */
void UseStack(int reg) {
   if (ProofReg(reg) == FAIL)
      return;
   CurrentStackPtr = (EVENT *) Register[reg].stack;
   CurrentStack = reg;
}
/* ********************************************************************	*/

/* FUNCTION CopyStack */
	 /* From reg 'from' to reg 'to' */
void CopyStack(int from, int to) {
EVENT *From = (EVENT *) Register[from].stack;
EVENT *To   = (EVENT *) Register[to  ].stack;
EVENT *End  = (EVENT *) Register[from].stack + MAX_EVENTS;

if (ProofReg(from) == FAIL || ProofReg(to) == FAIL)
   return;
while (From <= End  &&  From->type) {
    To->time = From->time;
    To->type = From->type;
    To->one = From->one;
    To->two = From->two;
    To->three = From->three;
    From++, To++;
    }
if (To < End) {				/* End of stack	*/
   To -> type = 0;
   if (++To < End)				/* Insurance	*/
      To -> type = 0;
   }
}

/* ********************************************************************	*/

/* FUNCTION StackDump */
	 /* Print the current stack in Columns columns	*/

#define Columns 2

void StackDump(void) {
    EVENT *Ptr = CurrentStackPtr;
    int i = 0;
    int col, rows;
    struct EVENT_INFO *Lookup;
    int entries = 0;
    int FirstEnd = 1;			/* Show end of stack only once!	*/

    fprintf(stderr, "%d.%d:\"%s\"   (register %d)",
		Register[CurrentStack].stacknumber,
		Register[CurrentStack].classnumber,
		Register[CurrentStack].stackname,
		CurrentStack);

	 while ((Ptr++)->type > 0)
	     entries++;
         rows = 1 + entries/Columns;

         for (i=0; i<rows; i++) {
	    int parameters = 0;

            fputs("\n", stderr);
            for (col=0; col<Columns; col++) {
	       Ptr = CurrentStackPtr + rows*col + i;
	       if (Ptr->type == END_STACK) {
		  if (FirstEnd) {
		     fprintf(stderr, "END");
		     FirstEnd = 0;
		     }
		  continue;
		  }

	       fprintf(stderr, "%4d", Ptr->time);

	       for (Lookup=Event_Info; Lookup->type>=0; Lookup++)
		  if (Lookup->type == Ptr->type)
		     break;
	       fprintf(stderr, " %-10.10s ", Lookup->tag);

	       if (strlen(Lookup->one) > 0) {
		  fprintf(stderr, "%-2.2s:%-4d", Lookup->one, Ptr->one);
		  parameters++;
	          }

	       if (strlen(Lookup->two) > 0) {
		  fprintf(stderr, "%-2.2s:%-4d", Lookup->two, Ptr->two);
		  parameters++;
	          }

	       if (strlen(Lookup->three) > 0) {
		  fprintf(stderr, "%-2.2s:%-4d", Lookup->three, Ptr->three);
		  parameters++;
	          }

	       if (col==0)
	          fprintf(stderr, "%*s", 7*(3-parameters), "");
	       }
            }
	 fprintf(stderr, "\n");
}
/* ********************************************************************	*/
/* FUNCTION EventMatch */
static int EventMatch(int Type, int match) {

	switch (match) {
	   case TARGET_ON + 2000:	/* Code for 'any target'	*/
		return(
		   ((Type <= TARGET_RE_9_POLAR) && (Type >= TARGET_RE_0)) ||
		   (Type == TARGET_ON_POLAR) ||
		   (Type == TARGET_SAC) ||
		   (Type == TARGET_ON));
	   default:
	   	return(Type == match);
	   }
        }
/* ********************************************************************	*/

/* FUNCTION StackExtract */
	 /* Obtain value or time assoc'd with specific event	*/
int StackExtract(int Type, int Occurrence, int What) {
   EVENT *Ptr = CurrentStackPtr;
   int    start_time = 0;
   int    i = 0;

   if (What==TIME)			/* Give time relative to TAPE_ON*/
      start_time = Get_Start_Time_From_Stack();

   if (Occurrence >= (int)'$') {
      EVENT *TOP = Ptr;
      int count = Occurrence - (int)'$'+ 1;

       while ((++Ptr)->type != END_STACK) ;               /* Find end     */
       while (--count >= 0) {
	  /* while ((--Ptr)->type != Type) */
	  while (! EventMatch((--Ptr)->type, Type))
	     if (Ptr <= TOP)
	         return(FAIL);
	  }
       goto RETURN_VALUE;
       }

   for (i=0; Ptr->type && i<MAX_EVENTS; i++, Ptr++)
       /* if (Ptr->type == Type) */
       if (EventMatch(Ptr->type, Type))
          if (--Occurrence == 0) {
             RETURN_VALUE:
	     switch (What) {
	        case TIME:  return(Ptr->time - start_time);
	        case ONE:   return(Ptr->one);
	        case TWO:   return(Ptr->two);
	        case THREE: return(Ptr->three);
	        }
	     }
   return(FAIL);
   }
/* ********************************************************************	*/

/* FUNCTION Get_Start_Time_From_Stack */
	 /* Return TAPE_ON time, or 0	*/
int Get_Start_Time_From_Stack(void) {
	EVENT *Ptr = CurrentStackPtr;
	int i;

	for (i=0; i<MAX_EVENTS; i++, Ptr++)
    	   if (Ptr->type == TAPE_ON)
	      return((int)Ptr->time);
	return(0);
	}
/* ********************************************************************	*/
