/* FILE sac.c */
     /* SetupDesaccading	User's parameter menu 			*/
     /* SetupFindSaccade	User's parameter menu 			*/
     /* DesaccadeData		Delete saccades				*/
     /* FindSaccade		Return ptr to begin,peak,end times	*/
/* ******************************************************************** */

#define VOR_PRESENT	0

#include "defs.h"				/* Misc constants	*/
#include "array.h"				/* Array declarations	*/
/* #include "sac.h" */				/* SaccadeData struct	*/

struct {					/* From sac.h		*/
  int begin;
  int peak;
  int end;
} SaccadeData;

int FindSmallSac = 0;				/* Relaxes criteria	*/
int NoSacsBeforeThis = 0; /* Indent before searching-FindSaccade() (ms)	*/
int NoSacsAfterThis = 0;  /* Don't look all the way to the end (ms)	*/
int SuppressNoSaccadeMessage = 0;	/* Don't tell us each time	*/
/* ********************************************************************	*/

int	b_offset = 30,
	e_offset = 30;
int	bU_offset = 70,
	eU_offset = 30;
int     DesaccadeType = 1;
int     MarkSaccades = 0;

/* ********************************************************************	*/

/* FUNCTION SetupDesaccading */
int SetupDesaccading(void) {
char answer[255];

PRINT_AGAIN:
#define fp(a,b) fprintf(stderr,a,b)
#define fs(a) fputs(a,stderr)
fs("Search limits:\n");
fp(" A    %-3d  Don't search earlier than ~ ms\n", NoSacsBeforeThis);
fp(" Z    %-3d  Don't search later   than ~ ms\n", NoSacsAfterThis);

fs("Deletion boundaries:\n");
fp(" b    %-3d  Delete NON-unit channels ~ ms BEFORE sac begin\n",  b_offset);
fp(" e    %-3d                           ~ ms AFTER  sac end\n",    e_offset);
fp(" B    %-3d  Delete     UNIT channel  ~ ms BEFORE sac begin\n",  bU_offset);
fp(" E    %-3d                           ~ ms AFTER  sac end\n",    eU_offset);
fp(" m    Mark saccade on screen (currently %s) [NOT IMPLEMENTED]\n",
					(MarkSaccades)? "on" : "off");
fp(" x    Desaccade exhaustively (currently %s)\n", (FindSmallSac)?"on":"off");
fs("\t(Test all 4 eye position traces with altered detection criteria)\n");
fp("\nDesaccade type (currently %d):\n", DesaccadeType); 
fs("  1   Desaccade all data (unit & non-unit)\n");
fs("  2   Desaccade only non-unit data\n");
fs("  3   Desaccade current channel only\n");
fs("  4   Desaccade current channel AND units\n");
fs("  ?   Print these lines\n");
fs("  q   Quit without desaccading\n");
fs("  g   Begin desaccading\n\n\n");
#undef fp
#undef fs

while  (1) {
   inputs(" Desac >  ", answer);
   /* if (answer[0] >= 'a' && answer[0] <= 'z')
       answer[0] += 'A' - 'a';			 * convert to upper case*/
   switch (answer[0]) {
       case 'A':    NoSacsBeforeThis = atoi(answer+1); break;
       case 'Z':    NoSacsAfterThis  = atoi(answer+1); break;

       case 'b':    b_offset  = atoi(answer+1); break;
       case 'e':    e_offset  = atoi(answer+1); break;
       case 'B':    bU_offset = atoi(answer+1); break;
       case 'E':    eU_offset = atoi(answer+1); break;

       case 'm':    MarkSaccades = !MarkSaccades; break;
       case 'x':    FindSmallSac = !FindSmallSac; break;

       case '1':
       case '2':
       case '3':
       case '4':    DesaccadeType = atoi(answer); break;

       case 'g':    return(1);
       case 'q':    return(0);

       default:	    goto PRINT_AGAIN;
       }
   }
}
/* ********************************************************************	*/

/* FUNCTION SetupFindSaccade */
void SetupFindSaccade(void) {
	fprintf(stderr, "Set exhaustive option in 'E' menu\n");
	fprintf(stderr, "Set search bounds in 'E' menu\n");
}
/* ********************************************************************	*/

/* FUNCTION DesaccadeData */
void DesaccadeData(int reg) {
   int SaveCurrentChannel = CurrentChannel;
   static int ChannelsToUse[5];
   int *Chn = ChannelsToUse;
   struct { int begin;
            int end;
          }  SacRange[300],
	    *SacPtr = SacRange;

   if (FindSmallSac) {		/* Check all possible position channels	*/
      if (RecordedChannel(OD_H))
         *(Chn++) = OD_H;
      if (RecordedChannel(OD_V))
         *(Chn++) = OD_V;
   } else
         *(Chn++) = TellCurrentChannel();	/* Use current channel	*/
   *Chn = -1;					/* Flag: end of channels*/

   for (Chn=ChannelsToUse; *Chn >= 0; Chn++) {	/* Do EACH channel	*/
      CurrentChannel = *Chn;
      while (FindSaccade(reg) != FAIL) {
         DeleteData(reg,			/* Desac this channel	*/
   	       (SacPtr->begin=SaccadeData.begin) - b_offset,
	       (SacPtr->end  =SaccadeData.end)   + e_offset);
         SacPtr++;				/*  & store sac bounds	*/
         }
      }

   if (DesaccadeType != 3)			/* Do additional chans?	*/
      while (--SacPtr >= SacRange) {
	 if (DesaccadeType != 4)
            DeleteAllData(reg, SacPtr->begin -b_offset, SacPtr->end+e_offset);
	 if (DesaccadeType != 2)
            DeleteUnitData(reg, SacPtr->begin-bU_offset, SacPtr->end+eU_offset);
         }

   CurrentChannel = SaveCurrentChannel;		/* Restore orig channel	*/
}
/* ********************************************************************	*/
/* ********************************************************************	*/
# if VOR_PRESENT
					/* MONKEY PARAMETERS:		*/
#  define OBVIOUS_SAC_VELOCITY 100.0		/* d/s: Skip fancy stuff*/
						/* Used to be 400 d/s	*/
#  define OBVIOUS_SAC_BOUNDARY	15.		/* d/s: start/end of sac*/ 
						/* Used to be   5 d/s	*/

#  define MIN_SAC_VELOCITY	23.0		/* d/s: else not a sac	*/
#  define FAST_SAC		37.0		/* For duration criteria*/

#  define SLOW_SAC_DURATION	34.0		/* ms: max for slow sac	*/
#  define MAX_DURATION		100.0		/* ms: max for any sac	*/
#  define HI_PASS		 4			/* StepMs (ms)	*/
#  define LO_PASS		32

/* NOTE: FindSmallSac  divides MIN_VEL by 2, doubles LO_PASS, and
	discards DURATION tests.  Best for fixation trials.	*/

/* FOR CATS:
	# MIN_SAC_VELOCITY	80.0
	# FAST_SAC		200.0
	# SLOW_SAC_DURATION	150.0
	# MAX_DURATION		250.0
	# HI_PASS		16
	# LO_PASS		100
*/

/* FUNCTION FindSaccade */
     /* Find FASTEST saccade in (horizontal or vertical) POSITION trace.
      *   WARNING: only looks in one or the other! *
     First, look for obvious saccades.  If nothing obvious, then:
     Use lo minus hi-pass diff; cleaner than d( dx/dt )/dt
     Saccades criteria: triphasic, with opposite-signed lobes just
     before and just after zero crossings.  This blocks velocity steps
     (VOR, OKN) from being considered saccades, although a step that
     begins/ends a trial may slip thru as a saccade.
     Uses ScratchPad (array.h).
     If (FindSmallSac), removes everything: good for fixation trials.
   */

     
int FindSaccade(int reg) {
FRAME *P;
float *At;
float *End;
float *End_Limit;
float          *MaxVelocityAt = NULL;
float           MaxVelocity;			/* Hi-est in the trial	*/
int             i;

if (ProofReg(reg) == FAIL)
   return(SaccadeData.end=SaccadeData.peak=SaccadeData.begin = FAIL);
End = ScratchPad + Register[reg].frame_count - LO_PASS*(FindSmallSac+1);
End_Limit = ScratchPad + NoSacsAfterThis;

switch (CurrentChannel) {
    case OD_H: case OD_V: case X3:
       break;
    default:
       vtprint("Is this a position channel?");
    }	

					/* CHECK FOR OBVIOUS SACCADES	*/
At = ScratchPad + HI_PASS;			/* Write pointer	*/
P  = Register[reg].channel[CurrentChannel].frame + HI_PASS-1; /*Read ptr*/
while (P++, At<End)				/* Calc abs(velocity)	*/
    *(At++) = ((P+HI_PASS)->n && (P-HI_PASS)->n)
          ?   (float)fabs(MEan(P+HI_PASS)-MEan(P-HI_PASS))/(2.*HI_PASS/1000.)
           :   0;				/* Replace NA with '0'	*/
At = ScratchPad + HI_PASS;
MaxVelocity = OBVIOUS_SAC_VELOCITY;

if (NoSacsBeforeThis)			/* Indent before searching?	*/
   if (NoSacsBeforeThis > At - ScratchPad)	/* Already enough?	*/
      At = ScratchPad + NoSacsBeforeThis;	/* Indent as requested	*/
while (++At < End) {			/* First pass: obvious sac?	*/
   if (NoSacsAfterThis)
      if (At > End_Limit)
         break;
   if ( *At > MaxVelocity)			/* Find peak velocity	*/
      MaxVelocity = *(MaxVelocityAt=At);  	/* Save peak veloc	*/
   }
if (MaxVelocity > OBVIOUS_SAC_VELOCITY) {	/* Got an obvious sac?	*/
   SaccadeData.peak  = MaxVelocityAt - &(ScratchPad[0]);
   At = ScratchPad + SaccadeData.peak - 10;
   while (--At > ScratchPad)			/* Look backwards for -	*/
      if (*At < OBVIOUS_SAC_BOUNDARY)		/*  Low velocity border?*/
	 break;
   SaccadeData.begin = At - ScratchPad;
   At = ScratchPad + SaccadeData.peak + 10;
   while (++At < End)				/* Look forward for -	*/
      if (*At < OBVIOUS_SAC_BOUNDARY)		/*  Low velocity border?*/
	 break;
   SaccadeData.end = At - ScratchPad;
   return(OK);
   }


if (FindSmallSac) {
   At = &(ScratchPad[LO_PASS*2]);	/* Use LO_PASS*2 through-out	*/
   P  = &(Register[reg].channel[CurrentChannel].frame[LO_PASS*2-1]);
   while (P++, At < End)
      *(At++) = ((P+LO_PASS*2)->n && (P+HI_PASS)->n &&
                 (P-LO_PASS*2)->n && (P-HI_PASS)->n   )
           ?  (MEan(P+HI_PASS  )-MEan(P-HI_PASS  ))/(2*HI_PASS  /1000.)
             -(MEan(P+LO_PASS*2)-MEan(P-LO_PASS*2))/(2*LO_PASS*2/1000.)
           : NoData;			/* Calc hi minus lo-pass diff	*/
 } else {
   At = &(ScratchPad[LO_PASS]);
   P  = &(Register[reg].channel[CurrentChannel].frame[LO_PASS-1]);
   while (P++, At < End)
      *(At++) = ((P+LO_PASS)->n && (P+HI_PASS)->n &&
                 (P-LO_PASS)->n && (P-HI_PASS)->n   )
           ?  (MEan(P+HI_PASS)-MEan(P-HI_PASS))/(2.*HI_PASS/1000.)
             -(MEan(P+LO_PASS)-MEan(P-LO_PASS))/(2.*LO_PASS/1000.)
           : NoData;
   }


TRY_AGAIN:
At  = &(ScratchPad[LO_PASS*(FindSmallSac+1)]);	/* Start in a ways	*/
MaxVelocity = (float)fabs(MIN_SAC_VELOCITY/(FindSmallSac+1));

if (NoSacsBeforeThis)			/* Indent before searching?	*/
   if (NoSacsBeforeThis > At - ScratchPad)	/* Already enough?	*/
      At = ScratchPad + NoSacsBeforeThis;	/* Indent as requested	*/

while (++At < End) {				/* Walk to end of reg	*/
   if (NoSacsAfterThis)
      if (At > End_Limit)
         break;
   if (*At != NoData)
      if (fabs(*At) > MaxVelocity)		/* Peak velocity?	*/
         MaxVelocity = (float)fabs(*(MaxVelocityAt=At));  /* Save peak veloc*/
   }

if (MaxVelocity <= MIN_SAC_VELOCITY/(FindSmallSac+1)) {	/* Vel criteria	*/
   if (! SuppressNoSaccadeMessage)
      vtprint("No saccade found.");
   return(SaccadeData.end=SaccadeData.peak=SaccadeData.begin = FAIL);
   }
SaccadeData.peak  = MaxVelocityAt - ScratchPad;

#define VEL_ZERO_CROSS   ((*MaxVelocityAt>0.) ? *At<0 : *At>0)

At = MaxVelocityAt;				/* Back to mid of sac	*/
while (--At > ScratchPad) 			/* Walk back to gap,	*/
   if (*At==NoData || (VEL_ZERO_CROSS))		/*  zero-cross or begin	*/
      break;
SaccadeData.begin = At - ScratchPad
		       - HI_PASS/2		/* Fix filter smear	*/
		       - 2 * FindSmallSac;	/* Bit extra if want all*/
if (SaccadeData.begin < 0)
    SaccadeData.begin = 0;

At = MaxVelocityAt;				/* Starting at peak,	*/
while (++At < End)				/* Walk forward to 	*/
   if (*At==NoData || (VEL_ZERO_CROSS))		/* Gap,zero-cross or end*/
      break;
SaccadeData.end = At - ScratchPad
		     + HI_PASS/2 		/* Filter smear	*/
		     + 2 * FindSmallSac;	/* Bit extra if want all*/
if (SaccadeData.end > Register[reg].frame_count)
    SaccadeData.end = Register[reg].frame_count;
#undef VEL_ZERO_CROSS

					/* APPLY SACCADE CRITERIA	*/
if (!FindSmallSac)				/* If not conservative,	*/
 if ((SaccadeData.end-SaccadeData.begin) >	/*  Test main-sequence:	*/
   ((MaxVelocity<FAST_SAC) ? SLOW_SAC_DURATION : MAX_DURATION)) {
    if (! SuppressNoSaccadeMessage)
       fprintf(stderr,"%d:%d Bogus saccade: %d to %d ms, %4.2f d/s\n",
		Header_Unit(), Header_Trial(),
		SaccadeData.begin,SaccadeData.end,MaxVelocity);
    for (i=SaccadeData.begin; i<=SaccadeData.end; i++)
       ScratchPad[i] = NoData;			/* Only in scratchpad	*/
    goto TRY_AGAIN;
    }
return(OK);
}
/* ********************************************************************	*/
/* ********************************************************************	*/
# else		/* VOR not present */
	/* No need to subtract the low-pass velocity first	*/
/* ********************************************************************	*/
/* ********************************************************************	*/
					/* MONKEY PARAMETERS:		*/
#  define MIN_SAC_VELOCITY	23.0		/* d/s: else not a sac	*/
#  define FAST_SAC		37.0		/* For duration criteria*/

#  define SLOW_SAC_DURATION	34.0		/* ms: max for slow sac	*/
#  define MAX_DURATION		100.0		/* ms: max for any sac	*/
#  define HI_PASS		 4			/* StepMs (ms)	*/

/* NOTE: FindSmallSac  divides MIN_VEL by 2 and discards DURATION tests.
 *  Best for fixation trials.	*/

/* FUNCTION FindSaccade */
     /* Find FASTEST saccade in (horizontal or vertical) POSITION trace.
      *   WARNING: only looks in one or the other! *
     If (FindSmallSac), removes everything: good for fixation trials.
   */

     
int FindSaccade(int reg) {
FRAME *P;
float *At;
float *End;
float *End_Limit;
float          *MaxVelocityAt = NULL;
float           MaxVelocity;			/* Hi-est in the trial	*/
int             i;

if (ProofReg(reg) == FAIL)
   return(SaccadeData.end=SaccadeData.peak=SaccadeData.begin = FAIL);
End = ScratchPad + Register[reg].frame_count - HI_PASS;
End_Limit = ScratchPad + NoSacsAfterThis;

switch (CurrentChannel) {
    case OD_H: case OD_V: case X3:
       break;
    default:
       vtprint("Is this a position channel?");
    }	


At = ScratchPad + HI_PASS;			/* Write pointer	*/
P  = Register[reg].channel[CurrentChannel].frame + HI_PASS-1; /*Read ptr*/
while (P++, At<End)				/* Calc abs(velocity)	*/
    *(At++) = ((P+HI_PASS)->n && (P-HI_PASS)->n)
          ?   (float)fabs(MEan(P+HI_PASS)-MEan(P-HI_PASS))/(2.*HI_PASS/1000.)
           :   0;				/* Replace NA with '0'	*/

TRY_AGAIN:
At = ScratchPad + HI_PASS;
MaxVelocity = (float)fabs(MIN_SAC_VELOCITY/(FindSmallSac+1));

if (NoSacsBeforeThis)			/* Indent before searching?	*/
   if (NoSacsBeforeThis > At - ScratchPad)	/* Already enough?	*/
      At = ScratchPad + NoSacsBeforeThis;	/* Indent as requested	*/

while (++At < End) {				/* Walk to end of reg	*/
   if (NoSacsAfterThis)
      if (At > End_Limit)
         break;
   if (*At != NoData)
      if (fabs(*At) > MaxVelocity)		/* Peak velocity?	*/
         MaxVelocity = (float)fabs(*(MaxVelocityAt=At));  /* Save peak veloc*/
   }

if (MaxVelocity <= MIN_SAC_VELOCITY/(FindSmallSac+1)) {	/* Vel criteria	*/
   if (! SuppressNoSaccadeMessage)
      vtprint("No saccade found.");
   return(SaccadeData.end=SaccadeData.peak=SaccadeData.begin = FAIL);
   }
SaccadeData.peak  = MaxVelocityAt - ScratchPad;

#define NEAR_ZERO   ((*MaxVelocityAt>0.) ? *At<2. : *At>-2.)

At = MaxVelocityAt;				/* Back to mid of sac	*/
while (--At > ScratchPad) 			/* Walk back to gap,	*/
   if (*At==NoData || (NEAR_ZERO))		/*  near-zero or begin	*/
      break;
SaccadeData.begin = At - ScratchPad
		       - HI_PASS/2		/* Fix filter smear	*/
		       - 2 * FindSmallSac;	/* Bit extra if want all*/
if (SaccadeData.begin < 0)
    SaccadeData.begin = 0;

At = MaxVelocityAt;				/* Starting at peak,	*/
while (++At < End)				/* Walk forward to 	*/
   if (*At==NoData || (NEAR_ZERO))		/* Gap,near-zero or end	*/
      break;
SaccadeData.end = At - ScratchPad
		     + HI_PASS/2 		/* Filter smear	*/
		     + 2 * FindSmallSac;	/* Bit extra if want all*/
if (SaccadeData.end > Register[reg].frame_count)
    SaccadeData.end = Register[reg].frame_count;
#undef NEAR_ZERO

					/* APPLY SACCADE CRITERIA	*/
if (!FindSmallSac)				/* If not conservative,	*/
 if ((SaccadeData.end-SaccadeData.begin) >	/*  Test main-sequence:	*/
   ((MaxVelocity<FAST_SAC) ? SLOW_SAC_DURATION : MAX_DURATION)) {
    if (! SuppressNoSaccadeMessage)
       fprintf(stderr,"%d:%d Bogus saccade: %d to %d ms, %4.2f d/s\n",
		Header_Unit(), Header_Trial(),
		SaccadeData.begin,SaccadeData.end,MaxVelocity);
    for (i=SaccadeData.begin; i<=SaccadeData.end; i++)
       ScratchPad[i] = NoData;			/* Only in scratchpad	*/
    goto TRY_AGAIN;
    }
return(OK);
}
/* ********************************************************************	*/
#endif    /* END of VOR not present */
