/* FILE read.c */
     /* Do most of direct reading from tape (also head.c and load.c)	*/
#include <ctype.h>
#include <fcntl.h>					/* open()	*/
#include "defs.h"
/* ******************************************************************** */
/*
	Read_trial:	  Get next trial
	Read_file:	  Get a new file
	ReRead_file:	  Start over again on this file
	Batch_read_file:  Open file when running batch
	Skip_trial:	  Move around in current file
	TrialNumber_file: Return trial #
 * ******************************************************************** */

static int  File;				/* File descriptor	*/
static int  TrialNumber = 0;
static char CurrentFileName[200];		/* File being read	*/
/* ******************************************************************** */

/* FUNCTION Read_file */
int Read_file(void) {
     if (File > 3)				/*  Close old file	*/
        close(File);			
     do {
	inputs("Data file:  ",CurrentFileName);	/* Ignores comments	*/

	while (CurrentFileName[0] == '\0')	/* Skip over empty lines*/
	    inputs("Data file:  ", CurrentFileName);

	while (strlen(CurrentFileName) > 0 &&	/* Rm trailing spaces	*/
	       isspace(CurrentFileName[strlen(CurrentFileName)-1]))
	       CurrentFileName[strlen(CurrentFileName)-1] = '\0'; 

        if ((File=open(CurrentFileName, 0)) == -1) {
	   char CmdLine[255];
	   sprintf(CmdLine, "gunzip %s", CurrentFileName);
	   system(CmdLine);
           File = open(CurrentFileName, 0);
	   }

	if (File == -1) {
           fprintf(stderr,"Cannot open file <%s>\n", CurrentFileName);
	   if (Status & COMMAND_MODE)
	      finis();
           system("ls");
	   }
     } while (File == -1 || CurrentFileName[0]=='\0');
     TrialNumber = 0;
     Init_CalibFile(CurrentFileName);
     return(Read_trial());
     }
/* ******************************************************************** */

/* FUNCTION ReRead_file */
int ReRead_file(void) {
     lseek(File, 0L, 0);			/* Start of file	*/
     TrialNumber = 0;
     return(Read_trial());
     }
/* ******************************************************************** */

/* FUNCTION Read_trial */
	 /* Read next trial */
int Read_trial(void) {
   /* UseStack(0); */	/* Already in Call_Load_Data() (2014-10-30)	*/
   if (Read_header(File)==FAIL)
      return(FAIL);
   RemoveReg(0); /* 2014-10-30: Moved here from Call_Load_Data() 	*/
   Call_Load_Data(File);			/* head.c		*/
   Do_AutoMode();
   TrialNumber++;
   return(OK);					/*   Accepted		*/
}
/* ******************************************************************** */

/* FUNCTION Batch_read_file */
	 /* Read new file (batch version of Read_file())		*/
void Batch_read_file(char newfilename[]) {
   if (File > 3)				/*  Close old file	*/
      close(File);				/* Added 4-26-2014	*/
   if ((File = open(newfilename,0)) == -1) {		/* Open file	*/
      fprintf(stderr, "Open failed (%s)", newfilename);
      finis();
      }
   strcpy(CurrentFileName, newfilename);
   Init_CalibFile(CurrentFileName);		/* Added 4-26-2014	*/
   TrialNumber = 0;
   if (Read_trial()==FAIL)
      finis();
   }
/* ******************************************************************** */

/* FUNCTION Skip_trial */
	 /* Skip over n trials */
int Skip_trial(int skip_over) {
   int target;

   if (skip_over == 0)
      return(OK);
	    
   if (skip_over < 0) {
      lseek(File, 0L, 0);			/* Start of file	*/
      skip_over += TrialNumber - 1;
      if (skip_over < 1)
	  skip_over = 1;
      TrialNumber = 0;
      }

   target = TrialNumber + skip_over;

   while (TrialNumber < target) {
      if (Read_header(File) == FAIL)
         return(FAIL);
      Skip_Data(File);
      TrialNumber++;
      }

   return(Read_trial());
   }
/* ******************************************************************** */

/* FUNCTION TrialNumber_file */
int TrialNumber_file(void) { return(TrialNumber); }
/* ******************************************************************** */
