/* FILE paint */
     /* Write/erase arbitrary lines and text	*/
/* ********************************************************************	*/

/* GLOBAL VARIABLES */
#include "defs.h"
#include "cross.h"
#include "graph.h"				/* Pixel->time&deg #defs*/
#include <ctype.h>				/* isdigit()		*/
#include <stdlib.h>				/* atof()		*/
#include <string.h>

/* ********************************************************************	*/

/* FUNCTION Paint */
	 /* Lines or text on screen.  Has independent linetype,color	*/
void Paint(char *cmdline) {
   static  int LineType    = 1;			/* Set to 1 only once	*/
   static  int Color[3]    = {0,0,0};		/* 3 components		*/
   static  int FontSize	   = 12;		/* All local versions	*/
   char   *answer;
   int     x;
   float   y;
   float   value;

switch(cmdline[0]) {
     case 'c': {				/* Change		*/
        if (cmdline[1] == 'l') {
	   LineType = atoi(cmdline+2);
	   return;
	   }

	/* All the rest are color; extra 'c' is optional */
        if (cmdline[1] == 'c') {
	   cmdline++;					/* Skip the 'c'	*/
	   }
        switch (cmdline[1]) {
	   case '=': Color[0] = -1; return;	/* Use col of gdata/chg	*/
	   case '0':
	   	Color[0] = Color[1] = Color[2] = 0; return; /* Black */
	   case '1': case 'r':
	   	Color[0] = atoi(cmdline+2); return;  	/* Set red col*/
	   case '2': case 'g':
	   	Color[1] = atoi(cmdline+2); return;  	/* Set grn col*/
	   case '3': case 'b':
	   	Color[2] = atoi(cmdline+2); return;  	/* Set blu col*/
	   case 'R':
	   	Color[1] = Color[2] = 0; Color[0] = 8; return;
	   case 'G':
	   	Color[0] = Color[2] = 0; Color[1] = 8; return;
	   case 'B':
	   	Color[0] = Color[1] = 0; Color[2] = 8; return;
	   case 'A': case 'a':				/* Monochrome	*/
	   	Color[0] = Color[1] = Color[2] = atoi(cmdline+2); return;
	   }
	 break; }
     case 't': {		/* e.g: t3 20 8: 3rd size text at (20,8)*/
	   answer = cmdline + 1;

	   if (*answer != ' ') {
	      char text_type = atoi(answer);	/* t 20 8 No font chg	*/

	      if (text_type < 5)
	          FontSize = 6 + 2*text_type;
	      else if (text_type > 4)
	          FontSize = text_type;
	      else
	          FontSize = 14;
	      answer = AtoF(answer, &(value));	/* Skip over text size	*/
	      }

	   answer = AtoF(++answer, &(value));
	   x = TimeToPix((double)value);
	   answer = AtoF(++answer, &(value));
	   y = VelToPix((double)value);
	   move(x, y);


	   if (Color[0] == -1)
	      ChangeColor();
	   else
	      ChangePaintColor(Color);
	   fontsize(FontSize);

	   ++answer;

	   /* Replace %%6 with the number of trials in register 6 */
	   { int i;
	   for (i=0; i<(int)strlen(answer); i++)
	    if (answer[i] == '%' && answer[i+1] == '%') {
	       	int reg = atoi(answer+i+2);
		char pre[255], post[255];
		int SkipChars = 2 + 1 + (reg>10) + (reg>100) + (reg>1000);
		 /*      '%%' + ones place + tens + hundreds + thous	*/

		strncpy(pre, answer, i);
		pre[i] = '\0';			/* Null terminate	*/
		strcpy(post, answer+i+SkipChars);
		sprintf(answer, "%s%d%s\n", pre, ContentReg(reg), post);
	        }
	   }

	   label(answer);
	   ChangeColor();			/* Set as per 'c' calls	*/
	   return;
	   }
     case 'l': {
	   int SaveType = Set_LineType(LineType);	/* Remember OLD	*/
	   extern int graph_bold;

	   linewidth(graph_bold);
	   if (Color[0] == -1)
	      ChangeColor();
	   else
	      ChangePaintColor(Color);
	   
	   answer = AtoF(cmdline+1, &(value));
	   x = TimeToPix((double)value);
	   answer = AtoF(++answer, &(value));
	   y = VelToPix((double)value);
	   move(x, y);

	   answer = AtoF(++answer, &(value));
	   x = TimeToPix(value);
	   answer = AtoF(++answer, &(value));
	   y = VelToPix(value);
	   cont((float)x, y);

   	   Set_LineType(SaveType);			/* Restore	*/
	   ChangeColor();			/* Set as per 'c' calls	*/
	   linewidth(2);
	   return;
	   }
      default: ;
    }				/* END switch */
} /* END FUNCTION */
/* ********************************************************************	*/

/* FUNCTION AtoF */
	 /* Put float value into value, return ptr to location in string*/
char *AtoF(char *stringptr, float *valueptr) {
	char *begin = stringptr;

	while (isspace(*stringptr))
	   if (++stringptr - begin > 20)
	      fprintf(stderr, "\nAtoF loop\n");
	*valueptr = (float) atof(stringptr);
	while (isdigit(*stringptr) || *stringptr=='-' || *stringptr=='.')
	   if (++stringptr - begin > 20)
	       fprintf(stderr, "\nAtoF loop2\n");
	return(stringptr);
}
/* ********************************************************************	*/
