/* FILE main */
     /* 		Main code of analysis program			*/

     /* OPTIONS/ARGUMENTS:  			(example)
      *   -f 		External command file	(byter -f < in.4A)
      *   file macro	Run 'macro' on 'file' 	(byter tm.1 c tm.2 s tm.3 x)
      */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <time.h>				/* time() needs it      */
#include <sys/time.h>				/* resource.h needs it	*/
#include <sys/resource.h>			/* For setrlimit call	*/
#include <setjmp.h>				/* Return from signals	*/
#include <errno.h>				/* Return from signals	*/
#include "defs.h"				/* #defines & macros	*/
#include "cross.h"
/* ******************************************************************** */

int main(int argc, char *argv[]) {
	/* int fpe(),finis(),segv();		* GOTO if hear signal	*/
	char answer[255];			/* For inputs		*/


	/* jump_buf save_env;	   * Save stuff for return from signal	*/
 	/* signal(SIGFPE, fpe);			* Catch float pt err	*/
 	/* signal(SIGINT, finis);		* ^C			*/
 	/* signal(SIGSEGV,segv);		* We're gonna die!	*/
	 {	/* Set limit on size of core dump: else clogs system!	*/
	 extern int errno;			/* see man 2 intro	*/
	 struct rlimit  our_limit;		/* see man getrlimit	*/
	 struct rlimit *our_ptr = &(our_limit);

	 our_ptr->rlim_cur = 500;		/* Max core size, bytes	*/
	 our_ptr->rlim_max = 501;
	 if (setrlimit(RLIMIT_CORE,our_ptr) != 0) {
	    fprintf(stderr, "\nErr %d in setting core limit", errno);
	    sleep(10);
	    }
	 }

 	GraphSetUp();				/* Init variables	*/
	InitLoad();

	{
	  struct timeval tmptimer ;
	  gettimeofday( &tmptimer , NULL ) ;
	  srand( tmptimer.tv_usec);   /* randomize the randomizer based on
					 time, according to LS, this should
					 better in a macro -- 1/9/06 */
	}

	while (argc>1 && argv[1][0] == '-') {	/* Parse options	*/
	   switch (argv[1][1]) {
	      case 'f':
		  Status |= COMMAND_MODE;
	   	  argv++; argc--;		/* Chew option		*/
		  if (argc > 1) {
	    	   fprintf(stderr, "Error: -f syntax is 'byter -f < filename'\n");
		   exit(0);
		     }
		  break;
	      default:
	   	  argv++; argc--;		/* Chew option		*/
		  break;
	      }
	   }					/* End option parsing	*/ 

 	if (argc > 1) {				/* Additional arguments?*/
	   Status |= BATCH_MODE;		/* Must want a batch run*/
	   while ((argc-=2) >= 0) {		/* Decrement and test	*/
	      Batch_read_file(*++argv);		/* Exits on failure	*/
	      DoMacro(*++argv);			/* Do macro		*/
	      }
	   exit(0);
	   }

	DescribeSelf();				/* First clears screen	*/
	while (Read_file() == FAIL);		/* Get new file		*/
	InitDoCmd();
	inputs("Byter > ",answer);

	while (1) {
	   /* setjmp(save_env);	*/		/* Fill save_environment*/
	   DoCommand(answer);
	   GraphFlush();			/* Insurance		*/
	   inputs("Byter > ", answer);	/* Cmd mode: won't print*/
	   }
}
/* ********************************************************************	*/
