/* FILE load.c */
     /* Lolevel read & load registers FOR "reach" files	*/

     /* FUNCTIONS:
      *   DescribeSelf:		Print constants of implementation
      *   InitLoad:		ZeroReg registers
      *   Load_Analog_Data:	Read & load analog data into register
      *   Load_Spike_Data:	Read & load spike data into register
      *   Load_Multi_Data:	Read & load multiunit data into register
      *   Load_Touch_Data:	Read or skip switch data
      *   Load_Button_Data:	Read or skip button data
      *   SizeOfTouch:		Compute touch size (based on version #)
      *   ButtonTime, ButtonValue:		DOES NOT BELONG HERE!!
      *   Set_ExcludedSpikesFlag:	Don't print at end of trial; sum up
      *   Print_ExcludedSpikesCount:	Print cumulated count now
      */

#include "defs.h"				/* Misc constants	*/
#include "array.h"				/* Array declarations	*/
#include "version.h"				/*Sets OLD_VORTEX,CALIB	*/
#include "_imports/deffs.h"			/* typedef TOUCH	*/
/* ******************************************************************** */

#define TOUCH_ON_SKIP	12 	/* Data invalid until ~ ms after touch	*/
#define TOUCH_OFF_SKIP	6 	/* Data invalid for ~ ms before release	*/

int ExcludedSpikesFlag = 0;
int ExcludedSpikesCount;
/* ******************************************************************** */

/* FUNCTION DescribeSelf */
void DescribeSelf(void) {
   if (Status & COMMAND_MODE)
      return;
   Erase_Screen;
   Move_To(1,22);fprintf(stderr,"Analysis program for WashU REACH (Update 6-21-00)");
   Move_To(2,24); fprintf(stderr,"%d registers",MAX_REGISTERS);
   Move_To(3,24); fprintf(stderr,"%d data frames per register",MAX_FRAMES);
   Move_To(4,24); fprintf(stderr,"%d channels per frame",      MAX_CHANNELS);
   Move_To(5,24); if (MINIMUM_ISI != 0.)
		     fprintf(stderr,"Max spike rate: %.0f hz",
			(MINIMUM_ISI<.05)?10000.:1000./MINIMUM_ISI);
   Move_To(9,1);
   }
/* ******************************************************************** */

/* FUNCTION InitLoad */
/* Called once; initializes the registers				*/
void InitLoad(void) {
   int i; 				/* Initializing counter	*/
   char *ZeroTag = "Last read";			/* Strcpy wants pointer	*/

   /* CurrentChannel = OD_H; */
   for (i=0;i<MAX_REGISTERS;i++)
       RemoveReg(i);
   strcpy(Register[0].tag, ZeroTag);
   }
/************************************************************************/
#define read_ (unsigned) read

/* FUNCTION Load_Analog_Data */
	 /* Read & load analog data */
/* #include "eyecal.h"				* Lookup tables	*/

#     define CONVERT(x)		((x)/20.0)	/*  AD unit = 1/20 deg	*/

int Load_Analog_Data(int Read,int Channels,int Frames) {
      					/* descriptor, bytes/frame, frames */
	 char  RawDelta[MAX_FRAMES*MAX_RECORDED_CHANNELS];
	 char *RawD = RawDelta;		/* Fast RawData access	*/
	 short  RawShort[MAX_FRAMES*MAX_RECORDED_CHANNELS];
	 short *RawS = RawShort;	/* Fast RawData access	*/
	 short    FirstFrame[MAX_RECORDED_CHANNELS];
         FRAME   *F;
	 short   *First = FirstFrame;
	 long	  SkipFrames = 0;		/* Won't fit in arrays	*/
	 int	  i,j;				/* All purpose counter	*/
	 int      rate = Header_MsPerFrame();
	 int      RecordedArm = (Header_ChairAt() == FAIL) &&
	 	              (Channels > 2);
	 int      DeltaWrite = Header_Flag(DELTA_WRITE);

   if (Header_Version() < 4 || Header_Version() > 1000)
       DeltaWrite = 1;				/* Not set in old code	*/
   Register[0].trial_count = 1;				/* Fill header	*/
   strncpy(Register[0].stackname, Header_stackname(), MAX_STACK_NAME_CHARS-1);
   Register[0].stacknumber =  Header_stacknumber();
   Register[0].classnumber =  Header_Table();
   	/* Note: Register[0].stack is never filled: never any need to	*/
   Register[0].shift = 0;				/* No shift	*/
   Register[0].frame_count = Frames * rate - (rate-rate/2);

   if (Frames == 0)			/* Fill header before you leave! */
       return(OK);

   if (Frames*rate > MAX_FRAMES) {		/* Will it all fit?	*/
      SkipFrames = (Frames*rate - (MAX_FRAMES + rate-1))/rate;
      Frames = Frames - SkipFrames;
      }

   Read_CalibFile(Header_CalibFile());		/* Get the right calib	*/

   Register[0].frame_count = Frames * rate - (rate-rate/2); /* 'Frames' chg'd?*/

   if (read_(Read,FirstFrame,Channels*sizeof(short)) != Channels*sizeof(short))
      {
      vtprint("Cannot find first data frame!");
      return(FAIL);
      }

   for (i=1; i<=Channels; i++) {
      F = &(Register[0].channel[i].frame[0]);

      F->sum   = CONVERT(((int)(*(First++)))-2048);
      F->sum2  = F->sum * F->sum;
      (F++)->n = 1;

      if (rate > 1) {			/* Fill in multiple 1 ms frames	*/
	 float save  = (F-1)->sum;
	 float save2 = (F-1)->sum2;
	 int r;
	 for (r=0; r<rate/2; r++) {	/* Shift whole thing by rate/2	*/
            F->sum   = save;
            F->sum2  = save2;
            (F++)->n = 1;
	    }
	 }
      }

   if (DeltaWrite) {
      if (read(Read, RawDelta, Channels*(Frames-1)) != 
		      		    Channels*(Frames-1)) {
         vtprint("Cannot find all behavioral data!");
         return(FAIL);
         }
    } else
      if (read_(Read, RawShort, sizeof(short)*Channels*(Frames-1)) != 
		      	       sizeof(short)*Channels*(Frames-1)) {
         vtprint("Cannot find all behavioral data!");
         return(FAIL);
         }

    if (lseek(Read, (long)Channels*SkipFrames*
		 ((DeltaWrite) ? sizeof(short) : sizeof(char)), 1) == -1) {
         vtprint("Err skipping over excess frames");
         return(FAIL);
         }

   for (j=0; j<Frames; j++) {		/* Might be one too far ??	*/
      for (i=1; i<=Channels; i++) {
         F = &(Register[0].channel[i].frame[j*rate + rate/2]);

	 if (DeltaWrite == 0) {
           F->sum = CONVERT((int)(*(RawS++))-2048);
	  } else if (RecordedArm && (i==ARM_H || i==ARM_V)) {
           F->sum = CONVERT((int)((((unsigned char)*(RawD++))-(550>>2)) << 2));
	  } else
           F->sum = (F-1)->sum + CONVERT((int)(*(RawD++))); /* Prev+delta*/

         F->sum2  = F->sum * F->sum;
         (F++)->n = 1;

         if (rate > 1) {		/* Fill in multiple 1 ms frames	*/
	    float save  = (F-1)->sum;
	    float save2 = (F-1)->sum2;
	    int r;
	    for (r=1; r<rate; r++) {
               F->sum   = save;
               F->sum2  = save2;
               (F++)->n = 1;
	       }
	    }
	 }
      }

   for (j=0; j<Frames; j++) {		/* Might be one too far ??	*/
       FRAME *HF = &(Register[0].channel[1].frame[j*rate + rate/2]);
       FRAME *VF = &(Register[0].channel[2].frame[j*rate + rate/2]);

       Do_Calibration(&(HF->sum), &(VF->sum));  /* Adjust H & V eye	*/

       HF->sum2 = HF->sum * HF->sum;	/* Fix H value		*/
       VF->sum2 = VF->sum * VF->sum;	/* Fix V value		*/

       /* Back up and correct prev values (ugh!)			*/
       if (rate > 1) {
	  float saveH  = HF->sum;
	  float saveH2 = HF->sum2;
	  float saveV  = VF->sum;
	  float saveV2 = VF->sum2;
	  int r;
	  HF--;
	  VF--;
	  for (r=1; r<rate; r++) {		/* For 'rate' frames:	*/
              HF->sum   = saveH;		/* Put in calib'd value	*/
              HF->sum2  = saveH2;		/* Square of that value	*/
              HF--;				/* And back up 1 frame	*/
              VF->sum   = saveV;		/* Put in calib'd value	*/
              VF->sum2  = saveV2;		/* Square of that value	*/
	      VF--;
	      }
	  }
      } 


   if (RecordedArm) {			/* Calib'ed value for 1st frame	*/
      Register[0].channel[ARM_H].frame[0] =
          Register[0].channel[ARM_H].frame[1];
      Register[0].channel[ARM_V].frame[0] =
          Register[0].channel[ARM_V].frame[1];
      }


   for (i=Channels+1; i<MAX_CHANNELS; i++) {
      F = &(Register[0].channel[i].frame[0]);

      Frames = Register[0].frame_count;		/* Zero out extra chans	*/
      while (--Frames > 0) {
         F->sum2 = F->sum = F->n = 0;
         F++;
         }
      }
   return(OK);
   }
/* ******************************************************************** */
#define SPIKE_CLOCK_RATE	1			/* ms per tic	*/
	/* NOTE: No other values (e.g., 0 or decimal) have been tested!	*/

/* fine DATA_TO_MS(i)	( ((i<0) ? 077777-i:i) * SPIKE_CLOCK_RATE) */
#define DATA_TO_MS(i)	(i * SPIKE_CLOCK_RATE)
#define MS_TO_FREQ(ms)	( 1000. / ms)
#define DATA_TO_FREQ(i)	MS_TO_FREQ(DATA_TO_MS(i))
#define FREQ_TO_MS(f)	(1000. / f)

/* FUNCTION Load_Spike_Data */
	 /* Raster only for channel one (zero) */
int Load_Spike_Data(int Read, int count, int spikechannel) {
			/* Descriptor, # spikes, unit channel	*/
         FRAME *F = &(Register[0].channel[
			(spikechannel==1) ? UNIT : SPIKE_2-2+spikechannel
			].frame[0]);
	 FRAME *Start = F;
#	 define MAX_SPIKES	30000
	 short    RawData[MAX_SPIKES];
	 int StartTime = Get_Start_Time_From_Stack();	    /* TAPE_ON	*/
	 int EndTime = Register[0].frame_count;
   	 float 	  freq = 0.0001;
	 int	  i;				/* All purpose counter	*/
	 int ExcludedISI = 0;			/* Count excluded spikes*/
	 int ExcludeFlag = 0;			/* Last spike excluded?	*/

   if (count >= MAX_SPIKES) {
      fprintf(stderr, "Increase 'MAX_SPIKES' in load.c (chan %d, %d spikes) ",
		      spikechannel, count);
      finis();
      }

   if (spikechannel == 1)
      for (i=0; i<MAX_FRAMES; i++)
         Register[0].spikes[i] = 0;		/* Clear raster		*/

   if (count == 0)
      goto FILL_IN_TO_END_OF_TRIAL;		/* Skip all else	*/

   if (read_(Read,RawData,count*sizeof(short)) != count*sizeof(short)) {
      vtprint("Cannot find all of unit data!");
      return(FAIL);
      }

   /* Spikes begin at time=0, analogData at TAPE_ON:  Skip early spikes	*/
    for (i=0; i<count; i++)				/* Go thru spks	*/
       if (DATA_TO_MS(RawData[i]) >= StartTime)
         break;

   if (i >= count)
      goto FILL_IN_TO_END_OF_TRIAL;

   for (; i<count; i++) {
      int ms = ((SPIKE_CLOCK_RATE==1) ?
      		RawData[i] :				/* Easy case	*/
		(int) DATA_TO_MS(RawData[i]+.5))	/* Must round	*/
	    - StartTime;				/* ms from start*/
      int PrevRaw = (i==0) ? -(MINIMUM_ISI+1) : RawData[i-1];
	   /* If 1st spike in data, put a spike a minimum ITI before it	*/

      if (ms > EndTime)
         break;

      if (i==0 || 
	 ((float) RawData[i]-PrevRaw) > MINIMUM_ISI) { /* Not spurious?*/
	 freq = DATA_TO_FREQ(RawData[i] - PrevRaw); /* New freq	*/
	 if (spikechannel == 1)
	    if (RawData[i] > 0)	/* No spike times < 0 in raster	*/
               (Register[0].spikes[ms])++; 		/* Fill raster	*/
	 ExcludeFlag = 0;
       } else if (ExcludeFlag && 	/* Previous spike(s) excluded?	*/
	 ((float)(RawData[i]-RawData[i-1-ExcludeFlag]) > MINIMUM_ISI)) {
	 /* NO exclusion if interval since last accepted spike is ok	*/
	 /* (Last accepted spike is RawData[i-1-ExcludeFlag])	*/
	 freq = DATA_TO_FREQ(RawData[i] - RawData[i-1-ExcludeFlag]);
	 if (spikechannel == 1)
	    if (RawData[i] > 0) /* No negative spike times in raster	*/
               (Register[0].spikes[ms])++; 		/* Fill raster	*/
	 ExcludeFlag = 0;
       } else {			/* Ignore spike; use prev freq	*/
	 ExcludedISI++;		/* Tally exclusions per trial	*/
	 ExcludeFlag++;		/* Set the flag			*/
	 }

      if (RawData[i] == PrevRaw) { /* Two+ in one bin?	*/
         freq = 1000;				/* Freq = 1000		*/
	 while (RawData[i] == RawData[i+1]) {	/* Maybe > 2 in one bin?*/
	    if (++i > count)			/* End of data?		*/
	       break;				/*  Leave while loop	*/
	    freq += 1000;
	    }
	 	/* Added -1 to skip borderline cases LHS 2016-09-25	*/
	 if ((F-Start) < (ms-1)) {		/* Shouldn't be!!	*/
	    fprintf(stderr, 
	     "i=%d, count=%d Raw[i]=%d [i-1]=%d ms=%d startT=%d F-Start=%ld\n",
	      i, count, RawData[i], PrevRaw,ms,StartTime, F-Start);
	    fatal("Error in multi-units - call larry!");
	    }
	 (F-1)->sum = freq;			/* Update prev bin	*/
         (F-1)->sum2 = freq * freq;		/* Update prev bin	*/
	 } 

      while ((F - Start) < ms) {			/* Subtract away*/
         F->sum = freq;
         F->sum2 = freq * freq;
         (F++)->n = 1;
	 if (F-Start >= MAX_FRAMES)		/* Reached the end	*/
	    return(OK);
         }
      }


   FILL_IN_TO_END_OF_TRIAL:
   {
   float LastISI = FREQ_TO_MS(freq);
   while ((F-Start) < Register[0].frame_count) {  /* Decay last freq	*/
      freq = MS_TO_FREQ(++LastISI);			/* Add a ms	*/
      F->sum = freq;
      F->sum2 = freq * freq;
      (F++)->n = 1;
      }
   }

   while ((F-Start) < MAX_FRAMES) {  		/* Insurance		*/
      /* if (F->n) fprintf(stderr, "THIS SHOULD NEVER HAPPEN!\n"); */
	   /* But it does!!  Why? */
      F->sum = F->sum2 = 0;			/* Should not need it!	*/
      (F++)->n = 0;
      }

   if (ExcludedISI > 20) {
      if (ExcludedSpikesFlag)
          ExcludedSpikesCount += ExcludedISI;
       else 
         fprintf(stderr,
	   "Warning: %d excluded spikes in chan %d (MINIMUM_ISI)\n", 
		ExcludedISI, spikechannel);
      }

   return(OK);
   }
/************************************************************************/

/* FUNCTION Set_ExcludedSpikesFlag */
void Set_ExcludedSpikesFlag(int value) {
   ExcludedSpikesFlag = value;
   if (ExcludedSpikesFlag)
      ExcludedSpikesCount = 0;
   }
/* FUNCTION Print_ExcludedSpikesCount */
void Print_ExcludedSpikesCount() {
   if (ExcludedSpikesCount)
     fprintf(stderr, "     %d spikes excluded\n", ExcludedSpikesCount);
   }
/************************************************************************/
# ifdef SUBSUMED_BY_LOAD_SPIKES
/* FUNCTION Load_Multi_Data */
	 /* NO RASTER FOR MULTIS!! */
int Load_Multi_Data(int Read, int count) {	/* Descriptor, # spikes	*/
         FRAME *F = &(Register[0].channel[MULTI].frame[0]);
	 FRAME *Start = F;
#	 define MAX_MULTI	30000
	 short    RawData[MAX_MULTI];
	 int StartTime = Get_Start_Time_From_Stack();	    /* TAPE_ON	*/
	 int EndTime = Register[0].frame_count;
   	 float 	  freq = 0.0001;
	 int	  i;				/* All purpose counter	*/

   if (count >= MAX_MULTI) {
      fprintf(stderr, "ARGH!  Increase 'MAX_MULTI' in load.c (%d)  ", count);
      finis();
      }

   if (count == 0)
      goto FILL_IN_TO_END_OF_TRIAL;		/* Skip all else	*/

   if (read_(Read,RawData,count*sizeof(short)) != count*sizeof(short)) {
      vtprint("Cannot find all of unit data!");
      return(FAIL);
      }

   /* Spikes begin at time=0, analogData at TAPE_ON:  Skip early spikes	*/
    for (i=0; i<count; i++)				/* Go thru spks	*/
       if (DATA_TO_MS(RawData[i]) >= StartTime)
         break;

   if (i >= count)
      goto FILL_IN_TO_END_OF_TRIAL;

   for (; i<count; i++) {
      int ms = ((SPIKE_CLOCK_RATE==1) ?
      		RawData[i] :				/* Easy case	*/
		(int) DATA_TO_MS(RawData[i]+.5))	/* Must round	*/
	    - StartTime;				/* ms from start*/
      if (ms > EndTime)
         break;
      if (i > 0)			/* Can't calc freq of 1st spike	*/
	 freq = DATA_TO_FREQ(RawData[i] - RawData[i-1]); /* New freq	*/

      if (RawData[i] == RawData[i-1]) {		/* Two+ in one bin?	*/
         freq = 1000;				/* Freq = 1000		*/
	 while (RawData[i] == RawData[i+1]) {	/* Maybe > 2 in one bin?*/
	    if (++i > count)			/* End of data?		*/
	       break;				/*  Leave while loop	*/
	    freq += 1000;
	    }
	 if ((F-Start) < ms)			/* Shouldn't be!!	*/
	    fatal("Error in multi-units - call larry!");
	 (F-1)->sum = freq;			/* Update prev bin	*/
         (F-1)->sum2 = freq * freq;		/* Update prev bin	*/
	 } 

       while ((F - Start) < ms) {			/* Subtract away*/
         F->sum = freq;
         F->sum2 = freq * freq;
         (F++)->n = 1;
	 if (F-Start >= MAX_FRAMES)		/* Reached the end	*/
	    return(OK);
         }
      }

   FILL_IN_TO_END_OF_TRIAL:
   {
   float LastISI = FREQ_TO_MS(freq);
   while ((F-Start) < Register[0].frame_count) {  /* Decay last freq	*/
      freq = MS_TO_FREQ(++LastISI);			/* Add a ms	*/
      F->sum = freq;
      F->sum2 = freq * freq;
      (F++)->n = 1;
      }
   }
   return(OK);
   }
#endif
/************************************************************************/
/* FUNCTION SizeofTouch */
	 /* Use version number */
int SizeofTouch() {
   switch (Header_Version()) {
      case 6:	/* Is 6 the same as 4? */
      case 4:	return(sizeof(ARMDATA));

      case 3:	return( (Header_Flag(NEW_TOUCH)) ?
	    			sizeof(ARMDATA) : sizeof(ARMDATA_OLD));
      case 10275:
      case 2:	return(sizeof(short));

      case 1:	return(sizeof(TOUCH));

      default:	if (Header_Year()>2000)
      		   return(sizeof(short));
		 else {
		   fprintf(stderr, "What's the touch size?\n");
		   return(0);
		   }
      }
    }
/************************************************************************/
/* FUNCTION Load_Touch2_Data */
int Load_Touch2_Data(int Read, int count2) {	/* descrptr,# switches	*/
	/* Eventually use a flag to the first Load_Touch */
      if (lseek(Read, count2*SizeofTouch(), 1) == -1) {
         vtprint("Cannot find touch2 data!");
         return(FAIL);
         }
      return(OK);
      }
/************************************************************************/

/* FUNCTION Load_Touch_Data */
	 /* Load into channels ARM_H and ARM_V	*/
	 /* Correct for TAPE_ON			*/
int Load_Touch_Data(int Read, int count) {	/* descrptr,# switches	*/
#	 define MAX_TOUCHES	1000		/* Most we'll ever see	*/

   if (count == 0)				/* Get away fast	*/
      return(OK);	/* Whoops: first clear channels of old data?	*/

   if (count > MAX_TOUCHES) {			/* Will it all fit?	*/
      vtprint("Cannot fit all the touch data!");
      return(FAIL);
      }

   /* *****************************************************************	*/
#       define RADStoDEG(x)      ((short)rint(x*360 / (2*3.14159)))
#       define CONVERT_H(x) (-RADStoDEG(atan((double) \
                                ((abs(x) - (2*40 + 1)) * 2.6) / 216)))
#       define CONVERT_V(y) (RADStoDEG(atan((double) \
                                ((abs(y) - (2*40 + 17)) * 2.6) / 216)))
   /* *****************************************************************	*/
   /* 2004 (reach 4) version: Read touch data from OPTICAL SCREEN!	*/
   /* Setup 3, Wel, ~6/04 to ??): includes width data			*/
   if (Header_Version() == 4 || Header_Version() == 6) {
      ARMDATA ArmData[MAX_TOUCHES];
      ARMDATA *In = ArmData;			/* Fast access		*/

      FRAME *H = &(Register[0].channel[ARM_H].frame[0]);
      FRAME *V = &(Register[0].channel[ARM_V].frame[0]);

      int   PrevTime = 1;
      int   StartTime = Get_Start_Time_From_Stack();
      int   EndTime = Register[0].frame_count;
      int   KeepGoing = 1;
      int   i;				/* All purpose counter	*/

      if (count <= 1) {				/* 1 should never be	*/
	 vtprint("Missing 1st (fake) touch");
	 return(FAIL);
         }

      if (read(Read,ArmData,count*SizeofTouch()) != 
	 		    count*SizeofTouch()) {
         vtprint("Cannot find rest of touch data!");
         return(FAIL);
         }

      if (count > 1) {			/* Any other than fake?	*/
	 ArmData[0].h = ArmData[1].h;		/* Make 1st same as 2nd	*/
	 ArmData[0].v = ArmData[1].v;
       } else
	 ArmData[0].h = ArmData[0].v = 0;	/* Make 1st a 'no touch'*/

      for (i=1; i<=count; i++)		/* Adjust times			*/
	 ArmData[i].time = (ArmData[i].time < StartTime) ?
		 	0 : ArmData[i].time - StartTime;  /* Unsigned!	*/

      for (; i>0; i--)		/* Find last event that fits	*/
	 if (ArmData[i].time < Register[0].frame_count)	/* Last event	*/
	     break;

      for (i=1; i<count; i++) {		/* Find 1st time > start time	*/
	 if (In->time > 0)		/*  Skip over negatives		*/
	    break;
         In++;
         }
      In--;				/* Pt to last <= 0ms touch	*/

      if (i==1) {			/* NO touches < 0 ms!		*/
         fprintf(stderr, "DIAG: probably need to do something here!\n");
	 }

      for (; KeepGoing; In++) {	/* Loop thru touches	*/
	 int Touching = In->h > 0 && In->v > 0;
	 float sumH, sumV;

	 if (((In+1)->time > EndTime) ||    /* Data past end of trial?	*/
	    (In - ArmData + 1 >= count)) {  /* At last touch data?	*/
	     (In+1)->time = EndTime;	    /* Go to the end		*/
	     KeepGoing = 0;		    /* And stop after this	*/
	     }

	 sumH = CONVERT_H(In->h);
	 sumV = CONVERT_V(In->v);
#ifdef DIAG
	 fprintf(stderr, "DIAG: %d to %u (%d; %d,%d) -> (%.0f,%.0f)\n",
		 PrevTime, (In+1)->time, Touching, In->h, In->v, sumH, sumV);
#endif

	 while (PrevTime < (In+1)->time) {
	     if (Touching) {
		H->sum = sumH;
		H->sum2 = H->sum * H->sum;
		(H++)->n = 1;

		V->sum = sumV;
		V->sum2 = V->sum * V->sum;
		(V++)->n = 1;
	       } else {
		H->sum = H->sum2 = 0;
		(H++)-> n = 0;
		V->sum = V->sum2 = 0;
		(V++)-> n = 0;
	        }
	     PrevTime++;
	     }
	}
      return(OK);

   /* *****************************************************************	*/
   /* 2004 (reach 3) version: Read touch data from OPTICAL SCREEN!	*/
   /* Early, rare (setup 3, Wel, ~1/04 to ~5/04): no width data		*/
   } else if (Header_Version() == 3) {
   	/* ARMDATA and ARMDATA_OLD are defined in _imports deffs.h	*/
      ARMDATA ArmData[MAX_TOUCHES];
      /* ARMDATA_OLD ArmData_old[MAX_TOUCHES];		* No width data	*/
      	/* Not yet implemented! */

#     ifdef WHEN_USE_DATA
      ARMDATA *raw = ArmData;			/* Fast access		*/
      ARMDATA *ended;				/* One past last	*/
      FRAME *H = &(Register[0].channel[ARM_H].frame[0]);
      FRAME *V = &(Register[0].channel[ARM_V].frame[0]);
      int   time;
      int   StartTime = Get_Start_Time_From_Stack();
      int	  i;				/* All purpose counter	*/
#     endif

      if (count <= 1) {				/* 1 should never be	*/
	 vtprint("Unexpected # touches!");
	 return(FAIL);
         }

#     ifdef WHEN_USE_DATA
	Read old data into ArmData_old!
#     endif
      if (read(Read,ArmData,count*SizeofTouch()) != 
	 		    count*SizeofTouch()) {
         vtprint("Cannot find rest of touch data!");
         return(FAIL);
         }
      }

   /* *****************************************************************	*/
   /* grab.2003: Analog input, plus single int for touch/release times	*/
   /* grab.2003: Replace analog data with NO_TOUCH if time is < 0	*/
   else if (Header_Version()==2 ||	/* Special: version 10275, pre-2001 */
   	   (Header_Version()==10275 && Header_Year() > 2000)) {
      short ArmData[MAX_TOUCHES];
      short *NextTouch = ArmData;
      int Frames = Register[0].frame_count;
      int StartTime = Get_Start_Time_From_Stack();
      int Touching = 0;
      int frame = 0;

      if (read_(Read, ArmData, count*sizeof(short)) != count*sizeof(short)) {
         vtprint("Cannot find (all of the) touch data!");
         return(FAIL);
         }

      while (count-- > 0) {
         int Time = abs(*NextTouch) - StartTime;

	 if (Time > Frames)
	     Time = Frames;
	 Touching = (*NextTouch >= 0);
	 NextTouch++;

	 if (Time <= 0)			/* Pre-tape onset	*/
	    continue;

	 if (Touching)
	    while (frame < Time + TOUCH_ON_SKIP) {
               Register[0].channel[ARM_H].frame[frame].n =
               Register[0].channel[ARM_V].frame[frame].n = 0;
	       frame++;
	       }
	  else
	    frame = Time - TOUCH_OFF_SKIP;
	  }

       if (Touching == 0)
          while (frame < Frames) {
               Register[0].channel[ARM_H].frame[frame].n =
               Register[0].channel[ARM_V].frame[frame].n = 0;
	       frame++;
	       }

      return(OK);
      }
   /* *****************************************************************	*/
  else if (Header_Year() > 2000) {
      fprintf(stderr, "Whoops - there's reach 2 data that isn't labelled!\n");
      }
   /* *****************************************************************	*/
   /* SERIAL PORT VERSION: reach version 1 (< 2000) */

  else {
	 TOUCH RawData[MAX_TOUCHES];
	 TOUCH *touch = RawData;		/* Fast access		*/
	 TOUCH *ended;				/* One past last	*/
         FRAME *H = &(Register[0].channel[ARM_H].frame[0]);
         FRAME *V = &(Register[0].channel[ARM_V].frame[0]);
	 int   time;
         int   StartTime = Get_Start_Time_From_Stack();
         int	  i;				/* All purpose counter	*/

   if (read_(Read,RawData+1,count*sizeof(TOUCH)) != count*sizeof(TOUCH)) {
      vtprint("Cannot find (all of the) touch data!");
      return(FAIL);
      }

   for (i=1; i<=count; i++)			/* Adjust times		*/
      RawData[i].time -= StartTime;

   for (; i>0; i--)			/* Find last event that fits	*/
      if (RawData[i].time < Register[0].frame_count)	/* Fits?	*/
         break;				/* Great; else keep backing up	*/
   ended = RawData + i + 1;		/* Pt to first touch PAST end	*/
   ended->time = Register[0].frame_count;	 /* Set to end time	*/
   
   for (i=1; i<count; i++) {
      if (touch->time > 0)		/* Skip negative touch times	*/
         break;
      touch++;				/* Pt to 1st non-neg touch time	*/
      }
   touch--;				/* Pt to last neg (or 0) touch	*/

   if (i==1) {			/* Pt to 1st touch? Then no <0 touches	*/
      RawData[0].touch = !(RawData[1].touch);	/* Must create dummy	*/
      RawData[0].time = 0;
      RawData[0].h = RawData[1].h;
      RawData[0].v = RawData[1].v;
      }
   
   time = -1;				/* Counter ++time at loop's top	*/
   touch--;				/* Counter ++touch at loop's top*/
   while (++touch < ended) {
      if (touch->touch)			/* 1st event is a touch?	*/
         while (++time < (touch+1)->time) {	/* Til next event, 	*/
		/* Note: if next event is 'ended', then time has been set
		 * to end of trial time.
		 */
            H->sum = CONVERT(touch->h);
            H->sum2 = H->sum * H->sum;
            (H++)->n = 1;

            V->sum = CONVERT(touch->v);
            V->sum2 = V->sum * V->sum;
            (V++)->n = 1;
	    }
       else				/* 1st event was a release?	*/
         while (++time < (touch+1)->time) {	/* Til next event, 	*/
            H->sum = H->sum2 = 0;			/* Necessary?	*/
            (H++)->n = 0;				/* No data (rel)*/

            V->sum = V->sum2 = 0;
            (V++)->n = 0;
	    }
      }
   return(OK);
   /* END OF SERIAL PORT VERSION (reach version 1, < 2000)  */
   }
   return(OK);					/* Never gets here	*/
   }
/************************************************************************/
#  define MAX_BUTTONS	250
BUTTONS ButtonData[MAX_BUTTONS];

/* FUNCTION Load_Button_Data */
	 /* Actually, just skip over it */
int Load_Button_Data(int Read, int count) {	/* descrptr,# switches	*/

   if (count == 0)				/* Get away fast	*/
      return(OK);	/* Whoops: first clear channels of old data?	*/

   if (count > MAX_BUTTONS) {			/* Will it all fit?	*/
      vtprint("Cannot fit all the button data!");
      return(FAIL);
      }
   /* *****************************************************************	*/

   if (read_(Read, ButtonData, count*sizeof(BUTTONS)) != count*sizeof(BUTTONS)) {
       vtprint("Cannot find (all of the) button data!");
       return(FAIL);
       }

   return(OK);
   }
/************************************************************************/

/* FUNCTION ButtonTime */
/* FUNCTION ButtonValue */
	 /* Return time of button 'i */
	 /* Return value of button 'i */
int ButtonTime(int i) { return(ButtonData[i].time); }
int ButtonValue(int i) { return(ButtonData[i].value); }
/************************************************************************/
