/* FILE lib.c */
	/* Agglomeration of original lib.a */

#include "defs.h"
#include "termdef.h"
#include <sys/types.h>
#include <sys/signal.h>


#define GENERATE_ALT_TABLE 0	/* Give ascii codes for alt-chars	 */

/* ******************************************************* */

/* FUNCTION fatal */
void fatal(char *sp) {
	fprintf( stderr, "\nfatal error: %s\n", sp );
	finis();
	}
/* ******************************************************* */

/* FUNCTION finis.c */
void finis(void) {
	extern int Status;

	if ((Status & COMMAND_MODE) || query("Exit byter?")) {
	   CloseAllFiles();				/* Can't hurt	*/
	   GraphShutDown();
	   exit(0);

	/* signal(SIGINT, finis);			* ^C		*/
	/* longjmp(save_env,1); */
	return;
	}
}
/* ******************************************************* */

/* FUNCTION Shift */
	 /* For inputs.c: alt keys are coded as sequence; shift removes
	  * one character of that sequence (at position string[1]) and
	  * shifts the rest of the string down to fill the gap
	  */
static void Shift(char *string) {
	int i;
	for (i=1; i<100; i++) {
	   if (string[i] == 0)
	      return;
	   string[i] = string[i+1];
	   }
	}
/* ******************************************************* */

/* FUNCTION inputs.c */
void inputs( char *say, char *fetch ) {
	extern int RepeatFlag;				/* Special inpt?*/

	if (RepeatFlag) {
	   extern int RepeatStringNumber;
	   extern char RepeatString[5][255];		/* Ptrs to strgs*/
	   strcpy(fetch, RepeatString[RepeatStringNumber]);
	   RepeatStringNumber++;		/* Advance to next line	*/
	   return;
	   }

	if (*say && !(Status&COMMAND_MODE))
	   fprintf( stderr, "%s", say );

	fgets(fetch,200,stdin);

	if (Status&COMMAND_MODE)
	   if (*fetch == '\0')		/* End of input file?		*/
	      finis();			/* Exit the program		*/

#if GENERATE_ALT_TABLE
	if (fetch[0] != '\n' && fetch[1] < 0) {
	   fprintf(stderr, " %c: %4d %4d %4d %4d %4d\n",
		fetch[0], fetch[0], fetch[1], fetch[2], fetch[3], fetch[4]);
	   fetch[0] = '\n';
	   }
#endif
				/* Encode alt-char as -char	*/
        if (fetch[0] < 0) {	/* An alt-char escape sequence!	*/
	    switch (fetch[0]) {	/* Most are 2 chars; some 3	*/

		    		/* Single character		*/
	       case -17: fetch[0] = -'o'; 	goto NO_SHIFT;

			 	/* Two character sequence	*/
	       case -62:
		   switch (fetch[1]) {
			case -75:  fetch[0] = -'m'; break;
			case -76:  fetch[0] = -'e'; break;
			case -82:  fetch[0] = -'r'; break;
			case -84:  fetch[0] = -'l'; break;
			case -87:  fetch[0] = -'g'; break;
			case -88:  fetch[0] = -'u'; break;
			}
		   break;

	       case -61:
		   switch (fetch[1]) {
			case -72:  fetch[0] = -'o'; break;
			case -89:  fetch[0] = -'c'; break;
			case -91:  fetch[0] = -'a'; break;
			case -97:  fetch[0] = -'s'; break;
			}
		   break;

	       case -59:  	   fetch[0] = -'q'; break;
	       case -58:  	   fetch[0] = -'f'; break;

/* Not real, right ???
	       case -56:
		   switch (fetch[1]) {
			case 10:  fetch[1] = -'o'; break;
			}
		   break;
 */

	       case -53:
		   switch (fetch[1]) {
			case -100: fetch[0] = -'n'; break;
			case -103: fetch[0] = -'h'; break;
			case -102: fetch[0] = -'k'; break;
			case -122: fetch[0] = -'i'; break;
			}
		   break;

	       case -50:  	   fetch[0] = -'z'; break;
	       case -49:  	   fetch[0] = -'p'; break;

	       case -30:		/* 3 char seqeunce	*/
		   switch (fetch[1]) {
			case -119:   fetch[0] = -'x'; break;
			case -128:   fetch[0] = -'t'; break;
		        default:     fetch[0] = -'b'; goto NO_SHIFT;
				 /* not another negative after the -30	*/

			case -120:
			 switch (fetch[2]) {
			  case -85:  fetch[0] = -'b'; break;
			  case -126: fetch[0] = -'d'; break;
			  case -122: fetch[0] = -'j'; break;
			  case -102: fetch[0] = -'v'; break;
			  case -111: fetch[0] = -'w'; break;
		   	 break;
			}
		   Shift(fetch);
		   break;
		   }
	       }
	    Shift(fetch);
	    NO_SHIFT: ;			/* 1 char seqeunce - no shift	*/
	    }

	*strchr(fetch, '\n') = 0;	/* Replace CR with null	*/

	if (Status&COMMAND_MODE) {
	   while (*fetch == '#') {	/* Stop at next non-comment line*/
	      *(fetch+1) = *(fetch+2) = *(fetch+3) = 0;
	      fgets(fetch,200,stdin);
	      *strchr(fetch, '\n') = 0;
	      }
	   while (*fetch != 0) {	/* Loop thru to end of line	*/
	      if (*fetch == '#') {	/* If you find a comment sign	*/
	          *fetch = 0;		/*  terminate the line & leave	*/
		  break;
		  }
	      fetch++;
	      }
	   }
}

/* ******************************************************* */
/* FUNCTION fpe.c */
void fpe(void) {
 fatal("Floating point err");
 /* signal(SIGFPE, fpe);			 * Reset */
}

/* ******************************************************* */
/* FUNCTION query */
int query(char *p) {
	char temp[255];
	extern int Status;

	if (!(Status & COMMAND_MODE))
	   fprintf(stderr,"%s %c", p, '\007');
	inputs("",temp);
	while(1)
	{
		if (temp[0] == 'y')
			return(1);
		if (temp[0] == 'n')
			return(0);
		if (temp[0] == NONE)
			return(DEFAULT);
		inputs("\007",temp);
	}
}
/* ******************************************************* */

/* FUNCTION segv */
void segv(void) {
 fatal("Ouch! Segmentation error");
}
/* ******************************************************* */
