/* FILE head.c */
     /* Interaction with header */
#include "defs.h"
#include "stack.h"				/* Stack variables	*/
#include "_imports/head.h"

#define DEBUG		0

/* ******************************************************************** *
	Read_header:	  Read in the header (test if header)
	Call_Load_Data:	  Call Load_Data with appropriate header variables
	Skip_data:	  Skip over data

	Print_head:	  Print info about trial on tek screen
	Print_number:     Print expno.HeadCount.trial on screen
	Name_Header:  	  Name trials of one header using header info

	Header_Trial:		Return h.trial
	Header_duration:  	Return trial duration
	Header_dflag:	  	Return data flag
	Write_Header_dflag:	Write data flag
	Header_stackname: 	Return ptr to stackname
	Header_Size:	  	Return sizeof(HEADER)
	Header_trialSize: 	Return bytes in header
	Header_ChairAt:		Return chair location
	Header_stacknumber;  	Return stack number
	Header_ButtonCount;
	Header_Table:
	Header_Version:		Return version number
	Header_Monk:		Return version number
	Header_CalibFile:	Number of calib file
	IsHeader:  	  	Boolean (test h.tag)

       	UseNewHeader:	  Replace header info with passed structure's info
       	CopyHeaderTo:	  Put present header into passed structure

	HeaderDump:	  Print header info on text screen
	Header_stack:	  	Return ptr to stack

   PRIVATE:
	*/
/* ******************************************************************** */

/* FUNCTION Read_header */
	 /* Read a header */
int Read_header(int File) {

   if (read(File, h.tag, sizeof(struct HEADER)) != sizeof(struct HEADER))
      return(FAIL);				/* No more headers?	*/
   if (!IsHeader(h.tag)) {
      vtprint("Err reading header");
      Print_number(0);
	
      { int i = -96;		/* Start back 96 bytes: must be mult of 8 */
      lseek(File, (long)(i-sizeof(struct HEADER)), 1);
      while (i<24) {		/* Go to 24th byte: must be mult of 8 */
         char Temp[10];
	 read(File, Temp, 8);
         fprintf(stderr, "Byte %d to %d:   %c %c %c %c %c %c %c %c\n",
	   i, i+8,
	   Temp[0],Temp[1],Temp[2],Temp[3],Temp[4],Temp[5],Temp[6],Temp[7]);
         i += 8; 
	 }
      }
      return(FAIL);
      }

   /* read(File, header_stack, h.event_count * sizeof(EVENT));	*/
   			/* 2014-10-30: moved to Call_Load_Data	*/

   if (!(Status & (MACRO_MODE|BATCH_MODE))) {
      Print_number(0);
      fprintf(stderr, "\n");
      }

   return(OK);
   }
/* ******************************************************************** */

/* FUNCTION Call_Load_Data */
void Call_Load_Data(int File) {
    read(File, header_stack, h.event_count * sizeof(EVENT));
    				/* Moved from Read_header() 2014-10-30	*/
    SaveStackAt(0);				/* cp headerstack to reg*/
    UseStack(0);				/* Set current stack	*/
     			/* Moved 10-30-2014 from end of this function	*/

    /* RemoveReg(0); */				/* Insurance		*/
     /* Commented out 10-30-2014; put in calling function, Read_trial() */
    if (DEBUG) fprintf(stderr, "end header: %ld\n", lseek(File,0L,1));
    Load_Analog_Data(File,(int)h.channel_count, (int)h.frame_count);
    if (DEBUG) fprintf(stderr, "end analog: %ld\n", lseek(File,0L,1));
    Load_Spike_Data(File, h.spike_count, 1);
    if (DEBUG) fprintf(stderr, "end spikes: %ld\n", lseek(File,0L,1));
    Load_Spike_Data(File, h.multi_count, 2);
    if (DEBUG) fprintf(stderr, "end multis: %ld\n", lseek(File,0L,1));
    Load_Spike_Data(File, h.id.spike_count3, 3);
    if (DEBUG) fprintf(stderr, "end spike3: %ld\n", lseek(File,0L,1));
    Load_Spike_Data(File, h.id.spike_count4, 4);
    if (DEBUG) fprintf(stderr, "end spike4: %ld\n", lseek(File,0L,1));
    Load_Touch_Data(File, h.touch_count1);
    if (DEBUG) fprintf(stderr, "end touches: %ld\n", lseek(File,0L,1));
    Load_Touch2_Data(File, h.touch_count2);
    if (DEBUG) fprintf(stderr, "end touch2s: %ld\n", lseek(File,0L,1));
    Load_Button_Data(File, h.button_count);
    if (DEBUG) fprintf(stderr, "end buttons: %ld\n", lseek(File,0L,1));
    }
/* ******************************************************************** */

/* FUNCTION Skip_Data */
void Skip_Data(int File) {
     if (Header_Flag(DELTA_WRITE))
        lseek(File, (long)h.channel_count * (1+h.frame_count), 1);
     else
        lseek(File, (long)h.channel_count * (h.frame_count*sizeof(short)), 1);

     lseek(File, (long)h.spike_count * sizeof(short), 1);
     lseek(File, (long)h.multi_count * sizeof(short), 1);
     lseek(File, (long)h.id.spike_count3 * sizeof(short), 1);
     lseek(File, (long)h.id.spike_count4 * sizeof(short), 1);
     lseek(File, (long)h.touch_count1 * SizeofTouch(), 1);
     lseek(File, (long)h.touch_count2 * SizeofTouch(), 1);
     lseek(File, (long)h.button_count * sizeof(BUTTONS), 1);
     }
/* ******************************************************************** */

/* FUNCTION Header_dflag */
/* FUNCTION Write_Header_dflag */
	 /* bit-wise flag of channels used, based on h.channel_count	*/
int Header_dflag(void) {
	int flag = 1;				/* Assume spikes	*/
	int i;

	if (h.touch_count1) {			/* Some versions don't	*/
	   flag |= (1<<ARM_H) | (1<<ARM_V); 	/*  use analog input	*/
	   if (h.id.version == 3 && Header_Flag(NEW_TOUCH))  /*grab.2004*/
	      flag |= (1<<ARM_H_WIDTH) | (1<<ARM_V_WIDTH);
	   }

#	ifdef DIAG
	/* Commented out 3-28-2015; does not seem to be used	*/
	if (h.multi_count)
	   flag |= (1<<MULTI);
#	endif


	for (i=0; i<h.channel_count; i++)	/* Use first 'n' chans	*/
	   flag |=  1 << (1+i);
	return(flag);
	}
void Write_Header_dflag(int flag) {		/* Overwrite data flag	*/
	int i;
        h.channel_count = 0;
	for (i=1; i<MAX_RECORDED_CHANNELS; i++)
	    if (flag & (1<<i))
	       (h.channel_count)++;
	}
/* ******************************************************************** */

char  *Header_stackname(void) {			/* Return stackname	*/
	return(h.stackname); }
int Header_stacknumber(void) {
	return(h.stacknumber); }
EVENT *Header_stack(void) {		/* Return ptr to stack	*/
	return(header_stack); }

int Header_Trial(void)  { return(h.trial); }
int Header_Unit(void)   { return(h.id.unit); }
int Header_Run(void)   { return(h.id.run); }
int Header_Table(void)  { return(h.column_number); }
int Header_EventCount(void) { return(h.event_count); }
int Header_MsPerFrame(void) { return(h.ms_per_frame); }
int Header_Version(void) { return(h.id.version); }
char *Header_Monk(void) { return(h.id.monk); }
int Header_CalibFile(void) { return(h.calib_file); }
int Header_ChairAt(void) { return(h.chair_at); }
int Header_Year(void) { return(h.date.year); }
/* Misc flag */
int  Header_Flag(int MASK) { return(h.flags & MASK); }
void Header_ClearFlag(int MASK)  { h.flags &= ~MASK; }
void Header_SetFlag(int MASK)  { h.flags |= MASK; }
int  Header_ButtonCount() { return(h.button_count); }
/* ******************************************************************** */

#define  PixPerSmallChar	12.5
#define  CharToPix(c)		((int) ((c) * 12.5))
		/* Very messy.  ScreenWidth()==1000, but really 1024	*/
		/* But if fully corrected for, Postscript has trouble.	*/

/* FUNCTION Print_head */
	 /* Label plot with header information	*/
void Print_head(int reg) {
char text[255];

UseStack(reg);

GraphFontSize(15);
sprintf(text, "%2d-%d-%d", h.date.month, h.date.day, h.date.year % 100);
GraphText(ScreenWidth()+14 - CharToPix(8), ScreenHeight() + 57, text);

sprintf(text, "%d.%d:  %s",
		StackNumberReg(reg), ClassNumberReg(reg), StackNameReg(reg));
GraphText(ScreenWidth()+14 - CharToPix(10 + (int)strlen(StackNameReg(reg))),
     ScreenHeight() + 100,
     text);


sprintf(text,"%d.%d", h.id.unit, h.id.run);
if (reg==0 && ContentReg(0)==1)
   sprintf(text, "%s.%d", text, h.trial);		/* Trial number	*/
else
   sprintf(text, "%s (%d)", text, ContentReg(reg));	/* Trial count	*/
GraphText(ScreenWidth()+14-220,ScreenHeight()+25, text);

sprintf(text, "%s", h.id.monk);
GraphText(ScreenWidth()+14- CharToPix((int)strlen(h.id.monk)),
	ScreenHeight()+25, text);

/* REPLACE WITH PROPER SYSTEM CALL TO time() */
#ifdef DIAG
fontsize(10);
GraphText(ScreenWidth()-125,25);
/* system("date | sed 's/... //' | sed 's/:[0-9][0-9] [PE][SD]T//'"); */
fontsize(12);
#endif
return;
}
/* ******************************************************************** */

/* FUNCTION Print_number */
	 /* Print monk unit.run number */
void Print_number(int reg) {
   fprintf(stderr,"%s %d.%d", h.id.monk, h.id.unit, h.id.run);
   if (reg==0 && ContentReg(0)==1)
      fprintf(stderr, ".%d", h.trial);			/* Trial number	*/
     else
      fprintf(stderr, "(%d)", ContentReg(reg));		/* Trial count	*/
   }
/* ******************************************************************** */

/* FUNCTION IsHeader */
int IsHeader(char *MayBeHead) {
return(	(MayBeHead[0] == 'H') && (MayBeHead[1] == 'e') &&
	(MayBeHead[2] == 'a') && (MayBeHead[3] == 'd') &&
	(MayBeHead[4] == 'e') && (MayBeHead[5] == 'r') &&
	(MayBeHead[6] == '!') && (MayBeHead[7] == '\0')  );
}
/* ********************************************************************	*/	

/* FUNCTION HeaderDump */
void HeaderDump(void) {
   Print_number(0);
   fprintf(stderr, "\nStack %d: %s    Table %d \n",
	h.stacknumber, h.stackname, h.column_number);
   fprintf(stderr,"   Version %d  Date %d-%d-%d\n",
	h.id.version, h.date.month, h.date.day, h.date.year);
   fprintf(stderr,"Time %d:%d.%d  Rate   %d\n",
	h.time.hour, h.time.minute, h.time.second, h.ms_per_frame);
   fprintf(stderr,"Frames %d  Channels %d Spikes %d %d %d %d  Touches %d+%d Buttons %d\n",
	h.frame_count, h.channel_count, h.spike_count, h.multi_count,
			h.id.spike_count3, h.id.spike_count4,
       			h.touch_count1, h.touch_count2, h.button_count);
   }
/* ********************************************************************	*/	
