/* FILE gspike */
     /*	Graph units in various ways:

	Graph_SpikeRaster:	Do one line of raster
	Graph_SpikeHisto:	Normal histogram of spikes
	Graph_SpikeIntegral:	Integrated spike count (Hikosaka-Wurtz)

	 Requires header (PixToIndex, etc, calls)
     */

#include "array.h"				/* Get the data		*/
#include "graph.h"				/* #includes defs.h	*/
/* ********************************************************************	*/

/* FUNCTION Graph_SpikeRaster */
	 /* Graph spike PST over interval specified by graph parameters	*/
int Graph_SpikeRaster(int reg) {
int  i;					/* Index trials	*/
int *Spike;
int BeginFrame = PixToIndex(0);
int EndFrame   = PixToIndex(SCREEN_WIDTH);
int Y_offset = (int) Get_y_offset();

if (ProofReg(reg) == FAIL)
   return(FAIL);
#ifdef ALLOW_MULTI_TRIAL_PLOTS
if (Register[reg].trial_count > 1) {
   vtprint("Rasters only of single trials!");
   return(FAIL);
   }
#endif
if (EndFrame > Register[reg].frame_count)
    EndFrame = Register[reg].frame_count;
if (BeginFrame < 0) {
    vtprint("DIAG: Possible err here.  Call larry! ");
    BeginFrame = 0;
    }

Spike = &(Register[reg].spikes[BeginFrame]);

for (i=BeginFrame; i<EndFrame; i++)
     if (*(Spike++)) {				/*  If there's a spike,	*/
	move(IndexToPix(i), Y_offset);			/* Time axis	*/
	cont(IndexToPix(i), Y_offset+6);
	}
return(OK);
}
/* ********************************************************************	*/

/* FUNCTION Graph_SpikeHisto */
	 /* Graph histogram 					*/
#define BINS	100				/* # bins for histo	*/
#define EXPAND	30000.		/* Scale factor	(best if BIN%1000 == 0) */

void Graph_SpikeHisto(int reg) {
int i;					/* Frame count		*/
int BeginFrame = PixToIndex(1);			/* 1st frame on screen	*/
int EndFrame   = PixToIndex(SCREEN_WIDTH);	/* Last frame on screen	*/
int FramesPerBin = (EndFrame-BeginFrame)/BINS;	/* Total frames/# bins	*/
int FramesSoFar = 0;			/* Count 'em		*/
int *SpikesInFrame = Register[reg].spikes;
int SpikesInBin = 0;
float Scaler = EXPAND/(SCREEN_HEIGHT/Get_y_mult())/Register[reg].trial_count;
/* DIAG/BUG:  SCALER ought to be calc'd for each frame (using Unit->n)	*/
int old_width = 0;				/* Save previous width	*/
int first = 1;
float Y_offset = Get_y_offset();

if (EndFrame > Register[reg].frame_count)
    EndFrame = Register[reg].frame_count;
if (BeginFrame < 0)				/* No points on the left*/
   BeginFrame = 0;				/*  IndexToPix does it 	*/
SpikesInFrame += BeginFrame;			/*  Push ptr to midway	*/

for (i=BeginFrame; i<EndFrame; i++) {		/* For frames on screen	*/
   SpikesInBin += *(SpikesInFrame++);		/* Tally added spikes	*/
   if (FramesSoFar++ >= FramesPerBin) {		/* Done with bin?	*/
      int height = irint(Y_offset + SpikesInBin * Scaler);
      if (first) {
         move(old_width, height);
	 first = 0;
      } else
         cont(old_width, height);
      cont(old_width=IndexToPix(i), height);
      FramesSoFar = SpikesInBin = 0;		/* Ready for next bin	*/
      }
   }
}
/* ********************************************************************	*/

/* FUNCTION Graph_SpikeIntegral */
	 /* Graph integral of spikes	*/
#define EXPAND2	1000.0

void Graph_SpikeIntegral(int reg) {
int  i;
int *Spikes = Register[reg].spikes;
int begin = PixToIndex(0);
int end   = PixToIndex(SCREEN_WIDTH);
float Integral = 0.;				/* Sum of spike histo	*/
float Scaler = EXPAND2/(SCREEN_HEIGHT/Get_y_mult())/Register[reg].trial_count;
float Y_offset = Get_y_offset();

if (begin > 0)
   Spikes += begin;
i = begin;
move(IndexToPix(i), Scaler*(Y_offset + (Integral += *(Spikes++))));
for (; i<end; i++)
   cont(IndexToPix(i), Scaler*(Y_offset + (Integral += *(Spikes++))));
}
/* ********************************************************************	*/
