/* FILE graph.h */
     /* Variables used for graphing.  See also _tek library	*/

#include "defs.h"
#include "_plot/plot.h"

/* ******************************************************************** */
int Set_LineType(int type);
void GraphPrintf(char *format, ...);
int  Get_x_offset(void);
void Set_x_offset(int x);
float Get_y_offset(void);
void  Set_y_offset(float y);
float Get_x_mult(void);
void  Set_x_mult(float x);
float Get_y_mult(void);
void  Set_y_mult(float y);
int ScreenHeight(void);
int ScreenWidth(void);
int PixToTime(int x);
float PixToVel(int y);
int TimeToPix(int ms);
float VelToPix(float y);
int IndexToPix(int ms);
int PixToIndex(int i);
void GraphZeroLine(void);
int  GraphLine(int when, int lip);
void GraphEvents(int reg);
void PrintGraphicsScaling(float HorizontalTicWidth);


/* ******************************************************************** */

/* TURNED INTO FUNCTIONS IN graphelse.c SO ACCESSIBLE FROM OUTSIDE 
 *  #define PixToTime(x)  (rint(x/x_mult - x_offset))	 * return int	*
 *  #define PixToVel(y)	  ((y-y_offset)/y_mult)	 	 * return float	*
 *  #define TimeToPix(x)	(irint(((x) + x_offset) * x_mult))
 *  #define VelToPix(y)		(irint((y) * y_mult + y_offset))
 *  #define IndexToPix(i)    	TimeToPix(i)
 *  #define PixToIndex(i)	 PixToTime(i)
 */

/* Suggestion: width of 1000, height so 3:2 aspect ratio, with ~75 top	*/
/*  Aspect ratio is (2*BOR+WIDTH+RIGHT_MAR) : (2*BOR+HEIGTH+TOP_MAR)	*/
#define BORDER		  10
#define SCREEN_WIDTH	1000
#define RIGHT_MARGIN	  24			/* For right edge tics	*/
#define SCREEN_HEIGHT	 750
#define TOP_MARGIN	  66			/* For title info	*/


#define MIN_BOUND	0
#define MAX_BOUND	(SCREEN_HEIGHT)	/* In _our_ pixels	*/
/* ********************************************************************	*/
