/* FILE gdata.c */
     /* Graph arrays received from array.c (tektroknix protocol)	*/
     /* FUNCTIONS:
      * GraphData:	Graph data average (and stdev)
      */
#include "array.h"				/* Get the data!	*/
#include "graph.h"

static void   Graph_Shaded_Stderr(int reg);
static FRAME *ShadeErrorSegment(FRAME *Begin, FRAME *SegBegin, FRAME *End);
/* ******************************************************************** */

/* FUNCTION Move */
/* FUNCTION Cont */
/* Original, glitchy versions:
 * #define Move(x,y)	move(TimeToPix(x), VelToPix(y))
 * #define Cont(x,y)	cont(TimeToPix(x), VelToPix(y))
 */

static int Last_x;
static float Last_y;
static int SkipVertical = 0;
static void ContEnd();

static void Move(int x, float y) {
	ContEnd();			/* Finish previous segment	*/
	move(Last_x=TimeToPix(x), Last_y=VelToPix(y));	/* New segment	*/
	}
static void Cont(int x, float y) {
	int X = TimeToPix(x);
	float Y = VelToPix(y);

	if (fabs(Y-Last_y) < 0.1) {	/* Skip small vertical change	*/
	   Last_x = X;			/* but save associated x	*/
	   SkipVertical = 1;		/* Remember you've skipped some	*/
	   return;			/* (else lose sharp corners)	*/
	   }
	if (X != Last_x) {		/* Skip small horizontal change	*/
	   if (SkipVertical &&		/* Preceeded by straight line?	*/
	        (fabs(Y-Last_y) > 0.1))		/* And now an uptick?	*/
	      cont(Last_x, Last_y);		/* Don't cut corner!	*/
	   cont(Last_x=X, Last_y=Y);		/* Now the current point*/
	   SkipVertical = 0;			/* No longer true	*/
	   }
	}
static void ContEnd() {			/* Still more to draw?		*/
	if (SkipVertical) {
	   cont(Last_x, Last_y);		/* Finish the line!	*/
	   SkipVertical = 0;
	   }   					/* Now start the new one*/
	}
/* ******************************************************************** */

/* FUNCTION GraphData */
int GraphData(int reg) {
   FRAME *F,*S;					/* Ptr to single frame	*/
   int	  BeginIndex = PixToIndex(0);	/* Do once for loops	*/
   int	  EndIndex = PixToIndex(SCREEN_WIDTH);	/* Ditto	*/
   int    LineBreak;				/* Next call: draw|cont?*/
   extern int graph_events, print_header, graph_bold,
   	      graph_stddev, graph_stddev_shade;

if (ProofReg(reg) == FAIL)
   return(FAIL);
UseStack(reg);					/* Set current stack	*/


color(0,0,0); 					/* Marks in black	*/
linewidth(2);
if (print_header)				/* Check flag		*/
   Print_head(reg);				/* Print header		*/
if (graph_events)
   GraphEvents(reg);
else if (!(Status&COMMAND_MODE))		/* CmdMode: no scaling!	*/
   PrintGraphicsScaling(0);			/* On upper left of plot*/
   
ChangeColor();					/* Set as per 'c' calls	*/

if (graph_stddev && graph_stddev_shade) {	/* Do shading?		*/
   Graph_Shaded_Stderr(reg);
   linewidth(2);
   flushpl();					/* Insurance		*/
   return(OK);
   }

LineBreak = 1;
linewidth(graph_bold);

S = F = Register[reg].channel[CurrentChannel].frame;	/* Ptrs at begin*/
if (EndIndex >= Register[reg].frame_count)
   EndIndex = Register[reg].frame_count-1;
while ((F-S) < BeginIndex)			/* Check for wrap around*/
   F++;						/* Skip till abscissa=0	*/


/* PLOT MEAN VALUE */
if (graph_stddev < 5)				/* Skip if ce+/-, cd+/-	*/
 while ((F-S) <= EndIndex) {
   if (LineBreak) {				/* In a line break:	*/
      if (F->n) {				/*  If new pt		*/
         Move(F-S,MEan(F));			/*   Begin a new line	*/
	 LineBreak = 0;
	 }
   } else if (F->n)				/* In mid-line, new pt:	*/
      Cont(F-S,MEan(F));			/*  continue the line or*/
   else						/* Mid-line, no new pt:	*/
      LineBreak = 1;				/*  break the line	*/
   F++;				/* Less dense output: might try F += 5	*/
   }
ContEnd();					/* Clean up loose ends	*/
LineBreak = 1;
linewidth((graph_bold)? 8:2);			/* Thickness of SE, SD	*/

/* PLOT STDERR or STDDEV */
if (graph_stddev && (Register[reg].trial_count>1)) { /* No SD on 1 trial*/
  float Std = 0.0;				/* Calc once and store	*/


  if (graph_stddev <= 6) {			/* 1:4,5,6: + SD or SE	*/
   F = Register[reg].channel[CurrentChannel].frame;
   while ((F-S) < BeginIndex)
       F++;

   while ((F-S) <= EndIndex) {
      int GotOne = 0;
      if (F->n > 1) {				/* Calc SE/SE or say no	*/
	 Std = SD(F);					/* Calc SD	*/
	 if (graph_stddev%2 == 0)  			/* Want SE?	*/
	    Std /= (float) sqrt((double)(F->n));	/* Calc SE	*/
	 if (graph_stddev==3 || graph_stddev==4)	/* +/- half	*/
	    Std /= 2.;
         if (Std < 20.0)				/* Do iff small	*/
	    GotOne = 1;
         }
      if (LineBreak) {				/* If in a line break:	*/
         if (GotOne) {
            Move(F-S, MEan(F) + Std);
	    LineBreak = 0;
	    }
      } else if (GotOne)			/* Else in mid-line:	*/
         Cont(F-S, MEan(F) + Std);
      else
	 LineBreak = 1;
      F++;
      }
  ContEnd();					/* Clean up loose ends	*/
  }
  LineBreak = 1;

  if (graph_stddev!=5 && graph_stddev!=6) {	/* 1:4,7,8: -SD or -SE 	*/
   F = Register[reg].channel[CurrentChannel].frame;
   while ((F-S) < BeginIndex) F++;
   while ((F-S) <= EndIndex) {
      int GotOne = 0;
      if (F->n > 1) {				/* Calc SE/SE or say no	*/
	 Std = SD(F);					/* Calc SD	*/
	 if (graph_stddev%2 == 0)  			/* Want SE?	*/
	    Std /= (float) sqrt((double)(F->n));	/* Calc SE	*/
	 if (graph_stddev==3 || graph_stddev==4)	/* +/- half	*/
	    Std /= 2.;
         if (Std < 20.0)				/* Do iff small	*/
	    GotOne = 1;
         }
      if (LineBreak) {				/* If in a line break:	*/
         if (GotOne) {
            Move(F-S, MEan(F) - Std);
	    LineBreak = 0;
	    }
      } else if (GotOne)			/* Else in mid-line:	*/
         Cont(F-S, MEan(F) - Std);
      else
	 LineBreak = 1;
      F++;
      }
   ContEnd();					/* Clean up loose ends	*/
   }
  }

linewidth(2);
flushpl();					/* Insurance		*/
return(OK);
}
/* END GraphData */
/* ******************************************************************** */

/* FUNCTION Graph_Shaded_Stderr */
	 /* Graph +/- 1 SEM, shaded */
static void Graph_Shaded_Stderr(int reg) {
   FRAME *Begin, *F, *End;			/* Frame pointers	*/

   if (Register[reg].trial_count<=1)		/* No SD on 1 trial	*/
      return;

   linewidth(0);

   F = Begin = Register[reg].channel[CurrentChannel].frame;

   if (PixToIndex(0) > 0)
      F += PixToIndex(0);

   End = Begin + PixToIndex(SCREEN_WIDTH);
   if ((End-F) >= Register[reg].frame_count)    /* Full screen of data?	*/
      End = F + Register[reg].frame_count-1;   	/* No:Keep ptr in array!*/

   while (F < End) {
      while (F <= End)				/* Walk to gap end	*/
         if ((++F)->n > 1)
            break;
      if (F >= End)				/* Whoops: at true end	*/
         break;
      F = ShadeErrorSegment(Begin, F, End);
      }
   }
/* ******************************************************************** */

/* FUNCTION ShadeErrorSegment */
	 /* Graph +/- 1 SEM, shaded */
static FRAME *ShadeErrorSegment(FRAME *Begin, FRAME *SegBegin, FRAME *End) {
   FRAME *F = SegBegin;
   FRAME *Stop;
   extern int graph_stddev;			/* SEM or SD?		*/
   float Halve = 1.0;

   Move(SegBegin-Begin, MEan(SegBegin));	/* Back where you start	*/

   if (graph_stddev == 3 || graph_stddev == 4)
      Halve = 0.5;

   while (F <= End) {
      if (F->n <= 1)
         break;					/* End the segment	*/
      switch (graph_stddev) {
	 case 5:
	 case 3:
	 case 1:
             Cont(F-Begin, MEan(F) + Halve*SD(F));
	     break;
	 case 6:
	 case 4:
         case 2:
             Cont(F-Begin, MEan(F) + Halve*SD(F)/sqrt((double)(F->n)));
	     break;
	 case 7:
	 case 8:
             Cont(F-Begin, MEan(F));
	     break;
	 }
      F++;
      }

   ContEnd();					/* Clean up loose ends	*/
   Stop = F;					/* Know where we stopped*/

   F--;
   while (F >= SegBegin) {
      if (F->n <= 1)
         break;
      switch (graph_stddev) {
	 case 7:
	 case 3:
	 case 1:
             Cont(F-Begin, MEan(F) - Halve*SD(F));
	     break;
	 case 8:
	 case 4:
         case 2:
             Cont(F-Begin, MEan(F) - Halve*SD(F)/sqrt((double)(F->n)));
	     break;
	 case 5:
	 case 6:
             Cont(F-Begin, MEan(F));
	     break;
	 }
      F--;
      }
   Cont(SegBegin-Begin, MEan(SegBegin));	/* Back where you start	*/
   ContEnd();					/* Clean up loose ends	*/
   fill(1);
   return(Stop);
   }
/* ******************************************************************** */
