/* arm.c: */
	void SetupFindArmMove(void);
	int FindArmMove(int reg);
/* auto.c: */
	void Set_AutoMode(void);
	void Do_AutoMode(void);
/* calc.c: */
	int FindIntercept(int reg1, int reg2, int time);
/* calib.c: */
	void Init_CalibFile(char *inputfile);
	void Read_CalibFile(int number);
	void Do_Calibration(float *h, float *v);
/* chg.c */
	void MenuChg(void);
	void ChangeParameter(char Parameter, char *Value);
	void ChangeColor(void);
	void ChangePaintColor(int *PaintColors);
/* data.c */
	void GetVergenceData(int reg);
	int SubtractData(int reg, int minus);
	int DivideData(int reg, int divide);
	int ComputeAmplitudesData(int reg);
	int ComputeProjectedAmplitudesData(int reg, int direction);
	int ChannelDataTransfer(int reg, int new);
	void SetupDivergeData(void);
	int DivergeData(int reg1, int reg2);
	int DivergeFromZeroData(int reg);
	int OffsetData(int reg, float offset);
	void SetupHalving(void);
	int HalveData(int reg);
	int RectifyData(int reg);
	int MultiplyData(int reg);
	int DeleteData(int reg, int Begin, int End);
	int DeleteUnitData(int reg, int Begin, int End);
	int DeleteAllData(int reg, int Begin, int End);
	float AvgSomeData(int reg, int Begin, int End);
	float AvgWrappedData(int reg, int Begin, int End);
	float StatsSomeData(int reg, int Begin, int End, char*  Stat);
	int FindPeakOfData(int reg, int Begin, int End, int FindPositivePeak);
	int FindFirstDataOver(int reg, float Value, int BeginAt);
	int FindFirstDataUnder(int reg, float Value, int BeginAt);
	int FindDataZeroCrossings(int reg, int BeginAt, int EndAt);
	int DataFlag(int reg);
/* diff.c */
	void SetupDifferentiate(void);
	int Differentiate(int X);
/* digi.c */
	int DigiPad(void);
/* do_cmd.c */
	void InitDoCmd(void);
	void DoCommand(char*  CmdLine);
/* file.c */
	int OpenFile(char *filetype);
	char *NameFile(void);
	int StatFile(int reg, int time);
	int AvgFile(int reg);
	int RawFile(int reg);
	int TextFile(int reg, FILE *File, int format);
	int ReadFile(int reg);
	int ReadFiles(int reg);
	void CloseAllFiles(void);
/* filt.c */
	void PickFilter(void);
	int Filter(int reg);
/* gdata.c */
	int GraphData(int reg);
/* gelse.c */
	/* see graph.h */
	void GraphSetUp(void);
	void GraphShutDown(void);
	void GraphErase(void);
	void GraphFlush(void);
	void GraphEvents(int reg);
	void GraphFontSize(int size);
	void GraphText(int x, int y, char *text);
	int  ScreenWidth(void);
	int  ScreenHeight(void);
/* gspike.c */
	int Graph_SpikeRaster(int reg);
	void Graph_SpikeHisto(int reg);
	void  Graph_SpikeIntegral(int reg);
/* head.c */
	int  Read_header(int File);
	void Call_Load_Data(int File);
	void Skip_Data(int File);
	int Header_dflag(void);
	void Write_Header_dflag(int flag);
	char  *Header_stackname(void);
	int Header_stacknumber(void);
	int Header_Trial(void);
	int Header_Unit(void);
	int Header_Run(void);
	int Header_Table(void);
	int Header_Year(void);
	int Header_Flag(int MASK);
	void Header_ClearFlag(int MASK);
	void Header_SetFlag(int MASK);
	int Header_EventCount(void);
	int Header_MsPerFrame(void);
	int Header_Version(void);
	int Header_CalibFile(void);
	char *Header_Monk(void);
	int Header_ChairAt(void);
	int Header_button_count(void);
	void Print_head(int reg);
	void Print_number(int reg);
	int IsHeader(char *MayBeHead);
	void HeaderDump(void);
/* help.c */
	void HelpMenu(char c);
	void HelpGeneral(void);
/* lib.c */
	void fatal(char *sp);
	void finis(void);
	void inputs(char *say, char *fetch);
	void fpe(void);
	int  query(char *p);
	void segv(void);
/* load.c */
	void DescribeSelf(void);
	void InitLoad(void);
	int Load_Analog_Data(int Read,int Channels,int Frames);
	int Load_Spike_Data(int Read, int count, int spikechannel);
	void Set_ExcludedSpikesFlag(int value);
	void Print_ExcludedSpikesCount(void);
	/* int Load_Multi_Data(int Read, int count); Obselete: 3-28-2015 */
	int Load_Button_Data(int Read, int count);
	int Load_Touch_Data(int Read,int count);
	int Load_Touch2_Data(int Read,int count2);
	int SizeofTouch();
/* main.c */
	int main(int argc, char *argv[]);
/* paint.c */
	void Paint(char *cmdline);
	char *AtoF(char* stringptr, float* valueptr);
/* read.c */
	int Read_file(void);
	int ReRead_file(void);
	int Read_trial(void);
	void Batch_read_file( char newfilename[]);
	int Skip_trial(int skip_over);
	int TrialNumber_file(void);
/* reg.c */
	int ProofReg(int reg);
	void ListReg(void);
	int RemoveReg(int reg);
	int TagReg(int changeReg);
	int MacroTagReg(int chargeReg, char *newname);
	int CopyReg(int from, int to);
	int AvgReg(int from, int to);
	void NormalizeReg(int reg);
	int SubtractReg(int to, int minus);
	int ShiftReg(int reg, int ms);
	int ContentReg(int reg);
	char *StackNameReg(int reg);
	int StackNumberReg(int reg);
	int ClassNumberReg(int reg);
	int CountReg(int reg);
/* repeat.c */
	void Repeat_macro(char *RepCmdLine);
/* sac.c */
	int  SetupDesaccading(void);
	void SetupFindSaccade(void);
	void DesaccadeData(int reg);
	int FindSaccade(int reg);
/* stack.c */
	void SaveStackAt(int reg);
	void UseStack(int reg);
	void CopyStack(int from, int to);
	void StackDump(void);
	int  StackExtract(int Type, int Occurrence, int What);
	int Get_Start_Time_From_Stack(void);
/* ttest.c */
	float Ttest(int *data1, int count1, int *data2, int count2, int sides);
	float Ttest_short(float mean1, int count1, float sem1,
		          float mean2, int count2, float sem2, int sides);
	float Ttest_shortest(float mean, int count, float sem, int sides);
	float Ttest_vs_zero(int *data, int count, int sides);
/* userio.c */
	void Title(char *cmd);
	int ChooseReg(char *p, int dfault, char *CmdLine);
	void vtprint(char *string);

/* _?macs/do_mac.c */
	void DoMacro(char *cmdline);
