/* FILE filter.c */
     /* Filter 'float' input with filter of length n (n is odd)
      * NOTE: filters only mean, not SD or SE (not sum2)
      * FOR NEW FILTERS, TRY:
      * http://www.dsptutor.freeuk.com/remez/RemezFIRFilterDesign.html
      */
#include "array.h"				/* For reg->ptr&datapts	*/
#include "defs.h"

/* Matlab:  lowpass, FIR, order X, hamming window, no scale, 1000=Fs, Fc = Y */

#define MAX_FILTER_LENGTH 8000

static float Weights_302[] = {
#			 include "_filters/L181.2-15.fil"
			 };
static float Weights_320[] = {
#			 include "_filters/L191.20-32.fil"
			 };
static float Weights_330[] = {
#			 include "_filters/L83.30-60.fil"
			 };


static float Weights_250[] = {
#			 include "_filters/L8000_0.25.fil"
			 };
static float Weights_251[] = {
#			 include "_filters/L6000_0.25.fil"
			 };
static float Weights_252[] = {
#			 include "_filters/L5000_0.25.fil"
			 };
static float Weights_500[] = {
#			 include "_filters/L4000_0.5.fil"
			 };
static float Weights_501[] = {
#			 include "_filters/L3000_0.5.fil"
			 };
static float Weights_1[] = {
#			 include "_filters/L2000_1.fil"
			 };
static float Weights_11[] = {
#			 include "_filters/L1500_1.fil"
			 };
static float Weights_2[] = {
#			 include "_filters/L1000_2.fil"
			 };
static float Weights_21[] = {
#			 include "_filters/L800_2.fil"
			 };
static float Weights_4[] = {
#			 include "_filters/L500_4.fil"
			 };
static float Weights_41[] = {
#			 include "_filters/L400_4.fil"
			 };
static float Weights_8[] = {
#			 include "_filters/L250_8.fil"
			 };
static float Weights_16[] = {
#			 include "_filters/L125_16.fil"
			 };
static float Weights_32[] = {
#			 include "_filters/L80_32.fil"
			 };
static float Weights_64[] = {
#			 include "_filters/L80_64.fil"
			 };


/* ********************************************************************	*/
int UseFilter = 8;

/* FUNCTION PickFilter */
void PickFilter(void) {
char Answer[20];

if (Status & COMMAND_MODE)
   goto BEYOND_THE_CHATTER;

fputs(        "\n #   Type Trans-Band(-3dB)   points", stderr);

fputs("\n 302   Lopass    2-15  ( 9)      90 -> 181", stderr);
fputs("\n 320   Lopass   20-32            95 -> 191", stderr);
fputs("\n 330   Lopass   30-60            41 -> 83", stderr);

fputs("\n  64   Lopass           64       80", stderr); /* Pts = ~*2+1	*/
fputs("\n  32   Lopass           32       80", stderr); /* eg, 161 pts	*/
fputs("\n  16   Lopass           16      125", stderr); /*     251 pts	*/
fputs("\n   8   Lopass            8      250", stderr);
fputs("\n   4   Lopass            4      500", stderr);
fputs("\n   41  Lopass            4      400", stderr);
fputs("\n   2   Lopass            2     1000", stderr);
fputs("\n   21  Lopass            2      800", stderr);
fputs("\n   1   Lopass            1     2000", stderr);
fputs("\n   11  Lopass            1     1500", stderr);
fputs("\n   500 Lopass            0.5   4000", stderr);
fputs("\n   501 Lopass            0.5   3000", stderr);
fputs("\n   250 Lopass            0.25  8000", stderr);
fputs("\n   251 Lopass            0.25  6000", stderr);
fputs("\n   252 Lopass            0.25  5000", stderr);

#ifdef UNUSED
fputs("\n 101 Lopass    Low            499", stderr);
fputs("\n 102 Lopass    Low            999", stderr);
fputs("\n 1   Lopass    2- 8  ( 5)     255", stderr);
fputs("\n 12  Lopass   35-64  (46)      73", stderr);
fputs("\n 16  Lopass   40-54  (47)     137", stderr);
fputs("\n 20  Lopass   43-57  (46)     137", stderr);
fputs("\n 24  Lopass   48-63           123", stderr);
fputs("\n 28  Lopass   48-85            65", stderr);
fputs("\n 32  Lopass   60-90            73", stderr);
fputs("\n 36  Lopass   68-101           65", stderr);
fputs("\n 40  Lopass   90-120           77", stderr);
fputs("\n 44,48,52,56  Lopass 120-180,180-240,240-300,300-360   37-39", stderr);
fputs("\n 301 Lopass    1              510", stderr);
fputs("\n 302 Lopass    2              254", stderr);
fputs("\n 2002 Lopass    0.2            510", stderr);
fputs("\n 2005 Lopass    0.5            510", stderr);
fputs("\n 201  Lopass    1              254", stderr);
fputs("\n 202  Lopass    2              180", stderr);
fputs("\n 210  Lopass    10             190", stderr);
fputs("\n 220  Lopass    20             190", stderr);
fputs("\n 225  Lopass    25             180", stderr);
fputs("\n 230  Lopass    30              82", stderr);
fputs("\n 235  Lopass    35              72", stderr);
/* fputs("\n 104   Diff  40-250      9 ", stderr);
   fputs("\n 108 Diff+lo 40-70       97", stderr);
 */
#endif

  while (1) {
     fprintf(stderr, "\n  Use filter [%d]", UseFilter);
    BEYOND_THE_CHATTER:
     inputs(">   : ",Answer);
     if (Answer[0] == NONE) {
	fprintf(stderr, "Will continue using filter %d\n", UseFilter);
	return;
        }
     switch (atoi(Answer)) {
	 case 302: case 320: case 330:
	 case 64: case 32: case 16: case 8: case 4: case 41:
	 case 2: case 21: case 1: case 11: case 500: case 501:
	 case 250: case 251: case 252:
	 	UseFilter = atoi(Answer);		/* And fall thru*/
		return;
	 default:
		fprintf(stderr,"\nFilter %d not available!\n",atoi(Answer));
         }
     }
}
/* ********************************************************************	*/

/* FUNCTION Filter */
	 /* */
int Filter(int reg) {
FRAME *C;
int    Count;
int    ManyTrials;				/* Boolean: >1 trial?	*/
float InPut[MAX_FRAMES+2*MAX_FILTER_LENGTH+4];
float *Put;
float *EndInput;
int EDGE;					/* Can't filter edges 	*/
float *Weights;					/* Point at filter	*/
int i;
float avg;
#define LENGTH(filter)	(sizeof(filter) / sizeof(float) - 1)

if (ProofReg(reg) == FAIL)
   return(FAIL);
C     = &(Register[reg].channel[CurrentChannel].frame[0]);
Count = Register[reg].frame_count;
ManyTrials = (Register[reg].trial_count>1);

switch (UseFilter) {			/* Pick a filter, any filter	*/
	case 250:  EDGE=LENGTH(Weights_250);  Weights=Weights_250;  break;
	case 251:  EDGE=LENGTH(Weights_251);  Weights=Weights_251;  break;
	case 252:  EDGE=LENGTH(Weights_252);  Weights=Weights_252;  break;
	case 500:  EDGE=LENGTH(Weights_500);  Weights=Weights_500;  break;
	case 501:  EDGE=LENGTH(Weights_501);  Weights=Weights_501;  break;
	case 1:    EDGE=LENGTH(Weights_1);  Weights=Weights_1;  break;
	case 11:   EDGE=LENGTH(Weights_11);  Weights=Weights_11;  break;
	case 2:    EDGE=LENGTH(Weights_2);  Weights=Weights_2;  break;
	case 21:   EDGE=LENGTH(Weights_21);  Weights=Weights_21;  break;
	case 4:    EDGE=LENGTH(Weights_4);  Weights=Weights_4;  break;
	case 41:   EDGE=LENGTH(Weights_41);  Weights=Weights_41;  break;
	case 8:    EDGE=LENGTH(Weights_8);  Weights=Weights_8;  break;
	case 16:   EDGE=LENGTH(Weights_16); Weights=Weights_16; break;
	case 32:   EDGE=LENGTH(Weights_32); Weights=Weights_32; break;
	case 64:   EDGE=LENGTH(Weights_64); Weights=Weights_64; break;

	case 302:EDGE=LENGTH(Weights_302);Weights=Weights_302;break;
	case 320:EDGE=LENGTH(Weights_320);Weights=Weights_320;break;
	case 330:EDGE=LENGTH(Weights_330);Weights=Weights_330;break;

	default: fprintf(stderr, "\nUnknown filter %d", UseFilter);
		 return(OK);
	}

{				/* Not all filters have gain=1	*/
   double sum = 0;
   int i;
   			/* Compute the sum of all the weghts	*/
   for (i=0; i<EDGE; i++)		/* All but center point	*/
	sum += 2*Weights[i];		/*  count double	*/
   sum += Weights[EDGE];
   /* fprintf(stderr, "DIAG: Filter coefs sum to %.3f\n", sum); */

   			/* Normalize each weight so sum = 1	*/
   if (fabs(sum-1) > 0.03)	/* If sum is substantially > 1	*/
      for (i=0; i<=EDGE; i++)
	  Weights[i] /= sum;
}


/* Input will look like:     c(pad, data, pad) where length(pad) = EDGE */

/* Fill up the input buffer */
Put = &(InPut[EDGE]);			/* Start edge in from 0	*/
while (Count--) {
   *(Put++) = MEan(C);
   C++;
   }

/* What is the value near the edge?  Fill the start with it!	*/
Put = &(InPut[EDGE]);			/* Start of real data	*/
avg = 0.;
for (i=0; i<EDGE/2; i++)
   avg += *(Put++);			/* Avg the first 20	*/
avg /= EDGE/2;

Put = &(InPut[EDGE]);			/* Pad at start of data	*/
for (i=0; i<EDGE; i++)
   *(Put--) = avg;

/* Same as above, but now do it for the end of the trial	*/
Count = Register[reg].frame_count;
Put = &(InPut[EDGE+Count]);		/* End of real data	*/
avg = 0.;
for (i=0; i<EDGE/2; i++)
   avg += *(Put--);			/* Avg the first 20	*/
avg /= EDGE/2;

Put = &(InPut[EDGE+Count]);		/* Pad from end of data	*/
for (i=0; i<EDGE; i++)
   *(Put++) = avg;



C = &(Register[reg].channel[CurrentChannel].frame[0]);

EndInput = &(InPut[EDGE+Count]);

/* LOW_PASS: */
for (Put=InPut+EDGE; Put<EndInput; Put++) {
    float *left  = Put-EDGE;		/* Data before Put	*/ 
    float *right = Put+EDGE;		/* Data after Put	*/ 
    float *WeightPtr =  Weights;	/* Points in filter	*/
    float Delta;
    float sum = 0;				/* Will be output point	*/

    while (left < right)			/* All but mid weight:	*/
       sum += *(WeightPtr++) * (*(left++) + *(right--));  /* Convolve	*/
    sum += *WeightPtr * *left;			/* Mid weight & data	*/

    /* 'sum' is the filtered output.  But notice that the input was NOT
     * the sequence of C->sum; it was C->sum / C->n.  So delta (below)
     * is not 'C->sum - sum'; it is 'C->sum / C-n - sum'.
     */ 

    if (ManyTrials) {
       Delta  = MEan(C) - sum;				/* Find delta	*/
       C->sum2 -= Delta * (2*MEan(C) - (C->n)*Delta);	/* Chg squares	*/
       C->sum = C->n * sum;				/* Chg sums	*/
    } else {						/* C->n==1?	*/
       C->sum = sum;					/* Faster:	*/
       C->sum2 = C->sum * C->sum;
       }
    if (! finite(C->sum)) {
       C->sum = C->sum2 = 0;
       C->n = 0;
       }
    C++;
    }
return(OK);
}
/* ********************************************************************	*/



#ifdef GET_DIFFERENTIATOR_WORKING
Point C at channel DiffChannel

for (Put=InPut+EDGE; Put<EndInput; Put++) {
    float *left  = Put-EDGE;		/* Data before Put	*/ 
    float *right = Put+EDGE;		/* Data after Put	*/ 
    float *WeightPtr =  Weights;	/* Points in filter	*/
    float sum = 0;				/* Will be output point	*/
    while (left < right)			/* All but mid weight:	*/
       sum += *(WeightPtr++) * (*(left++) - *(right--));    /* Convolve	*/
    (C++)->sum = sum;		    		    	    /* Store	*/
    fprintf(stderr,"\n%d %f", C - &(Register[reg].frame[EDGE]), C->sum);
    }
return(OK);
#endif
