/* FILE do_cmd */
     /* Process commands						*/
#include <stdio.h>
#include <ctype.h>				/* isdigit()		*/
#include "defs.h"
#include "cross.h"
#include "sac.h"				/* Get saccade data	*/
/* ******************************************************************** */
static int      offset_begin,
      		offset_end;      /* (ms) Assume start at 0 w/ 1:1 scale	*/
static int	peak_begin,
		peak_end;
static int	FindPositivePeak;

static char     LastUnitGraph = 'u';

int		VerboseValue;

extern void GraphLine(int when, int lip);
extern int  PixToTime(int x);
/* ******************************************************************** */

/* FUNCTION InitDoCmd */
void InitDoCmd(void) {
  peak_begin = offset_begin  = 50;
  offset_end = 100;		/* Was StackExtract(CHAIR_SPEED,1,TIME) */
  peak_end   = 1000;		/* Was StackExtract(TAPE_OFF,1,TIME) 	*/
}
/* ******************************************************************** */

/* FUNCTION DoCommand */
	 /* Process a command	*/

void DoCommand(char *CmdLine) {
   static int
      begin_x=0, end_x=0,			/* Markers--msec	*/
      number,					/* General purpose	*/
      reg1=0,  reg2=0;			/* For general purpose	*/
   int DeleteAll = 1;

 switch(CmdLine[0]) {

    case '' + 1:					/* line feed	*/
	return;

/* *******************************************************************	*/
/*  			INFORMATION 					*/
/* *******************************************************************	*/

    case '?':
	if (CmdLine[1] == 0) {				/* Uf1 is legal	*/
	   fputs("\n	Commands	?", stderr);	/* Sum of cmds	*/
	   fputs("\n	Header		H", stderr);	/* Print header	*/
	   fputs("\n	Stack		S", stderr);	/* Print stack	*/
	   fputs("\n	Trial #		=", stderr);	/* ex.evnt.trial*/
	   fputs("\n	Version		v", stderr);	/* Self descript*/
	   inputs("\n > Your request:     ",CmdLine+1);
	   }
	switch(CmdLine[1]) {
	   case '?': HelpMenu('?');   break;
	   case 'H': HeaderDump();    break; 	/* Print header info	*/
	   case 'S': StackDump();     break; 	/* Print stack out	*/
	   case '=': Print_number(0); break; 	/* expno.event.trial	*/
	   case 'v':
	  	 Erase_Screen;
	  	 DescribeSelf();
		 ListReg();
		 break;
	   }
	break;




/* *******************************************************************	*/
/*  			COMPUTATION 					*/
/* *******************************************************************	*/
     case 'a':						/* Average	*/
	reg1 = ChooseReg("Avg from", reg1,CmdLine+1);
	reg2 = ChooseReg("Avg into", reg2,CmdLine+3);
	AvgReg(reg1,reg2);
        break;
     case '-':						/* Subtract 	*/
	reg1 = ChooseReg("Subtract from", reg1,CmdLine+1);
	reg2 = ChooseReg("Subtract     ", reg2,CmdLine+3);
	SubtractReg(reg1,reg2);
        break;
     case '_':						/* Subtr chans	*/
	reg1 = ChooseReg("Subtract channels in reg",reg1,CmdLine+1);
	SubtractData(reg1,ChooseReg("Subtract channel(defs.h)",9,CmdLine+2));
	break;			 		/* Get # from defs.h */
     case '/':						/* Subtract 	*/
	reg1 = ChooseReg("Divide from", reg1,CmdLine+1);
	reg2 = ChooseReg("Divide     ", reg2,CmdLine+3);
	DivideData(reg1,reg2);
        break;
     case 'C':						/* Trnsfr chans	*/
	reg1 = ChooseReg("Transfer channels (from current) in reg",
			reg1,CmdLine+1);
	ChannelDataTransfer(reg1,ChooseReg("Destination channel(defs.h)",
			9,CmdLine+2));		/* Get # from defs.h */
	break;
      case 'M':				/* Multiply channel by constant	*/
	MultiplyData(reg1 = ChooseReg("Multiply",reg1,CmdLine+1));
	break;
      case '>':
      case '<':
	reg1 = ChooseReg("Shift reg", reg1, CmdLine+1);
	inputs(" Shift by (ms) >", CmdLine);
	if (CmdLine[0] == NONE)
	   break;
	ShiftReg(reg1, atoi(CmdLine));
	break;

   case 'L':					/* Length: sqrt(x^2+y^2)*/
	reg1 = ChooseReg("Length (euclidean distance)",reg1,CmdLine+1);
	ComputeAmplitudesData(reg1);		/* For posit & veloc	*/
	break;
   case '':					/* Project pos & vel	*/
	reg1 = ChooseReg("Length (projection distance)",reg1,CmdLine+1);
	inputs(" Relative to (deg) >", CmdLine);
	if (CmdLine[0] == NONE)
	   break;
	ComputeProjectedAmplitudesData(reg1, atoi(CmdLine));
	break;

   case 'E':					/* Desac options: write!*/
	if (SetupDesaccading() == 0)		/* Said 'don't do it'?	*/
	   break;
   case 'e':					/* Eliminate saccades	*/
	reg1 = ChooseReg("Desaccade",reg1,CmdLine+1);
	DesaccadeData(reg1);
	break;

   case 'H':					/* Halve, or rectify	*/
	SetupHalving();
	break;

   case 'h':
	reg1 = ChooseReg("Halve (rectify)",reg1,CmdLine+1);
	HalveData(reg1);
	break;

   case 'K':
	reg1 = ChooseReg("Full wave rectify)",reg1,CmdLine+1);
	RectifyData(reg1);
	break;

   case 'P': 					/* Prepare to find peak	*/
	reg1 = ChooseReg("Register",reg1,CmdLine+1);
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	    fprintf(stderr, "Start peak search at (ms):  ");
	inputs("", CmdLine);
	peak_begin = atoi(CmdLine);
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	    fprintf(stderr, "End peak search at (ms):  ");
	inputs("", CmdLine);
	peak_end = atoi(CmdLine);
	if (!(Status & COMMAND_MODE)) {
	   GraphLine(peak_begin,7);	      /* Draw it	*/
	   GraphLine(peak_end, -7);
	   }
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	   fprintf(stderr, "Find positive peak?");
	FindPositivePeak = query("");
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	   fprintf(stderr, "Search between %d and %d ms for %s peak\n",
		peak_begin, peak_end,
		(FindPositivePeak) ? "positive" : "negative");
	CmdLine[1] = NONE;				/* Clear for 'p'*/
	if ((Status & (MACRO_MODE|COMMAND_MODE)))
	   break;			/* Fall thru if interactive	*/

   case 'p':
	if (*CmdLine == 'p')
	   reg1 = ChooseReg("Register",reg1,CmdLine+1);
	number = FindPeakOfData(reg1, peak_begin, peak_end, FindPositivePeak);
	if (!(Status & COMMAND_MODE))
	   GraphLine(number, 0);
	fprintf(stderr,
	   "\n%stive peak reg %d at %d ms (%5.2f ± %5.2f) (%d-%d ms)\n",
	   (FindPositivePeak)?"Posi":"Nega", 
	   reg1,
	   number,
	   AvgSomeData(reg1, number-2, number+2),
	   StatsSomeData(reg1,number-2,number+2, "SE"),
	   peak_begin, peak_end);
	break;

   case 'S':
	SetupFindSaccade();
   case 's':					/* Find saccades	*/
	if ((FindSaccade(reg1) != FAIL) && !(Status & COMMAND_MODE)) {
	   int    SaveChannel = CurrentChannel;

	   CurrentChannel = OD_H;
	   GraphData(reg1);
	   fprintf(stderr, "Saccade: From %d to %d ms (%d ms): %.1f x ",
	    SaccadeData.begin,SaccadeData.end,
	    SaccadeData.end - SaccadeData.begin,
	    AvgSomeData(reg1, SaccadeData.end+100-5, SaccadeData.end+100+5) -
	    AvgSomeData(reg1, SaccadeData.begin-100-5,SaccadeData.begin-100+5));
	   CurrentChannel = OD_V;
	   GraphData(reg1);
	   fprintf(stderr, "%.1f\n",
	    AvgSomeData(reg1, SaccadeData.end+100-5, SaccadeData.end+100+5) -
	    AvgSomeData(reg1, SaccadeData.begin-100-5,SaccadeData.begin-100+5));
	    
	   Differentiate(reg1);
	   fprintf(stderr, "    Peak velocity (at %d ms) = %.1f deg/s\n",
	    SaccadeData.peak, AvgSomeData(0,SaccadeData.peak,SaccadeData.peak));
	   GraphLine(SaccadeData.begin, 5);
	   GraphLine(SaccadeData.peak,  0);
	   GraphLine(SaccadeData.end,  -5);

	   CurrentChannel = H_VEL;
	   fprintf(stderr, "   Component velocities: %.1f x ",
	    AvgSomeData(reg1, SaccadeData.peak-5, SaccadeData.peak+5));

	   CurrentChannel = V_VEL;
	   fprintf(stderr, "%.1f\n",
	    AvgSomeData(reg1, SaccadeData.peak-5, SaccadeData.peak+5));
	
	   CurrentChannel = SaveChannel;	/* Restore channel	*/
	} else
	   fprintf(stderr, "  Can't find saccade\n");
	break;

     case '':
	SetupFindArmMove();
	break;
     case 't': {
        extern int FindStartOfArmMove;			/* arm.c	*/
	int at = FindArmMove(reg1=
			ChooseReg("Find arm move", reg1, CmdLine+1));

	if (at == FAIL)
	   break;
        fprintf(stderr, "Reach %s at %d ms\n",
		(FindStartOfArmMove) ? "starts" : "ends", at);
	/* if (! (Status & COMMAND_MODE)) */
	   GraphLine(at, (FindStartOfArmMove) ? 5:-5);
	break;
        }

     case '':
	NormalizeReg(reg1 = ChooseReg("Normalize reg", reg1, CmdLine+1));
	break;

     case 'D':				/* Divergence time (2 registers)*/
	SetupDivergeData();			/* And fall thru	*/
	break;

     case 'd':
	reg1 = ChooseReg("Divergence of reg", reg1, CmdLine+1);
	reg2 = ChooseReg("From reg         ", reg2, CmdLine+3);
	number = DivergeData(reg1, reg2);
	if (!(Status & MACRO_MODE)) {
	   if (number != FAIL)
	      GraphLine(number,0);     		/* Show it	*/
	   GraphData(reg1);
	   GraphData(reg2);
	   }
	if (number == FAIL)
	   fputs("Never diverges\n",stderr);
	fprintf(stderr, "Diverges after %d ms\n", number);
	break;
     case 'Z':
     case 'z':
	reg1 = ChooseReg("Diverge from zero of reg", reg1, CmdLine+1);
	number = DivergeFromZeroData(reg1);
	if (!(Status & (MACRO_MODE|COMMAND_MODE)) || CmdLine[0]=='Z') {
	   if (number != FAIL)
	       GraphLine(number,0);
	   GraphData(reg1);
	   }
	if (number == FAIL)
	   fputs("Never diverges\n",stderr);
	fprintf(stderr, "Diverges after %d ms\n", number);
	break;

     case 'I':						/* Setup dx/dt	*/
	SetupDifferentiate();
     case 'i':						/* Differentiate*/
	reg1 = ChooseReg("Differentiate", reg1, CmdLine+1);
	Differentiate(reg1);
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	   GraphData(reg1);
        break;

     case 'V':				/* Put vergence into channel X3	*/
     case 'v':				/* Put vergence into channel X3	*/
	reg1 = ChooseReg("Vergence", reg1, CmdLine+1);
	GetVergenceData(reg1);
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	   GraphData(reg1);
	break;

      case 'b': /* Mark mouse location as "begin"/"end"; delete interval*/
        DeleteAll = 0;
      case 'B': /* Ditto, but delete ALL data				*/
        if (Status & COMMAND_MODE) {
	   reg1 = ChooseReg("", reg1, CmdLine+1);
	   inputs("", CmdLine);
	   begin_x = atoi(CmdLine);
	   inputs("", CmdLine);
	   end_x = atoi(CmdLine);
	} else {
	   begin_x = PixToTime(ch.ch_x);	      /* STORE AS TIME	*/
	   GraphLine(begin_x,5);		      /* Draw it	*/
	   while (1) {		/* Clumsy coding, but need to accept	*/
	      char ccc = cross_hair(&ch);	/* EITHER an 'e' or 'E'	*/
	      if (ccc=='e' || ccc=='E')
	         break;
	      }
	   end_x = PixToTime(ch.ch_x);		      /* Store time	*/
	   GraphLine(end_x,-5);			      /* Draw it	*/
	   }

	if (DeleteAll) {
	   DeleteAllData(reg1, begin_x, end_x);
	   DeleteUnitData(reg1, begin_x, end_x);
	} else
	   DeleteData(reg1, begin_x, end_x);
	break;

      case -'b':	/* alt-b: delete using current interval	*/
			/* alt-x: returns negative of ascii x	*/
	   reg1 = ChooseReg("", reg1, CmdLine+1);
	   DeleteAllData(reg1, begin_x, end_x);
	   DeleteUnitData(reg1, begin_x, end_x);
	   break;

      case '': 	/* Delete between two (non-mouse) entered times	*/
			/* DEPRECATED!!!!			*/
	  fprintf(stderr, "^B is deprecated - use B\n");
	  if (Status & COMMAND_MODE) {
	     reg1 = ChooseReg("", reg1, CmdLine+1);
	     inputs("", CmdLine);
	     begin_x = atoi(CmdLine);
	     inputs("", CmdLine);
	     end_x = atoi(CmdLine);
	  } else {
	     reg1 = ChooseReg("Delete data from", reg1, CmdLine+1);
	     fprintf(stderr, "Delete> Begin at [%d ms] :  ", begin_x);
	     inputs("", CmdLine);
	     if (CmdLine[0] && isdigit(CmdLine[0]))
	        begin_x = atoi(CmdLine);
	     fprintf(stderr, "Delete> End   at [%d ms] :  ", end_x);
	     inputs("", CmdLine);
	     if (CmdLine[0] && isdigit(CmdLine[0]))
	  	end_x = atoi(CmdLine);
	     }
	  DeleteAllData(reg1, begin_x, end_x);
	  DeleteUnitData(reg1, begin_x, end_x);
	  break;
	     
      case 'F':  					/* Set up filter*/
	PickFilter();
	if ((Status & (MACRO_MODE|COMMAND_MODE)))
	   break;			/* Fall thru if interactive	*/

      case 'f': /* Filter */
	reg1 = ChooseReg("Filter",reg1,CmdLine+1);
	Filter(reg1);
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	   GraphData(reg1);
	break;

      case 'O': 				/* Set up+print offset	*/
	/* if (Status & COMMAND_MODE) { 	 * If cmd mode, no graph*/
	   inputs("", CmdLine);
	   if (CmdLine[0] && isdigit(CmdLine[0]))
	      offset_begin = atoi(CmdLine);
	   inputs("", CmdLine);
	   if (CmdLine[0] && isdigit(CmdLine[0]))
	      offset_end = atoi(CmdLine);
	   GraphLine(offset_begin,7);		      /* Draw it	*/
	   GraphLine(offset_end, -7);
	   break;

#	ifdef DIAG
	DO_AGAIN:
	switch(cross_hair(&ch)) {
	   case 'b': 
		offset_begin = PixToTime(ch.ch_x);
   		GraphLine(offset_begin,7);
   		while (cross_hair(&ch) != 'e');	  /* Wait for e	*/
   		offset_end = PixToTime(ch.ch_x);
   		GraphLine(offset_end,-7);
	   case 'g':
		break;
	   default:
      		fputs("\n g	go; accept interval",	stderr);
      		fputs("\n b,e 	reselect interval",	stderr);
      		sleep(1);
		goto DO_AGAIN;
	   }
	break;
#	endif

      case 'o': 		/* Print amplitude of offset	*/
	reg1 = ChooseReg("Offset",reg1,CmdLine+1);
	if (!(Status & COMMAND_MODE))
           fprintf(stderr, "\n");
	fprintf(stderr,"%d %d-%d ms: %5.2f +/- %5.2f (se=%5.2f, n=%.0f)\n",
		reg1, offset_begin, offset_end,
		AvgSomeData(reg1,offset_begin,offset_end),
		StatsSomeData(reg1,offset_begin,offset_end, "SD"),
		StatsSomeData(reg1,offset_begin,offset_end, "SE"),
		StatsSomeData(reg1,offset_begin,offset_end, "N")
		);
	break;

      case -'o': 	/*Alt-o:offset register (inputs() for mapping)	*/
			/* alt-x: returns negative of ascii x	*/
	     reg1 = ChooseReg("", reg1, CmdLine+1);
	     if (ContentReg(reg1) < 1)
                break;
	     OffsetData(reg1,AvgSomeData(reg1,offset_begin,offset_end));
	     if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	        GraphData(reg1);
	     break;

      case '': 		/* Ctrl-o: set times, do offset	*/
	  if (Status & COMMAND_MODE) {
	     reg1 = ChooseReg("", reg1, CmdLine+1);
	     inputs("", CmdLine);
	     offset_begin = atoi(CmdLine);
	     inputs("", CmdLine);
	     offset_end = atoi(CmdLine);
	  } else {
	     reg1 = ChooseReg("offset data from", reg1, CmdLine+1);
	     fprintf(stderr, "offset> Begin at [%d ms] :  ", offset_begin);
	     inputs("", CmdLine);
	     if (CmdLine[0] && isdigit(CmdLine[0]))
	        offset_begin = atoi(CmdLine);
	     fprintf(stderr, "offset> End   at [%d ms] :  ", offset_end);
	     inputs("", CmdLine);
	     if (CmdLine[0] && isdigit(CmdLine[0]))
	  	offset_end = atoi(CmdLine);
	     }
	  
	OffsetData(reg1,AvgSomeData(reg1,offset_begin,offset_end));
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	   GraphData(reg1);
	  break;


/* *******************************************************************	*/
/*  			DATA MANIPULATION				*/
/* *******************************************************************	*/

      case 'l':
	ListReg();
	break;
      case 'm': /* Copy register 1 to register 2; reg2 becomes new reg1 */
	number = ChooseReg("Move/copy from",reg1, CmdLine+1);
	CopyReg(number, reg1=ChooseReg("Move to  ",reg2, CmdLine+3));
        break;
      case 'r':
	RemoveReg(ChooseReg("Remove register",1000,CmdLine+1));
	break;
      case 'k':
	TagReg(ChooseReg("Rename register",reg2,CmdLine+1));
	break;

      case 'W':					/* Write to disk	*/
	if (query("Write raw data to disk? ") == 1)
	  RawFile(reg2=ChooseReg("Sum, sum squared to disk",reg2,CmdLine+1));
	else
	if (query("Digested data? ") == 1)
	  AvgFile(reg2 = ChooseReg("Mean, stddev to disk",reg2,CmdLine+1));
        reg2++;					/* Autoincrement	*/
	break;
      case '': {				/* Other formats	*/
	FILE *WriteFile = fopen("RegisterData.txt", "a");
	reg2 = ChooseReg("Eye & spikes of register #:",reg2,CmdLine+1);
	TextFile(reg2, WriteFile, 2);
	fclose(WriteFile);
	break;
	}

      case 'R':				/* READ files */
	reg2 = ChooseReg("Put into register",reg2,CmdLine+1);
	if (CmdLine[2] == NONE)
	   inputs(" Enter 's' if sequential files (else anything)", CmdLine+2);
	if (CmdLine[2]=='s' || CmdLine[3]=='s')
	   ReadFiles(reg2);			/* Reads many files	*/
        else
	   ReadFile(reg2++);			/* Auto increment	*/
	break;


      case 'n':
	fputs("  Reading ",stderr);
 	Read_trial();
	if (!(Status & (MACRO_MODE|COMMAND_MODE)))
	   GraphData(0);
	reg1 = 0;				/* Reset default	*/
	break;

      case 'N': 
	if (CmdLine[1] == 0)			/* Could have say "Ns"	*/
	   inputs("\nGo to >",CmdLine+1);		/* Give prompt	*/

	if (CmdLine[1] == 0) {				/* Can say "Ns"	*/
	   N_MENU:
	   fputs("\nGo to:",stderr);
	   fputs("\n  New file            f", stderr);
	   fputs("\n  Re-read file        r", stderr);
	   fputs("\n  Next trial          n", stderr);
	   fputs("\n  Prev trial          p", stderr);
	   fputs("\n  Skip trials         s", stderr);
	   inputs( "\n> Your order: ",CmdLine+1);	/* Read as string*/
	   }
	switch(CmdLine[1]) {
	     case 'f':	Read_file(); break;
	     case 'r':	ReRead_file(); break;
	     case 'n':  Read_trial(); break;
	     case 'p':	Skip_trial(-1); break;
	     case 's':					/* Skip trials	*/
	   		if (CmdLine[2] == 0)	/* Can give, eg, "Ns3"	*/
			   inputs(">  Move how many? ",CmdLine+2);
			Skip_trial(atoi(CmdLine+2));
			break;
	     case '?':  goto N_MENU;
	   default :	goto END;
	   }
       END:
	reg1 = 0;
	break;


/* *******************************************************************	*/
/*  			GRAPHICS 					*/
/* *******************************************************************	*/

      case 'U':					/* Set up unit graphing	*/
	fputs("\nUnit displays:",stderr);
	fputs("\n  Raster     r", stderr);		/* Standard PST	*/
	fputs("\n  Histogram  h", stderr);		/* Make a histo	*/
	fputs("\n  Integral   i", stderr);		/* Up-slope line*/

	inputs("\n  > Your request:     ",CmdLine+1);
	LastUnitGraph = CmdLine[1];
	*(CmdLine+1) = 0;				/* Null out	*/

      case 'u':						/* Unit graphing*/
	reg1 = ChooseReg("File",reg1,CmdLine+1);	/* Register # ?	*/
	switch(LastUnitGraph) {
	   case 'r':	Graph_SpikeRaster(reg1);
	  		break;
	   case 'h':	Graph_SpikeHisto(reg1);
			break;
	   case 'i':	Graph_SpikeIntegral(reg1);
			break;
	   default:	break;
	   }
	break;
      case 'T': /* Print title */
	Title(CmdLine+1);
	break;
      case 'g': /* Graph register 1 */
	reg1 = ChooseReg("Graph",reg1, CmdLine+1);
	GraphData(reg1);
	break;
      case 'c': 		/* Change parameter P to value V	*/
      case 'G': 		/* Chg graphics parameter P to value V	*/
	if (CmdLine[1] == 0) {				/* General form	*/
           inputs("Change > ", CmdLine+1);
	   if (CmdLine[1] == 0) {
	     MenuChg();
	     inputs("\n> Enter emboldened letter: ", CmdLine+1);
	     }
	   if (CmdLine[1] == 0)				/* Exit 'c'	*/
	      break;
	   }
	if (CmdLine[2]==0)			    	/* Have P not V	*/
	   inputs("\n> Enter new value: ",CmdLine+2);
	ChangeParameter(CmdLine[1], CmdLine+2);		/* Have P and V	*/
	break;

      case 'X':
	Erase_Screen;
	break;
      case 'x': /* Erase graphics screen */
	GraphErase();
	break;

      case '': /* Print screen */
	/* Print_screen; */
	break;


/* *******************************************************************	*/
/*  			MISCELANEOUS 					*/
/* *******************************************************************	*/

      case 'A': /* Adjust */
	Set_AutoMode();
	break;
      case '%': /* Digi Pad*/
	DigiPad();
	break;
      case '@': /* Paint program */
	Paint(CmdLine+1);
	break;
      case '*':
	if (CmdLine[1] == NONE)
	   inputs( "\n>   Your order: ",CmdLine+1);	/* Read as string*/
	if (CmdLine[1] == 'R') {			/* Let all see it*/
	    Repeat_macro(CmdLine+2);			/* Don't send 'R'*/
	    /* should there be a break here? */
	    }
	UseStack(0);		/* Insurance (may trip you up some day)	 */
 	Status |= MACRO_MODE;	
	DoMacro(CmdLine+1);
 	Status &= ~MACRO_MODE;	
	break;

      case '&': /* Change current stack */
	reg1 = ChooseReg("Current stack",reg1, CmdLine+1);
	UseStack(reg1);
	break;

      case '^': /* Desperation	*/
	CloseAllFiles();
	break;

      case '!': /* Echo line to stderr */
        fprintf(stderr, "%s\n", CmdLine + 1);
	break;

      case 'Q': /* Quit */
	finis();
	break;

    default:
	break;
    } /* END switch */


CmdLine[1] = CmdLine[2] =				/* Re-init	*/
CmdLine[3] = CmdLine[4] =
CmdLine[5] = CmdLine[6] =
CmdLine[7] = CmdLine[8] =
CmdLine[9] = NONE;
} /* END FUNCTION main */
/* ********************************************************************	*/
