/* FILE digi */
     /* Emulate a digipad; write to file				*/
/* ********************************************************************	*/

/* GLOBAL VARIABLES */
#include <stdio.h>
#include <ctype.h>				/* isdigit()		*/
#include "defs.h"
#include "cross.h"
#include "graph.h"				/* Pixel->time&deg #defs*/

/* See defs.h for globals, #defines and macros	*/
/* ********************************************************************	*/
static int StatReg = -1;			/* -1: none, else reg#	*/
						/* Allow external access*/
/* FUNCTION DigiPad */
int DigiPad(void) {
	FILE *DigiData;				/* Name of file		*/
	char  DigiData_text[255];		/* Accept text for file	*/
	int   pt_cnt;				/* Counts points written*/
	char  FileName[255];			/* Name of file to open	*/
	char  CommandLine[255];
extern FILE *fdopen(int fildes, const char *type);	/* NOT ANSI C!	*/

DigiData = fdopen(OpenFile("d"),"w");		/* Open unique name	*/
strcpy(FileName, NameFile());			/* Remember filename	*/
pt_cnt = 1;

GET_NEXT_CHAR:
inputs("DigiPad > ", CommandLine);

switch(*CommandLine) {
   case 'F':
	fclose(DigiData);
	if (pt_cnt == 1)				/* Empty file?	*/
	   unlink(FileName);				/* Remove it	*/

	if  (query("DigiPad > Re-open old file or specially name file? [y/n]"))
	   while (DigiData == NULL) {
              fprintf(stderr,"\nFile name to open:  ");
              fscanf( stdin ,"%20s",FileName);
	      query("");			/* Chew \n from scan	*/
              DigiData = fopen(FileName,"a");
	      }
	else {
	   DigiData = fdopen(OpenFile("d"), "w");
	   strcpy(FileName, NameFile());	/* Remember filename	*/
	   }
	fprintf(stderr,"%s opened", FileName);
	break;
   case 'E':					/* Decrement & tell us	*/
	 fprintf(stderr, "\nDigiPad > Next Digi point:  %d", --pt_cnt);
	 break;
   case 'P': case 'p':
	 move(0,720);
	 GraphPrintf("%s", NameFile);
	 break;
   case '?':
	fprintf(stderr,"\nDIGI PAD EMULATION:");
	fprintf(stderr,"\n F   open new file");
	fprintf(stderr,"\n P   print file name on graph");
	fprintf(stderr,"\n");
	fprintf(stderr,"\n a   write time,vel");
	fprintf(stderr,"\n b,e difference mode");
	fprintf(stderr,"\n S   stats with 'a' command?");
	fprintf(stderr,"\n");
	fprintf(stderr,"\n T   write subtitle");
	fprintf(stderr,"\n E   erase last point (set back point counter)");
	fprintf(stderr,"\n");
	fprintf(stderr,"\n g   graph a new trace");
	fprintf(stderr,"\n x   clear and redraw");
	fprintf(stderr,"\n 1-3 change screen");
	fprintf(stderr,"\n c   change parameters");
	fprintf(stderr,"\n nN  new trial/header/file");
	fprintf(stderr,"\n Q   quit");
	break;
   case 'T':
	fputs("\07",stderr);
	inputs("\nDigiPad > Text: ", DigiData_text);
	fprintf(DigiData, "\n*	 %s", DigiData_text);
	break;
   case 'a': {					/* Left mouse key	*/
        int time = PixToTime(ch.ch_x), span = PixToTime(2);

	fprintf(DigiData, "%3d %6d %6.2f\n",
		pt_cnt, time, PixToVel(ch.ch_y));
	if (StatReg != -1 && ContentReg(StatReg) != FAIL) {
	 if (ContentReg(StatReg) == 1)
	   fprintf(DigiData, "   %6.2f\n",
		AvgSomeData(StatReg, time-span, time+span));
 	 else if (ContentReg(StatReg) > 1)
	   fprintf(DigiData, "   %6.2f %6.2f %6.2f %6.2f\n",
		AvgSomeData(StatReg,   time-span, time+span),
		StatsSomeData(StatReg, time-span, time+span, "SD"),
		StatsSomeData(StatReg, time-span, time+span, "SE"),
		StatsSomeData(StatReg, time-span, time+span, "N"));
	 }
	fprintf(stderr, "\n%3d %6d %6.2f",
		pt_cnt, PixToTime(ch.ch_x), PixToVel(ch.ch_y));
	if (StatReg != -1 && ContentReg(StatReg) != FAIL) {
	 if (ContentReg(StatReg) == 1)
	   fprintf(stderr, "   %6.2f\n",
		AvgSomeData(StatReg, time-span, time+span));
 	 else if (ContentReg(StatReg) > 1)
	   fprintf(stderr, "   %6.2f %6.2f %6.2f %6.2f\n",
		AvgSomeData(StatReg,   time-span, time+span),
		StatsSomeData(StatReg, time-span, time+span, "SD"),
		StatsSomeData(StatReg, time-span, time+span, "SE"),
		StatsSomeData(StatReg, time-span, time+span, "N"));
	 }
	fputs("\07",stderr);
	mark_point(ch,pt_cnt++,' ');
	break;
	}

   case 'S': {
  	     char answer[255];
	if (*(CommandLine+1) == '\0') {
	   fprintf(stderr, "\nDigiPad > Stats of reg # [%d]: ", StatReg);
	   inputs("", answer);
	} else
	   answer[0] = *(CommandLine+1);

	switch (answer[0]) {
	   case '\0':
		break;
	   case '-': case 'n': case 'N':
	   	StatReg = -1;
		break;
	   case '?':
		fputs("Enter register number to print stats of\n", stderr);
		fputs("Enter \"n\" or -1 to disable\n",		   stderr);
		break;
	   default:
		if (isdigit(answer[0]))
	   	   StatReg = atoi(answer);
		else
	   	   fprintf(stderr, "digipad(): Input err\n");
	    }
	break;
	}

   case 'b':
	{
	int t1, y1;					/* Temp storage	*/
	int div;					/* Divisor      */

	fputs("\07",stderr);
	mark_point(ch,pt_cnt,'+');
	t1 = PixToTime(ch.ch_x);
	y1 = PixToVel(ch.ch_y);

        while (cross_hair(&ch) != 'e');		/* Wait for 2nd pt	*/
	fputs("\07",stderr);
	if ((div = PixToTime(ch.ch_x) - t1) == 0)	/* Block /0 err	*/
	   div = 1;				/* Small (~1/128 deg)	*/
	fprintf(DigiData, "\n%3d    %7d %7.2f %7.2f    d",
		pt_cnt,
		PixToTime(ch.ch_x) - t1,
		PixToVel(ch.ch_y) - y1,
	       (PixToVel(ch.ch_y) - y1) / div);
	fprintf(stderr, "\n%3d    %7d %7.2f %7.2f    d",
		pt_cnt,
		PixToTime(ch.ch_x) - t1,
		PixToVel(ch.ch_y) - y1,
	       (PixToVel(ch.ch_y) - y1) / div);
	mark_point(ch,pt_cnt++,'-');
	break;
	}

   case 'x':
	erase();					/* And fall thru*/
   case 'g':
	DoCommand("g");					/* Request #	*/
	break;

   case 'X':
   case 'c':
   case 'n':
   case 'N':
   case '1':
   case '2':
   case '3':
		DoCommand(CommandLine);
	        break;

   case 'Q': case 'q':
	fclose(DigiData);
	if (pt_cnt == 1)				/* Empty file?	*/
	   unlink(FileName);				/* Remove it	*/
	return(OK);

   default:  break;
   }

goto GET_NEXT_CHAR;					/* Start over	*/
}
/* ********************************************************************	*/

/* FUNCTION mark_point */
	 /* Show where DigiData point is, and describe type		*/
void mark_point(CROSS_HAIR where, int n_id, char a_id) {
/* CROSS_HAIR where;				 * Holds cursor position*/
/* int	   n_id;				 * Numeric    identifier*/
/* char	   a_id;				 * Alphabetic identifier*/

move(where.ch_x - 10,where.ch_y - 10);
cont(where.ch_x + 10,where.ch_y + 10);
move(where.ch_x - 10,where.ch_y + 10);
cont(where.ch_x + 10,where.ch_y - 10);

move(where.ch_x - 50,where.ch_y - 20);
GraphPrintf("%d%c",n_id,a_id);
}
/* END mark_point */
/* ********************************************************************	*/
